/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.FieldList;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.impl.PrefixingActionImpl;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.anotations.LeastFixedPointApplAnn;
import circusRefine.core.crules.anotations.RecursionUnfoldPart1Ann;
import circusRefine.core.crules.anotations.RecursionUnfoldPart2Ann;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * Fabrica das leis de Recursao de Circus
 * 
 * @author Cristiano Gurgel
 */
public class RecursionLawsFactory extends ActionLawsFactory {
	
	public RecursionLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da fabrica
	 * 
	 * @param codName codigo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_RECURSION, codName);
	}
	
	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> leis = new LinkedList<CircusLaw>();
		
		/* C.128 */
		leis.add(this.criarLeiRecursionUnfoldPart1());
		
		/* C.128 */
		leis.add(this.criarLeiRecursionUnfoldPart2());
		
		/* C.129 */
		leis.add(this.criarLeiRecursionLeastFixedPoint());
		
		leis.add(this.criarLeiVarExpRec());
		
		leis.add(this.criarLeiRecSync());
		
		return leis;
	}

	/**
	 * Cria a lei C.129 ( Recursion -- least fixed point )
	 * 
	 * @return 
	 */
	public CircusLaw criarLeiRecursionLeastFixedPoint() {
		
		/* Criando o LHS da lei */
		JokerAction fX = factory.createJokerAction("F(X)", null);
		JokerName x = 
			this.getFactory().createJokerName("X", null);
		MuAction left = this.factory.createMuAction(fX, x);
		
		/* Criando o RHS da lei */
		JokerAction right = factory.createJokerAction("Y", null);
		
		/* Usada na OP */
		JokerAction fY = 
			this.getFactory().createJokerAction("f(Y)", null);
		right.getAnns().add(new LeastFixedPointApplAnn(x, fX, right, fY));
		
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obrigações de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Obrigação de prova1 */
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Refinement,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(fY, right));
    	ops.add(op1);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0529");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C.129", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_RECURSION);
    	
    	
    	/* Adicionando Detalhes de Lei*/
    	
    	return result;
	}
	
	
	/**
	 * Cria a lei C.128 ( Recursion Unfold )
	 * 
	 * @return 
	 */
	public CircusLaw criarLeiRecursionUnfoldPart2() {
		
		/* Criando o LHS da lei */
		JokerAction fX = factory.createJokerAction("F(X)", null);
		JokerName x = 
			this.getFactory().createJokerName("X", null);
		MuAction left = this.factory.createMuAction(fX, x);
		
		/* Criando o RHS da lei */
		JokerAction right = factory.createJokerAction("F(uX @ F(X))", null);
		
		/* Usada na OP */
		fX.getAnns().add(new RecursionUnfoldPart2Ann(x,fX,right));
		
		
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obrigações de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0745");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C.128_2", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_RECURSION);
    	
    	
    	
    	return result;
	}
	
	
	/**
	 * Cria a lei C.128 ( Recursion Unfold )
	 * 
	 * @return 
	 */
	public CircusLaw criarLeiRecursionUnfoldPart1() {
		
		/* Criando o LHS da lei */
		JokerAction fX = factory.createJokerAction("F(X)", null);
		JokerName x = 
			this.getFactory().createJokerName("X", null);
		
		MuAction left = this.factory.createMuAction(fX, x);
		
		/* Criando o RHS da lei */
		JokerAction right = factory.createJokerAction("F(uX @ F(X))", null);
		
		/* Usada na OP */
		right.getAnns().add(new RecursionUnfoldPart1Ann(x,fX,right));
		
		
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obrigações de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0751");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C.128_1", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_RECURSION);
    	
    	
    	
    	return result;
	}
	
	public CircusLaw criarLeiVarExpRec() {
		
		/* Criando o LHS da lei */
		JokerAction fX = factory.createJokerAction("F(X)", null);
		JokerName x = 
			this.getFactory().createJokerName("X", null);
		
		JokerDeclList decl = factory.createJokerDeclList("x", null);	
		VarDeclCommand var = factory.createVarDeclCommand(decl, fX);	
		MuAction left = this.factory.createMuAction(var,x);
		
		/* Criando o RHS da lei */
	

		MuAction mu = this.factory.createMuAction(fX,x);		
		VarDeclCommand right = factory.createVarDeclCommand(decl, mu);
		
	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obrigações de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	String detailsOp = "x is Initialized before use in F";
		ArrayList<String> detailsListOps = new ArrayList<String>();
		detailsListOps.add(detailsOp);
    	

    	/* Criando a Lei */
    	String nome = this.createName("VarExpRec");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C.1012", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_RECURSION);
    	

		LawDefinitionAnn defAnn = new LawDefinitionAnn(detailsListOps);

		result.getAnns().add(defAnn);

    	return result;
	}

	public CircusLaw criarLeiRecSync() {
		
		/* Criando o LHS da lei 
		 * uX . A1; c -> X [ns1 | {c} U cs | ns2] uX . A2; c -> X
		 * 
		 * */
		JokerAction fX = factory.createJokerAction("X", null);
		JokerName x = 
			this.getFactory().createJokerName("X", null);

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
	
		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);

		FieldList flist = this.getFactory().createCircusFieldList();
		Communication com = this.factory.createCommunication(c, flist, 
				CommUsage.Normal, CommPattern.Input, null, null);
		
		
		PrefixingAction pref = factory.createPrefixingAction(fX,com);
		SeqAction seq1 = factory.createSeqAction(Arrays.asList(a1,pref));
		SeqAction seq2 = factory.createSeqAction(Arrays.asList(a2,pref));	

		MuAction mu1 = this.factory.createMuAction(seq1,x);		
		MuAction mu2 = this.factory.createMuAction(seq2,x);
	
		
		/* Paralelismo*/
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);
		
		/* Lista de argumentos da aniao */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(csExpr, c));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplicacao daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoA1), true);

		CircusChannelSet channel = this.factory.createCircusChannelSet(applUniao);
		
		ParallelAction left = factory.createParallelAction
		(Arrays.asList(mu1,mu2), Arrays.asList(ns1,ns2), channel);
	

		/*Parte direita
		 * uX . (A1 || A2);c -> X
		 */
		
		ParallelAction parRight = factory.createParallelAction
		(Arrays.asList(a1,a2), Arrays.asList(ns1,ns2), cs);
		
		SeqAction seqRight = factory.createSeqAction(Arrays.asList(parRight,pref));
		
		MuAction right = factory.createMuAction(seqRight, x);
	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obrigações de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	

		/*
		 * *************************** *
		 * OP2: wrtV(A1) ^ usedV(A2) = 0 *
		 * *************************** *
		 */
    	
    	
    	RefExpr funWrtv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.WRT_V);
    	/* Aplicacao wrtv*/
    	
    	RefExpr argWR = this.getFactory().createRefExpr();
    	argWR.getAnns().add(new ActionArgumentAnn(a1));
    	
    		
		ApplExpr applWrtv = 
			this.getFactory().createApplExpr(Arrays.asList(funWrtv, 
					argWR), false);
		
		RefExpr funUsedV = OPsDischargeUtils.refFuncao(OPsDischargeUtils.USED_V);
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedV = this.getFactory().createRefExpr();
		argUsedV.getAnns().add(new ActionArgumentAnn(a2));
		
		/* Aplicacao FV_Action 2 */
		ApplExpr applUsedV = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedV, 
					argUsedV), false);
    	
	
       /*Criando a Intersecao */
		
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);
		

		/* Lista de argumentos da intersecao */
		ZExprList listaInter = 
			this.getFactory().createZExprList
			(Arrays.asList(applWrtv,applUsedV));
		TupleExpr argsInter = 
			this.getFactory().createTupleExpr(listaInter);

		/* Aplicacao da intersecao */
		ApplExpr applInter = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsInter), true);
		
		/* Monta a referencia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applInter, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);
        

		/*
		 * OP2 wrtV(A2) ^ usedV(A1) = O
		 */
		
		RefExpr argWR2 = this.getFactory().createRefExpr();
		argWR2.getAnns().add(new ActionArgumentAnn(a2));
    	
		
	    applWrtv = this.getFactory().createApplExpr(Arrays.asList(funWrtv, 
					argWR2), false);
	    
	    RefExpr argUsedV2 = this.getFactory().createRefExpr();
	    argUsedV2.getAnns().add(new ActionArgumentAnn(a1));
		
		/* Aplicacao UsedV */
		applUsedV = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedV, 
					argUsedV2), false);
		
		ZExprList listaInter2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applWrtv,applUsedV));
		TupleExpr argsInter2 = 
			this.getFactory().createTupleExpr(listaInter2);

		/* Aplicacao da intersecao */
		ApplExpr applInter2 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsInter2), true);
    	
		
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(applInter2, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op2);
		
    	/* Criando a Lei */
    	String nome = this.createName("RecSync");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C.1031", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_RECURSION);

    	return result;
	}

	
	
}
