/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.FieldList;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.astmodifiers.CommunicationArgumentAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Prefixos
 * 
 * @author Cristiano Castro
 */
public class PrefixLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public PrefixLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_PREFIX, codName);
	}
	
	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		/* C.100*/
		result.add(createLawPrefixSkip());
		
		/* C.101*/
		result.add(createLawPrefixSequentialCompositionAssociativity());
		
		/* C.102*/
		result.add(createLawPrefixHiding());
		
		/* C.103*/
		result.add(createLawPrefixIntroduction());
		
		/* C.105*/
		result.add(createLawPrefixInternalChoiceDistribution());
		
		/* C.106*/
		result.add(createLawPrefixParrallelismCompositionDistribution());
		
		/* C.107*/
		result.add(createLawCommunicationParallelismCompositionDistribution());
		
		/* C.108*/
		result.add(createLawInputPrefixParrallelismCompositionDistribution());
		
		
		return result;
	}

	
	/**
	 * a lei C-100 de circus (<i> Prefix/Skip </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixSkip() {

		/* Criando o LHS da lei */

		JokerAction a = factory.createJokerAction("A", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		PrefixingAction left = factory.createPrefixingAction(a, c1);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par1 = factory.createPrefixingAction(
				factory.createSkipAction(), c1);
		
		SeqAction right = factory.createSeqAction(Arrays.asList(par1,a));
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0695");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.100", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	
	/**
	 * a lei C-101 de circus (<i> Prefix/Sequential Composition -- Associativity </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixSequentialCompositionAssociativity() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerCommunication c1 = factory.createJokerCommunication(null, null, 
    			null, null, null, null, "c1", null);
		
		
		//JokerCommunication c1 = this.getFactory().createJokerCommunication(refNomeCanal,
			//	this.getFactory().createCircusFieldList(), null, 
			//	null, null, null, null, null);
		/*Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);*/

		SeqAction par1 = factory.createSeqAction(Arrays.asList(a1,a2));
		PrefixingAction left = factory.createPrefixingAction(par1, c1);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par2 = factory.createPrefixingAction(a1, c1);
		
		SeqAction right = factory.createSeqAction(Arrays.asList(par2,a2));
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* 
		 * OP
		 */ 
		
		/* Montando o nome da fun��o alfa */
		ZName nomeInputVars = this.getFactory().createZName(
				OPsDischargeUtils.INPUT_VARS, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funInputVars = this.getFactory().createRefExpr(nomeInputVars, 
				this.getFactory().createZExprList(), false, false);
		RefExpr refNomeCanal = factory.createRefExpr();
		refNomeCanal.getAnns().add(new CommunicationArgumentAnn(c1));
		ApplExpr applInputVars = factory.createApplExpr(Arrays.asList(funInputVars,refNomeCanal), false);
		
		
		RefExpr funFv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argFVA2 = this.getFactory().createRefExpr();
		argFVA2.getAnns().add(new ActionArgumentAnn(a2));
		
		
		
		/* Aplicacao FV_Action 1 */
		
		ApplExpr applFVA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funFv, 
					argFVA2), false);

		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(applFVA2,applInputVars));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		/* Monta a refer�ncia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		//applIntersecao1
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);
		
		ops.add(op1);
		
		/* Criando a Lei */
		String nome = this.createName("COD0696");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.101", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	
	/**
	 * a lei C-102 de circus (<i> Prefix/Hiding </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixHiding() {

		/* Criando o LHS da lei */

		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		PrefixingAction par1 = factory.createPrefixingAction(
				factory.createSkipAction(), c1);
		CircusChannelSet c = factory.createCircusChannelSet(refNomeCanal);
		
		HideAction left = factory.createHideAction(par1, c);
		
		/* Criando o RHS da lei */
		
		SkipAction right = factory.createSkipAction();
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0697");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.102", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	
	/**
	 * a lei C-103 de circus (<i> Prefix Introduction </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixIntroduction() {

		/* Criando o LHS da lei */
		
		JokerAction left = factory.createJokerAction("A", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par1 = factory.createPrefixingAction(left, c1);
		CircusChannelSet c = factory.createCircusChannelSet(refNomeCanal);
		
		HideAction right = factory.createHideAction(par1, c);
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		
		
		/*
		 * OP1
		 */
		/* Montando o nome da fun��o usedC */
		ZName nomeUsedC = this.getFactory().createZName(
				OPsDischargeUtils.USED_C, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedC = this.getFactory().createRefExpr(nomeUsedC, 
				this.getFactory().createZExprList(), false, false);

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedCA = this.getFactory().createRefExpr();
		argUsedCA.getAnns().add(new ActionArgumentAnn(left));
		
		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA), false);
		
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(refNomeCanal,applUsedCA), 
					false);
		
		NegPred op1Neg = factory.createNegPred(op1);
		
		ops.add(op1Neg);
		
		/* Criando a Lei */
		String nome = this.createName("COD0698");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.103", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	/**
	 * a lei C-105 de circus (<i> Prefix/Internal Choice -- Distribution</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixInternalChoiceDistribution() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		IntChoiceAction par1 = factory.createIntChoiceAction(Arrays.asList(a1,a2));
		PrefixingAction left = factory.createPrefixingAction(par1, c1);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par2 = factory.createPrefixingAction(a1, c1);
		PrefixingAction par3 = factory.createPrefixingAction(a2, c1);
		
		IntChoiceAction right = factory.createIntChoiceAction(Arrays.asList(par2,par3));
		
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0699");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.105", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	
	/**
	 * a lei C-106 de circus (<i> Prefix/Parrallelism Composition -- Distribution</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawPrefixParrallelismCompositionDistribution() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet csSet =factory.createCircusChannelSet(csExpr);
		
		ZExprList listaa = factory.createZExprList(Arrays.asList(refNomeCanal));
		SetExpr cSetExpr = factory.createSetExpr(listaa);
		
		ParallelAction par1 = factory.createParallelAction(Arrays.asList(a1,a2)
				, Arrays.asList(ns1,ns2), csSet);
		
		PrefixingAction left = factory.createPrefixingAction(par1, c1);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par2 = factory.createPrefixingAction(a1, c1);
		PrefixingAction par3 = factory.createPrefixingAction(a2, c1);
		
		
		/* Montando Uniao */

		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(csExpr, cSetExpr));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplica��o daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsFuncaoA1), true);

		CircusChannelSet channel = this.factory.createCircusChannelSet(applUniao);

		ParallelAction right = factory.createParallelAction
		(Arrays.asList(par2,par3), Arrays.asList(ns1,ns2), channel);
		
		
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		
		/*
		 * OP
		 */
		
		RefExpr funUsedC = OPsDischargeUtils.refFuncao(OPsDischargeUtils.USED_C);
		
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedCA1 = this.getFactory().createRefExpr();
		argUsedCA1.getAnns().add(new ActionArgumentAnn(a1));

		RefExpr argUsedCA2 = this.getFactory().createRefExpr();
		argUsedCA2.getAnns().add(new ActionArgumentAnn(a2));

		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA1), false);

		ApplExpr applUsedCA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA2), false);

		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applUsedCA1,applUsedCA2 ));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);
		
		MemPred parr1 = factory.createMemPred(Arrays.asList(refNomeCanal,applUniao2), false);
		NegPred parr2 = factory.createNegPred(parr1);
		
		MemPred parr3 = factory.createMemPred(Arrays.asList(refNomeCanal,csExpr), false);
		
		OrPred op = factory.createOrPred(Arrays.asList(parr2,parr3));
		
		ops.add(op);
		
		
		/* Criando a Lei */
		String nome = this.createName("COD0700");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.106", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	
	
	/**
	 * a lei C-107 de circus (<i> Communication/Parallelism Composition 
	 * -- Distribution</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawCommunicationParallelismCompositionDistribution() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerName a2 = factory.createJokerName("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		
		
		JokerExpr e = factory.createJokerExpr("e", null);
		JokerName x = factory.createJokerName("x", null);
		RefExpr refX = factory.createRefExpr(x, null, false, false);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		
		DotField cOutE = this.getFactory().createDotField(e);
		cOutE.getAnns().add(factory.createOutputFieldAnn());
		
		InputField  cInX = factory.createInputField(x, factory.createTruePred());
		
		CircusFieldList cField1 = factory.createCircusFieldList(Arrays.asList(cOutE));
		CircusFieldList cField2 = factory.createCircusFieldList(Arrays.asList(cInX));
		
		Communication c1OutE = this.getFactory().createCommunication(refNomeCanal, 
				cField1, CommUsage.Normal, 
				CommPattern.Synch, null, null);
		
		Communication c1InX = this.getFactory().createCommunication(refNomeCanal, 
				cField2, CommUsage.Normal, 
				CommPattern.Synch, null, null);

		
		ExprList listaExprX = factory.createZExprList(Arrays.asList(refX));
		ExprList listaExprE = factory.createZExprList(Arrays.asList(e));
		
		CallAction a2X = factory.createCallAction(a2, listaExprX);
		CallAction a2e = factory.createCallAction(a2, listaExprE);
		
		PrefixingAction par1 = factory.createPrefixingAction(a1, c1OutE);
		PrefixingAction par2 = factory.createPrefixingAction(a2X, c1InX);
		
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet csSet =factory.createCircusChannelSet(csExpr);
		
		
		ParallelAction left = factory.createParallelAction(Arrays.asList(par1,par2)
				, Arrays.asList(ns1,ns2), csSet);
		
		/* Criando o RHS da lei */
		
		DotField eDot = factory.createDotField(e);
		FieldList eDotList = factory.createCircusFieldList(Arrays.asList(eDot));
		Communication cDote = this.getFactory().createCommunication(refNomeCanal, 
				eDotList, CommUsage.Normal, 
				CommPattern.Synch, null, null);
		
		ParallelAction par4 = factory.createParallelAction(Arrays.
				asList(a1,a2e), Arrays.asList(ns1,ns2), csSet);
		
		PrefixingAction right = factory.createPrefixingAction(par4, cDote);
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		
		/*
		 * OPs
		 */
		
		MemPred op1 = factory.createMemPred(Arrays
				.asList(refNomeCanal,csExpr), false);
		
		CallAction act2 = factory.createCallAction(a2);
		
		RefExpr funFv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		/* ListaArgumentos da fun��o UsedC */
		RefExpr argFVA2 = this.getFactory().createRefExpr();
		argFVA2.getAnns().add(new ActionArgumentAnn(act2));
		
		ApplExpr applFVA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funFv, 
					argFVA2), false);
		
		MemPred op2aux = factory.createMemPred(Arrays.asList(refX,applFVA2), false);
		NegPred op2 = factory.createNegPred(op2aux);
		
		ops.add(op1);
		ops.add(op2);
		
		/* Criando a Lei */
		String nome = this.createName("COD0701");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.107", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
	
	/**
	 * a lei C-108 de circus (<i> Input Prefix/ Parrallelism 
	 * Composition -- Distribution</i>.
	 * 
	 * @return a nova lei de circus
	 */
	
	public CircusLaw createLawInputPrefixParrallelismCompositionDistribution() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		
		JokerName x = factory.createJokerName("x", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		
		InputField  cInX = factory.createInputField(x, factory.createTruePred());
		
		CircusFieldList cField2 = factory.createCircusFieldList(Arrays.asList(cInX));
		
		Communication c1InX = this.getFactory().createCommunication(refNomeCanal, 
				cField2, CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet csSet =factory.createCircusChannelSet(csExpr);
		
		
		ParallelAction par1 = factory.createParallelAction(Arrays.asList(a1,a2)
				, Arrays.asList(ns1,ns2), csSet);
		
		PrefixingAction left = factory.createPrefixingAction(par1, c1InX);
		
		/* Criando o RHS da lei */
		
		PrefixingAction par2 = factory.createPrefixingAction(a1, c1InX);
		PrefixingAction par3 = factory.createPrefixingAction(a2, c1InX);
		ParallelAction right = factory.createParallelAction(Arrays.
				asList(par2,par3), Arrays.asList(ns1,ns2), csSet);
				
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		
		/*
		 * OPs
		 */
		
		MemPred op1 = factory.createMemPred(Arrays
				.asList(refNomeCanal,csExpr), false);
		
		ops.add(op1);
		
		/* Criando a Lei */
		String nome = this.createName("COD0702");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.108", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PREFIX);

		return result;

	}
}
