/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.BasicChannelSetExpr;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusCommunicationList;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CircusNameSet;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.ZDeclListImpl;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.anotations.ChannelExtensionAnn;
import circusRefine.core.crules.utils.DashedTerm;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * Cria as leis da parte de Parallelism Composition.
 * 
 * @author Cristiano Castro
 */
public class ParallelismCompositionLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a nova f�brica de leis informando o src da 
	 * internacionaliza��o
	 * 
	 * @param inter o arquivo respons�vel pela internacionaliza��o
	 */
	public ParallelismCompositionLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/* C.76 */
		result.add(this.criarLeiParallelismCompositionCommutativity());

		/* C-78 */
		result.add(this.createLawParallelismCompositionIntroduction1_1());

		/* C-80 */
		result.add(this.createLawChannelExtension());

		/* C-81 */
		result.add(this.createLawChannelExtension2());

		/* C-82 */
		result.add(this.createLawChannelExtension3());

		/* C-83 */
		result.add(this.criarLeiChannelExtension4Parte1RefinamentoParaDir());
		result.add(this.criarLeiChannelExtension4Parte1RefinamentoParaEsq());

		/* C.84 */
		result.add(this.criarLeiParallelismCompositionSequenceStep());

		/* C.85 */
		result.add(this.criarLeiParallelismCompositionExternalChoiceExchange());

		/* C.86 */
		result.add(this.criarLeiParallelsimCompositionExternalChoiceExpansion());

		/* C.87 */
		result.add(this.criarLeiParallelsimCompositionExternalChoiceDistribution());

		/* C.88 */
		result.add(this.criarLeiParallelismCompositionSequenceDistribution());

		/* C.90 */
		result.add(this.createLawParallelismCompositionUnit());

		/* C.91 */
		result.add(this.createLawParallelismCompositionUnit2());

		/* C.92 */
		result.add(this.createLawParallelismDeadLocked1P1());
		result.add(this.createLawParallelismDeadLocked1P2());

		/* C.93 */
		result.add(this.createLawParallelismDeadLocked2());

		/* C.94 */
		result.add(this.createLawParallelismCompositionZero());

		result.add(this.createLawVar_Exp_Par2());

		result.add(criarLeiParallelismCompositionSequenceStep2());

		result.add(criarLeiVarExpPar());

		result.add(createLawParInter());
		
		result.add(this.createLawParOutInpInterExchange2());
		
		result.add(this.createLawParOutInpInterExchange3());

		return result;
	}

	/**
	 * Cria a Lei <i>Parallelism composition commutativity</i> 
	 * 		(C-76).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiParallelismCompositionCommutativity() {

		/* Criando o LHS da lei */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		ParallelAction left = 
			factory.createParallelAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2), cs);

		/* Criando o RHS da lei */
		ParallelAction right = 
			factory.createParallelAction(Arrays.asList(a2, a1), 
					Arrays.asList(ns2, ns1), cs);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0477");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.76", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}

	/**
	 * Cria a primeira parte da lei C-78 de circus (<i>Parallelism
	 * composition introduction 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismCompositionIntroduction1_1() {

		/* Criando o LHS da lei */
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		PrefixingAction cThenA = this.getFactory().createPrefixingAction(a, c);

		/* Criando o RHS da lei */

		SkipAction skip = this.getFactory().createSkipAction();
		PrefixingAction cThenSkip = 
			this.getFactory().createPrefixingAction(skip, c);

		JokerExpr ns1Expr = this.getFactory().createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.getFactory().createCircusNameSet(ns1Expr);
		JokerNameSet ns2 = this.getFactory().createJokerNameSet("ns2", null);
		CircusCommunicationList listaC = 
			this.getFactory().createCircusCommunicationList(Arrays.asList(c));
		BasicChannelSetExpr exprConjC = 
			this.getFactory().createBasicChannelSetExpr(listaC);
		ChannelSet conjC = this.getFactory().createCircusChannelSet(exprConjC);
		ParallelAction right = 
			this.getFactory().createParallelAction(Arrays.asList(cThenA, 
					cThenSkip), Arrays.asList(ns1, ns2), conjC);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(cThenA, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * ************************* *
		 * OP1: \not(c \in usedC(A)) *
		 * ************************* * 
		 */
		RefExpr argA = this.getFactory().createRefExpr();
		argA.getAnns().add(new ActionArgumentAnn(a));

		RefExpr usedC = OPsDischargeUtils.refFuncao(OPsDischargeUtils.USED_C);
		ApplExpr usedCA = 
			this.getFactory().createApplExpr(Arrays.asList(usedC, argA), false);
		MemPred cInUsedCA = 
			this.getFactory().createMemPred(Arrays.asList(refNomeCanal, usedCA), 
					false);
		NegPred notCInUsedCA = this.getFactory().createNegPred(cInUsedCA);

		ops.add(notCInUsedCA);

		/*
		 * *************************** *
		 * OP2: wrtV(A) \subseteq ns_1 *
		 * *************************** *
		 */
		RefExpr wrtV = OPsDischargeUtils.refFuncao(OPsDischargeUtils.WRT_V);
		ApplExpr wrtVA = 
			this.getFactory().createApplExpr(Arrays.asList(wrtV, argA), false);

		ZExprList listaWrtVANs1 = 
			this.getFactory().createZExprList(Arrays.asList(ns1Expr, wrtVA));
		TupleExpr wrtVANs1 = this.getFactory().createTupleExpr(listaWrtVANs1);

		RefExpr subseteq = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.SUBSETEQ);
		MemPred wrtVASubseteqNs1 = 
			this.getFactory().createMemPred(Arrays.asList(wrtVANs1, subseteq), 
					true);

		ops.add(wrtVASubseteqNs1);

		/* Criando a Lei */
		String nome = this.createName("COD0598");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.78_1", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}




	/**
	 * a lei C-80 de circus (<i>Channel extension
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawChannelExtension() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ParallelAction left = factory.createParallelAction(Arrays
				.asList(a1,a2), Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */
		JokerName c = factory.createJokerName("c", null);
		RefExpr exprc = factory.createRefExpr(c, this.factory
				.createJokerExprList(),false, false);
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(csExpr, exprc));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplica��o daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoA1), true);

		CircusChannelSet channel = this.factory.createCircusChannelSet(applUniao);

		ParallelAction right = factory.createParallelAction
		(Arrays.asList(a1,a2), Arrays.asList(ns1,ns2), channel);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * ************************* *
		 * OP1: \not(c \in usedC(A)) *
		 * ************************* * 
		 */

		RefExpr argA1 = this.getFactory().createRefExpr();
		argA1.getAnns().add(new ActionArgumentAnn(a1));

		RefExpr argA2 = this.getFactory().createRefExpr();
		argA2.getAnns().add(new ActionArgumentAnn(a2));

		RefExpr usedC = OPsDischargeUtils.refFuncao(OPsDischargeUtils.USED_C);

		ApplExpr usedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(usedC, argA1), false);
		ApplExpr usedCA2 = 
			this.getFactory().createApplExpr(Arrays.asList(usedC, argA2), false);

		ZExprList listaArgs = factory.createZExprList(Arrays.asList(usedCA1,usedCA2));
		TupleExpr expr = factory.createTupleExpr(listaArgs);
		ApplExpr uniaoCA1CA2 = factory.createApplExpr(
				Arrays.asList(funCUniao,expr), true);

		MemPred cIn = 
			this.getFactory().createMemPred(Arrays.asList(exprc, uniaoCA1CA2), 
					false);
		NegPred op1 = this.getFactory().createNegPred(cIn);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0680");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.80", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}


	/**
	 * a lei C-81 de circus (<i>Channel extension 2
	 * </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawChannelExtension2() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2E = factory.createJokerAction("A2(e)", null);
		JokerExpr e = factory.createJokerExpr("e", null);
		ExprList elist = factory.createZExprList(Arrays.asList(e));



		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ParallelAction left = factory.createParallelAction(Arrays
				.asList(a1,a2E), Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */

		JokerName c = factory.createJokerName("c", null);
		RefExpr refC = factory.createRefExpr(c, factory.createZExprList(), false, false);


		DotField eOut = this.getFactory().createDotField(e);
		eOut.getAnns().add(factory.createOutputFieldAnn());

		CircusFieldList listaOutE = 
			this.factory.createCircusFieldList(Arrays.asList(eOut));

		Communication cOutE = this.factory.createCommunication(refC, listaOutE, 
				CommUsage.Normal, CommPattern.Output, null, null);

		PrefixingAction cOutEThenA1 = this.factory.createPrefixingAction(a1, cOutE);

		JokerName x = factory.createJokerName("x", null);
		RefExpr refX = factory.createRefExpr(x, factory.createZExprList(), false, false);

		JokerAction a2X = factory.createJokerAction("A2(x)", null);
		a2X.getAnns().add(new ChannelExtensionAnn(e,x, a2X, a2E));

		InputField xIn = this.factory.createInputField(x,
				factory.createTruePred());

		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(xIn));

		Communication cInX = this.factory.createCommunication(refC, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);


		PrefixingAction cInXThenA2 = this.factory.createPrefixingAction(a2X, cInX);


		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(csExpr, refC));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplica��o daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoA1), true);

		CircusChannelSet channel = this.factory.createCircusChannelSet(applUniao);

		ParallelAction right = factory.createParallelAction
		(Arrays.asList(cOutEThenA1,cInXThenA2), Arrays.asList(ns1,ns2), channel);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * ************************* *
		 * OP1 *
		 * ************************* * 
		 */

		RefExpr argA1 = this.getFactory().createRefExpr();
		argA1.getAnns().add(new ActionArgumentAnn(a1));

		RefExpr argA2 = this.getFactory().createRefExpr();
		argA2.getAnns().add(new ActionArgumentAnn(a2E));

		RefExpr usedC = OPsDischargeUtils.refFuncao(OPsDischargeUtils.USED_C);

		ApplExpr usedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(usedC, argA1), false);
		ApplExpr usedCA2 = 
			this.getFactory().createApplExpr(Arrays.asList(usedC, argA2), false);

		ZExprList listaArgs = factory.createZExprList(Arrays.asList(usedCA1,usedCA2));
		TupleExpr expr = factory.createTupleExpr(listaArgs);
		ApplExpr uniaoCA1CA2 = factory.createApplExpr(
				Arrays.asList(funCUniao,expr), true);

		MemPred cIn = 
			this.getFactory().createMemPred(Arrays.asList(refC, uniaoCA1CA2), 
					false);
		NegPred op1 = this.getFactory().createNegPred(cIn);

		/* ************************* *
		 * OP2*
		 * ************************* * 
		 */


		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		ApplExpr fvA2 = 
			this.getFactory().createApplExpr(Arrays.asList(fv, argA2), false);
		MemPred xInFVA2 = 
			this.getFactory().createMemPred(Arrays.asList(refX, fvA2), 
					false);
		NegPred op2 = this.getFactory().createNegPred(xInFVA2);

		/* ************************* *
		 * OP3*
		 * ************************* * 
		 */

		/* Montando a refer�ncia a fun��o FVE */

		RefExpr funFreeV = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);


		ApplExpr applFVe = 
			this.getFactory().createApplExpr(Arrays.asList(funFreeV, e), 
					false);

		/* Monta a referencia a fun��o "_ \cap _" */

		ZName nomeIntersecao = this.getFactory().createZName(ZString.ARG_TOK + 
				ZString.CAP + ZString.ARG_TOK, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		RefExpr funWrtV = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.WRT_V);

		ApplExpr applfunWrtVA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funWrtV, argA2), 
					false);

		ExprList listaArgsFvWrtV = 
			this.getFactory().createZExprList(Arrays.asList(applFVe, 
					applfunWrtVA2));

		TupleExpr argr = 
			this.getFactory().createTupleExpr(listaArgsFvWrtV);

		ApplExpr semiop2 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argr), true);

		/* Monta a refer�ncia ao conjunto vazio */
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			SchemaLawsFactory.montarConjuntoUnitarioDoConjuntoVazio();

		/* Igualdade */
		MemPred op3 = 
			this.getFactory().createMemPred(
					Arrays.asList(semiop2, 
							conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);
		ops.add(op2);
		ops.add(op3);

		/* Criando a Lei */
		String nome = this.createName("COD0682");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.81", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}



	/**
	 * a lei C-82 de circus (<i>Channel extension 3
	 * </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawChannelExtension3() {


		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2E = factory.createJokerAction("A2(e)", null);


		//JokerName e = factory.createJokerName("e", null);
		//RefExpr refE = factory.createRefExpr(e, null, false, false);
		JokerExpr refE = factory.createJokerExpr("e", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		JokerExpr cs1Expr = factory.createJokerExpr("cs1", null);
		JokerExpr cs2Expr = factory.createJokerExpr("cs2", null);

		CircusChannelSet cs = factory.createCircusChannelSet(cs1Expr);
		CircusChannelSet cs2 = factory.createCircusChannelSet(cs2Expr);

		ParallelAction preleft = factory.createParallelAction(Arrays
				.asList(a1,a2E), Arrays.asList(ns1,ns2), cs);

		HideAction left = factory.createHideAction(preleft, cs2);


		/* Criando o RHS da lei */

		JokerName c = factory.createJokerName("c", null);
		RefExpr refC = factory.createRefExpr(c, factory.createZExprList(), false, false);

		DotField eOut = this.getFactory().createDotField(refE);
		eOut.getAnns().add(factory.createOutputFieldAnn());

		CircusFieldList listaOutE = 
			this.factory.createCircusFieldList(Arrays.asList(eOut));

		Communication cOutE = this.factory.createCommunication(refC, listaOutE, 
				CommUsage.Normal, CommPattern.Output, null, null);

		PrefixingAction cOutEThenA1 = this.factory.createPrefixingAction(a1, cOutE);

		JokerName x = factory.createJokerName("x", null);
		RefExpr refX = factory.createRefExpr(x, factory.createZExprList(), false, false);

		InputField xIn = this.factory.createInputField(x,
				factory.createTruePred());

		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(xIn));

		Communication cInX = this.factory.createCommunication(refC, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);

		JokerAction a2X = factory.createJokerAction("A2(x)", null);
		a2X.getAnns().add(new ChannelExtensionAnn(refE,x, a2X, a2E));

		PrefixingAction cInXThenA2 = this.factory.createPrefixingAction(a2X, cInX);


		ParallelAction preRight = factory.createParallelAction
		(Arrays.asList(cOutEThenA1,cInXThenA2), Arrays.asList(ns1,ns2), cs);

		HideAction right = factory.createHideAction(preRight, cs2);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * ************************* *
		 * OP1  e OP2*
		 * ************************* * 
		 */

		MemPred memberShipPred1 = 
			factory.createMemPred(Arrays.asList(refC, cs1Expr), false);
		MemPred memberShipPred2 = 
			factory.createMemPred(Arrays.asList(refC, cs2Expr), false);
		ops.add(memberShipPred1);
		ops.add(memberShipPred2);


		/* ************************* *
		 * OP3*
		 * ************************* * 
		 */

		RefExpr argA2 = this.getFactory().createRefExpr();
		argA2.getAnns().add(new ActionArgumentAnn(a2E));


		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		ApplExpr fvA2 = 
			this.getFactory().createApplExpr(Arrays.asList(fv, argA2), false);
		MemPred xInFVA2 = 
			this.getFactory().createMemPred(Arrays.asList(refX, fvA2), 
					false);

		NegPred op3 = this.getFactory().createNegPred(xInFVA2);
		ops.add(op3);


		/* Criando a Lei */
		String nome = this.createName("COD0749");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.82", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}



	/**
	 * Cria Uma lei <i>Channel Extension 4 Part 1</i> (C-83). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiChannelExtension4Parte1RefinamentoParaDir() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr cs1Expr = factory.createJokerExpr("cs1Expr", null);
		JokerExpr cs2Expr = factory.createJokerExpr("cs2Expr", null);
		CircusChannelSet cs1 = factory.createCircusChannelSet(cs1Expr);
		CircusChannelSet cs2 = factory.createCircusChannelSet(cs2Expr);
		ParallelAction par = factory.createParallelAction(Arrays.asList(a1, a2),
				Arrays.asList(ns1, ns2), cs1);
		HideAction left = factory.createHideAction(par, cs2);

		/* Criano do RHS */
		JokerName nomeCanal = factory.createJokerName("channelName", null);
		RefExpr ref = factory.createRefExpr(nomeCanal, 
				factory.createZExprList(), false, false);
		Communication c = factory.createCommunication(ref, 
				factory.createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		/* Adicionando anota��o para montar as OPs */
		PrefixingAction a3 = factory.createPrefixingAction(a1, c);
		PrefixingAction a4 = factory.createPrefixingAction(a2, c);
		ParallelAction par2 = factory.createParallelAction(Arrays.asList(a3, 
				a4), Arrays.asList(ns1, ns2), cs1);
		HideAction right = factory.createHideAction(par2, cs2);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();
		MemPred memberShipPred1 = 
			factory.createMemPred(Arrays.asList(ref, cs1Expr), false);
		MemPred memberShipPred2 = 
			factory.createMemPred(Arrays.asList(ref, cs2Expr), false);
		list.add(memberShipPred1);
		list.add(memberShipPred2);

		String nome = this.createName("COD0515");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);
		LawNumberAnn id = new LawNumberAnn("C.83_1", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}


	/**
	 * Cria Uma lei <i>Parallelism Composition/External choice Expansion</i> (C-86). 
	 * Esta lei foi feita apenas para o caso simples; 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiParallelsimCompositionExternalChoiceExpansion() {

		//TODO fazer essa lei para caso geral

		/* criando o LHS */
		JokerName nomeCanal = this.getFactory().createJokerName("a1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication comA1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerAction a1 = this.getFactory().createJokerAction("A1", null);
		PrefixingAction a1ThenA1 = this.getFactory().createPrefixingAction(a1, comA1);

		JokerName nomeCanalB = this.getFactory().createJokerName("b1", null);
		RefExpr refNomeCanalB = this.getFactory().createRefExpr(nomeCanalB, 
				this.getFactory().createZExprList(), false, false);
		Communication comB1 = this.getFactory().createCommunication(refNomeCanalB, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);
		JokerAction b1 = this.getFactory().createJokerAction("B1", null);
		PrefixingAction b1ThenB1 = this.getFactory().createPrefixingAction(b1, comB1);


		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		JokerExpr cs = factory.createJokerExpr("cs", null);

		CircusChannelSet csChannelSet = factory.createCircusChannelSet(cs);

		ParallelAction left = factory.createParallelAction(Arrays.asList(a1ThenA1, b1ThenB1),
				Arrays.asList(ns1, ns2), csChannelSet);

		/* Criano do RHS */

		JokerName nomeCanalC = factory.createJokerName("c", null);
		RefExpr refC = factory.createRefExpr(nomeCanalC, 
				factory.createZExprList(), false, false);
		Communication c = factory.createCommunication(refC, 
				factory.createCircusFieldList(), CommUsage.Normal, 

				CommPattern.Synch, null, null);
		JokerAction cAction = factory.createJokerAction("C", null);

		PrefixingAction cThenC = factory.createPrefixingAction(cAction, c);
		ExtChoiceAction bExtc = this.factory.createExtChoiceAction(Arrays.asList(b1ThenB1, cThenC));

		ParallelAction right = factory.createParallelAction(Arrays.asList(a1ThenA1, 
				bExtc), Arrays.asList(ns1, ns2), csChannelSet);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1*/


		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(refNomeCanal, cs));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);


		/* OP2*/
		MemPred memberShipPred1 = 
			factory.createMemPred(Arrays.asList(refC, cs), false);

		/* OP3*/

		SetExpr exprs1 = factory.createSetExpr(factory.createZExprList(Arrays.asList(refNomeCanal)));
		MemPred preop3 = 
			factory.createMemPred(Arrays.asList(refC, exprs1), false);
		NegPred op3 = factory.createNegPred(preop3);

		/* OP4*/
		SetExpr exprs2 = factory.createSetExpr(factory.createZExprList(Arrays.asList(refNomeCanalB)));
		MemPred preop4 = 
			factory.createMemPred(Arrays.asList(refC, exprs2), false);
		NegPred op4 = factory.createNegPred(preop4);


		/* Adicionando OPs*/
		list.add(op1);
		list.add(memberShipPred1);
		list.add(op3);
		list.add(op4);



		String nome = this.createName("COD0750");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);
		LawNumberAnn id = new LawNumberAnn("C.86", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}




	/**
	 * Cria Uma lei <i>Parallelism Composition/External choice Expansion</i> (C-86). 
	 * Esta lei foi feita apenas para o caso simples; 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiParallelsimCompositionExternalChoiceDistribution() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction b = factory.createJokerAction("B", null);

		JokerExpr csExpr = this.factory.createJokerExpr("cs", null);
		CircusChannelSet cs = this.factory.createCircusChannelSet(csExpr);

		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);

		ParallelAction parte1 = factory.createParallelAction(
				Arrays.asList(a1,b), Arrays.asList(ns1,ns2) ,cs);

		ParallelAction parte2 = factory.createParallelAction(
				Arrays.asList(a2,b), Arrays.asList(ns1,ns2) ,cs);

		ExtChoiceAction left = factory.createExtChoiceAction
		(Arrays.asList(parte1,parte2));

		/* Criando do RHS */

		ExtChoiceAction parter11 = factory.createExtChoiceAction(
				Arrays.asList(a1,a2));


		ParallelAction right = factory.createParallelAction(
				Arrays.asList(parter11,b), Arrays.asList(ns1,ns2) ,cs);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* OP1*/
		/* 
		 ***********************************
		 * OP1: initials(A_3) \subseteq cs *
		 ***********************************
		 */

		/* Montando a refer�ncia � fun��o initials */
		ZName nomeInitials = 
			this.getFactory().createZName(OPsDischargeUtils.INITIALS, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funInicials = this.getFactory().createRefExpr(nomeInitials, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o initial */
		RefExpr argInitials = this.getFactory().createRefExpr();
		argInitials.getAnns().add(new ActionArgumentAnn(b));

		/* Aplica��o da fun��o initials */
		ApplExpr applInicials = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitials), false);

		/* Montando a refer�ncia a fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(applInicials, csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);

		/*OP2*/

		/* Monta a refer�ncia � fun��o "divergenceFree" */
		ZName det = 
			this.getFactory().createZName(OPsDischargeUtils.DETERMINISTIC, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funDet = 
			this.getFactory().createRefExpr(det, 
					this.getFactory().createZExprList(), false, false);

		/* Montando a aplica��o "divergenceFree(A_3)" */
		ApplExpr applDivergenceFreeA3 = 
			this.getFactory().createApplExpr(Arrays.asList(funDet, 
					argInitials), false);

		ExprPred op2 = this.getFactory().createExprPred(applDivergenceFreeA3);

		/* Adicionando ops*/
		ops.add(op1);
		ops.add(op2);

		String nome = this.createName("COD0752");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.87", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}








	/**
	 * Cria Uma lei <i>Channel Extension 4 Part 1</i> (C-83). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiChannelExtension4Parte1RefinamentoParaEsq() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		JokerName nomeCanal = factory.createJokerName("c", null);
		RefExpr ref = factory.createRefExpr(nomeCanal, 
				factory.createZExprList(), false, false);
		Communication c = factory.createCommunication(ref, 
				factory.createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);
		PrefixingAction parLeftAction = factory.createPrefixingAction(a1, c);
		PrefixingAction parRightAction = factory.createPrefixingAction(a2, c);

		JokerExpr cs1Expr = factory.createJokerExpr("cs1Expr", null);
		JokerExpr cs2Expr = factory.createJokerExpr("cs2Expr", null);
		CircusChannelSet cs1 = factory.createCircusChannelSet(cs1Expr);
		CircusChannelSet cs2 = factory.createCircusChannelSet(cs2Expr);
		ParallelAction par = 
			factory.createParallelAction(Arrays.asList(parLeftAction, 
					parRightAction), Arrays.asList(ns1, ns2), cs1);
		HideAction left = factory.createHideAction(par, cs2);

		/* Criando do RHS */
		/* Joker que pega o nome do canal para montar as OPs */
		ParallelAction par2 = factory.createParallelAction(Arrays.asList(a1, 
				a2), Arrays.asList(ns1, ns2), cs1);
		HideAction right = factory.createHideAction(par2, cs2);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();
		MemPred memberShipPred1 = 
			factory.createMemPred(Arrays.asList(ref, cs1Expr), false);
		MemPred memberShipPred2 = 
			factory.createMemPred(Arrays.asList(ref, cs2Expr), false);
		list.add(memberShipPred1);
		list.add(memberShipPred2);

		String nome = this.createName("COD0520");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);
		LawNumberAnn id = new LawNumberAnn("C83_2", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}

	/**
	 * Cria Uma lei <i>Parallelism composition/Sequence -- step</i>
	 *  (C-84). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiParallelismCompositionSequenceStep() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction a3 = factory.createJokerAction("A3", null);
		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);
		JokerExpr csExpr = this.factory.createJokerExpr("cs", null);
		CircusChannelSet cs = this.factory.createCircusChannelSet(csExpr);
		SeqAction act1 = factory.createSeqAction(Arrays.asList(a1, a2));
		ParallelAction left = factory.createParallelAction(Arrays.asList(act1, 
				a3), Arrays.asList(ns1, ns2), cs);

		/* Criando do RHS */
		ParallelAction act2 = factory.createParallelAction(Arrays.asList(a2, 
				a3), Arrays.asList(ns1, ns2), cs);
		SeqAction right = factory.createSeqAction(Arrays.asList(a1, act2));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<? extends Pred> list = 
			this.montarOPsParallelismCompositionSequenceStep(a1, a3, 
					cs.getExpr(), ns1.getExpr());

		/* Criando Obriga��es de Prova */
		List<Pred> ops = new ArrayList<Pred>();


		/*
		 * OP1 segundo o artigo
		 * 
		 */


		/* ************************************* *
		 * OP 1 : usedC(A_1) = \emptyset *
		 * ************************************* *
		 */

		/* Montando o nome da fun��o usedC */
		ZName nomeUsedC = this.getFactory().createZName(
				OPsDischargeUtils.USED_C, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedC = this.getFactory().createRefExpr(nomeUsedC, 
				this.getFactory().createZExprList(), false, false);

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedC = this.getFactory().createRefExpr();
		argUsedC.getAnns().add(new ActionArgumentAnn(a1));

		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedC), false);

		/* Monta a refer�ncia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applUsedCA1, 
					conjuntoUnitarioDoConjuntoVazio), true);


		ops.add(op1);

		/**
		 * OP2
		 */

		/* Nome da fun��o wrtV */
		ZName nomeWrtV = this.getFactory().createZName(OPsDischargeUtils.WRT_V, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funWrtV = this.getFactory().createRefExpr(nomeWrtV, 
				this.getFactory().createZExprList(), false, false);

		/* Monta a aplica��o da fun��o wrtV(A_1) */
		ApplExpr applFunWrtVA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funWrtV, 
					argUsedC), false);

		/* Monta a refer�ncia � fun��o "usedV" */
		ZName nomeUsedV = this.getFactory().createZName(
				OPsDischargeUtils.FV_Action, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedV = this.getFactory().createRefExpr(nomeUsedV, 
				this.getFactory().createZExprList(), false, false);

		/* Aplica��o da fun��o "usedV(A_3)" */
		RefExpr argA3 = this.getFactory().createRefExpr();
		argA3.getAnns().add(new ActionArgumentAnn(a3));
		ApplExpr applFunUsedVA_3 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedV, 
					argA3), false);

		/* Cria a lista de argumentos "(wrtV(A_1), usedV(A_3))" */
		ZExprList listaArgsWrtVA1UsedVA3 = 
			this.getFactory().createZExprList(Arrays.asList(applFunWrtVA1, 
					applFunUsedVA_3));
		TupleExpr argsWrtVA1UsedVA3 = 
			this.getFactory().createTupleExpr(listaArgsWrtVA1UsedVA3);

		/* 
		 * Montando a aplica��o interse��o 
		 * "wrtV(A_1) \cap usedV(A_3)" 
		 */

		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		ApplExpr applIntersecaoWrtVA1UsedVA3 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsWrtVA1UsedVA3), true);

		/* Montando a op2 */
		MemPred op2 = 
			this.getFactory().createMemPred(
					Arrays.asList(applIntersecaoWrtVA1UsedVA3, 
							conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op2);

		/**
		 * OP3
		 */

		ZExprList listaArgsWrtVA1Ns1 = 
			this.getFactory().createZExprList(Arrays.asList(applFunWrtVA1, 
					ns1.getExpr()));
		TupleExpr argsWrtVA1Ns1 = 
			this.getFactory().createTupleExpr(listaArgsWrtVA1Ns1);

		/* Aplica��o da fun��o "wrtV(A_1) \subseteq ns1" */

		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		MemPred op3 = 
			this.getFactory().createMemPred(Arrays.asList(argsWrtVA1Ns1, 
					funSubsetEq), true);
		ops.add(op3);

		String nome = this.createName("COD0593");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.84", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}


	/**
	 * Cria Uma lei <i>Parallelism Composition\ExternalChoice - Exchange</i>
	 *  (C-85). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiParallelismCompositionExternalChoiceExchange() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction b1 = factory.createJokerAction("B1", null);
		JokerAction b2 = factory.createJokerAction("B2", null);

		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);

		ParallelAction parte1 = factory.createParallelAction(
				Arrays.asList(a1,a2), Arrays.asList(ns1,ns2) ,cs);

		ParallelAction parte2 = factory.createParallelAction(
				Arrays.asList(b1,b2), Arrays.asList(ns1,ns2) ,cs);

		ExtChoiceAction left = factory.createExtChoiceAction
		(Arrays.asList(parte1,parte2));

		/* Criando do RHS */

		ExtChoiceAction parter1 = factory.createExtChoiceAction(
				Arrays.asList(a1,b1));

		ExtChoiceAction parter2 = factory.createExtChoiceAction(
				Arrays.asList(a2,b2));

		ParallelAction right = factory.createParallelAction(
				Arrays.asList(parter1,parter2), Arrays.asList(ns1,ns2) ,cs);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1*/
		ParallelAction leftOp1 = factory.createParallelAction
		(Arrays.asList(a1,b2), Arrays.asList(ns1,ns2), cs);

		ParallelAction rightOp1 = factory.createParallelAction
		(Arrays.asList(a2,b1), Arrays.asList(ns1,ns2), cs);

		ActionTransformerPred op1 = factory.createActionTransformerPred
		(null, Transformation.Equivalence,CircusUtils.DEFAULT_REFINEMENT_MODEL 
				,Arrays.asList(leftOp1,rightOp1));

		/*OP2*/

		StopAction stop = factory.createStopAction();
		ActionTransformerPred op2 = factory.createActionTransformerPred
		(null, Transformation.Equivalence,CircusUtils.DEFAULT_REFINEMENT_MODEL 
				,Arrays.asList(rightOp1,stop));

		list.add(op1);
		list.add(op2);

		String nome = this.createName("COD0681");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.85", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}



	/**
	 * Cria Uma lei <i>Parallelism composition/Sequence -- Distribution</i>
	 *  (C-88). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiParallelismCompositionSequenceDistribution() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction b1 = factory.createJokerAction("B1", null);
		JokerAction b2 = factory.createJokerAction("B2", null);
		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);
		JokerExpr csExpr = this.factory.createJokerExpr("cs", null);
		CircusChannelSet cs = this.factory.createCircusChannelSet(csExpr);

		ParallelAction par1 = factory.createParallelAction(Arrays.
				asList(a1,a2), Arrays.asList(ns1,ns2), cs);

		ParallelAction par2 = factory.createParallelAction(Arrays.
				asList(b1,b2), Arrays.asList(ns1,ns2), cs);

		SeqAction left = factory.createSeqAction(Arrays.asList(par1,par2));

		/* Criando do RHS */

		SeqAction parr1 = factory.createSeqAction(Arrays.asList(a1,b1));
		SeqAction parr2 = factory.createSeqAction(Arrays.asList(a2,b2));

		ParallelAction right = factory.createParallelAction(Arrays.
				asList(parr1,parr2), Arrays.asList(ns1,ns2), cs);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* 
		 ***********************************
		 * OP1
		 ***********************************
		 */

		/* Montando a refer�ncia � fun��o initials */
		ZName nomeInitials = 
			this.getFactory().createZName(OPsDischargeUtils.INITIALS, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funInicials = this.getFactory().createRefExpr(nomeInitials, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o initial */
		RefExpr argInitialsB1 = this.getFactory().createRefExpr();
		argInitialsB1.getAnns().add(new ActionArgumentAnn(b1));

		RefExpr argInitialsB2 = this.getFactory().createRefExpr();
		argInitialsB2.getAnns().add(new ActionArgumentAnn(b2));

		/* Aplica��o da fun��o initials */
		ApplExpr applInicialsB1 = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitialsB1), false);

		ApplExpr applInicialsB2 = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitialsB2), false);

		/* Montando Uniao */

		/* Montando o nome da interse��o */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaUniao = 
			this.getFactory().createZExprList
			(Arrays.asList(applInicialsB1,applInicialsB2 ));
		TupleExpr argsUniao = 
			this.getFactory().createTupleExpr(listaUniao);

		/* Aplica��o da intersecao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao), true);


		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(applUniao,csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);
		/*
		 * ************************************* *
		 * OP 2 
		 * ************************************* *
		 */

		/* Montando o nome da fun��o usedC */
		ZName nomeUsedC = this.getFactory().createZName(
				OPsDischargeUtils.USED_C, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedC = this.getFactory().createRefExpr(nomeUsedC, 
				this.getFactory().createZExprList(), false, false);

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedCA1 = this.getFactory().createRefExpr();
		argUsedCA1.getAnns().add(new ActionArgumentAnn(a1));

		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA1), false);


		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsIntersecaoCsUsedCA1 = 
			this.getFactory().createZExprList(Arrays.asList(applUsedCA1, applInicialsB2));
		TupleExpr argsIntersecaoA1 = 
			this.getFactory().createTupleExpr(listaArgsIntersecaoCsUsedCA1);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecaoA1), true);

		/* Monta a refer�ncia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);
		/*
		 * ****************************************** *
		 * OP3
		 * ****************************************** *
		 */

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedCA2 = this.getFactory().createRefExpr();
		argUsedCA2.getAnns().add(new ActionArgumentAnn(a2));


		ApplExpr applUsedCA2 = factory.createApplExpr(Arrays.asList(funUsedC,argUsedCA2),false);

		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(applUsedCA2, applInicialsB1));
		TupleExpr argsIntersecaoOp3 = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao3 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecaoOp3), true);

		MemPred op3 = factory.createMemPred(Arrays.asList(applIntersecao3,
				conjuntoUnitarioDoConjuntoVazio)
				, true);

		/* **** */
		/* OP4  */
		/* **** */
		/* Montando o nome da fun��o usedC */

		ZName nomeUsedV = this.getFactory().createZName(
				OPsDischargeUtils.USED_V, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedV = this.getFactory().createRefExpr(nomeUsedV, 
				this.getFactory().createZExprList(), false, false);

		RefExpr argUsedVB1 = this.getFactory().createRefExpr();
		argUsedVB1.getAnns().add(new ActionArgumentAnn(b1));

		RefExpr argUsedVB2 = this.getFactory().createRefExpr();
		argUsedVB2.getAnns().add(new ActionArgumentAnn(b2));

		ApplExpr applfunUsedV = factory.createApplExpr(Arrays.
				asList(funUsedV, argUsedVB1), false);

		ApplExpr applfunUsedVB2 = factory.createApplExpr(Arrays.
				asList(funUsedV, argUsedVB2), false);

		ZExprList listaArgsIntersecao4 = 
			this.getFactory().createZExprList(Arrays.asList(applfunUsedV, ns2Expr));
		TupleExpr argsIntersecaoOp4 = 
			this.getFactory().createTupleExpr(listaArgsIntersecao4);

		ZExprList listaArgs2Intersecao4 = 
			this.getFactory().createZExprList(Arrays.asList(applfunUsedVB2, ns1Expr));
		TupleExpr argsIntersecao2Op4 = 
			this.getFactory().createTupleExpr(listaArgs2Intersecao4);

		ApplExpr applInter4 = factory.createApplExpr(Arrays.asList
				(funIntersecao, argsIntersecaoOp4),true);

		ApplExpr appl2Inter4 = factory.createApplExpr(Arrays.asList
				(funIntersecao, argsIntersecao2Op4),true);

		MemPred op4 = factory.createMemPred(Arrays.asList(applInter4,
				appl2Inter4), true);

		/*
		 *  OP5 
		 */

		MemPred op5 = factory.createMemPred(Arrays.asList(appl2Inter4,
				conjuntoUnitarioDoConjuntoVazio), true);

		list.add(op1);
		list.add(op2);
		list.add(op3);
		list.add(op4);
		list.add(op5);

		String nome = this.createName("COD0683");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.88", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}

	/**
	 * Monta as OPs da lei C-84 Parallelism composition/Sequence-step
	 * 
	 * @param a1 a a��o A_1 da lei
	 * @param a3 a a��o A_3 da lei
	 * @param cs o conjunto de canais cs na lei
	 * @param ns1 o conjunto de nomes ns_1 da lei
	 * @return a lista de Predicados correspondendo as Obriga��es de Prova
	 */
	private List<? extends Pred> 
	montarOPsParallelismCompositionSequenceStep(CircusAction a1, 
			CircusAction a3, Expr cs, Expr ns1) {

		/* 
		 ***********************************
		 * OP1: initials(A_3) \subseteq cs *
		 ***********************************
		 */

		/* Montando a refer�ncia � fun��o initials */
		ZName nomeInitials = 
			this.getFactory().createZName(OPsDischargeUtils.INITIALS, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funInicials = this.getFactory().createRefExpr(nomeInitials, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o initial */
		RefExpr argInitials = this.getFactory().createRefExpr();
		argInitials.getAnns().add(new ActionArgumentAnn(a3));

		/* Aplica��o da fun��o initials */
		ApplExpr applInicials = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitials), false);

		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(applInicials, cs));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);

		/*
		 * ************************************* *
		 * OP 2 : cs \cap usedC(A_1) = \emptyset *
		 * ************************************* *
		 */

		/* Montando o nome da fun��o usedC */
		ZName nomeUsedC = this.getFactory().createZName(
				OPsDischargeUtils.USED_C, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedC = this.getFactory().createRefExpr(nomeUsedC, 
				this.getFactory().createZExprList(), false, false);

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedC = this.getFactory().createRefExpr();
		argUsedC.getAnns().add(new ActionArgumentAnn(a1));

		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedC), false);

		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsIntersecaoCsUsedCA1 = 
			this.getFactory().createZExprList(Arrays.asList(cs, applUsedCA1));
		TupleExpr argsIntersecaoA1 = 
			this.getFactory().createTupleExpr(listaArgsIntersecaoCsUsedCA1);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecaoA1), true);

		/* Monta a refer�ncia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao, 
					conjuntoUnitarioDoConjuntoVazio), true);

		/*
		 * ****************************************** *
		 * OP3: wrtV(A_1) \cap usedV(A_3) = \emptyset *
		 * ****************************************** *
		 */

		/* Nome da fun��o wrtV */
		ZName nomeWrtV = this.getFactory().createZName(OPsDischargeUtils.WRT_V, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funWrtV = this.getFactory().createRefExpr(nomeWrtV, 
				this.getFactory().createZExprList(), false, false);

		/* Monta a aplica��o da fun��o wrtV(A_1) */
		ApplExpr applFunWrtVA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funWrtV, 
					argUsedC), false);

		/* Monta a refer�ncia � fun��o "usedV" */
		ZName nomeUsedV = this.getFactory().createZName(
				OPsDischargeUtils.FV_Action, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedV = this.getFactory().createRefExpr(nomeUsedV, 
				this.getFactory().createZExprList(), false, false);

		/* Aplica��o da fun��o "usedV(A_3)" */
		ApplExpr applFunUsedVA_3 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedV, 
					argInitials), false);

		/* Cria a lista de argumentos "(wrtV(A_1), usedV(A_3))" */
		ZExprList listaArgsWrtVA1UsedVA3 = 
			this.getFactory().createZExprList(Arrays.asList(applFunWrtVA1, 
					applFunUsedVA_3));
		TupleExpr argsWrtVA1UsedVA3 = 
			this.getFactory().createTupleExpr(listaArgsWrtVA1UsedVA3);

		/* 
		 * Montando a aplica��o interse��o 
		 * "wrtV(A_1) \cap usedV(A_3)" 
		 */
		ApplExpr applIntersecaoWrtVA1UsedVA3 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsWrtVA1UsedVA3), true);

		/* Montando a op3 */
		MemPred op3 = 
			this.getFactory().createMemPred(
					Arrays.asList(applIntersecaoWrtVA1UsedVA3, 
							conjuntoUnitarioDoConjuntoVazio), true);

		/*
		 * ************************* *
		 * OP4: divergence-free(A_3) *
		 * ************************* *
		 */

		/* Monta a refer�ncia � fun��o "divergenceFree" */
		ZName nomeDivergenceFree = 
			this.getFactory().createZName(OPsDischargeUtils.DIVERGENCE_FREE, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funDivergenceFree = 
			this.getFactory().createRefExpr(nomeDivergenceFree, 
					this.getFactory().createZExprList(), false, false);

		/* Montando a aplica��o "divergenceFree(A_3)" */
		ApplExpr applDivergenceFreeA3 = 
			this.getFactory().createApplExpr(Arrays.asList(funDivergenceFree, 
					argInitials), false);

		ExprPred op4 = this.getFactory().createExprPred(applDivergenceFreeA3);

		/*
		 * **************************** *
		 * OP5: wrtV(A_1) \subseteq ns1 *
		 * **************************** *
		 */

		/* Cria a lista de argumentos "(wrtV(A_1), usedV(A_3))" */
		ZExprList listaArgsWrtVA1Ns1 = 
			this.getFactory().createZExprList(Arrays.asList(applFunWrtVA1, 
					ns1));
		TupleExpr argsWrtVA1Ns1 = 
			this.getFactory().createTupleExpr(listaArgsWrtVA1Ns1);

		/* Aplica��o da fun��o "wrtV(A_1) \subseteq ns1" */
		MemPred op5 = 
			this.getFactory().createMemPred(Arrays.asList(argsWrtVA1Ns1, 
					funSubsetEq), true);

		return Arrays.asList(op1, op2, op3, op4, op5);
	}


	/**
	 * a lei C-90 de circus (<i> Parallelismo Composition Unit
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismCompositionUnit() {

		/* Criando o LHS da lei */

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ParallelAction left = factory.createParallelAction(Arrays
				.asList(factory.createSkipAction(),factory.createSkipAction())
				, Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */

		SkipAction right = factory.createSkipAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0684");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.90", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}



	/**
	 * a lei C-91 de circus (<i> Parallelismo Composition Unit 2
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismCompositionUnit2() {

		/* Criando o LHS da lei */

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ParallelAction left = factory.createParallelAction(Arrays
				.asList(factory.createStopAction(),factory.createStopAction())
				, Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */

		StopAction right = factory.createStopAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0685");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.91", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}

	/**
	 * a lei C-92 de circus (<i> Parallelismo Deadlocked 1 parte 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismDeadLocked1P1() {

		/* Criando o LHS da lei */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);


		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		JokerName nomeCanal = this.getFactory().createJokerName("c1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerName nomeCanal2 = this.getFactory().createJokerName("c2", null);
		RefExpr refNomeCanal2 = this.getFactory().createRefExpr(nomeCanal2, 
				this.getFactory().createZExprList(), false, false);
		Communication c2 = this.getFactory().createCommunication(refNomeCanal2, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		PrefixingAction c1ThenA1 = this.getFactory().createPrefixingAction(a1, c1);
		PrefixingAction c2ThenA2 = this.getFactory().createPrefixingAction(a2, c2);


		ParallelAction left = factory.createParallelAction(Arrays
				.asList(c1ThenA1,c2ThenA2)
				, Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */

		StopAction right = factory.createStopAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * OP1
		 */
		RefExpr c1Expr = factory.createRefExpr(nomeCanal, null, false, false);
		RefExpr c2Expr = factory.createRefExpr(nomeCanal2, null, false, false);		

		MemPred op1aux = 
			this.getFactory().createMemPred(Arrays.asList(c1Expr, c2Expr), 
					true);
		NegPred op1 = this.getFactory().createNegPred(op1aux);


		/*
		 * OP2
		 */
		ExprList exprs = factory.createZExprList(Arrays.asList(c1Expr,c2Expr));
		SetExpr c1c2 = factory.createSetExpr(exprs);

		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(c1c2,csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);

		ops.add(op1);
		ops.add(op2);

		/* Criando a Lei */
		String nome = this.createName("COD0687");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.92", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}


	/**
	 * a lei C-92 de circus (<i> Parallelismo Deadlocked 1 parte 2</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismDeadLocked1P2() {

		/* Criando o LHS da lei */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		JokerName nomeCanal = this.getFactory().createJokerName("c1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerName nomeCanal2 = this.getFactory().createJokerName("c2", null);
		RefExpr refNomeCanal2 = this.getFactory().createRefExpr(nomeCanal2, 
				this.getFactory().createZExprList(), false, false);
		Communication c2 = this.getFactory().createCommunication(refNomeCanal2, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		StopAction left = factory.createStopAction();

		/* Criando o RHS da lei */

		PrefixingAction c2ThenA2 = factory.createPrefixingAction(a2, c2);

		ParallelAction right = factory.createParallelAction
		(Arrays.asList(left,c2ThenA2), Arrays.asList(ns1,ns2), cs);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * OP1
		 */
		RefExpr c1Expr = factory.createRefExpr(nomeCanal, null, false, false);
		RefExpr c2Expr = factory.createRefExpr(nomeCanal2, null, false, false);		

		MemPred op1aux = 
			this.getFactory().createMemPred(Arrays.asList(c1Expr, c2Expr), 
					true);
		NegPred op1 = this.getFactory().createNegPred(op1aux);


		/*
		 * OP2
		 */
		ExprList exprs = factory.createZExprList(Arrays.asList(c1Expr,c2Expr));
		SetExpr c1c2 = factory.createSetExpr(exprs);

		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(c1c2,csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);

		ops.add(op1);
		ops.add(op2);

		/* Criando a Lei */
		String nome = this.createName("COD0688");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.92", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}


	/**
	 * a lei C-92 de circus (<i> Parallelismo Deadlocked 2</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismDeadLocked2() {

		/* Criando o LHS da lei */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		JokerName nomeCanal = this.getFactory().createJokerName("c1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerName nomeCanal2 = this.getFactory().createJokerName("c2", null);
		RefExpr refNomeCanal2 = this.getFactory().createRefExpr(nomeCanal2, 
				this.getFactory().createZExprList(), false, false);
		Communication c2 = this.getFactory().createCommunication(refNomeCanal2, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		PrefixingAction c1ThenA1 = factory.createPrefixingAction(a1, c1);
		PrefixingAction c2ThenA2 = factory.createPrefixingAction(a2, c2);

		JokerPred g1 = factory.createJokerPred("g1", null);
		GuardedAction gc1ThenA1 =factory.createGuardedAction(c1ThenA1, g1);

		JokerPred g2 = factory.createJokerPred("g2", null);
		GuardedAction g2c1ThenA1 =factory.createGuardedAction(c2ThenA2, g2);


		ZExprList lista = factory.createZExprList(Arrays.asList(refNomeCanal,refNomeCanal2));
		SetExpr c1c2 = factory.createSetExpr(lista);

		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaUniao = 
			this.getFactory().createZExprList
			(Arrays.asList(csExpr,c1c2 ));
		TupleExpr argsUniao = 
			this.getFactory().createTupleExpr(listaUniao);

		/* Aplica��o da intersecao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao), true);

		CircusChannelSet channelset = factory.createCircusChannelSet(applUniao);

		ParallelAction left = factory.createParallelAction(Arrays.
				asList(gc1ThenA1,g2c1ThenA1), Arrays.asList(ns1,ns2), channelset);

		/* Criando o RHS da lei */

		StopAction right = factory.createStopAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/*
		 * OP1
		 */
		RefExpr c1Expr = factory.createRefExpr(nomeCanal, null, false, false);
		RefExpr c2Expr = factory.createRefExpr(nomeCanal2, null, false, false);		

		MemPred op1aux = 
			this.getFactory().createMemPred(Arrays.asList(c1Expr, c2Expr), 
					true);
		NegPred op1 = this.getFactory().createNegPred(op1aux);


		/*
		 * OP2
		 */
		ExprList exprs = factory.createZExprList(Arrays.asList(c1Expr,c2Expr));

		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(c1c2,csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);

		ops.add(op1);
		ops.add(op2);

		/* Criando a Lei */
		String nome = this.createName("COD0689");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.93", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}


	/**
	 * a lei C-94 de circus (<i> Parallelismo Composition Zero
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismCompositionZero() {

		/* Criando o LHS da lei */

		JokerAction a = factory.createJokerAction("A", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		ParallelAction left = factory.createParallelAction(Arrays
				.asList(factory.createChaosAction(),a)
				, Arrays.asList(ns1,ns2), cs);

		/* Criando o RHS da lei */

		ChaosAction right = factory.createChaosAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0686");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.94", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}

	/**
	 * Lei que tive que criar para aplicar a tatica syncInput
	 * 
	 * @return
	 */
	public CircusLaw createLawVar_Exp_Par2() {


		/* Criando o LHS da lei */

		/* Criando o circvar da acao esquerda do paralelismo */
		JokerDeclList dl = this.factory.createJokerDeclList("d", null);
		JokerAction a1 = this.factory.createJokerAction("A1", null);
		VarDeclCommand leftPar = this.factory.createVarDeclCommand(dl, a1);

		/* Criando o circvar da acao direita do paralelismo */
		JokerAction a2 = this.factory.createJokerAction("A2", null);
		VarDeclCommand rightPar = this.factory.createVarDeclCommand(dl, a2);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);

		ParallelAction left = 
			factory.createParallelAction(Arrays.asList(leftPar, rightPar), 
					Arrays.asList(ns1, ns2), cs);

		/* Criando o RHS da lei 
		 * Parte direita */


		/* Criando o circvar da acao direita do paralelismo 
		 * (\circvar\ d @ A_1 \lpar ns_1 | cs | ns_2 \rpar A_2)*/

		ParallelAction par = 
			factory.createParallelAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2), cs);

		VarDeclCommand right = this.factory.createVarDeclCommand(dl, par);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando a Obriga��o de prova */
		List<Pred> ops = new ArrayList<Pred>();


		/* Criando a Lei */
		String nome = this.createName("VAR_EXP");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1001", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}

	/**
	 * Lei Parallelism Composition Sequence Step2
	 * 
	 * @return
	 */
	public CircusLaw criarLeiParallelismCompositionSequenceStep2() {


		/* Criando o LHS da lei */

		/* Criando o circvar da acao esquerda do paralelismo */
		JokerDeclList dl = this.factory.createJokerDeclList("d", null);
		JokerAction a1 = this.factory.createJokerAction("A1", null);
		JokerAction a2 = this.factory.createJokerAction("A2", null);
		JokerAction a3 = this.factory.createJokerAction("A3", null);

		/* Criando o SeqActon */



		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		//JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		/* Criando o circvar da acao direita do paralelismo 

		/* Criando o SeqActon */
		SeqAction seq1 = this.factory.createSeqAction(Arrays.asList(a1,a2));
		SeqAction seq2 = this.factory.createSeqAction(Arrays.asList(a1,a3));

		ParallelAction leftPar = 
			factory.createParallelAction(Arrays.asList(seq1, seq2), 
					Arrays.asList(ns1, ns2), cs);

		VarDeclCommand left = this.factory.createVarDeclCommand(dl, leftPar);

		/* Criando o RHS da lei 
		 * Parte direita 
		\circvar\ d @ A_1 \circseq (A_2 \lpar ns_ 1 | cs | ns_2 \rpar A_3)*/
		ParallelAction rightPar = 
			factory.createParallelAction(Arrays.asList(a2,a3),
					Arrays.asList(ns1, ns2), cs);

		SeqAction seq = this.factory.createSeqAction(Arrays.asList(a1, rightPar));
		VarDeclCommand right = this.factory.createVarDeclCommand(dl, seq);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando a Obriga��o de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/**
		 * usedC(A_1) \subseteq cs
		 */

		RefExpr funUsedC = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.USED_C);

		RefExpr argUsedCA = factory.createRefExpr();
		argUsedCA.getAnns().add(new ActionArgumentAnn(a1));

		ApplExpr applUsedCA = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA), false);

		RefExpr subseteq = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.SUBSETEQ);

		ZExprList listaSub = 
			this.getFactory().createZExprList(Arrays.asList(applUsedCA , csExpr));
		TupleExpr listaSubTuple  = this.getFactory().createTupleExpr(listaSub);

		MemPred useCSubseteqA1 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubTuple, subseteq), 
					true);

		ops.add(useCSubseteqA1);

		/**
		 * OP2 $wrtV(A_1) \subseteq \alpha(d)
		 */

		RefExpr wrtV = OPsDischargeUtils.refFuncao(OPsDischargeUtils.WRT_V);

		RefExpr wrtVA1 = factory.createRefExpr();
		wrtVA1.getAnns().add(new ActionArgumentAnn(a1));

		ApplExpr applWrtv = factory.createApplExpr(Arrays
				.asList(wrtV,wrtVA1), false);

		/*
		 * alfa
		 */

		ZName nomeAlpha = this.getFactory().createZName(OPsDischargeUtils.ALPHA,
				this.getFactory().createZStrokeList(), null);
		RefExpr funAlpha = this.getFactory().createRefExpr(nomeAlpha, 
				this.getFactory().createZExprList(), false, false);

		ZSchText textoArgS1Stroke = this.getFactory().createZSchText(dl, 
				this.getFactory().createTruePred());
		SchExpr argS1Stroke = this.getFactory().createSchExpr(textoArgS1Stroke);

		/* Monta a aplicação \alpha(d) */
		ApplExpr applAlphaS1 = 
			this.getFactory().createApplExpr(Arrays.asList(funAlpha, 
					argS1Stroke), false);

		ZExprList listaArgsAlphaS1Alpha = 
			this.getFactory().createZExprList(Arrays.asList(applWrtv, 
					applAlphaS1));
		TupleExpr argsAlpha = 
			this.getFactory().createTupleExpr(listaArgsAlphaS1Alpha);

		MemPred wrtVaLPHA = 
			this.getFactory().createMemPred(Arrays.asList(argsAlpha, subseteq), 
					true);

		ops.add(wrtVaLPHA);

		/* Criando a Lei */
		String nome = this.createName("ParSeq2");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1002", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}

	/**
	 * Lei Var-Exp-Par
	 * 
	 * @return
	 */
	public CircusLaw criarLeiVarExpPar() {

		/* Criando o LHS da lei 
		 * (var d : T ² A1) [ ns1 | cs | ns2 ] A2 = 
		 * (var d : T ² A1 [ ns1 | cs | ns2 ] A2)*/

		/* Criando o circvar da acao esquerda do paralelismo */
		DeclList dl = this.factory.createJokerDeclList("d", null);
		JokerAction a1 = this.factory.createJokerAction("A1", null);
		JokerAction a2 = this.factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		//JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);

		/* Criando o VarDecl */
		VarDeclCommand var = factory.createVarDeclCommand(dl, a1);


		/* Criando o Paralelismo da esquerda */
		ParallelAction left = 
			factory.createParallelAction(Arrays.asList(var, a2), 
					Arrays.asList(ns1, ns2), cs);


		/* Criando o RHS da lei 
		 * Parte direita */

		/* Criando o Paralelismo */
		ParallelAction leftPar = 
			factory.createParallelAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2), cs);
		VarDeclCommand right = this.factory.createVarDeclCommand(dl, leftPar);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando a Obriga��o de prova */
		List<Pred> ops = new ArrayList<Pred>();


		/*Criando as OPS*/

		RefExpr funFv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argFVA2 = this.getFactory().createRefExpr();
		argFVA2.getAnns().add(new ActionArgumentAnn(a2));

		ApplExpr fvA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funFv, argFVA2), false);


		/*Criando a intersecao */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		//ZDeclList dlDash = (ZDeclList) DashedTerm.getDashedTerm(dl); 
		//DeclList lista = factory.createZDeclList(Arrays.asList(dl,dlDash));


		ZSchText textoDl = this.getFactory().createZSchText(dl, 
				this.getFactory().createTruePred());
		SchExpr argS1Stroke = this.getFactory().createSchExpr(textoDl);
		ExprList exprs = factory.createZExprList(Arrays.asList(argS1Stroke));
		SetExpr listX = factory.createSetExpr(exprs);



		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(listX,fvA2));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		/* Monta a referencia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("VarExpPar");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1003", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}


	/*	public CircusLaw criarLeiParComm() {

		 Criando o LHS da lei 
		/*$A_1 \lpar ns_1 | cs | ns_2 \rpar A_2 =
	 *  A_2 \lpar ns_2 | cs | ns_1 \rpar A_1$ 

		 Criando o circvar da acao esquerda do paralelismo 
		JokerAction a1 = this.factory.createJokerAction("A1", null);
		JokerAction a2 = this.factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		//JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);


		 Criando o Paralelismo 
		ParallelAction left = 
			factory.createParallelAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2), cs);

		 Criando o RHS da lei 
	 * Parte direita 

		 Criando o Paralelismo 
		ParallelAction right = 
			factory.createParallelAction(Arrays.asList(a2, a1), 
					Arrays.asList(ns2, ns1), cs);

		 Criando o transformer 
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		 Criando a Obriga��o de prova 
		List<Pred> ops = new ArrayList<Pred>();

		 Criando a Lei 
		String nome = this.createName("ParComm");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1006", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;
	}
	 */


	public CircusLaw createLawParInter () {

		/* Criando o LHS da lei */

		/*A1 [ ns1 | cs | ns2 ] A2 = A1 j[ns1 | ns2] A2 */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);



		/*Expr e = conjuntoVazio;
		CircusChannelSet cs = factory.createCircusChannelSet(conjuntoVazio);*/

		/*ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		CircusChannelSet es = factory.createCircusChannelSet(conjuntoVazio);*/
		ParallelAction left = factory.createParallelAction(
				Arrays.asList(a1,a2), Arrays.asList(ns1,ns2),cs);

		/* Criando o RHS da lei */

		InterleaveAction right = factory.createInterleaveAction(Arrays
				.asList(a1,a2)
				, Arrays.asList(ns1,ns2));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();


		/*(usedC(A1) U usedC(A2)) ^ cs = \EMPTY*/

		RefExpr funUsedC = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.USED_C);

		RefExpr argUsedCA = factory.createRefExpr();
		argUsedCA.getAnns().add(new ActionArgumentAnn(a1));

		ApplExpr applUsedCA = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA), false);

		RefExpr argUsedCA2 = factory.createRefExpr();
		argUsedCA2.getAnns().add(new ActionArgumentAnn(a2));

		ApplExpr applUsedCA2 = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA2), false);

		/* Lista de argumentos da uniao */
		ZExprList listaArgs = factory.createZExprList(Arrays.asList(applUsedCA,applUsedCA2));
		TupleExpr argsFuncaoUsedC = factory.createTupleExpr(listaArgs);


		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);


		/* Aplica��o daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoUsedC), true);

		/*Criar intersecao */

		ZName nomeInter = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCInter = this.getFactory().createRefExpr(nomeInter, 
				this.getFactory().createZExprList(), false, false);

		ZExprList listaArgsInter = factory.createZExprList(Arrays.asList(applUniao,csExpr));
		TupleExpr argsFuncaoInter = factory.createTupleExpr(listaArgsInter);


		/* Aplicacao inter */
		ApplExpr applInter = 
			this.getFactory().createApplExpr(Arrays.asList(funCInter, 
					argsFuncaoInter), true);

		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applInter, 
					conjuntoUnitarioDoConjuntoVazio), true);


		ops.add(op1);


		/* Criando a Lei */
		String nome = this.createName("ParInterleave");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1020", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}

	public CircusLaw createLawParOutInpInterExchange2() {

		/* Criando o LHS da lei */


		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction a3 = factory.createJokerAction("A3", null);
		JokerAction a4 = factory.createJokerAction("A4", null);
		JokerAction a5 = factory.createJokerAction("A5", null);
		JokerAction a6 = factory.createJokerAction("A6", null);

		/*
		 * Pref 1
		 */
		JokerName c1 = factory.createJokerName("c1", null);
		RefExpr refC = factory.createRefExpr(c1, factory.createZExprList(), false, false);

		JokerName x = factory.createJokerName("x", null);
	
		InputField xIn = this.factory.createInputField(x,
				factory.createTruePred());

		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(xIn));

		Communication cInX = this.factory.createCommunication(refC, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);


		PrefixingAction cInXThenA1 = this.factory.createPrefixingAction(a1, cInX);
		/*
		 * Prefix 2
		 */
		JokerName c2 = factory.createJokerName("c2", null);
		RefExpr refC2 = factory.createRefExpr(c2, factory.createZExprList(), false, false);

		Communication c2InX = this.factory.createCommunication(refC2, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);

		PrefixingAction cInXThenA2 = this.factory.createPrefixingAction(a2, c2InX);

		/*
		 * Prefix 3 !V
		 */

		//JokerName c3 = factory.createJokerName("c3", null);
		//RefExpr refC3 = factory.createRefExpr(c3, factory.createZExprList(), false, false);
		JokerName c3 = this.factory.createJokerName("c3", null);

		JokerExpr csExpr = factory.createJokerExpr("c3", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);
		
		RefExpr refC3 = factory.createRefExpr(c3, factory.createZExprList(), false, false);
		
		JokerExpr v = factory.createJokerExpr("v", null);

		DotField vOut = this.getFactory().createDotField(v);
		vOut.getAnns().add(factory.createOutputFieldAnn());

		CircusFieldList listaOutV = 
			this.factory.createCircusFieldList(Arrays.asList(vOut));

		Communication cOutV = this.factory.createCommunication(refC3, listaOutV, 
				CommUsage.Normal, CommPattern.Output, null, null);

		SkipAction skip = factory.createSkipAction();

		PrefixingAction vOutVThenA3 = this.factory.createPrefixingAction(skip, cOutV);

		/*
		 * Prefix 3 x
		 */


		Communication c3InX = this.factory.createCommunication(refC3, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);

		PrefixingAction cInXThenA4 = this.factory.createPrefixingAction(a4, c3InX);

		/*
		 * Prefix 4
		 */

		PrefixingAction cInXThenA5 = this.factory.createPrefixingAction(a5, c2InX);

		/**
		 * Paralle 1
		 */


		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);
		JokerExpr ns3Expr = this.factory.createJokerExpr("ns3", null);
		CircusNameSet ns3 = this.factory.createCircusNameSet(ns3Expr);
		JokerExpr ns4Expr = this.factory.createJokerExpr("ns4", null);
		CircusNameSet ns4 = this.factory.createCircusNameSet(ns4Expr);
		JokerExpr ns5Exp = factory.createJokerExpr("ns5", null);
		CircusNameSet ns5 = factory.createCircusNameSet(ns5Exp);
		JokerExpr ns6Expr = this.factory.createJokerExpr("ns6", null);
		CircusNameSet ns6 = this.factory.createCircusNameSet(ns6Expr);

	
		InterleaveAction interLeft = factory.createInterleaveAction(
				Arrays.asList(cInXThenA1,cInXThenA2),Arrays.asList(ns1,ns2));

		
		/*
		 * Seq 1
		 */

		SeqAction seqLeft = factory.createSeqAction(Arrays.asList(interLeft,a3));
		SeqAction seqLeft2 = factory.createSeqAction(Arrays.asList(seqLeft,vOutVThenA3));


		/**
		 * Inter 2
		 */

		InterleaveAction interLeft2 = factory.createInterleaveAction(
				Arrays.asList(cInXThenA4,cInXThenA5),Arrays.asList(ns5,ns6));
		SeqAction seq3 = factory.createSeqAction(Arrays.asList(interLeft2,a6));

		/**
		 * Parallel final
		 */

		ParallelAction left = factory.createParallelAction(
				Arrays.asList(seqLeft2,seq3),Arrays.asList(ns3,ns4),cs);

		/* Criando o RHS da lei 
		 * Parte direita
		 * */
		
		/**
		 * Montando a uniao
		 * ns2 U ns6
		 */
		
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da uniao */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(ns2Expr,ns6Expr));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplicacao daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoA1), true);

		CircusNameSet setUniao = this.factory.createCircusNameSet(applUniao);
		
		/**
		 * Parralel right 1
		 */

		
		InterleaveAction interRight = factory.createInterleaveAction(
				Arrays.asList(a2,a5),Arrays.asList(ns2,ns6));
		PrefixingAction cInXThenPar = this.factory.createPrefixingAction(interRight, c2InX);
		
		PrefixingAction vOutThenA4 = this.factory.createPrefixingAction(a4, cOutV);
        SeqAction seqRight1 = factory.createSeqAction(Arrays.asList(a3,vOutThenA4));
        
        SeqAction seqRight2 = factory.createSeqAction(Arrays.asList(seqRight1,a6));
        
        SeqAction seqRight3 = factory.createSeqAction(Arrays.asList(cInXThenPar,seqRight2));
        
        /**
         * Parralel Right final
         */
		
        InterleaveAction right = factory.createInterleaveAction(
				Arrays.asList(cInXThenA1,seqRight3),Arrays.asList(ns1,setUniao));
		

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();


		/*(ns1 U ns2) C ns3 */
		
		ZExprList listaArgsUniao2 = 
			this.getFactory().createZExprList(Arrays.asList(ns1Expr,ns2Expr));

		TupleExpr argsFuncaoNs1Ns2 = 
			this.getFactory().createTupleExpr(listaArgsUniao2);

		/* Aplicacao daUniao */
		ApplExpr applUniaoNs1Ns2 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoNs1Ns2), true);

		RefExpr subseteq = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.SUBSETEQ);

		ZExprList listaSub = 
			this.getFactory().createZExprList(Arrays.asList(applUniaoNs1Ns2 , ns3Expr));
		TupleExpr listaSubTuple  = this.getFactory().createTupleExpr(listaSub);

		MemPred subseteqNs1Ns2 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubTuple, subseteq), 
					true);
		ops.add(subseteqNs1Ns2);
		
		/**
		 * ns5 U ns6 C ns4
		 */
		
		ZExprList listaArgsUniaoNs5Ns6 = 
			this.getFactory().createZExprList(Arrays.asList(ns5Exp,ns6Expr));

		TupleExpr argsFuncaoNs5Ns6 = 
			this.getFactory().createTupleExpr(listaArgsUniaoNs5Ns6);

		/* Aplicacao daUniao */
		ApplExpr applUniaoNs5Ns6 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoNs5Ns6), true);

		ZExprList listaSubNs5Ns6 = 
			this.getFactory().createZExprList(Arrays.asList(applUniaoNs5Ns6 , ns4Expr));
		TupleExpr listaSubTupleNs5Ns6  = this.getFactory().createTupleExpr(listaSubNs5Ns6);

		MemPred subseteqNs5Ns6 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubTupleNs5Ns6, subseteq), 
					true);
		ops.add(subseteqNs5Ns6);
		
		
		/*
		 * OP3 wrtV(A1) C ns1
		 */
		RefExpr funWrtv = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtv = factory.createRefExpr();
		argWrtv.getAnns().add(new ActionArgumentAnn(a1));

		ApplExpr applWrtv = factory.createApplExpr(Arrays
				.asList(funWrtv,argWrtv), false);
		
		ZExprList listaSubWrtvA1 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtv , ns1Expr));
		TupleExpr listaSubWrtvA1Ns1  = this.getFactory().createTupleExpr(listaSubWrtvA1);

		MemPred subsetWrtvA1Ns1 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA1Ns1, subseteq), 
					true);
		ops.add(subsetWrtvA1Ns1);
		
		/*
		 * OP4 wrtV(A2) C ns2
		 */
		
		RefExpr funWrtvA2 = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtvA2 = factory.createRefExpr();
		argWrtvA2.getAnns().add(new ActionArgumentAnn(a2));

		ApplExpr applWrtvA2 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA2), false);
		
		ZExprList listaSubWrtvA2 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA2 , ns2Expr));
		TupleExpr listaSubWrtvA2Ns2  = this.getFactory().createTupleExpr(listaSubWrtvA2);

		MemPred subsetWrtvA2Ns2 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA2Ns2, subseteq), 
					true);
		ops.add(subsetWrtvA2Ns2);
		
		/**
		 * op4 wrtV(A3) C ns3
		 */
		
		
		//RefExpr funWrtvA3 = OPsDischargeUtils.refFuncao
		//(OPsDischargeUtils.WRT_V);

		RefExpr argWrtvA3 = factory.createRefExpr();
		argWrtvA3.getAnns().add(new ActionArgumentAnn(a3));

		ApplExpr applWrtvA3 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA2), false);
		
		ZExprList listaSubWrtvA3 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA3 , ns3Expr));
		TupleExpr listaSubWrtvA3Ns3  = this.getFactory().createTupleExpr(listaSubWrtvA3);

		MemPred subsetWrtvA3Ns3 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA3Ns3, subseteq), 
					true);
		ops.add(subsetWrtvA3Ns3);
		
		/**
		 * op4 wrtV(A4) C ns4
		 */
		
		
		RefExpr funWrtvA4 = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtvA4 = factory.createRefExpr();
		argWrtvA4.getAnns().add(new ActionArgumentAnn(a4));

		ApplExpr applWrtvA4 = factory.createApplExpr(Arrays
				.asList(funWrtvA4,argWrtvA4), false);
		
		ZExprList listaSubWrtvA4 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA4 , ns5Exp));
		TupleExpr listaSubWrtvA4Ns5  = this.getFactory().createTupleExpr(listaSubWrtvA4);

		MemPred subsetWrtvA4Ns5 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA4Ns5, subseteq), 
					true);
		ops.add(subsetWrtvA4Ns5);
		
		
		/**
		 * op5 wrtV(A6) C ns6
		 */
		
		
		RefExpr funWrtvA6 = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtvA6 = factory.createRefExpr();
		argWrtvA6.getAnns().add(new ActionArgumentAnn(a5));

		ApplExpr applWrtvA6 = factory.createApplExpr(Arrays
				.asList(funWrtvA6,argWrtvA6), false);
		
		ZExprList listaSubWrtvA6 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA6 , ns6Expr));
		TupleExpr listaSubWrtvA6Ns6  = this.getFactory().createTupleExpr(listaSubWrtvA6);

		MemPred subsetWrtvA6Ns6 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA6Ns6, subseteq), 
					true);
		ops.add(subsetWrtvA6Ns6);
		
		/**
		 * wrtV(A3) ^ (usedC(A4) U usedC(A6)) = 0
		 */
		

		RefExpr funUsedC = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.USED_C);
		RefExpr argUsedCA4 = factory.createRefExpr();
		argUsedCA4.getAnns().add(new ActionArgumentAnn(a4));

		ApplExpr applUsedCA4 = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA4), false);
		
		RefExpr argUsedCA6 = factory.createRefExpr();
		argUsedCA6.getAnns().add(new ActionArgumentAnn(a6));

		ApplExpr applUsedCA6 = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA6), false);

		/* Lista de argumentos da uniao */
		ZExprList listaArgs = factory.createZExprList(Arrays.asList(applUsedCA4, applUsedCA6));
		TupleExpr argsFuncaoUsedC = factory.createTupleExpr(listaArgs);


		/* AplicaCAo daUniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoUsedC), true);

		
		argWrtvA3 = factory.createRefExpr();
		argWrtvA3.getAnns().add(new ActionArgumentAnn(a3));
		ApplExpr applWrtvCA4 = factory.createApplExpr(Arrays
				.asList(funWrtv,argWrtvA3), false);
		

		
		/*Criar intersecao */

		ZName nomeInter = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCInter = this.getFactory().createRefExpr(nomeInter, 
				this.getFactory().createZExprList(), false, false);

		ZExprList listaArgsInter = factory.createZExprList(Arrays.asList(applUniao2,applWrtvCA4));
		TupleExpr argsFuncaoInter = factory.createTupleExpr(listaArgsInter);


		/* Aplicacao inter */
		ApplExpr applInter = 
			this.getFactory().createApplExpr(Arrays.asList(funCInter, 
					argsFuncaoInter), true);

		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unitario do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		MemPred op8 = 
			this.getFactory().createMemPred(Arrays.asList(applInter, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op8);


		/* Criando a Lei */
		String nome = this.createName("ParOutInpInterExchange2");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1050", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}
	
	
	public CircusLaw createLawParOutInpInterExchange3() {

		/* Criando o LHS da lei */


		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction a3 = factory.createJokerAction("A3", null);
		JokerAction a4 = factory.createJokerAction("A4", null);
		JokerAction a5 = factory.createJokerAction("A5", null);
		JokerAction a6 = factory.createJokerAction("A6", null);
		JokerAction a7 = factory.createJokerAction("A7", null);
		
		

		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);
		JokerExpr ns3Expr = this.factory.createJokerExpr("ns3", null);
		CircusNameSet ns3 = this.factory.createCircusNameSet(ns3Expr);
		JokerExpr ns4Expr = this.factory.createJokerExpr("ns4", null);
		CircusNameSet ns4 = this.factory.createCircusNameSet(ns4Expr);
		JokerExpr ns5Exp  = this.factory.createJokerExpr("ns5", null);
		CircusNameSet ns5 = factory.createCircusNameSet(ns5Exp);
		JokerExpr ns6Expr = this.factory.createJokerExpr("ns6", null);
		CircusNameSet ns6 = this.factory.createCircusNameSet(ns6Expr);
		JokerExpr ns7Expr = this.factory.createJokerExpr("ns7", null);
		CircusNameSet ns7 = this.factory.createCircusNameSet(ns7Expr);


		/*
		 * Pref 1
		 */
		JokerName c1 = factory.createJokerName("c1", null);
		RefExpr refC = factory.createRefExpr(c1, factory.createZExprList(), false, false);

		JokerName x = factory.createJokerName("x", null);
	
		InputField xIn = this.factory.createInputField(x,
				factory.createTruePred());

		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(xIn));

		Communication cInX = this.factory.createCommunication(refC, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);


		PrefixingAction cInXThenA1 = this.factory.createPrefixingAction(a1, cInX);
		/*
		 * Prefix 2
		 */
		JokerName c2 = factory.createJokerName("c2", null);
		RefExpr refC2 = factory.createRefExpr(c2, factory.createZExprList(), false, false);

		Communication c2InX = this.factory.createCommunication(refC2, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);

		PrefixingAction cInXThenA2 = this.factory.createPrefixingAction(a2, c2InX);

		
		/**
		 * Criar o inter entre c -> A1 e c-> A2
		 */
		
		InterleaveAction interLeft = factory.createInterleaveAction(
				Arrays.asList(cInXThenA1,cInXThenA2),Arrays.asList(ns1,ns2));
		
		/*
		 * Prefix 3 !V
		 */

	
		JokerName c3 = this.factory.createJokerName("c3", null);
		JokerExpr csExpr = factory.createJokerExpr("c3", null);
		CircusChannelSet cs = factory.createCircusChannelSet(csExpr);
		
		RefExpr refC3 = factory.createRefExpr(c3, factory.createZExprList(), false, false);
		
		JokerExpr v = factory.createJokerExpr("v", null);

		DotField vOut = this.getFactory().createDotField(v);
		vOut.getAnns().add(factory.createOutputFieldAnn());

		CircusFieldList listaOutV = 
			this.factory.createCircusFieldList(Arrays.asList(vOut));

		Communication cOutV = this.factory.createCommunication(refC3, listaOutV, 
				CommUsage.Normal, CommPattern.Output, null, null);

		SkipAction skip = factory.createSkipAction();

		PrefixingAction vOutVThenA3 = this.factory.createPrefixingAction(skip, cOutV);

		
		/**
		 * Seq 1
		 */
		
		SeqAction seqLeft = factory.createSeqAction(Arrays.asList(interLeft,a3));
		SeqAction seqLeft2 = factory.createSeqAction(Arrays.asList(seqLeft,vOutVThenA3));

		
		
		/*
		 * Prefix 3 x
		 */


		Communication c3InX = this.factory.createCommunication(refC3, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);

		PrefixingAction cInXThenA4 = this.factory.createPrefixingAction(a4, c3InX);

		/*
		 * Prefix 4
		 */

		PrefixingAction cInXThenA5 = this.factory.createPrefixingAction(a5, c2InX);

		/*
		 * Prefix 6
		 */

		JokerName c4 = factory.createJokerName("c4", null);
		RefExpr refC4 = factory.createRefExpr(c4, factory.createZExprList(), false, false);
		Communication c4InX = this.factory.createCommunication(refC4, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);
		PrefixingAction cInXThenA6 = this.factory.createPrefixingAction(a6, c4InX);
		
		/**
		 * Inter 2
		 */

		InterleaveAction interLeft2 = factory.createInterleaveAction(
				Arrays.asList(cInXThenA5,cInXThenA6),Arrays.asList(ns6,ns7));
		SeqAction seq3 = factory.createSeqAction(Arrays.asList(interLeft2,a7));
		
		/**
		 * Inter da uniao
		 */
		
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da uniao */
		ZExprList listaArgsUniao = 
			this.getFactory().createZExprList(Arrays.asList(ns6Expr,ns7Expr));

		TupleExpr argsFuncaoA1 = 
			this.getFactory().createTupleExpr(listaArgsUniao);

		/* Aplicacao daUniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoA1), true);
		
		CircusNameSet setUniao = this.factory.createCircusNameSet(applUniao);
		
		InterleaveAction interLeft3 = factory.createInterleaveAction(
				Arrays.asList(cInXThenA4,seq3),Arrays.asList(ns5,setUniao));
		SeqAction seq4 = factory.createSeqAction(Arrays.asList(cInXThenA4,interLeft3));
		

		/**
		 * Parallel final
		 */

		ParallelAction left = factory.createParallelAction(
				Arrays.asList(seqLeft2,seq4),Arrays.asList(ns3,ns4),cs);

		/* Criando o RHS da lei 
		 * Parte direita
		 * */
	
		
		/**
		 * Inter A2[ ns2 | ns6 ] A5
		 */
		
		InterleaveAction interRightA2A5 = factory.createInterleaveAction(
				Arrays.asList(a2,a5),Arrays.asList(ns2,ns6));
		
		/**
		 * Prefix c2 -> A2[ ns2 | ns6 ] A5
		 */
		
		PrefixingAction c2InXThenInter = this.factory.createPrefixingAction(interRightA2A5, c2InX);
		
		
		/**
		 * Inter de ns2 U ns6
		 */
	
		
		ZExprList listaArgsUniao26 = 
			this.getFactory().createZExprList(Arrays.asList(ns2Expr,ns6Expr));

		TupleExpr argsFuncao26 = 
			this.getFactory().createTupleExpr(listaArgsUniao26);

		/* Aplicacao daUniao */
		ApplExpr applUniao26 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncao26), true);

		CircusNameSet setUniao26 = this.factory.createCircusNameSet(applUniao26);
		
		InterleaveAction interRight1 = factory.createInterleaveAction(
				Arrays.asList(c2InXThenInter,cInXThenA6),Arrays.asList(setUniao26,ns7));
		
		
		  /**
	     * Inter da uniao ns2 U ns6 U ns7
	     */

		ZExprList listaArgsUniao267 = 
			this.getFactory().createZExprList(Arrays.asList(ns2Expr,ns6Expr));

		TupleExpr argsFuncao = 
			this.getFactory().createTupleExpr(listaArgsUniao267);
		
		
		
		//TupleExpr argsFuncao2 = 
		//	this.getFactory().createTupleExpr(listaArgsUniao2672);

		/* Aplicacao daUniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncao), true);
		
		ZExprList listaArgsUniao2672 = 
			this.getFactory().createZExprList(Arrays.asList(applUniao2,ns7Expr));
		
		TupleExpr argsFuncao2 = 
				this.getFactory().createTupleExpr(listaArgsUniao2672);
		
		/* Aplicacao daUniao */
		ApplExpr applUniao22 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncao2), true);
		
		

		CircusNameSet setUniao267 = this.factory.createCircusNameSet(applUniao22);
	
		
		/**
		 * Prefix c3!v -> A4
		 */
		
		PrefixingAction vInXThenA4 = this.factory.createPrefixingAction(a4, cOutV);
		
		
		/**
		 * Interleave final
		 */
		
		InterleaveAction interRight2 = factory.createInterleaveAction(
				Arrays.asList(cInXThenA1,interRight1),Arrays.asList(ns1,setUniao267));
		
		/**
		 * Seq final
		 */

        
        SeqAction seqRight1 = factory.createSeqAction(Arrays.asList(a3,vInXThenA4));
        SeqAction seqright2 = factory.createSeqAction(Arrays.asList(seqRight1,a7));
        SeqAction right = factory.createSeqAction(Arrays.asList(interRight2,seqright2));
        

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();


		//(ns1 U ns2) C ns3 
		
		ZExprList listaArgsUniaoNs1Ns2 = 
			this.getFactory().createZExprList(Arrays.asList(ns1Expr,ns2Expr));

		TupleExpr argsFuncaoNs1Ns2 = 
			this.getFactory().createTupleExpr(listaArgsUniaoNs1Ns2);

		// Aplicacao daUniao 
		ApplExpr applUniaoNs1Ns2 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoNs1Ns2), true);

		RefExpr subseteq = 
			OPsDischargeUtils.refFuncao(OPsDischargeUtils.SUBSETEQ);

		ZExprList listaSub = 
			this.getFactory().createZExprList(Arrays.asList(applUniaoNs1Ns2 , ns3Expr));
		TupleExpr listaSubTuple  = this.getFactory().createTupleExpr(listaSub);

		MemPred subseteqNs1Ns2 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubTuple, subseteq), 
					true);
		ops.add(subseteqNs1Ns2);
		
		/**
		 * ns5 U ns6 U ns7 C ns4
		 */
		
		ZExprList listaArgsUniaoNs5Ns6 = 
			this.getFactory().createZExprList(Arrays.asList(ns5Exp,ns6Expr,ns7Expr));

		
		
		TupleExpr argsFuncaoNs5Ns6 = 
			this.getFactory().createTupleExpr(listaArgsUniaoNs5Ns6);

		// Aplicacao daUniao 
		ApplExpr applUniaoNs5Ns6 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoNs5Ns6), true);

		ZExprList listaSubNs5Ns6 = 
			this.getFactory().createZExprList(Arrays.asList(applUniaoNs5Ns6 , ns4Expr));
		TupleExpr listaSubTupleNs5Ns6  = this.getFactory().createTupleExpr(listaSubNs5Ns6);

		MemPred subseteqNs5Ns6 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubTupleNs5Ns6, subseteq), 
					true);
		ops.add(subseteqNs5Ns6);
		
		
		
		// * OP3 wrtV(A1) C ns1
		 
		RefExpr funWrtv = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtv = factory.createRefExpr();
		argWrtv.getAnns().add(new ActionArgumentAnn(a1));

		ApplExpr applWrtv = factory.createApplExpr(Arrays
				.asList(funWrtv,argWrtv), false);
		
		ZExprList listaSubWrtvA1 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtv , ns1Expr));
		TupleExpr listaSubWrtvA1Ns1  = this.getFactory().createTupleExpr(listaSubWrtvA1);

		MemPred subsetWrtvA1Ns1 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA1Ns1, subseteq), 
					true);
		ops.add(subsetWrtvA1Ns1);
		
		
		 // OP4 wrtV(A2) C ns2
		
		
		RefExpr funWrtvA2 = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.WRT_V);

		RefExpr argWrtvA2 = factory.createRefExpr();
		argWrtvA2.getAnns().add(new ActionArgumentAnn(a2));

		ApplExpr applWrtvA2 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA2), false);
		
		ZExprList listaSubWrtvA2 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA2 , ns2Expr));
		TupleExpr listaSubWrtvA2Ns2  = this.getFactory().createTupleExpr(listaSubWrtvA2);

		MemPred subsetWrtvA2Ns2 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA2Ns2, subseteq), 
					true);
		ops.add(subsetWrtvA2Ns2);
		
		/**
		 * op4 wrtV(A3) C ns3
		 */
		
		
		RefExpr argWrtvA3 = factory.createRefExpr();
		argWrtvA3.getAnns().add(new ActionArgumentAnn(a3));

		ApplExpr applWrtvA3 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA3), false);
		
		ZExprList listaSubWrtvA3 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA3 , ns3Expr));
		TupleExpr listaSubWrtvA3Ns3  = this.getFactory().createTupleExpr(listaSubWrtvA3);

		MemPred subsetWrtvA3Ns3 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA3Ns3, subseteq), 
					true);
		ops.add(subsetWrtvA3Ns3);
		
		/**
		 * op4 wrtV(A4) C ns4
		 */
		

		RefExpr argWrtvA4 = factory.createRefExpr();
		argWrtvA4.getAnns().add(new ActionArgumentAnn(a4));

		ApplExpr applWrtvA4 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA4), false);
		
		ZExprList listaSubWrtvA4 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA4 , ns5Exp));
		TupleExpr listaSubWrtvA4Ns5  = this.getFactory().createTupleExpr(listaSubWrtvA4);

		MemPred subsetWrtvA4Ns5 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA4Ns5, subseteq), 
					true);
		ops.add(subsetWrtvA4Ns5);
		
		
		/**
		 * op5 wrtV(A5) C ns6
		 */
		

		RefExpr argWrtvA6 = factory.createRefExpr();
		argWrtvA6.getAnns().add(new ActionArgumentAnn(a5));

		ApplExpr applWrtvA6 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA6), false);
		
		ZExprList listaSubWrtvA6 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA6 , ns6Expr));
		TupleExpr listaSubWrtvA6Ns6  = this.getFactory().createTupleExpr(listaSubWrtvA6);

		MemPred subsetWrtvA6Ns6 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA6Ns6, subseteq), 
					true);
		ops.add(subsetWrtvA6Ns6);
		
		/**
		 * op5 wrtV(A6) C ns7
		 */
		

		RefExpr argWrtvA7 = factory.createRefExpr();
		argWrtvA7.getAnns().add(new ActionArgumentAnn(a6));

		ApplExpr applWrtvA7 = factory.createApplExpr(Arrays
				.asList(funWrtvA2,argWrtvA7), false);
		
		ZExprList listaSubWrtvA7 = 
			this.getFactory().createZExprList(Arrays.asList(applWrtvA7 , ns7Expr));
		TupleExpr listaSubWrtvA6Ns7  = this.getFactory().createTupleExpr(listaSubWrtvA7);

		MemPred subsetWrtvA6Ns7 = 
			this.getFactory().createMemPred(Arrays.asList(listaSubWrtvA6Ns7, subseteq), 
					true);
		ops.add(subsetWrtvA6Ns7);
		
		
		/**
		 * wrtV(A3) ^ (usedC(A4) U usedC(A7)) = 0
		 */
		

		RefExpr funUsedC = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.USED_C);
		RefExpr argUsedCA4 = factory.createRefExpr();
		argUsedCA4.getAnns().add(new ActionArgumentAnn(a4));

		ApplExpr applUsedCA4 = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA4), false);
		
		RefExpr argUsedCA7 = factory.createRefExpr();
		argUsedCA7.getAnns().add(new ActionArgumentAnn(a7));

		ApplExpr applUsedCA7 = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA7), false);

		// Lista de argumentos da uniao 
		ZExprList listaArgs = factory.createZExprList(Arrays.asList(applUsedCA4, applUsedCA7));
		TupleExpr argsFuncaoUsedC = factory.createTupleExpr(listaArgs);


		// AplicaCAo daUniao 
		applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funCUniao, 
					argsFuncaoUsedC), true);

		
		argWrtvA3 = factory.createRefExpr();
		argWrtvA3.getAnns().add(new ActionArgumentAnn(a3));
		ApplExpr applWrtvCA4 = factory.createApplExpr(Arrays
				.asList(funWrtv,argWrtvA3), false);
		

		
		//Criar intersecao 

		ZName nomeInter = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCInter = this.getFactory().createRefExpr(nomeInter, 
				this.getFactory().createZExprList(), false, false);

		ZExprList listaArgsInter = factory.createZExprList(Arrays.asList(applUniao2,applWrtvCA4));
		TupleExpr argsFuncaoInter = factory.createTupleExpr(listaArgsInter);


		// Aplicacao inter 
		ApplExpr applInter = 
			this.getFactory().createApplExpr(Arrays.asList(funCInter, 
					argsFuncaoInter), true);

		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		// Monta o conjunto unitario do conjunto vazio 
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		MemPred op8 = 
			this.getFactory().createMemPred(Arrays.asList(applInter, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op8);


		/* Criando a Lei */
		String nome = this.createName("ParOutInpInterExchange3");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1051", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION);

		return result;

	}
	



}
