/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusNameSet;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveActionIte;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Interleaving
 * 
 * @author Cristiano Castro
 */
public class InterleavingLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public InterleavingLawsFactory(Internacional inter, InternalManager gerInterno) {
		super(inter, gerInterno);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_INTERLEAVING, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		/*C.95*/
		result.add(criarLeiInterleavingSequenceDistribution());
		
		/*C.96*/
		result.add( createLawInterleavingZero());
		
		/*C.97*/
		result.add(createLawInterleavingStop());
		
		/*C.98*/
		result.add(createLawParallelismCompositionInterleavingEquivalence());
		
		/*C.99*/
		result.add(createLawInterleavingChoices());
		
		result.add(createLawInterUnit());
		
		result.add(createLawParInter2());
		
		result.add(this.createLawParInterExchange());
		
		result.add(this.createLawInterIndex());
		
		return result;
	}




	/**
	 * Cria Uma lei <i>Interleaving/Sequence -- Distribution</i>
	 *  (C-95). 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiInterleavingSequenceDistribution() {

		/* criando o LHS */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction b1 = factory.createJokerAction("B1", null);
		JokerAction b2 = factory.createJokerAction("B2", null);
		JokerExpr ns1Expr = this.factory.createJokerExpr("ns1", null);
		CircusNameSet ns1 = this.factory.createCircusNameSet(ns1Expr);
		JokerExpr ns2Expr = this.factory.createJokerExpr("ns2", null);
		CircusNameSet ns2 = this.factory.createCircusNameSet(ns2Expr);
		JokerExpr csExpr = this.factory.createJokerExpr("cs", null);
		CircusChannelSet cs = this.factory.createCircusChannelSet(csExpr);

		InterleaveAction par1 = factory.createInterleaveAction(Arrays.
				asList(a1,a2), Arrays.asList(ns1,ns2));

		ParallelAction par2 = factory.createParallelAction(Arrays.
				asList(b1,b2), Arrays.asList(ns1,ns2), cs);

		SeqAction left = factory.createSeqAction(Arrays.asList(par1,par2));

		/* Criando do RHS */

		SeqAction parr1 = factory.createSeqAction(Arrays.asList(a1,b1));
		SeqAction parr2 = factory.createSeqAction(Arrays.asList(a2,b2));

		ParallelAction right = factory.createParallelAction(Arrays.
				asList(parr1,parr2), Arrays.asList(ns1,ns2), cs);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* 
		 ***********************************
		 * OP1
		 ***********************************
		 */

		/* Montando a refer�ncia � fun��o initials */
		ZName nomeInitials = 
			this.getFactory().createZName(OPsDischargeUtils.INITIALS, 
					this.getFactory().createZStrokeList(), null);
		RefExpr funInicials = this.getFactory().createRefExpr(nomeInitials, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o initial */
		RefExpr argInitialsB1 = this.getFactory().createRefExpr();
		argInitialsB1.getAnns().add(new ActionArgumentAnn(b1));

		RefExpr argInitialsB2 = this.getFactory().createRefExpr();
		argInitialsB2.getAnns().add(new ActionArgumentAnn(b2));

		/* Aplica��o da fun��o initials */
		ApplExpr applInicialsB1 = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitialsB1), false);

		ApplExpr applInicialsB2 = 
			this.getFactory().createApplExpr(Arrays.asList(funInicials, 
					argInitialsB2), false);

		/* Montando Uniao */

		/* Montando o nome da interse��o */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaUniao = 
			this.getFactory().createZExprList
			(Arrays.asList(applInicialsB1,applInicialsB2 ));
		TupleExpr argsUniao = 
			this.getFactory().createTupleExpr(listaUniao);

		/* Aplica��o da intersecao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao), true);


		/* Montando a refer�ncia � fun��o \subseteq */
		ZName nomeSubsetEq = this.getFactory().createZName(
				OPsDischargeUtils.SUBSETEQ, 
				this.getFactory().createZStrokeList(), null);
		RefExpr funSubsetEq = this.getFactory().createRefExpr(nomeSubsetEq, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da fun��o \subseteq */
		ZExprList listaArgsSubsetEq = 
			this.getFactory().createZExprList(Arrays.asList(applUniao,csExpr));
		TupleExpr argsSubsetEq = 
			this.getFactory().createTupleExpr(listaArgsSubsetEq);

		/* Aplica��o da fun��o SubsetEq */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(argsSubsetEq, 
					funSubsetEq), true);
		/*
		 * ************************************* *
		 * OP 2 
		 * ************************************* *
		 */

		/* Montando o nome da fun��o usedC */
		ZName nomeUsedC = this.getFactory().createZName(
				OPsDischargeUtils.USED_C, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUsedC = this.getFactory().createRefExpr(nomeUsedC, 
				this.getFactory().createZExprList(), false, false);

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argUsedCA1 = this.getFactory().createRefExpr();
		argUsedCA1.getAnns().add(new ActionArgumentAnn(a1));

		RefExpr argUsedCA2 = this.getFactory().createRefExpr();
		argUsedCA2.getAnns().add(new ActionArgumentAnn(a2));

		/* Aplica��o da fun��o usedC */
		ApplExpr applUsedCA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA1), false);

		ApplExpr applUsedCA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUsedC, 
					argUsedCA2), false);

		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applUsedCA1,applUsedCA2 ));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(applUniao2,csExpr));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		/* Monta a refer�mcia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op2 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);

		list.add(op1);
		list.add(op2);

		String nome = this.createName("COD0690");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.95", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_INTERLEAVING);

		return result;
	}
	
	/**
	 * a lei C-96 de circus (<i> Interleaving Zero
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawInterleavingZero() {

		/* Criando o LHS da lei */

		JokerAction a = factory.createJokerAction("A", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs", null);

		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(factory.createChaosAction(),a)
				, Arrays.asList(ns1,ns2));

		/* Criando o RHS da lei */

		ChaosAction right = factory.createChaosAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0691");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.96", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);

		return result;

	}
	
	/**
	 * a lei C-97 de circus (<i> Interleaving Stop
	 * 1</i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawInterleavingStop() {

		/* Criando o LHS da lei */

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(factory.createStopAction(),factory.createStopAction())
				, Arrays.asList(ns1,ns2));

		/* Criando o RHS da lei */

		StopAction right = factory.createStopAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0692");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.97", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);

		return result;

	}
	
	
	
	/**
	 * a lei C-98 de circus (<i> Parallelism Composition/
	 * Interleaving Equivalence </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawParallelismCompositionInterleavingEquivalence() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(a1,a2)
				, Arrays.asList(ns1,ns2));

		/* Criando o RHS da lei */

		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);
		
		CircusChannelSet es = factory.createCircusChannelSet(conjuntoVazio);
		ParallelAction right = factory.createParallelAction(
				Arrays.asList(a1,a2), Arrays.asList(ns1,ns2),es);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0693");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.98", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);

		return result;

	}
	
	/**
	 * a lei C-99 de circus (<i> Interleaving Choices </i>.
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawInterleavingChoices() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		
		JokerName nomeCanal = this.getFactory().createJokerName("c1", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);

		JokerName nomeCanal2 = this.getFactory().createJokerName("c2", null);
		RefExpr refNomeCanal2 = this.getFactory().createRefExpr(nomeCanal2, 
				this.getFactory().createZExprList(), false, false);
		Communication c2 = this.getFactory().createCommunication(refNomeCanal2, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				CommPattern.Synch, null, null);
		
		PrefixingAction par1 = factory.createPrefixingAction(a1, c1);
		PrefixingAction par2 = factory.createPrefixingAction(a2, c2);
		
		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(par1,par2)
				, Arrays.asList(ns1,ns2));

		/* Criando o RHS da lei */
		
		InterleaveAction parr1 = factory.createInterleaveAction(
				Arrays.asList(a1,par2), Arrays.asList(ns1,ns2));
		
		InterleaveAction parr2 = factory.createInterleaveAction(
				Arrays.asList(par1,a2), Arrays.asList(ns1,ns2));
		
		PrefixingAction lastpar1 = factory.createPrefixingAction(parr1, c1);
		PrefixingAction lastpar2 = factory.createPrefixingAction(parr2, c2);
		
		ExtChoiceAction right = factory.createExtChoiceAction(
				Arrays.asList(lastpar1,lastpar2));
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0694");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.99", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);

		return result;

	}
	
	/* A [ns1 | ns2] Skip = A */
	
	public CircusLaw createLawInterUnit() {

		/* Criando o LHS da lei */

		JokerAction a = factory.createJokerAction("A", null);
		SkipAction skip = factory.createSkipAction();
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(a,skip)
				, Arrays.asList(ns1,ns2));
		
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, a));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("InterUnit");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1006", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);
		
		return result;
		
	}
	
/*A_1 \linter ns_2 | ns_2 \rinter A_2 
 * = A_1 \lpar ns_2 | \emptyset | ns_2 \rpar A_2 */
	
	public CircusLaw createLawParInter2() {

		/* Criando o LHS da lei */

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		InterleaveAction left = factory.createInterleaveAction(Arrays
				.asList(a1,a2)
				, Arrays.asList(ns1,ns2));
		
		/*Criando parte direita 
		 * que e um Paraelismo*/
		
		JokerExpr csExpr = factory.createJokerExpr("emptyset", null);
		//CircusChannelSet cs = factory.createCircusChannelSet(csExpr);
		
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);
		
		Expr e = conjuntoVazio;
		CircusChannelSet cs = factory.createCircusChannelSet(conjuntoVazio);
		
		ParallelAction right = factory.createParallelAction(Arrays.
				asList(a1,a2), Arrays.asList(ns1,ns2), cs);

		
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("ParInter2");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1008", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);
		
		return result;
		
	}
	
	
	public CircusLaw createLawInterIndex() {

		/* Criando o LHS da lei 
		 * \Interleave x:\{v_1,\dots,v_n\} @ \linter~ns(x)~\rinter A(x) 
		 * */

		JokerAction a1 = factory.createJokerAction("A1", null);
		
		JokerNameSet ns2 = factory.createJokerNameSet("ns", null);
		 JokerDeclList decl = factory.createJokerDeclList("x", null);

		InterleaveActionIte inter = factory.createInterleaveActionIte(a1, decl, ns2);
		/*Criando parte direita 
		 * que e um Paraelismo*/
		
		JokerExpr csExpr = factory.createJokerExpr("emptyset", null);
		//CircusChannelSet cs = factory.createCircusChannelSet(csExpr);
		
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);
		
		Expr e = conjuntoVazio;
		CircusChannelSet cs = factory.createCircusChannelSet(conjuntoVazio);
		
		//ParallelAction right = factory.createParallelAction(Arrays.
		//		asList(a1,a2), Arrays.asList(ns1,ns2), cs);

		
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(a1, inter));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("InterIndex");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1008", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);
		
		return result;
		
	}
	
	
	public CircusLaw createLawParInterExchange() {

		/* Criando o LHS da lei 
		 * \Interleave x:\{v_1,\dots,v_n\} @ \linter~ns(x)~\rinter A(x) 
		 * */

		JokerAction a1 = factory.createJokerAction("A1", null);
		
		JokerNameSet ns2 = factory.createJokerNameSet("ns", null);
		 JokerDeclList decl = factory.createJokerDeclList("x", null);

		InterleaveActionIte inter = factory.createInterleaveActionIte(a1, decl, ns2);
		/*Criando parte direita 
		 * que e um Paraelismo*/
		
		JokerExpr csExpr = factory.createJokerExpr("emptyset", null);
		//CircusChannelSet cs = factory.createCircusChannelSet(csExpr);
		
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);
		
		Expr e = conjuntoVazio;
		CircusChannelSet cs = factory.createCircusChannelSet(conjuntoVazio);
		
		//ParallelAction right = factory.createParallelAction(Arrays.
		//		asList(a1,a2), Arrays.asList(ns1,ns2), cs);

		
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(a1, inter));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("ParOutInpInterExchangeN");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1033", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_INTERLEAVING);
		
		return result;
		
	}
	
}
