/*
 * Projeto: Circus Factory
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.impl.ChaosActionImpl;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.FalsePred;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

/**
 * Cria as leis de Guarda
 * 
 * @author Cristiano Castro
 */
public class GuardsLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public GuardsLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_GUARDS, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/* C.57 */
		result.add(this.criarLeiGuardCombination());

		/* C.58 */
		result.add(this.criarLeiGuardsExpansion()); 

		/* C-59 */
		result.add(this.criarLeiGuardsSequenceAssociativity());

		/* C-60 */
		result.add(this.criarLeiGuardsExternalChoiceDistribution());

		/* C-61 */
		result.add(this.criarLeiGuardInternalChoiceDistribution());

		/* C-62 */
		result.add(this.criarLeiGuardParallelismCompositionDistribution());

		/* C-63 */
		result.add(this.criarLeiGuardParallelismCompositionDistribution2());

		/* C-64 */
		result.add(this.criarLeiGuardParallelismCompositionDistribution3());

		/* C-65 */
		result.add(this.criarLeiGuardInterleavingDistribution1());
		
		/* C-66 */
		result.add(this.criarLeiGuardInterleavingDistribution2());

		/* C-67 */
		result.add(this.criarLeiGuardedTrue());
		
		/* C-68 */
		result.add(this.criarLeiGuardedFalse());
		
		/* C-69 */
		result.add(this.criarLeiGuardedStop());

		
		result.add(this.criarLeiTeste());
		
		return result;
	}

	/**
	 * Cria a Lei <i>Guard combination</i> (C-57). 
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardCombination() {

		/* Criando o LHS da lei */
		JokerPred g1 = factory.createJokerPred("g1", null);
		JokerPred g2 = factory.createJokerPred("g2", null);
		JokerAction a = factory.createJokerAction("A", null);
		GuardedAction acao = factory.createGuardedAction(a, g2);
		GuardedAction left = factory.createGuardedAction(acao, g1);

		/* Criando o RHS da lei */
		List<Pred> conjuncoes = new ArrayList<Pred>();
		conjuncoes.add(g1);
		conjuncoes.add(g2);
		Pred guarda = factory.createAndPred(conjuncoes, And.Wedge);
		GuardedAction right = factory.createGuardedAction(a, guarda);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0478");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.57", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}

	/**
	 * Cria a Lei <i>Guards expansion</i> (C.58).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardsExpansion() {

		/* Criando o LHS da lei */
		JokerPred g1 = factory.createJokerPred("g1", null);
		JokerPred g2 = factory.createJokerPred("g2", null);
		JokerAction a = factory.createJokerAction("A", null);
		List<Pred> disjuncoes = new ArrayList<Pred>();
		disjuncoes.add(g1);
		disjuncoes.add(g2);
		Pred guarda = factory.createOrPred(disjuncoes);
		GuardedAction left = factory.createGuardedAction(a, guarda);

		/* Criando o RHS da lei */
		GuardedAction acao1 = factory.createGuardedAction(a, g1);
		GuardedAction acao2 = factory.createGuardedAction(a, g2);
		ExtChoiceAction right = 
			factory.createExtChoiceAction(Arrays.asList(acao1, acao2));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0479");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-58", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}

	/**
	 * Cria a Lei <i>Guards/Sequence associativity</i> (C-59).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardsSequenceAssociativity() {

		/* Criando o LHS da lei */
		JokerPred g = factory.createJokerPred("g", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		GuardedAction left1 = factory.createGuardedAction(a1, g);
		SeqAction left = factory.createSeqAction(Arrays.asList(left1, a2));

		/* Criando o RHS da lei */
		SeqAction acao1 = factory.createSeqAction(Arrays.asList(a1, a2));
		GuardedAction right = factory.createGuardedAction(acao1, g);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0480");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-59", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}



	/**
	 * Cria a Lei <i>Guards/External Choice Distribution </i> (C-60).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardsExternalChoiceDistribution() {

		/* Criando o LHS da lei */
		JokerPred g = factory.createJokerPred("g", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		ExtChoiceAction ext = factory.createExtChoiceAction(Arrays.asList(a1,a2));

		GuardedAction left = factory.createGuardedAction(ext, g);


		/* Criando o RHS da lei */

		GuardedAction um = factory.createGuardedAction(a1, g);
		GuardedAction dois = factory.createGuardedAction(a2, g);
		ExtChoiceAction right = factory.createExtChoiceAction
		(Arrays.asList(um,dois));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0674");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-60", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}


	/**
	 * Cria a lei GuardInternalChoiceDistribution (C-61)
	 * 
	 * @return a nova CircusLaw
	 */
	public CircusLaw criarLeiGuardInternalChoiceDistribution() {
		JokerPred g = factory.createJokerPred("g", null);
		JokerAction A1 = factory.createJokerAction("A", null);
		JokerAction A2 = factory.createJokerAction("B", null);

		IntChoiceAction left1 = 
			factory.createIntChoiceAction(Arrays.asList(A1, A2));
			GuardedAction left = factory.createGuardedAction(left1, g);

			GuardedAction right1 = factory.createGuardedAction(A1, g);
			GuardedAction right2 = factory.createGuardedAction(A2, g);
			IntChoiceAction right = 
				factory.createIntChoiceAction(Arrays.asList(right1, right2));

			/* Criando o transformer */
			ActionTransformerPred trans = factory.createActionTransformerPred(null, 
					Transformation.Equivalence,
					CircusUtils.DEFAULT_REFINEMENT_MODEL, 
					Arrays.asList(left, right));

			String nome = this.createName("COD0474");
			CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
					new ArrayList<Pred>());

			LawNumberAnn id = new LawNumberAnn("C.61", nome);
			result.getAnns().add(id);
			LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

			return result;

	}

	/**
	 * Cria a Lei <i>Guard/Parallelism composition -- distribution 
	 * 	</i> (C-62).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardParallelismCompositionDistribution() {

		/* Criando o LHS da lei */
		JokerPred g = factory.createJokerPred("g", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		ParallelAction semileft = factory.createParallelAction(Arrays.asList(a1, 
				a2), Arrays.asList(ns1, ns2), cs);

		GuardedAction left = factory.createGuardedAction(semileft, g);

		/* Criando o RHS da lei */

		GuardedAction guard1 = factory.createGuardedAction(a1, g);
		GuardedAction guard2 = factory.createGuardedAction(a2, g);

		ParallelAction right = factory.createParallelAction(Arrays.
				asList(guard1,guard2), Arrays.asList(ns1,ns2), cs);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();


		/* Criando a Lei */
		String nome = this.createName("COD0675");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.62", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}




	/**
	 * Cria a Lei <i>Guard/Parallelism composition -- distribution 
	 * 	2</i> (C-63).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardParallelismCompositionDistribution2() {

		/* Criando o LHS da lei */
		JokerPred g1 = factory.createJokerPred("g1", null);
		JokerPred g2 = factory.createJokerPred("g2", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
		GuardedAction left1 = factory.createGuardedAction(a1, g1);
		GuardedAction left2 = factory.createGuardedAction(a2, g2);
		ParallelAction left = factory.createParallelAction(Arrays.asList(left1, 
				left2), Arrays.asList(ns1, ns2), cs);

		/* Criando o RHS da lei */
		OrPred right1 = factory.createOrPred(Arrays.asList(g1, g2));
		GuardedAction right = factory.createGuardedAction(left, right1);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		IffPred op1 = factory.createIffPred(Arrays.asList(g1, g2));
		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0742");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.63", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}


	/**
	 * Cria a Lei <i>Guard/Parallelism composition -- distribution 3
	 * 	</i> (C-64).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardParallelismCompositionDistribution3() {

		/* Criando o LHS da lei */
		JokerPred g1 = factory.createJokerPred("g1", null);
		JokerPred g2 = factory.createJokerPred("g2", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerChannelSet cs = factory.createJokerChannelSet("cs", null);

		AndPred and = factory.createAndPred(Arrays.asList(g1,g2), And.Wedge);
		ParallelAction semileft = factory.createParallelAction(Arrays.asList(a1, 
				a2), Arrays.asList(ns1, ns2), cs);

		GuardedAction left = this.factory.createGuardedAction(semileft, and);

		/* Criando o RHS da lei */

		GuardedAction right1 = factory.createGuardedAction(a1, g1);
		GuardedAction right2 = factory.createGuardedAction(a2, g2);

		ParallelAction right = factory.createParallelAction(Arrays.
				asList(right1,right2), Arrays.asList(ns1,ns2), cs);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		IffPred op1 = factory.createIffPred(Arrays.asList(g1, g2));
		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0673");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.64", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}


	/**
	 * Cria a Lei <i>Guards/Interleanving -- distribution</i> (C-65).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardInterleavingDistribution1() {

		/* Criando o LHS da lei */
		JokerPred g = factory.createJokerPred("g", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		InterleaveAction left1 = 
			factory.createInterleaveAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2));
		GuardedAction left = factory.createGuardedAction(left1, g);

		/* Criando o RHS da lei */
		GuardedAction right1 = factory.createGuardedAction(a1, g);
		GuardedAction right2 = factory.createGuardedAction(a2, g);
		InterleaveAction right = 
			factory.createInterleaveAction(Arrays.asList(right1, right2), 
					Arrays.asList(ns1, ns2));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0492");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.65", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}

	
	/**
	 * Cria a Lei <i>Guards/Interleanving -- distribution 2</i> (C-66).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardInterleavingDistribution2() {

		/* Criando o LHS da lei */
		JokerPred g1 = factory.createJokerPred("g1", null);
		JokerPred g2 = factory.createJokerPred("g2", null);
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		
		GuardedAction a1g = factory.createGuardedAction(a1, g1);
		GuardedAction a2g = factory.createGuardedAction(a2, g2);
		
		InterleaveAction left = 
			factory.createInterleaveAction(Arrays.asList(a1g, a2g), 
					Arrays.asList(ns1, ns2));

		/* Criando o RHS da lei */
		
		OrPred or = factory.createOrPred(Arrays.asList(g1,g2));
		
		GuardedAction right = factory.createGuardedAction(left, or);
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0676");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.66", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}
	
	public CircusLaw criarLeiTeste (){
		
		TruePred falso = factory.createTruePred();
		
		JokerAction a = factory.createJokerAction("A", null);
		
		GuardedAction left = factory.createGuardedAction(a, falso);
		
		ChaosAction right = factory.createChaosAction();
		
		ActionTransformerPred transLei = factory.createActionTransformerPred(null, Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, Arrays.asList(left,right));
		
		
		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		FalsePred falsoo = factory.createFalsePred();
		
		ImpliesPred pred1 = factory.createImpliesPred(Arrays.asList(falso, falsoo));
		ops.add(pred1);
		
		
		/* Criando a Lei */
		String nome = this.createName("LeiTeste");
		
		
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, transLei, ops);
		
		LawNumberAnn id = new LawNumberAnn("C.999", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_GUARDS);
		
		
		/* Inserindo detalhes da lei*/
    	String[] obs = new String[2];
    	obs[0] = "This is a wrong law";
    	obs[1] = "it should not be here";
    	
    	LawDefinitionAnn lawAnn = new LawDefinitionAnn(obs,null,null,null);
    	result.getAnns().add(lawAnn);
		
		return  result;
	}
	
	
	
	/**
	 * Cria a Lei <i>Guarded True</i> (C-67).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardedTrue() {

		/* Criando o LHS da lei */
		JokerAction a = factory.createJokerAction("A", null);
		
		TruePred tru = factory.createTruePred();
		
		GuardedAction left = factory.createGuardedAction(a, tru);

		/* Criando o RHS da lei */

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, a));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0677");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-67", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}
	
	/**
	 * Cria a Lei <i>Guarded False</i> (C-68).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardedFalse() {

		/* Criando o LHS da lei */
		JokerAction a = factory.createJokerAction("A", null);
		
		FalsePred tru = factory.createFalsePred();
		
		GuardedAction left = factory.createGuardedAction(a, tru);

		/* Criando o RHS da lei */
		StopAction right = factory.createStopAction();
		
		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0678");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-68", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_GUARDS);

		return result;
	}
	
	
	
	
	/**
	 * Cria a Lei <i>Guarded Stop</i> (C-69).
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiGuardedStop() {

		/* Criando o LHS da lei */
		JokerPred g = factory.createJokerPred("g", null);
		StopAction stop = factory.createStopAction();
		GuardedAction left = factory.createGuardedAction(stop, g);


		/* Criando o RHS da lei */
		StopAction right = factory.createStopAction();

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0506");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C-69", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_GUARDS);

		return result;
		
	}

}
