/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.Pred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Chaos
 * 
 * @author Cristiano Castro
 */
public class ChaosLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public ChaosLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_CHAOS, codName);
	}
	
	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		result.add(criarLeiChaosRefinement());
		
		return result;
	}

	
	/**
	 * Cria Uma lei <i>Chaos Refinement</i> (C-135) 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiChaosRefinement() {

		JokerAction a = factory.createJokerAction("A", null);
		

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(factory.createChaosAction(), a));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("COD0715");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.135", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
}
