/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.messages.MessagesManager;


/**
 * Excesso disparada quando h um erro na lei de definio de Xi
 * 
 * @author Cristiano Castro
 */
public class XiRuleApplicationException extends CRulesException {

	/** Nmero para serializao */
	private static final long serialVersionUID = 3479859899589321842L;
	
	public XiRuleApplicationException(String code, Throwable cause) throws 
			CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(code), cause);
	}

	public XiRuleApplicationException(String code) {
		super(code);
	}

}
