/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.opsdischarge.SyntacticFunctionsUtils;

// TODO modificar esta classe para aceitar tambm duas listas que contenham um mesmo nome declarado */

/**
 * Anotao utilizada para unificar duas listas de declaraes. 
 * Para esse mtodo, as listas devem ser disjuntas, ou seja, no podem 
 * ter um mesmo nome declarado
 * 
 * @author Cristiano Castro
 */
public class UnifyDeclListAnn extends LawApplAnn {

	/** Primeira lista a ser unificada */
	private JokerDeclList d1;
	
	/** Segunda lista a ser unificada */
	private JokerDeclList d2;
	
	/** Lista resultante da unificao */
	private JokerDeclList dl;
	
	/**
	 * Inicia o objeto informando os jokers que unificam com a primeira lista, 
	 * a segunda lista e a lista resultante da unificao
	 * 
	 * @param fst a primeira lista a ser unificada
	 * @param scn a segunda lista a ser unificada
	 * @param total a lista resultante da unificao
	 */
	public UnifyDeclListAnn(JokerDeclList total, JokerDeclList fst, 
			JokerDeclList scn) {
		this.setD1(fst);
		this.setD2(scn);
		this.setDl(total);
	}
	
	/**
	 * @return the d1
	 */
	private JokerDeclList getD1() {
		return d1;
	}

	/**
	 * @param d1 the d1 to set
	 */
	private void setD1(JokerDeclList d1) {
		this.d1 = d1;
	}

	/**
	 * @return the d2
	 */
	private JokerDeclList getD2() {
		return d2;
	}

	/**
	 * @param d2 the d2 to set
	 */
	private void setD2(JokerDeclList d2) {
		this.d2 = d2;
	}

	/**
	 * @return the dl
	 */
	private JokerDeclList getDl() {
		return dl;
	}

	/**
	 * @param dl the dl to set
	 */
	private void setDl(JokerDeclList dl) {
		this.dl = dl;
	}

	/**
	 * Aplica a unificao de duas listas de declaraes.
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		HashSet<Term> result = new HashSet<Term>();

		ZDeclList lista1 = (ZDeclList)
			UnifyDeclListAnn.findOriginal(this.getD1().getName(), unificacao);
		ZDeclList lista2 = (ZDeclList) 
			UnifyDeclListAnn.findOriginal(this.getD2().getName(), unificacao);
		
		HashSet<ZName> nomesL1 = 
			SyntacticFunctionsUtils.variaveisDeclaradas(lista1);
		HashSet<ZName> nomesL2 = 
			SyntacticFunctionsUtils.variaveisDeclaradas(lista2);
		
		/* nomesL1  agora a interseo */
		nomesL1.retainAll(nomesL2);
		
		if (nomesL1.isEmpty()) {
			
			/* Iterseo  vazia */
			
			/* 
			 * Monta a lista que ir unificar com o joker da lista
			 * total 
			 */
			ZDeclList listaTotal = this.factory.createZDeclList();
			listaTotal.addAll(lista1);
			listaTotal.addAll(lista2);
			
			/* nova unificao da lista total */
			JokerDeclListBinding novo = 
				this.factory.createJokerDeclListBinding(this.getDl(), 
						listaTotal);
			unificacao.add(novo);
			
			/* Retira o joker da lista total da lista de parametros */
			result.add(this.getDl());
			
		} else {
			
			/* As listas possuem um nomes em comum  */
			String msg = 
				MessagesManager.getInstance().getMessage("UnifyDeclListMsg");
			throw new CannotUnifyDeclListException(msg);
		}
		
		return result;
	}
	
	/**
	 * Excesso de erro na unificanao
	 * 
	 * @author Cristiano Castro
	 */
	protected class CannotUnifyDeclListException extends CRulesException {

		/** Nmero serial */
		private static final long serialVersionUID = -851756224294966704L;
		
		/**
		 * Construtor que recebe a mensagem de erro
		 * 
		 * @param msg a mensgem para o usurio
		 */
		public CannotUnifyDeclListException(String msg) {
			super(msg);
		}
		
	}
	
}
