/*
 * Projeto: circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.BuilderVisitor;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.BindingGetterVisitor;
import circusRefine.core.util.JokersGetterVisitor;
import circusRefine.core.util.ParaNameGetter;
import circusRefine.util.Pair;

// TODO comentar essa classe

/**
 * 
 * @author crisgc
 *
 */
public class RemoveParaAnn extends LawApplAnn {

	private JokerName nomeParaRemover;
	
	private JokerParaList listaParaOriginal;
	
	public RemoveParaAnn(JokerName nomeARemover, JokerParaList listaOriginal) {
		this.setListaParaOriginal(listaOriginal);
		this.setNomeParaRemover(nomeARemover);
	}

	public JokerName getNomeParaRemover() {
		return nomeParaRemover;
	}
	
	public void setNomeParaRemover(JokerName nomeParaRemover) {
		this.nomeParaRemover = nomeParaRemover;
	}
	
	public JokerParaList getListaParaOriginal() {
		return listaParaOriginal;
	}
	
	public void setListaParaOriginal(JokerParaList listaParaOriginal) {
		this.listaParaOriginal = listaParaOriginal;
	}
	
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		
		/* Procura pela lista original real */
		for (Binding bind : unificacao) {
			Pair<String, Term> mapeamento = BindingGetterVisitor.getMap(bind);
			Term result = mapeamento.getSecond();

			if ( result != null ) { /* Achou o mapeamento da lista principal */

				/* Monta o nome do pargrafo a ser removido */
				List<Term> jokers = 
					JokersGetterVisitor.getJokers(this.getNomeParaRemover());
				Set<Binding> unify = crUtils.getParameters(jokers, resposta);
				ZName novoNome = 
					(ZName)BuilderVisitor.build(this.getNomeParaRemover(), unify);

				/* Comea a montar a ZParaList com o item removido */
				ZParaList lista1 = factory.createZParaList((ZParaList)result);
				Para aRemover = 
						ParaNameGetter.getParaFromName(novoNome, lista1);
				lista1.remove(aRemover);

				/* Cria o binding para o pl2 */
				JokerParaListBinding binding = 
					factory.createJokerParaListBinding((JokerParaList)parametro, 
							lista1);
				unificacao.add(binding);
				
			} 
		}
		
		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(parametro);
		return toReturn;
	}

}
