/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.anotations;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnmarshalException;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.annotations.TemporaryTermAnn;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CancelledApplException;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.crules.utils.DefinitionFromATermGetter;
import circusRefine.core.crules.utils.TermFromANameGetter;
import circusRefine.core.util.ClonerVisitor;

/**
 * Anota��o para aplicar uma Copy Rule ao programa
 * 
 * @author Cristiano Gurgel
 */
public class CopyRuleForNameAnn extends LawApplAnn {
	
	int cont = 0;

	/**
	 * M�todo que efetivamente efetua a troca de um nome em uma �rvore 
	 * pela sua defini��o
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param classeNome a classe do nome
	 * @param ast a �rvore no qual as defini��es s�o pesquisadas
	 * @param result a sub-�rvore onde se dar� a substitui��o
	 * @return a nova sub-�rvore formada
	 */
	public static Term changeNameToDefinition(ZName nome, Term classeNome, 
			Term ast, Term result, InternalManager gerInt) {
		
		/* N�o leva em considera��o os strokes no nome */
		ZName copiaNome = ClonerVisitor.cloneTerm(nome);
		copiaNome.getZStrokeList().clear();
		
		/* Busca pela defini��o substituir o nome */
		Term aSubstituir = 
			DefinitionFromATermGetter.find(copiaNome, classeNome, ast, gerInt);
		Term toReturn;
		
		if (aSubstituir != null) {
			
			/* Caso o nome pesquisado n�o tenha falhado */
			Term troca = UpdateVisitor.update(classeNome, aSubstituir, result,false);
			toReturn = ClonerVisitor.cloneTermRemovingRelationsStack(troca);
		} else {
			toReturn = ClonerVisitor.cloneTermRemovingRelationsStack(result); 
		}
		
		return toReturn; 
	}
	
	/**
	 * M�todo est�tico para retornar as fun��es de esquema que s�o 
	 * trat�veis pela lei de c�pia
	 * 
	 * @return um conjunto de {@link String}s com as fun��es 
	 *  \Delta e \Xi
	 */
	public static Set<String> funcoesEsquemas() {
		Set<String> result = new TreeSet<String>();
		result.add(ZString.DELTA);
		result.add(ZString.XI);
		return result;
	}
	
	/** O joker do nome da a��o a ser substitu�da */
	private JokerAction nomeAcao;
	
	/** Referencia para o gerenciador Interno*/
	private InternalManager gerInterno;
	/** 
	 * Cria a classe com o joker que se ligar� ao nome da a��o a seSr
	 * substitu�da
	 * 
	 * @param nomeDaAcao o joker que representa o nome da a��o
	 */
	public CopyRuleForNameAnn(JokerAction nomeDaAcao, InternalManager gerInt) {
		this.setNomeAcao(nomeDaAcao);
		gerInterno = gerInt;
	}

	private JokerAction getNomeAcao() {
		return nomeAcao;
	}

	private void setNomeAcao(JokerAction nomeAcao) {
		this.nomeAcao = nomeAcao;
	}

	/**
	 * Aplica a lei de C�pia substituindo a {@link CallAction} 
	 * contendo o nome referenciado pelo Joker pela defini��o da a��o
	 * presente no processo no qual a {@link CallAction} est�
	 * 
	 * @param interno o gerenciador interno da ferramenta, usado para
	 *  obter acesso a AST, bem como receber par�metros do usu�rio
	 * @param unificacao o conjunto com a unifica��o da lei feita at�
	 *  o momento
	 * @param parametro o joker que representa a nova a��o
	 * @throws CommandException 
	 * @throws UnmarshalException 
	 * @throws IOException 
	 * @throws ParseException 
	 * @throws CancelledApplException 
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws CRulesException {

		/* Procura pelo AcaoOriginal */
		Term result = LawApplAnn.findOriginal(this.getNomeAcao().getName(), 
				unificacao);

		TemporaryTermAnn ann = result.getAnn(TemporaryTermAnn.class);
		
		Term realResult;
		
		/* Testa se o termo possui uma anotação de termo termporário */
		if (ann != null) {
			realResult = ann.getRealTerm();
		} else {
			realResult = result;
		}
		
		JokerActionBinding binding;

		if (realResult instanceof CallAction) {
					
			/* 
			 * Se for um nome entao a substitui��o ocorre 
			 * diretamente 
			 */
			ZName nome = ((CallAction)result).getZName();
			CircusAction aSubstituir;
			
		//	 Busca a ação definida pelo nome 
			aSubstituir = (CircusAction)
				DefinitionFromATermGetter.find(nome, realResult, 
						crUtils.getInterno().retornarProgAtual(), gerInterno);
          //  }	
			/* Cria o binding para o circusAction */
			binding = factory.createJokerActionBinding((JokerAction)parametro, 
						aSubstituir);

		} else {

			JokerName jokerNome = this.factory.createJokerName("name", null);
			List<Term> params = new LinkedList<Term>(Arrays.asList(jokerNome));
			Set<Binding> binds = crUtils.getParameters(params, resposta);

			/* Procura o termo a substituir */
			ZName nome = 
				(ZName)CopyRuleForNameAnn.findOriginal(jokerNome.getName(), 
						binds);
			
			/* 
			 * Os tipos de nomes podem ser: a��o, processo, name set,
			 * channel set ou um ref expr 
			 */
			Term expressaoOuAcaoNome = TermFromANameGetter.getTerm(nome, 
					result);

			CircusAction acao = (CircusAction)
				CopyRuleForNameAnn.changeNameToDefinition(nome, 
					expressaoOuAcaoNome, 
					crUtils.getInterno().retornarProgAtual(), result, gerInterno);

			/* Cria o binding para o circusAction */
			binding = factory.createJokerActionBinding((JokerAction)parametro, 
						acao);

			
		}
		
		unificacao.add(binding);
		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(parametro);
		return toReturn;

	}
	
}
