package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.FreeOccurrencesExprFromActionGetter;
import circusRefine.core.print.Printer;

/**
 * Classe utilizada para aplicao da lei Channel Extension 3
 * e para a Channel Extension 2
 * @author alessandro
 *
 */
public class ChannelExtensionAnn extends LawApplAnn{

	private JokerExpr e;
	private JokerName x;
	
	private JokerAction a2X;
	private JokerAction a2E;
	
	public ChannelExtensionAnn(JokerExpr e2, JokerName x2, JokerAction a2x, JokerAction a2e) {
		this.e = e2;
		this.x = x2;
		this.a2X = a2x;
		this.a2E = a2e;
		
	}
	/**
	 * Deve-se verificar inicialmente a existencia do "E" em a 
	 * e depois substitu-la por "X"
	 * @return Ele retorna os Jokers que no podem ser tratados como parmetro a ser 
	 * inserido
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao, Term parametro, LawAnswer resposta) 
	throws Exception {
		
		Set<Term> result = new HashSet<Term>();
		CircusAction acaofinal = null;
		
		
		/* Pergunte quem  a expressao E que deve estar contida no termo A2E*/
		/* Para isso define inicialmente o conjunto de parmetros*/
		List< Term > parametros = new LinkedList<Term>();
		parametros.add(e);
		parametros.add(x);
		
		/* requisita insero do parmetro e*/
		Set< Binding > retorno = crUtils.getParameters(parametros, resposta);
		
		RefExpr exprE = (RefExpr)this.findOriginal(e.getName(), retorno);
				
		/* Pega a ao unificada a2 que deve conter o e*/
		
		CircusAction acao2 = (CircusAction) this.findOriginal(a2E.getName(), unificacao);
		
		
		
		/* Captura as ocorrencias que deverao ser substituidas*/
		LinkedList<Expr> ocorrencias = FreeOccurrencesExprFromActionGetter.procurarOcorrencias(acao2, exprE);
		
		if (ocorrencias.size() > 0) {
			/* Pedir parmetro X*/
			parametros.clear();
			ZName name = (ZName)this.findOriginal(x.getName(), retorno);
			RefExpr exprX = factory.createRefExpr(name, factory.createZExprList(), false, false);
			
			
			/* Substituir cada ocorrncia de e por x */
			for (Expr expr : ocorrencias) {
				 acaofinal = (CircusAction)UpdateVisitor.update(expr, exprX, acao2,false); 
			}
			unificacao.addAll(retorno);/* Unificando x e "e"  */
			
			/* Unificando o F(Y) */
			JokerActionBinding bind = 
				this.factory.createJokerActionBinding(this.a2X, 
						acaofinal);
			
			unificacao.add(bind);
			
		}
		else /* Nao pode aplicar a lei*/ {
			String msg = MessagesManager.getInstance().getMessage("CRefineLawApplError");
			throw  new CircusLawApplicationException(msg);
		}
		
		result.add(e);
		result.add(x);
		result.add(a2X);
		
		return result;
	}
	
	
}
