/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.util.BindingGetterVisitor;
import circusRefine.core.util.ChildrenTermExtractor;
import circusRefine.core.util.ListTermCompareVisitor;
import circusRefine.util.Pair;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerCommunicationBinding;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaBinding;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.rules.unification.UnificationException;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RenameList;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerExprListBinding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameBinding;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerNameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerRenameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.ast.JokerStrokeBinding;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;

/**
 * A classe que implementa o visitor para unificacao
 * 
 * @author Cristiano Gurgel
 */
public class UnifierVisitor implements TermVisitor<Set<Binding>>, 
		JokerActionVisitor<Set<Binding>>, JokerChannelSetVisitor<Set<Binding>>,
		JokerCommunicationVisitor<Set<Binding>>, 
		JokerDeclListVisitor<Set<Binding>>, JokerExprVisitor<Set<Binding>>,
		JokerExprListVisitor<Set<Binding>>, JokerNameVisitor<Set<Binding>>,
		JokerNameListVisitor<Set<Binding>>, JokerNameSetVisitor<Set<Binding>>,
		JokerPredVisitor<Set<Binding>>, JokerProcessVisitor<Set<Binding>>,
		JokerRenameListVisitor<Set<Binding>>, JokerStrokeVisitor<Set<Binding>>,
		JokerParaVisitor<Set<Binding>>, JokerParaListVisitor<Set<Binding>> {

	
	/**
	 * Para as táticas
	 */
	ArrayList<Pair<Term, Term>> res = new ArrayList<Pair<Term,Term>>();
	
	/**
	 * Metodo util para unificar 2 termos, um com o programa no qual
	 * sera aplicado uma lei e outro com o Spec da lei
	 * 
	 * @param real o termo no qual sera aplicado a lei
	 * @param law o Spec de uma Transformacao
	 * @return uma lista com as unificacoes
	 * @throws UnificationException se os termos nao puderem ser 
	 * 		unificados
	 */
	public static Set<Binding> unify(Term real, Term law) 
			throws UnificationException {
		try {
			UnifierVisitor visitor = new UnifierVisitor(real);
			Set<Binding> result = law.accept(visitor);

			/* Caso haja falha no teste de unifica��o */
			if (!UnifierVisitor.unifyTest(result)) {
				throw new UnificationException(law, real, "Mesmo Joker " + 
					"unificado com Termos distintos sintaticamente ");
			}
			return result;
		} catch (RunTimeUnificationException e) {
			throw new UnificationException(e.getLeft(), e.getRight(), 
					e.getMessage(), e);
		}
	}
	
	/** A pilha de unificacao */
	private Stack<Term> pilha;
	
	/** Log para a documenta��o da unificacao */
	private StringWriter log;
	
	private static final String msg1 = "Os elementos nao sao do mesmo tipo.";
	private static final String msg2 = "O numero de filhos dos dois" + 
			" elementos  diferente";
	
	/**
	 * Construtor padrao
	 */
	public UnifierVisitor(Term real) {
		this.setStack(new Stack<Term>());
		this.getStack().add(real);
		this.setLog(new StringWriter());
		this.addMessage("Log Unificacao: " + this.getClass());
	}
	
	/**
	 * Acessa a pilha de unificacao.
	 * 
	 * @return a pilha de unificacao
	 */
	private Stack<Term> getStack() {
		return pilha;
	}
	
	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}
	
	/**
	 * Seta a pilha de unificacao 
	 * 
	 * @param pilha a nova pilha de unificacao 
	 */
	private void setStack(Stack<Term> pilha) {
		this.pilha = pilha;
	}
	
	/**
	 * Visita a AST procurando Jokers para unificacao
	 * 
	 * @param lei o termo referente a lei
	 * @return uma lista com os elementos de ligacao
	 */
	public Set<Binding> visitTerm(Term lei) {
		
		Term real = this.getStack().pop();
		
		Pair<Term, Term> mapeamento = new Pair<Term, Term>();
		
		
		if (lei.getClass().isInstance(real)) {
			
			/* Testa o numero de filhos */
			if (lei.getChildren().length == real.getChildren().length) {
				
				/* relatorio */
				this.addMessage(lei.getClass().getName() + " -> " + 
						real.getClass().getName());

				/* Extrai os filhos */
				ChildrenTermExtractor extrator = new ChildrenTermExtractor();
				
				List<Term> childrenLaw = lei.accept(extrator);
				List<Term> childrenTerm = real.accept(extrator);
				
								
				Iterator<Term> childrenTermItr = childrenTerm.iterator();
				
				/* Testa os tamanhos das listas */
				if (childrenLaw.size() != childrenTerm.size()) {
					this.handleError(lei, real, UnifierVisitor.msg2);
				}
				
				Set<Binding> result = new HashSet<Binding>();

				/* Constroi o resultado */			
				for (Term termLaw : childrenLaw) {
					Term termReal = childrenTermItr.next();
					if (termLaw != null) {
                     
						mapeamento.setFirst(termReal);
						mapeamento.setSecond(termLaw);
						res.add(mapeamento);
						//applies.addAll(termLaw.toString(),termReal);
						
						/* Testa se os termos s�o null */
						this.getStack().push(termReal);
						result.addAll(termLaw.accept(this));
					} else if (termReal != null){
						
						/* O termo Real n�o � null: n�o unifica */
						this.handleError(termLaw, termReal, "Um termo da lei " +
								"� null enquanto o termo real n�o o �");
					}
				}
               
				return result;
			} else {
				
				/* Numero de filhos nao bate */
				this.handleError(lei, real, UnifierVisitor.msg2);
				
			}
			
		}
		
		/* Erro de unificacao */
		this.handleError(lei, real, UnifierVisitor.msg1);
		return new HashSet<Binding>();
	}
	
	/**
	 * Visita a AST procurando Jokers para unificacao
	 * 
	 * @param lei o termo referente a lei
	 * @return uma lista com os elementos de ligacao
	 */
	public Set<Binding> visitTermTatica(Term lei) {
		
		Term real = this.getStack().pop();
	
		if (lei.getClass().isInstance(real)) {
			
			/* Testa o numero de filhos */
			if (lei.getChildren().length == real.getChildren().length) {
				
				
				/* Extrai os filhos */
				ChildrenTermExtractor extrator = new ChildrenTermExtractor();
				
				List<Term> childrenLaw = lei.accept(extrator);
				List<Term> childrenTerm = real.accept(extrator);
				
								
				Iterator<Term> childrenTermItr = childrenTerm.iterator();
				
				/* Testa os tamanhos das listas */
				if (childrenLaw.size() != childrenTerm.size()) {
					this.handleError(lei, real, UnifierVisitor.msg2);
				}
				
				Set<Binding> result = new HashSet<Binding>();

				/* Constroi o resultado */			
				for (Term termLaw : childrenLaw) {
					Term termReal = childrenTermItr.next();
					if (termLaw != null) {
						
						/* Testa se os termos s�o null */
						this.getStack().push(termReal);
						result.addAll(termLaw.accept(this));
					} else if (termReal != null){
						
						/* O termo Real n�o � null: n�o unifica */
						this.handleError(termLaw, termReal, "Um termo da lei " +
								"� null enquanto o termo real n�o o �");
					}
				}

				return result;
			} else {
				
				/* Numero de filhos nao bate */
				this.handleError(lei, real, UnifierVisitor.msg2);
				
			}
			
		}
		
		/* Erro de unificacao */
		this.handleError(lei, real, UnifierVisitor.msg1);
		return new HashSet<Binding>();
	}
	
	
	
	/**
	 * Trata o {@link JokerAction} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerAction(JokerAction joker) {
		
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof CircusAction) {
			CircusAction acao = (CircusAction) real;
			JokerActionBinding bind = 
					factory.createJokerActionBinding(joker, acao);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + acao.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
		
	}
	
	/**
	 * Trata o {@link JokerChannelSet} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerChannelSet(JokerChannelSet joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof ChannelSet) {
			ChannelSet chSet = (ChannelSet) real;
			JokerChannelSetBinding bind = 
					factory.createJokerChannelSetBinding(joker, chSet);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + chSet.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
		
	}

	/**
	 * Trata o {@link JokerCommunication} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerCommunication(JokerCommunication joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Communication) {
			Communication comm = (Communication) real;
			JokerCommunicationBinding bind = 
					factory.createJokerCommunicationBinding(joker, comm);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + comm.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}
	
	
	
	/**
	 * Trata o {@link JokerDeclList} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerDeclList(JokerDeclList joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof DeclList) {
			DeclList dList = (DeclList) real;
			JokerDeclListBinding bind = 
					factory.createJokerDeclListBinding(joker, dList);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + dList.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerExpr} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerExpr(JokerExpr joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Expr) {
			Expr exp = (Expr) real;
			JokerExprBinding bind = 
					factory.createJokerExprBinding(joker, exp);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + exp.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerExprList} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerExprList(JokerExprList joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof ExprList) {
			ExprList eList = (ExprList) real;
			JokerExprListBinding bind = 
					factory.createJokerExprListBinding(joker, eList);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + eList.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerName} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerName(JokerName joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Name) {
			Name name = (Name) real;
			JokerNameBinding bind = 
					factory.createJokerNameBinding(joker, name);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + name.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerNameList} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */
	public Set<Binding> visitJokerNameList(JokerNameList joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof NameList) {
			NameList nList = (NameList) real;
			JokerNameListBinding bind = 
					factory.createJokerNameListBinding(joker, nList);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + nList.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerNameSet} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerNameSet(JokerNameSet joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof NameSet) {
			NameSet nSet = (NameSet) real;
			JokerNameSetBinding bind = 
					factory.createJokerNameSetBinding(joker, nSet);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + nSet.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerPred} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerPred(JokerPred joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Pred) {
			Pred pred = (Pred) real;
			JokerPredBinding bind = 
					factory.createJokerPredBinding(joker, pred);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + pred.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerProcess} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerProcess(JokerProcess joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof CircusProcess) {
			CircusProcess proc = (CircusProcess) real;
			JokerProcessBinding bind = 
					factory.createJokerProcessBinding(joker, proc);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + proc.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerRenameList} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerRenameList(JokerRenameList joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof RenameList) {
			RenameList proc = (RenameList) real;
			JokerRenameListBinding bind =
					factory.createJokerRenameListBinding(joker, proc);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + proc.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerStroke} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerStroke(JokerStroke joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Stroke) {
			Stroke proc = (Stroke) real;
			JokerStrokeBinding bind = 
					factory.createJokerStrokeBinding(joker, proc);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + proc.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerStroke} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerPara(JokerPara joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof Para) {
			Para proc = (Para) real;
			JokerParaBinding bind = factory.createJokerParaBinding(joker, proc);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + proc.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}

	/**
	 * Trata o {@link JokerStroke} encontrado no termo da lei, 
	 * executando um link com o termo real
	 * 
	 * @param joker o joker a ser visitado
	 * @return o conjunto de bindings, nesse caso um conjunto contendo 
	 * 		somente um elemento
	 */	
	public Set<Binding> visitJokerParaList(JokerParaList joker) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Term real = this.getStack().pop();
		
		/* Testa se pode ser unificado */
		if (real instanceof ParaList) {
			ParaList proc = (ParaList) real;
			JokerParaListBinding bind = 
					factory.createJokerParaListBinding(joker, proc);
			
			/* Criando a lista a ser retornada */
			Set<Binding> result = new HashSet<Binding>();
			result.add(bind);
			
			this.addMessage("Adicionando Binding: " + joker.getName() + 
					" -> " + proc.getClass());
			
			return result;
			
		} else {
			
			/* Erro de unificacao */
			this.handleError(joker, real, UnifierVisitor.msg1);
			return new HashSet<Binding>();
		}
	}
	/**
	 * Trata um erro de unificacao
	 *  
	 * @param obj1 objeto a unificar
	 * @param obj2 objeto a unificar com obj1
	 * @param msg mensagem de erro
	 */
	private void handleError(Term obj1, Term obj2, String msg) {
		throw new RunTimeUnificationException(obj1, obj2, msg);
	}

	/**
	 * Testa se um Joker n�o � unificado 2 vezes com duas, ASTs
	 * distintas.
	 * 
	 * @param links a lista de unificacoes
	 * @return <code>true</code> caso a unificacao seja correta,
	 * 		<code>false</code> caso contr�rio
	 */
	private static boolean unifyTest(Set<Binding> links) {
		Map<String, ListTerm<Term>> mapeamento = 
			new	HashMap<String, ListTerm<Term>>();
		BindingGetterVisitor mapGetter = new BindingGetterVisitor();
		
		/* log!! */
		StringWriter log = new StringWriter();
		log.append("----- Teste de unifica��o ---- \n");
		
		
		/* 
		 * Lista os termos mapeados por uma determinada String em 
		 * uma lista 
		 */
		for (Binding bind : links) {
			Pair<String, Term> binding = bind.accept(mapGetter);
				
			String chave = binding.getFirst();

			if (mapeamento.containsKey(chave)) {
				ListTerm<Term> value = mapeamento.get(chave);
				value.add(binding.getSecond());
				log.append("Adicionando: " + chave + " -> " + 
						binding.getSecond().getClass() + "\n");

			} else {

				ListTerm<Term> value = new ListTermImpl<Term>();
				value.add(binding.getSecond());
				log.append("Adicionando: " + chave + " -> " + 
						binding.getSecond().getClass() + "\n");
				mapeamento.put(chave, value);
			}
		}
		
		/* 
		 * Efetivamente testa a se todas as estruturas mapeadas 
		 * por uma string s�o sintaticamente iguais 
		 */
		for (ListTerm<Term> lista : mapeamento.values()) {
			ListTermCompareVisitor comparador = new ListTermCompareVisitor();
			if (lista.accept(comparador)) {
				log.append(comparador.getInfo());
			} else {
				
				/* Compara��o n�o bate */
				log.append(" ------ Fim dos Testes de Unifica��o -------\n");
				return false;
			}
			
		}
		
		log.append(" ------ Fim dos Testes de Unifica��o -------\n");
		
		return true;
	}
	
	/**
	 * Classe a ser disparada quando ocorre um erro no 
	 * UnificationVisitor.
	 * 
	 * @author Cristiano Gurgel
	 */
	class RunTimeUnificationException extends RuntimeException {

		private static final long serialVersionUID = -4188412832043382397L;

		/** O termo � esquerda que n�o conseguiu unificar */
		private Object left;
		
		/** O termo � direita que n�o conseguiu unificar */ 
		private Object right;
		
		/**
		 * Const�i uma excess�o de unifica��o com os termos que n�o foram
		 * 	unificados corretamente
		 * 
		 * @param leftTerm o termo a esquerda que tentou ser unificado
		 * @param rightTerm o termo a direita que tentou ser unificado
		 * @param message a mensagem de erro
		 */
		public RunTimeUnificationException(Object leftTerm, Object rightTerm, 
				String message) {
			super(message);
			this.setLeft(leftTerm);
			this.setRight(rightTerm);
		}
		
		/**
		 * Acessa o termo � esquerda que tentou ser unificado
		 * 
		 * @return o termo � esquerda
		 */
		public Object getLeft() {
			return left;
		}
		
		private void setLeft(Object left) {
			this.left = left;
		}
		
		/**
		 * O termo � direita que tentou ser unificado
		 * 
		 * @return o termo � direita
		 */
		public Object getRight() {
			return right;
		}
		
		private void setRight(Object right) {
			this.right = right;
		}
		
	}
	
}



