/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules;

import net.sourceforge.czt.circuspatt.util.CircusLaw;
import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.messages.MessagesManager;

/**
 * Excess�o disparada quando h� algum problema com a aplica��o de lei,
 * seja problema de unifica��o, ou at� problemas de aplica��o em tempo
 * de execu��o caso a lei possua uma anota��o para aplica��o
 * 
 * @author Cristiano Castro
 */
public class CircusLawApplicationException extends CRulesException {

	/** N�mero para a serializa��o */
	private static final long serialVersionUID = 5082964937476978743L;

	/** Lei que gerou a excess�o de aplica��o */
	private CircusLaw law;
	
	private String lei;
	
	public String getLei() {
		return lei;
	}

	public void setLei(String lei) {
		this.lei = lei;
	}

	/**
	 * Inicia a excess�o informando a lei que n�o conseguiu ser 
	 * aplicada e uma excess�o informando a causa da n�o aplica��o 
	 * da lei. A mensagem da infomra��o ao usu�rio ser� setada como a da 
	 * excess�o causa da n�o aplica��o da lei
	 * 
	 * @param arg0 a lei que n�o conseguiu ser aplicada
	 * @param cause a causa para a n�o aplica��o da lei de refinamento
	 * @throws CRulesMissingMessageException n�o ache o c�digo de erro
	 *  na aplicaca��o de lei
	 */
	public CircusLawApplicationException(CircusLaw arg0, Exception arg1) throws 
		CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage("CRefineLawApplError"), 
				arg1);
		this.setLaw(arg0);
		
	}
	
		
	/**
	 * Inicia a excess�o informando a lei que n�o conseguiu ser 
	 * aplicada e uma mensagem para o usu�rio explicando o motivo da
	 * lei n�o ser aplicada
	 * 
	 * @param arg0 a lei que n�o conseguiu ser aplicada
	 * @param msg a mensagem informando ao usu�rio o porqu� de a lei
	 *  n�o ser aplicada
	 */
	public CircusLawApplicationException(CircusLaw arg0, String code ) {
		super( code );
		this.setLaw( arg0 );
	}
	
	/**
	 * Inicia a excess�o informando a lei que n�o conseguiu ser 
	 * aplicada e uma mensagem para o usu�rio explicando o motivo da
	 * lei n�o ser aplicada
	 * 
	 * @param arg0 a lei que n�o conseguiu ser aplicada
	 * @param msg a mensagem informando ao usu�rio o porqu� de a lei
	 *  n�o ser aplicada
	 */
	public CircusLawApplicationException(String code) {
		super( code );
	}
	
	public CircusLawApplicationException(String code, Exception e) {
		super(code, e);
	}

	/**
	 * @return the law
	 */
	public CircusLaw getLaw() {
		return this.law;
	}

	/**
	 * @param law the law to set
	 */
	public void setLaw(CircusLaw law) {
		this.law = law;
	}
	
}
