/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.astmodifiers;

import circusRefine.core.util.ClonerVisitor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.Communication;

/**
 * Classe utilizada para permitir que uma fun��o receba uma 
 * comunica��o como argumento. Necess�rio em fun��es como 
 * initials: Communication -> seq Name
 * 
 * @author Cristiano Castro
 */
public class CommunicationArgumentAnn implements IASTModifierAnn {

	/** A comunica��o argumento da fun��o */
	private Communication comm;
	
	public CommunicationArgumentAnn(Communication c1) {
		setTerm(c1);
	}

	/**
	 * Acessa a comunica��o argumento da fun��o
	 * 
	 * @return o argumento da fun��o
	 */
	public Communication getTerm() {
		return this.comm;
	}

	/**
	 * Modifica a comunica��o argumento da fun��o
	 * 
	 * @param newTerm a nova comunica��o
	 * @throws ClassCastException se o par�metro n�o for uma 
	 *  comunica��o
	 */
	public void setTerm(Term newTerm) {
		this.comm = (Communication) newTerm;
	}

	/**
	 * Retorna um clone da anota��o atual
	 * 
	 * @return uma Communication
	 */
	public IASTModifierAnn clone() throws CloneNotSupportedException {
		Communication c = 
			ClonerVisitor.cloneTermRemovingRelationsStack(this.getTerm());
		return new CommunicationArgumentAnn(c);
	}
	
	
	public IASTModifierAnn create() {
		return new CommunicationArgumentAnn(null);
	}

}
