/*
 * Projeto
 */
package circusRefine.core.annotations;

import circusRefine.util.CRefineAnnotation;
import net.sourceforge.czt.base.ast.Term;

/**
 * Classe para encapsular um termo selecionado. Utilizado 
 * na aplicação de leis a esquemas 
 * 
 * @author Cristiano Castro
 *
 * @param <T> o tipo do termo real
 */
public class TemporaryTermAnn implements CRefineAnnotation {

	private Term realTerm;

	/**
	 * @param realTerm
	 */
	public TemporaryTermAnn(Term realTerm) {
		this.setRealTerm(realTerm);
	}

	/**
	 * @return the realTerm
	 */
	public Term getRealTerm() {
		return realTerm;
	}

	/**
	 * @param realTerm the realTerm to set
	 */
	private void setRealTerm(Term realTerm) {
		this.realTerm = realTerm;
	}
	
}
