/*
 * Projeto: Circus Refine
 */
package circusRefine.core;

import net.sourceforge.czt.base.ast.Term;

/**
 * Resposta a um comando de carregamento de programa
 * 
 * @author Cristiano Castro
 */
public class LoadAnswer implements StepAnswer {

	/** Programa gerado a partir do parser */
	private Term programaCarregado;
	
	/** String com a especificao */
	private String especificacao;

	/**
	 * A resposta ao carregamento  inicializado com o termo a ser 
	 * carregado e a especificao.
	 * 
	 * @param programaCarregado o {@link Term} com a especificao
	 * @param especificacao a String com a especificao
	 */
	public LoadAnswer(Term programaCarregado, String especificacao) {
		this.setProgramaCarregado(programaCarregado);
		this.setEspecificacao(especificacao);
	}

	/**
	 * @return the programaCarregado
	 */
	public Term getProgramaCarregado() {
		return programaCarregado;
	}

	/**
	 * @param programaCarregado the programaCarregado to set
	 */
	private void setProgramaCarregado(Term programaCarregado) {
		this.programaCarregado = programaCarregado;
	}

	/**
	 * @return the especificacao
	 */
	public String getEspecificacao() {
		return especificacao;
	}

	/**
	 * @param especificacao the especificacao to set
	 */
	private void setEspecificacao(String especificacao) {
		this.especificacao = especificacao;
	}
		
}
