/*
 * LawAnswer.java
 *
 * Created on 27 de Setembro de 2005, 14:53
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */
package circusRefine.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.zpatt.ast.Sequent;
import net.sourceforge.czt.zpatt.ast.SequentList;
import circusRefine.core.util.POLog;
import circusRefine.util.OPTipos;
import circusRefine.util.Pair;

/**
 * A resposta a aplicao de uma lei na AST.
 *
 * @author comp
 * @author Cristiano Gurgel
 */
public class LawAnswer implements StepAnswer {

	/** Programa resultante da aplicacao da lei */
	private Term progResultante_;
	
	/** Nova AST gerada com a aplicacao de uma Lei */
	private Term novaAST;

	/** Pares de OP e OP extendida e o tipo da avaliao */
	private List<Pair<Pair<Sequent, Sequent>, Pair<OPTipos,POLog>>> ops;

	/** Lista com os parmetros utilizados na aplicao de lei */
	private List<String> parametrosUtilizados;
	
	/** Lei aplicada */
	private CircusLaw leiAplicada;
	
	//TODO remover essa linhaI e LinhaF e utilizar as q estao no historico
	/** Linha inicial de uma aplicao de lei */
	private int linhaInicial;
	
	/** Linha final da aplicao de lei */
	private int linhaFinal;
	
	/**
	 * Inicia a resposta da lei sem nenhum atributo setado
	 */
	public LawAnswer() {
		this.setParametrosUtilizados(new LinkedList<String>());
		this.setOps(new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>>());
	}
	
	/** Creates a new instance of LawAnswer */
	public LawAnswer(Term prog, Term progAntigo, 
			Term ast, SequentList obrigs, Spec antigaAST) {
		this();
		this.setProgResultante(prog);
		this.iniciarOPs(obrigs);
		this.setNovaAST(ast);
	}
	
	public void setProgResultante(Term prog) {
		this.progResultante_ = prog;
	}

	public Term getProgResultante() {
		return this.progResultante_;
	}

	public Term getNovaAST() {
		return novaAST;
	}
	
	/**
	 * @param novaAST the novaAST to set
	 */
	public void setNovaAST(Term novaAST) {
		this.novaAST = novaAST;
	}

	/**
	 * @return the ops
	 */
	public List<Pair<Pair<Sequent, Sequent>, Pair<OPTipos,POLog>>> getOps() {
		return ops;
	}

	/**
	 * @param ops the ops to set
	 */
	private void setOps(List<Pair<Pair<Sequent, Sequent>, Pair<OPTipos, POLog>>> ops) {
		this.ops = ops;
	}

	/**
	 * @return the parametrosUtilizados
	 */
	 public List<String> getParametrosUtilizados() {
		 return parametrosUtilizados;
	 }

	 /**
	  * @param parametrosUtilizados the parametrosUtilizados to set
	  */
	 public void setParametrosUtilizados(List<String> parametrosUtilizados) {
		 this.parametrosUtilizados = parametrosUtilizados;
	 }

	/**
	 * @return the leiAplicada
	 */
	public CircusLaw getLeiAplicada() {
		return leiAplicada;
	}

	/**
	 * @param leiAplicada the leiAplicada to set
	 */
	public void setLeiAplicada(CircusLaw leiAplicada) {
		this.leiAplicada = leiAplicada;
	}

	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	public void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	public void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}
	
	/**
	 * Inicia a tripla de OPs com as ops normais passadas como 
	 * parmetro, as OPs extendidas em null e o tipo da avaliao
	 * iniciando como no avaliada
	 * 
	 * @param opsNormais a lista de obrigaes de prova gerada pela
	 *  lei aplicada
	 */
	public void iniciarOPs(SequentList opsNormais) {
		for (Sequent seq : opsNormais) {
			
			/* Cria o par a ser adicionado */
			Pair<Sequent, Sequent> parOPs = 
				new Pair<Sequent, Sequent>(seq, null);
			Pair<OPTipos, POLog> parOPTipoLog = new
			Pair<OPTipos, POLog>(OPTipos.OP_CHECADA_NRECONHECIDA,
					new POLog());
			Pair<Pair<Sequent, Sequent>, Pair<OPTipos, POLog>> aAdicionar =
				new Pair<Pair<Sequent,Sequent>, Pair<OPTipos,POLog>>(parOPs,parOPTipoLog);
			
			this.getOps().add(aAdicionar);
		}
	}

	
}
