/*
 * Projeto: Circus Refine
 */
package circusRefine.core;

/**
 * Resposta do CRefine ao comando de edio de um comentrio
 * 
 * @author Cristiano Castro
 */
public class EditCommentAnswer implements StepAnswer {


	/** Linha inicial na qual foi aplicado o comentrio */
	private int linhaInicial;
	
	/** Linha final na qual foi aplicado o comentrio */
	private int linhaFinal;
	
	/** Texto no qual o comentrio foi adicionado */
	private String text;


	/**
	 * Inicia a resposta  ao com as linhas nas quais foi aplicado
	 * o comentrio e com o texto do comentrio em si.
	 * 
	 * @param linhaInicial a linha inicial do comentrio
	 * @param linhaFinal a linha final do comentrio
	 * @param text o texto do comentrio
	 */
	public EditCommentAnswer(int linhaInicial, int linhaFinal, String text) {
		this.setLinhaInicial(linhaInicial);
		this.setLinhaFinal(linhaFinal);
		this.setText(text);
	}
	
	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	public void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	public void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}

	/**
	 * @return the text
	 */
	public String getText() {
		return text;
	}

	/**
	 * @param text the text to set
	 */
	public void setText(String text) {
		this.text = text;
	}
	
}
