/*
 * Projeto: Circus Refine
 */
package circusRefine.core;

import net.sourceforge.czt.base.ast.Term;


/**
 * Resposta a uma ao de coleta de processo ou ao por parte do 
 * usurio
 * 
 * @author Cristiano Castro
 */
public class CollectAnswer implements StepAnswer {

	/** Tipo da coleta efetuada */
	private TipoColeta tipo;
	
	/** Nome do pargrafo coletado */
	private String nomeParagrafo;

	/** O termo coletado pelo comando */
	private Term termoColetado;
	
	/**
	 * Inicia a resposta a coleta com os atributos setados
	 * 
	 * @param tipo o tipo da coleta (Processo ou ao)
	 * @param nomeParagrafo nome do pargrafo coletado
	 */
	public CollectAnswer(TipoColeta tipo, String nomeParagrafo, Term termo) {
		this.setTipo(tipo);
		this.setNomeParagrafo(nomeParagrafo);
		this.setTermoColetado(termo);
	}

	/**
	 * @return the tipo
	 */
	public TipoColeta getTipo() {
		return tipo;
	}

	/**
	 * @param tipo the tipo to set
	 */
	private void setTipo(TipoColeta tipo) {
		this.tipo = tipo;
	}

	/**
	 * @return the nomeParagrafo
	 */
	public String getNomeParagrafo() {
		return nomeParagrafo;
	}

	/**
	 * @param nomeParagrafo the nomeParagrafo to set
	 */
	private void setNomeParagrafo(String nomeParagrafo) {
		this.nomeParagrafo = nomeParagrafo;
	}

	/**
	 * @return the termoColetado
	 */
	public Term getTermoColetado() {
		return termoColetado;
	}

	/**
	 * @param termoColetado the termoColetado to set
	 */
	private void setTermoColetado(Term termoColetado) {
		this.termoColetado = termoColetado;
	}
	
}
