package circusRefine.Tactic.Principal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;

/**
 * Classe responsável por gerenciar uma tática sequencial
 * @author Madiel Filho
 *
 */
public class TSemi extends TaticaBinaria{



	/**
	 * 
	 */
	private static final long serialVersionUID = -5537131633126643448L;


	public TSemi(TacticComponent tacticLeft, TacticComponent tacticRight) {
		this.setTaticaEsquerda(tacticLeft);
		this.setTaticaDireita(tacticRight);
	}


	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	}


	/**
	 * Método para executar a tática sequencial
	 */

	public TacticAnswer aplicar(RCell rCell, List<Object> argMap,
			InternalManager gerInterno) throws Exception, Unification  {

		Vector respEsq = new Vector();
		Vector respDir = new Vector();
		Vector respostas = new Vector();
		TacticAnswer respFinal = null;
		TacticAnswer answerLeft = null;

		if (this.getTaticaEsquerda() instanceof TAlt){
			GerenciadorTaticas.controlTSemi = true;
			GerenciadorTaticas.rootTalt = true;
			GerenciadorTaticas.tacRoot = this;
		}
		answerLeft = this.getTaticaEsquerda().aplicar(rCell, this.getTaticaEsquerda().getArgumentos(), gerInterno);
	
		if (answerLeft != null){
			respEsq = answerLeft.getRespostas();
			for (int i = 0; i < respEsq.size(); i++) {

				RCell rCellLeft = (RCell) respEsq.get(i);

					TacticAnswer respApliDir = this.getTaticaDireita().aplicar(rCellLeft, this.getTaticaDireita().getArgumentos(), gerInterno);
				if (respApliDir != null){
					Vector respDireita = respApliDir.getRespostas();
					this.setAplicaDir(true);
					RCell rCellRight = (RCell) respDireita.get(0);
					RCell rCellResposta = new RCell(rCellRight.getNoPrograma(),rCellRight.getOps());
					respostas.add(rCellResposta);
				}
				/**
				 * Verificando se é uma recursão
				 */
				else if (GerenciadorTaticas.rec){
					RCell rCellResposta = new RCell(rCellLeft.getNoPrograma(),rCellLeft.getOps());
					respostas.add(rCellResposta);
					break;
				}
				/**
				 * repete ate o ultimo TALt ser aplicado
				 */
				do{
				
					/**
					 * A aplicação da direita falhou
					 */
					if (GerenciadorTaticas.controlTaltLeft){
						/**
						 * Entao a tatica da esquerda e um TAlt e tem que aplicar
						 * a outra parte do TAlt
						 */
						answerLeft = this.getTaticaEsquerda().aplicar(rCell, this.getTaticaEsquerda().getArgumentos(), gerInterno);
						if (answerLeft != null){
							respEsq = answerLeft.getRespostas();
							rCellLeft = (RCell) respEsq.get(0);
							TacticAnswer respApliDir2 = this.getTaticaDireita().aplicar(rCellLeft, this.getTaticaDireita().getArgumentos(), gerInterno);
							if (respApliDir2 != null){
								RCell rCellResposta2 = new RCell(rCell.getNoPrograma(),rCell.getOps());
								respostas.add(rCellResposta2);
								this.setAplicaDir(true);
							}
						}
					}

				/**
				    Nao faz parte de um TAlt
					  **/
				}while(GerenciadorTaticas.controlTaltLeft);

				/**
				 * Aplica a tatica da direita pois o TSemi nao tem um filho
				 * que seja um TAlt
				 */
				if (respostas.size() == 1 && !this.isAplicaDir()){
					respApliDir = this.getTaticaDireita().aplicar(rCellLeft, this.getTaticaDireita().getArgumentos(), gerInterno);
					respDir = respApliDir.getRespostas();
					RCell rCellDir = (RCell) respDir.get(0);
					RCell rCellResposta = new RCell(rCellDir.getNoPrograma(),rCellDir.getOps());
					respostas.add(rCellResposta);
					
				}
			}
		}

 		GerenciadorTaticas.controlTSemi = false;
		if (respostas.size() > 0)
		respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));		
		return respFinal;
	}

}
