package circusRefine.Tactic.Principal;

import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.impl.MuActionImpl;
import net.sourceforge.czt.z.ast.Name;

import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;
import circusRefine.core.util.ChildrenTermExtractor;


public class Mubox extends TaticaUnaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = -750938296874240012L;


	public Mubox(TacticComponent tatica) {
		this.setTactic(tatica);
	}



	@Override
	public String toString() {

		return null;
	}


	@Override
	public TacticAnswer aplicar(RCell rCell, List<Object> args,
			InternalManager gerInterno)
			throws Exception, LawNotFound {

		NoPrograma programaInicial = rCell.getNoPrograma();
		TacticAnswer respFinal = null;
		NoPrograma novoP = null;
		RCell novoRcell = null;
		Vector resp = new Vector();
		RCell rCellResposta = new RCell();
		Name name = null;
		Term mainAction = null;

		
		/**
		 * Verifica se realmente é um Mubox
		 * Aplica no corpo da recursao
		 */
		if(rCell.getNoPrograma().getPrograma() instanceof MuActionImpl){
			
			/**
			 * Recebendo os argumentos do MuAction
			 */
			MuActionImpl mu2 = (MuActionImpl) programaInicial.getPrograma();
			name = mu2.getName();
			mainAction = mu2.getCircusAction();
			
			//List<Term> termos = gerInterno.verificarOperador(programaInicial);
			ChildrenTermExtractor extrator = new ChildrenTermExtractor();
			List<Term> termos = programaInicial.getPrograma().accept(extrator);

			/**
			 * Criando um rCell para a Ação
			 */
			novoP = new NoPrograma(termos.get(0));
			novoRcell = new RCell(novoP,rCell.getOps());

			TacticAnswer respTat = this.getTactic().aplicar(novoRcell, args, gerInterno);

			Vector resposta = respTat.getRespostas();
			if(resposta != null){
				RCell rcell = (RCell) resposta.get(0);
				
				
				//Vector resp = gerInterno.montarRespostaUnaria(termos.get(1),resposta, programaInicial.getPrograma());

				/**
				 * Montar a resposta do MuAction
				 */

				//Term muAction = gerInterno.criarMuAction(termos.get(1),rcell,rCell.getNoPrograma().getPrograma());
				MuActionImpl mu = (MuActionImpl) programaInicial.getPrograma();
				CircusAction ca = (CircusAction) rcell.getNoPrograma().getPrograma();
				mu.setCircusAction(ca);
				mu.setName(name);

				NoPrograma noPrograma = new NoPrograma(mu);
				rCellResposta = new RCell(noPrograma,rcell.getOps());				
				resp.add(rCellResposta);
				respFinal = new TacticAnswer(resp);
			}
		}

		return respFinal;
		
	}


	}
