package circusRefine.Tactic.Factories;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;

import circusRefine.Tactic.Excecao.LawNotFound;
import circusRefine.Tactic.Excecao.TacticNotFound;
import circusRefine.Tactic.Principal.Tatica;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.factories.LawsFactory;
import circusRefine.util.Internacional;

 
  /**
   * Classe responsável por criar todas as táticas do sistema
   * 
   * @author Madiel Filho
   *
   */

public class TacticsCreator {

	
	private static final String DIRETORIO_TATICAS = "tacticsArcAngelC/NBPhase";
	private static final String DIRETORIO_TATICAS_SERIALIZE = "tacticsArcAngelC/tacticsSerialize/";
	/** Fabricas de onde serão criadas as táticas */

	InternalManager inter;

	public TacticsCreator( InternalManager gerInt){
		this.inter = gerInt;
		this.createTactics();
		
	}
	
	
	public void createTactics(){
		/**
		 * Pegar as taticas que estao armazenadas
		 * no arquivo
		 */
		
		File diretorio = new File(DIRETORIO_TATICAS_SERIALIZE);
		File fList[] = diretorio.listFiles();

		System.out.println("Numero de arquivos no diretorio : " + diretorio.listFiles().length );
		
		for (File file : fList) {
			Tatica tatica = new Tatica();
			GerenciadorTaticas ger = new GerenciadorTaticas();
			try {
					try {
						if (!file.isDirectory()){
							tatica = ger.readTactic(file.getName());
							inter.adicionarTatica(tatica);
						}
					} catch (ClassNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
                  
					
		
				
				
				/**
				 * Depois vai ver essas taticas que tao em tacticsSerializa
				 */
				
				//inter.updateTacticList();
			}catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			}
		//inter.updateTacticList();
	}
}
