package newjcircusutil.multisync;

import java.util.*;

import javax.swing.JOptionPane;

import org.jcsp.lang.*;

/*
 * Client Synchronise on a multiple channels
 *
 * Created on 09 June 2003, 10:05
 * @author  Marcel Oliveira
 */
public class MultiSyncClient implements CSProcess{
    
    /* Index of elements of the SYNCs objects */
    private final int FROM_INDEX      = 0;
    private final int TO_INDEX        = 1;
    private final int SYNC_ID_INDEX   = 2;
    private final int WRITER_ID_INDEX = 3;
    
    /* Synchronising Channels */
    private List seqOfSync;
    
    /* No-Synchronising Channels */
    private List seqOfNotSync;
    
    /* Choosen synchronisation */
    private int choosen;

    /* Value transmitted */
    private Object valueTrans;
    
    /* Guards (when this is a Client for External Choice) */
    private boolean guards[];

    /* Creates a new instance of SyncClient 
     * @param Integer id - Identifier of this client
     * @param List seqOfSync - List of synchronisations. Each synchronisation is 
     * an array in the form {from_channel, to_channel, id}, where id is the identifier
     * of this client in the channel multi-synchronisation
     * @param List listOfNotSeq List of interruptions which can occur in this client
     * @param Object valueTrasn - Value transmitted in a communication
     */
    public MultiSyncClient(List seqOfSync, List seqOfNotSync, Object valueTrans) {
        this.seqOfSync = seqOfSync;
        this.seqOfNotSync = seqOfNotSync;
        this.valueTrans = valueTrans;
    }

    /**
     *
     */
    public MultiSyncClient(List seqOfSync, List seqOfNotSync, Object valueTrans, boolean guards[]) {
        this.seqOfSync = seqOfSync;
        this.seqOfNotSync = seqOfNotSync;
        this.valueTrans = valueTrans;
        this.guards = guards;
    }
    
    public int getChoosen() {
        return choosen;
    }
    public Object getValueTrans() {
        return valueTrans;
    }
    
    public void run() {
        List result = offer();
        this.choosen = ((Integer)result.get(0)).intValue();
        this.valueTrans = result.get(1);
    }

    private List offer() {
         int numberOfSyncs = this.seqOfSync.size();
         CSProcess[] syncs = new CSProcess[numberOfSyncs];

/*Tentativa abaixo**/
        for (int i=0; i<numberOfSyncs; i++) {
        	System.out.println ("*******)))--->>> " + i);
        	
//        	final ChannelOutput toSync;
        	
        	System.out.println ("instanceof " + this.seqOfSync.get(i));

/*        	if (this.seqOfSync.get(i) instanceof Any2OneChannel []) {
        		toSync =
                	(ChannelOutput)
                	(
                		Channel.getOutputArray(
                			(Any2OneChannel []) ( this.seqOfSync.get(i)))
                	)
                	[TO_INDEX]//)
                	;
        	}
        	else if (this.seqOfSync.get(i) instanceof Any2AnyChannel []) {
        		toSync =
                	(ChannelOutput)
                	(
                		Channel.getOutputArray(
                			(Any2AnyChannel []) ( this.seqOfSync.get(i)))
                	)
                	[TO_INDEX]//)
                	;
        	}
        	else if (this.seqOfSync.get(i) instanceof One2AnyChannel []) {
        		toSync =
                	(ChannelOutput)
                	(
                		Channel.getOutputArray(
                			(One2AnyChannel []) ( this.seqOfSync.get(i)))
                	)
                	[TO_INDEX]//)
                	;
        	}
        	else if (this.seqOfSync.get(i) instanceof One2OneChannel []) {
        		toSync =
                	(ChannelOutput)
                	(
                		Channel.getOutputArray(
                			(One2OneChannel []) ( this.seqOfSync.get(i)))
                	)
                	[TO_INDEX]//)
                	;
        	}
        	else {
        		toSync = null;
        	}
*/
/*Tentativa acima**/
            final ChannelOutput toSync = (ChannelOutput)(((Object[])this.seqOfSync.get(i))[TO_INDEX]);
            
            final Integer syncIdFinal = (Integer)(((Object[])this.seqOfSync.get(i))[SYNC_ID_INDEX]);
            CSProcess sync = new CSProcess () {
               public void run () {
                   // 1) sends id to controller
                   toSync.write(syncIdFinal);
               }
            };
            syncs[i] = sync;           
         }
         
         // This will not be a parallelism in most of the cases: just one process
         Parallel parallel = new Parallel(syncs);
         parallel.run();
         
         return sync();
    }
    
    private List sync() {
        
        Object object = this.valueTrans;
        
        AltingChannelInput[] fromChannels = toAltingChannelsInput(getSyncs(FROM_INDEX,this.seqOfSync));
        ChannelOutput[] toChannels = toChannelsOutput(getSyncs(TO_INDEX,this.seqOfSync));
        Integer[] syncIds = toInteger(getSyncs(SYNC_ID_INDEX,this.seqOfSync));
        Integer[] writerIds = toInteger(getSyncs(WRITER_ID_INDEX,this.seqOfSync));// este e sempre zero
        
        AltingChannelInput[] notSyncChannels = toAltingChannelsInput(this.seqOfNotSync.toArray());
        AltingChannelInput[] allInputChannels = toAltingChannelsInput(concat(fromChannels,notSyncChannels));
        
        Alternative alt = new Alternative(allInputChannels);
        
        int choosen;
        
        if (this.guards == null)
            choosen = alt.select();
        else
            choosen = alt.select(this.guards);
        
        if (choosen < fromChannels.length) {
            // A multi-sync channel has been chosen.
            
            // This will be always the case when there is no alternative involved, that is,
            // we have a multi-synchronization occurring independent of an external choice.
            
            AltingChannelInput from = fromChannels[choosen];
            ChannelOutput to = toChannels[choosen];
            Integer syncId = syncIds[choosen];
            Integer writerId = writerIds[choosen];

            // 2) receives a boolean WHY DOES IT READ AGAIN?
            from.read();    
            
            // 3) sends the id
            to.write(syncId);
            
            // 4) receives a boolean again
            Boolean synchronised = (Boolean)from.read();
            
            if (synchronised.booleanValue()) {
                if(syncId.intValue() == writerId.intValue()) {
                    // 5) send the value
                    
                    to.write(this.valueTrans);
                    
                } else if (syncId.intValue() != writerId.intValue()) {
                    object = from.read();
                    
                }
                
                
                //WITHDRAW OTHERS
                AltingChannelInput[] fromChannels_withdraw = toAltingChannelsInput(remove(choosen,fromChannels));
                ChannelOutput[] toChannels_withdraw = toChannelsOutput(remove(choosen,toChannels));
                Integer[] syncIds_withdraw = toInteger(remove(choosen,syncIds));

                CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
                for (int i=0; i<fromChannels_withdraw.length; i++) {
                    final AltingChannelInput fromInt = fromChannels_withdraw[i];
                    final ChannelOutput toInt = toChannels_withdraw[i];
                    final Integer syncIdInt = syncIds_withdraw[i];

                    final int internalI = i;
                    CSProcess process = new CSProcess() {
                        public void run () {
                            CSProcess first = new CSProcess() {
                                public void run () {
                                    toInt.write(AuxiliarMethods.flip(syncIdInt));
                                }
                            };
                            CSProcess second = new CSProcess() {
                                public void run () {
                                    Boolean invite = (Boolean)fromInt.read();
                                    if (invite.booleanValue()) {
                                        fromInt.read();
                                    } else if (!invite.booleanValue()) {
                                    }
                                }
                            };
                            CSProcess[] procs = new CSProcess[]{first,second};
                            Parallel intInterleave = new Parallel(procs);
                            intInterleave.run();
                        }
                    };
                    // put the parallelism in the array
                    no_sync[i] = process;
                }

                // run the interleaving of parallelisms
                Parallel extInterleave = new Parallel(no_sync);
                extInterleave.run();
                
                // OBS: There is no code for q.i. At this moment this method returns
                // and the client terminates to run. So, q.i has no representation here
                // in the client interface. We can see q.i as the events that will
                // be executed at the client process when this method returns.
                
                // We don't make the recursive call to offer because a client will be
                // instantiated each iteration.
                
                /////////////////////////////////////////
                // REMOVED FROM ORIGINAL PROTOCOL
                //offer();
                /////////////////////////////////////////
                
            } else if (!synchronised.booleanValue()) {
                // released, keep waiting
                 return sync();
            }
        } else {
            // A non multisync channel has been chosen (interrupt)
            AltingChannelInput not_sync = allInputChannels[choosen];

            // why do all of them read from the not sync channel?
            object = not_sync.read();
            System.out.println("read from a notSync channel");
            
            AltingChannelInput[] fromChannels_withdraw = fromChannels;
            ChannelOutput[] toChannels_withdraw = toChannels;
            Integer[] syncIds_withdraw = syncIds;

            CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
            for (int i=0; i<fromChannels_withdraw.length; i++) {
                final AltingChannelInput fromInt = fromChannels_withdraw[i];
                final ChannelOutput toInt = toChannels_withdraw[i];
                final Integer syncIdInt = syncIds_withdraw[i];

                CSProcess process = new CSProcess() {
                    public void run () {
                        CSProcess first = new CSProcess() {
                            public void run () {
                                toInt.write(AuxiliarMethods.flip(syncIdInt));
                            }
                        };
                        CSProcess second = new CSProcess() {
                            public void run () {
                                Boolean invite = (Boolean)fromInt.read();
                                if (invite.booleanValue()) {
                                    fromInt.read();
                                } else if (!invite.booleanValue()) {
                                }
                            }
                        };
                        CSProcess[] procs = new CSProcess[]{first,second};
                        Parallel intInterleave = new Parallel(procs);
                        intInterleave.run();
                    }
                };
                no_sync[i] = process;
            }
            Parallel extInterleave = new Parallel(no_sync);
            extInterleave.run();
            /////////////////////////////////////////
            // REMOVED FROM ORIGINAL PROTOCOL
            //offer();
            /////////////////////////////////////////
        }
        
        Vector result = new Vector();
        result.add(new Integer(choosen));
        result.add(object);
        return result;
    }
    
    private Object[] getSyncs(int type, List seqOfSync) {
        Object[] result = new Object[seqOfSync.size()];
        for (int i=0; i<seqOfSync.size(); i++) {
            Object[] x = (Object[])seqOfSync.get(i);
            result[i] = x[type];
        }
        
        return result;
    }
    
    private Object[] concat(Object[] array1, Object[] array2) {
        int finalSize = array1.length + array2.length;
        Object result[] = new Object[finalSize];
        
        for(int i=0; i<array1.length; i++) {
            result[i] = array1[i];
        }
        for(int i=0; i<array2.length; i++) {
            result[array1.length+i] = array2[i];
        }
        return result;
    }
    
    /**
     * Returns a new object which contains the same elements
     * in 'array', except the one in position 'index'.
     */
    private Object[] remove(int index, Object[] array) {
        int finalSize = array.length - 1;
        Object result[] = new Object[finalSize];
        
        int currentIndex = 0;
        for(int i=0; i<array.length; i++) {
            if (i != index) {
                result[currentIndex] = array[i];
                currentIndex++;
            }
        }
        return result;
    }

    private AltingChannelInput[] toAltingChannelsInput(Object[] array) {
        AltingChannelInput result[] = new AltingChannelInput[array.length];
        for(int i=0; i<array.length; i++) {
            
            result[i] = (AltingChannelInput)array[i];
        }
        return result;
    }
    
    private ChannelOutput[] toChannelsOutput(Object[] array) {
        ChannelOutput result[] = new ChannelOutput[array.length];
        for(int i=0; i<array.length; i++) {
            result[i] = (ChannelOutput)array[i];
        }
        return result;
    }

    private Integer[] toInteger(Object[] array) {
        Integer result[] = new Integer[array.length];
        for(int i=0; i<array.length; i++) {
            result[i] = (Integer)array[i];
        }
        return result;
    }

}
