package newjcircusutil.multisync;

import java.util.*;
import org.jcsp.lang.*;

/*
 * Process that managers the MultySyncControllers
 *
 * Created on 22 May 2003, 16:06
 * @author  Marcel Oliveira
 */
public class ControllersManager implements CSProcess {
    
    /* Communication channel of this process */
    private ChannelInput endManager;

    /* Controllers managed by this process */
    private CSProcess controllers;

    /* Creates a new instance of Alarm */
    public ControllersManager(ChannelInput newendManager, CSProcess newcontrollers){
        this.endManager = newendManager;
        this.controllers = newcontrollers;
    }
    
    /* Runs this process */
    public void run() {
        ProcessManager manager = new ProcessManager(this.controllers);
        manager.start();
        this.endManager.read();
        System.out.println("Finish manager");
        manager.stop();
    }
    
}


