package jcspunittool;


public class Event {
	public static final int READING = 0;
	public static final int WRITING = 1;
	public static final int IRRELEVANT = 2;
	public static final int SYNC = 3;
	
	private int process;
	private int channel;
	private Object object;
	private int accesstype;
	
	public long time;
	
	public Event (int channel, int accesstype, Object object) {
		this.channel = channel;
		this.object = object;
		this.accesstype = accesstype;
	}
	public Event (int channel, int accesstype) { //NEWWW
		this (channel, accesstype, new Object());
	}
	/*public Event (Object channel, String accesstype, Object object) {
		this.channel = channel.hashCode();
		this.object = object;
		if (accesstype.compareTo("reading") == 0 || accesstype.compareTo("read") == 0)
			this.accesstype = READING;
		else
			this.accesstype = WRITING;
	}*/
	public Event (Object channel, Object object) {
		this.channel = channel.hashCode();
		this.object = object;
		this.accesstype = IRRELEVANT;
	}
	public Event () {
		this (0,0,null);
	}
	public boolean partialEventEquals (Event e) {
		if (this.getChannel() == e.getChannel()
			&& this.getObject().equals(e.getObject())) {
			return true;
		}
		else return false;
	}
	public boolean fullEventEquals (Event e) {
		if (this.partialEventEquals (e) && this.getAccesstype() == e.getAccesstype()) {
			return true;
		}
		else return false;
	}
	public int getProcess () {
		return this.process;
	}
	public int getChannel () {
		return this.channel;
	}
	public int getAccesstype () {
		return this.accesstype;
	}
	public Object getObject () {
		return this.object;
	}
	
	public void setProcess (int proccode) {
		this.process = proccode;
	}
	public void setChannel (int channelcode) {
		this.channel = channelcode;
	}
	public void setObject (Object object) {
		this.object = object;
	}
}