package fireControlSystem.util;

/*
 * Generates random values as requested
 *
 * Created on 12 May 2003, 18:07
 * @author  Marcel Oliveira
 */
public class RandomGenerator {
    
    /* Creates a new instance of RandomGenerator */
    public RandomGenerator() {
    }
    
    /*
     * Choose an random number in the given interval
     * 
     * @return int A random number in the given interval
     */
    public static int generateNumber(int min, int max){
        int randomNumber = min;
        Long randomLong = new Long(Math.round(Math.random()*100));
        int randomInt = randomLong.intValue();
        
        int numberOfIntervals = max - min + 1;
        int interval = 100 / numberOfIntervals;

        boolean ready = false;
        for (int i=1; i<=numberOfIntervals && !ready ; i++){
            if (randomInt <= i*interval) {
                randomNumber = min+i-1;
                ready=true;
            }
        }
        System.out.println("RandomGenerator :: generateNumber -> Min="+min+", Max="+max+", Result="+randomNumber);
        return randomNumber;
    }
    
    public static void main(String[] args) {
        for (int i=0 ; i< 100; i++) {
            RandomGenerator.generateNumber(1, 10);
        }
    }
}
