package fireControlSystem.typing;

/*
 * Represents the faults Ids of the system
 *
 * Created on 12 May 2003, 10:22
 * @author  Marcel Oliveira
 */
public class FaultId extends Type {
    
    /* Ids of faults */
    public static final int ZONE_FAULT            = 0;
    public static final int EARTH_FAULT           = 1;
    public static final int SOUNDER_LINE_FAULT    = 2;
    public static final int POWER_FAULT           = 3;
    public static final int ISOLATE_REMOTE_SIGNAL = 4;
    public static final int ACTUATOR_LINE_FAULT   = 5;
    
    /* Limits of the faults ids */
    public static final int MIN_FAULT_ID = 0;
    public static final int MAX_FAULT_ID = 5;

    /*
     * Creates a new instance of FaultId with the respective value 
     * @param value The value of the object FaultId
     * @throws InvalidValueException If the value is not valid
     */
    public FaultId(int value) {
        this.setValue(value);
    }

}
