package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process that managers the Processes that have multi-synchronisation
 *
 * Created on 22 May 2003, 16:06
 * @author  Marcel Oliveira
 */
public class ProcessManagerMultiSync implements CSProcess {
    
    /* Communication channel of this process */
    private ChannelOutput endManager;

    /* Process managed by this process */
    private CSProcess process;

    /* Creates a new instance of Alarm */
    public ProcessManagerMultiSync(ChannelOutput newendManager, CSProcess newprocess){
        this.endManager = newendManager;
        this.process = newprocess;
    }
    
    /* Runs this process */
    public void run() {
        process.run();
        endManager.write(null);
    }
    
}


