package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig the Output
 *
 * Created on 11 June 2003, 17:16
 * @author  Marcel Oliveira
 */
public class Output implements CSProcess {
    public Alarm alarme;
    public Display display;
    public class CSP1 implements CSProcess {
		public void run(){
			CSProcess [] cspVetor = new CSProcess [] {new CSP2(), new CSP3()};
			Parallel emParalelo = new Parallel (cspVetor);
		    emParalelo.run();
		}
	}
	public class CSP3 implements CSProcess {
		public void run() {
		    alarme.run();
		}
	}

	public class CSP2 implements CSProcess {
		public void run() {
			display = new Display(switchLamp,switchBuzzer);
			display.run();
		}
	}

	private ChannelInput[][] switchLamp;
    private ChannelInput switchBuzzer;
    private ChannelInput alarm;
    
    /* Creates a new instance of Output */
    public Output(ChannelInput[][] newswitchLamp, ChannelInput newswitchBuzzer, ChannelInput newalarm) {
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
        this.alarm = newalarm;
        
	    alarme = new Alarm (alarm);

    }

    /* Runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
}


