package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Client Synchronise on a multiple channels
 *
 * Created on 09 June 2003, 10:05
 * @author  Marcel Oliveira
 */
public class MultiSyncClient implements CSProcess{
    
    /* Index of elements of the SYNCs objects */
    private final int FROM_INDEX      = 0;
    private final int TO_INDEX        = 1;
    private final int SYNC_ID_INDEX   = 2;
    private final int WRITER_ID_INDEX = 3;
    
    /* Synchronising Channels */
    private List seqOfSync;
    
    /* No-Synchronising Channels */
    private List seqOfNotSync;
    
    /* Choosen synchronisation */
    private int choosen;

    /* Value transmitted */
    private Object valueTrans;

    /* Creates a new instance of SyncClient 
     * @param Integer id - Identifier of this client
     * @param List seqOfSync - List of synchronisations. Each synchronisation is 
     * an array in the form {from_channel, to_channel, id}, where id is the identifier
     * of this client in the channel multi-synchronisation
     * @param List listOfNotSeq List of interruptions which can occur in this client
     * @param Object valueTrasn - Value transmitted in a communication
     */
    public MultiSyncClient(List seqOfSync, List seqOfNotSync, Object valueTrans) {
        this.seqOfSync = seqOfSync;
        this.seqOfNotSync = seqOfNotSync;
        this.valueTrans = valueTrans;
    }
    
    public int getChoosen() {
        return choosen;
    }
    public Object getValueTrans() {
        return valueTrans;
    }
    
    public void run() {
        List result = offer();
        this.choosen = ((Integer)result.get(0)).intValue();
        this.valueTrans = result.get(1);
    }

    private List offer() {
         int numberOfSyncs = this.seqOfSync.size();
         CSProcess[] syncs = new CSProcess[numberOfSyncs];

        for (int i=0; i<numberOfSyncs; i++) {
            final ChannelOutput toSync = (ChannelOutput)(((Object[])this.seqOfSync.get(i))[TO_INDEX]);
            final Integer syncIdFinal = (Integer)(((Object[])this.seqOfSync.get(i))[SYNC_ID_INDEX]);
            CSProcess sync = new CSProcess () {
               public void run () {
                   toSync.write(syncIdFinal);
               }
            };
            syncs[i] = sync;           
         }
         
         Parallel parallel = new Parallel(syncs);
         parallel.run();
         
         return sync();
    }
    
    private List sync() {
        Object object = this.valueTrans;
        
        AltingChannelInput[] fromChannels = toAltingChannelsInput(getSyncs(FROM_INDEX,this.seqOfSync));
        ChannelOutput[] toChannels = toChannelsOutput(getSyncs(TO_INDEX,this.seqOfSync));
        Integer[] syncIds = toInteger(getSyncs(SYNC_ID_INDEX,this.seqOfSync));
        Integer[] writerIds = toInteger(getSyncs(WRITER_ID_INDEX,this.seqOfSync));
        
        AltingChannelInput[] notSyncChannels = toAltingChannelsInput(this.seqOfNotSync.toArray());
        AltingChannelInput[] allInputChannels = toAltingChannelsInput(concat(fromChannels,notSyncChannels));
        
        Alternative alt = new Alternative(allInputChannels);
        
        int choosen = alt.select();
        
        if (choosen < fromChannels.length) {
            AltingChannelInput from = fromChannels[choosen];
            ChannelOutput to = toChannels[choosen];
            Integer syncId = syncIds[choosen];
            Integer writerId = writerIds[choosen];

            from.read();    
            to.write(syncId);
            Boolean synchronised = (Boolean)from.read();

            if (synchronised.booleanValue()) {
                if(syncId.intValue() == writerId.intValue()) {
                    to.write(this.valueTrans);
                } else if (syncId.intValue() != writerId.intValue()) {
                    object = from.read();
                }
                
                //WITHDRAW OTHERS
                AltingChannelInput[] fromChannels_withdraw = toAltingChannelsInput(remove(choosen,fromChannels));
                ChannelOutput[] toChannels_withdraw = toChannelsOutput(remove(choosen,toChannels));
                Integer[] syncIds_withdraw = toInteger(remove(choosen,syncIds));

                CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
                for (int i=0; i<fromChannels_withdraw.length; i++) {
                    final AltingChannelInput fromInt = fromChannels_withdraw[i];
                    final ChannelOutput toInt = toChannels_withdraw[i];
                    final Integer syncIdInt = syncIds_withdraw[i];

                    final int internalI = i;
                    CSProcess process = new CSProcess() {
                        public void run () {
                            CSProcess first = new CSProcess() {
                                public void run () {
                                    toInt.write(AuxiliarMethods.flip(syncIdInt));
                                }
                            };
                            CSProcess second = new CSProcess() {
                                public void run () {
                                    Boolean invite = (Boolean)fromInt.read();
                                    if (invite.booleanValue()) {
                                        fromInt.read();
                                    } else if (!invite.booleanValue()) {
                                    }
                                }
                            };
                            CSProcess[] procs = new CSProcess[]{first,second};
                            Parallel intInterleave = new Parallel(procs);
                            intInterleave.run();
                        }
                    };
                    no_sync[i] = process;
                }
                Parallel extInterleave = new Parallel(no_sync);
                extInterleave.run();
                /////////////////////////////////////////
                // REMOVED FROM ORIGINAL PROTOCOL
                //offer();
                /////////////////////////////////////////
            } else if (!synchronised.booleanValue()) {
                 return sync();
            }
        } else {
            AltingChannelInput not_sync = allInputChannels[choosen];

            object = not_sync.read();
            
            AltingChannelInput[] fromChannels_withdraw = fromChannels;
            ChannelOutput[] toChannels_withdraw = toChannels;
            Integer[] syncIds_withdraw = syncIds;

            CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
            for (int i=0; i<fromChannels_withdraw.length; i++) {
                final AltingChannelInput fromInt = fromChannels_withdraw[i];
                final ChannelOutput toInt = toChannels_withdraw[i];
                final Integer syncIdInt = syncIds_withdraw[i];

                CSProcess process = new CSProcess() {
                    public void run () {
                        CSProcess first = new CSProcess() {
                            public void run () {
                                toInt.write(AuxiliarMethods.flip(syncIdInt));
                            }
                        };
                        CSProcess second = new CSProcess() {
                            public void run () {
                                Boolean invite = (Boolean)fromInt.read();
                                if (invite.booleanValue()) {
                                    fromInt.read();
                                } else if (!invite.booleanValue()) {
                                }
                            }
                        };
                        CSProcess[] procs = new CSProcess[]{first,second};
                        Parallel intInterleave = new Parallel(procs);
                        intInterleave.run();
                    }
                };
                no_sync[i] = process;
            }
            Parallel extInterleave = new Parallel(no_sync);
            extInterleave.run();
            /////////////////////////////////////////
            // REMOVED FROM ORIGINAL PROTOCOL
            //offer();
            /////////////////////////////////////////
        }
        
        Vector result = new Vector();
        result.add(new Integer(choosen));
        result.add(object);
        return result;
    }
    
    private Object[] getSyncs(int type, List seqOfSync) {
        Object[] result = new Object[seqOfSync.size()];
        for (int i=0; i<seqOfSync.size(); i++) {
            Object[] x = (Object[])seqOfSync.get(i);
            result[i] = x[type];
        }
        return result;
    }
    
    private Object[] concat(Object[] array1, Object[] array2) {
        int finalSize = array1.length + array2.length;
        Object result[] = new Object[finalSize];
        
        for(int i=0; i<array1.length; i++) {
            result[i] = array1[i];
        }
        for(int i=0; i<array2.length; i++) {
            result[array1.length+i] = array2[i];
        }
        return result;
    }
    
    private Object[] remove(int index, Object[] array) {
        int finalSize = array.length - 1;
        Object result[] = new Object[finalSize];
        
        int currentIndex = 0;
        for(int i=0; i<array.length; i++) {
            if (i != index) {
                result[currentIndex] = array[i];
                currentIndex++;
            }
        }
        return result;
    }

    private AltingChannelInput[] toAltingChannelsInput(Object[] array) {
        AltingChannelInput result[] = new AltingChannelInput[array.length];
        for(int i=0; i<array.length; i++) {
            result[i] = (AltingChannelInput)array[i];
        }
        return result;
    }
    
    private ChannelOutput[] toChannelsOutput(Object[] array) {
        ChannelOutput result[] = new ChannelOutput[array.length];
        for(int i=0; i<array.length; i++) {
            result[i] = (ChannelOutput)array[i];
        }
        return result;
    }

    private Integer[] toInteger(Object[] array) {
        Integer result[] = new Integer[array.length];
        for(int i=0; i<array.length; i++) {
            result[i] = (Integer)array[i];
        }
        return result;
    }

}
