package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Classe que representa o processo GasReleasedLamps
 *
 * Created on 13 May 2003, 12:36
 * @author  Marcel Oliveira
 */
public class GasReleasedLamps implements CSProcess {

    private ChannelInput[][] switchLamp;
    public class CSP1 implements CSProcess {
		public void run(){
		    Vector procVec_0 = new Vector();

		    for (AreaId id = new AreaId(AreaId.MIN_AREA_ID); 
		            id.compareTo(new AreaId(AreaId.MAX_AREA_ID)) <= 0; id=new AreaId(id.getValue()+1) ) {
		        procVec_0.add(new I_0(id));
		    }

		    CSProcess[] processes_0 = new CSProcess[procVec_0.size()];

		    for (int i=0; i < procVec_0.size(); i++) {
		        processes_0[i] = (CSProcess)procVec_0.get(i);
		    }
		    Parallel emParalelo = new Parallel(processes_0);
		    emParalelo.run();
		}
	}

	public class I_0 implements CSProcess {
        public class CSP2 implements CSProcess {
			public void run(){
			    (new GenericLamp(new Integer(Type.AREA_ID),area,switchLamp)).run();
			}
		}

		private AreaId area;

        public I_0 (AreaId newarea){
            this.area = newarea;
        }

        public void run(){
            CSP2 csp2 = new CSP2();
            csp2.run();
        }
    }
    
    /* Creates a new instance of FireLamps */
    public GasReleasedLamps(ChannelInput[][] newswitchLamp) {
        this.switchLamp = newswitchLamp; 
    }
    
    /* runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
 
}
