package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Classe que representa o processo FireLamps
 *
 * Created on 13 May 2003, 12:36
 * @author  Marcel Oliveira
 */
public class FireLamps implements CSProcess {

    private ChannelInput[][] switchLamp;
    public class CSP1 implements CSProcess {
		public void run(){
		    Vector procVec_0 = new Vector();

		    for (ZoneId id = new ZoneId(ZoneId.MIN_ZONE_ID); 
		            id.compareTo(new ZoneId(ZoneId.MAX_ZONE_ID)) <= 0; id=new ZoneId(id.getValue()+1) ) {
		        procVec_0.add(new I_0(id));
		    }

		    CSProcess[] processes_0 = new CSProcess[procVec_0.size()];

		    for (int i=0; i < procVec_0.size(); i++) {
		        processes_0[i] = (CSProcess)procVec_0.get(i);
		    }
		    (new Parallel(processes_0)).run();
		}
	}

	public class I_0 implements CSProcess {
        public class CSP2 implements CSProcess {
			public void run(){
			    (new GenericLamp(new Integer(Type.ZONE_ID),zone,switchLamp)).run();
			}
		}

		private ZoneId zone;

        public I_0 (ZoneId newzone){
            this.zone = newzone;
        }

        public void run(){
            CSP2 csp2 = new CSP2();
            csp2.run();
        }
    }
    
    /* Creates a new instance of FireLamps */
    public FireLamps(ChannelInput[][] newswitchLamp) {
        this.switchLamp = newswitchLamp; 
    }
    
    /* runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
 
}
