package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Represents the process DisplayLamps
 *
 * Created on 13 May 2003, 12:53
 * @author  Marcel Oliveira
 */
public class DisplayLamps implements CSProcess {
	public class CSP4 implements CSProcess {
		public void run() {
		    GasReleasedLamps grl = new GasReleasedLamps(switchLamp);
		    grl.run();
		}
	}

	public class CSP3 implements CSProcess {
		public void run() {
		    FireLamps fl = new FireLamps(switchLamp);
		    fl.run();
		}
	}

	public class CSP2 implements CSProcess {
		public void run() {
		    SimpleLamps sl = new SimpleLamps(switchLamp);
		    sl.run();
		}
	}

    public class CSP1 implements CSProcess {
		public void run(){
			CSProcess [] cspVetor = new CSProcess[] { //cspVetor1
		            (new CSP2()),
		            (new CSP3()),
		            (new CSP4())
		        };
		    Parallel emParalelo = new Parallel(cspVetor);
		    emParalelo.run();
		}
	}

	private ChannelInput[][] switchLamp;
    
    /* Creates a new instance of DisplayLamps */
    public DisplayLamps(ChannelInput[][] newswitchLamp) {
        this.switchLamp = newswitchLamp;            
    }
    
    /* runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
}
