package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process InternalSystem
 *
 * Created on 22 May 2003, 18:21
 * @author  Marcel Oliveira
 */
public class ConcreteInternalSystem implements CSProcess {
    CSP1 csp1;
    CSP2 csp2;
    CSP3 csp3;
    Parallel emParalelo;
    CSProcess [] cspVetor;
    
    public class CSP1 implements CSProcess {

		public void run(){
			csp2 = new CSP2();
			csp3 = new CSP3();
			cspVetor = new CSProcess [] {csp2, csp3};
			emParalelo = new Parallel (cspVetor);
			emParalelo.run();
		    /*(new Parallel( //emParalelo
		        new CSProcess[]{ //Vetor CSPVetor1
		            new CSP2(),
		            new CSP3(),
		        }
		    )).run();*/
		}
	}

	public class CSP2 implements CSProcess {
		public void run(){
		    DisplayController displayc = new DisplayController( //displayControler
		            from_switchOn, to_switchOn,
		            from_detection, to_detection,
		            from_fault, to_fault,
		            from_silenceAlarm, to_silenceAlarm,
		            from_reset, to_reset,
		            from_actuatorsReplaced, to_actuatorsReplaced,
		            displayDischarge, 
		            switched,
		            switchLamp, switchBuzzer);
		    displayc.run();
		}
	}

	public class CSP3 implements CSProcess {
		public void run(){
		    FireControl fc = new FireControl(from_switchOn, to_switchOn, 
		       from_detection, to_detection,
		       from_silenceAlarm, to_silenceAlarm,
		       from_reset, to_reset,
		       from_actuatorsReplaced, to_actuatorsReplaced,
		       from_modeSwitch, to_modeSwitch,
		       externalManualDischarge, 
		       from_fault, to_fault,
		       countdown, 
		       gasDischarged, gasNotDischarged, 
		       from_manualDischarge, to_manualDischarge,
		       from_automaticDischarge, to_automaticDischarge,
		       from_couting, to_couting,
		       from_anyDischarge, to_anyDischarge,
		       from_noDischarge, to_noDischarge,
		       displayDischarge,
		       switched,
		       alarm, systemState,
		       clockFinished, startClock);
		    fc.run();
		}
	}

	private AltingChannelInput[] from_switchOn; 
    private ChannelOutput to_switchOn;
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset; 
    private AltingChannelInput[] from_actuatorsReplaced; 
    private ChannelOutput to_actuatorsReplaced; 
    private AltingChannelInput[] from_modeSwitch; 
    private ChannelOutput to_modeSwitch;
    private AltingChannelInput externalManualDischarge; 
    private AltingChannelInput countdown;
    private AltingChannelInput[] from_fault;
    private ChannelOutput to_fault;
    private AltingChannelInput[] gasDischarged;
    private AltingChannelInput[] gasNotDischarged;
    private AltingChannelInput[] from_manualDischarge; 
    private ChannelOutput to_manualDischarge; 
    private AltingChannelInput[] from_automaticDischarge;
    private ChannelOutput to_automaticDischarge;
    private AltingChannelInput[] from_couting;
    private ChannelOutput to_couting;
    private AltingChannelInput[] from_anyDischarge;
    private ChannelOutput to_anyDischarge;
    private AltingChannelInput[] from_noDischarge;
    private ChannelOutput to_noDischarge;
    private ChannelOutput alarm;
    private ChannelOutput[][] switchLamp;
    private ChannelOutput switchBuzzer;
    private ChannelOutput systemState;
    private AltingChannelInput clockFinished;
    private ChannelOutput startClock;
    private Any2OneChannel displayDischarge;
    private Any2OneChannel switched;
    
    /* Creates a new instance of InternalSystem */
    public ConcreteInternalSystem(AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
                                AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
                                AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm, 
                                AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
                                AltingChannelInput[] newfrom_actuatorsReplaced, 
                                ChannelOutput newto_actuatorsReplaced, 
                                AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
                                AltingChannelInput newexternalManualDischarge, 
                                AltingChannelInput newcountdown, 
                                AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault, 
                                AltingChannelInput[] newgasDischarged, AltingChannelInput[] newgasNotDischarged, 
                                AltingChannelInput[] newfrom_manualDischarge, 
                                ChannelOutput newto_manualDischarge, 
                                AltingChannelInput[] newfrom_automaticDischarge, 
                                ChannelOutput newto_automaticDischarge, 
                                AltingChannelInput[] newfrom_couting, ChannelOutput newto_couting, 
                                AltingChannelInput[] newfrom_anyDischarge, ChannelOutput newto_anyDischarge, 
                                AltingChannelInput[] newfrom_noDischarge, ChannelOutput newto_noDischarge, 
                                ChannelOutput newalarm, ChannelOutput[][] newswitchLamp, 
                                ChannelOutput newswitchBuzzer, ChannelOutput newsystemState, 
                                AltingChannelInput newclockFinished, ChannelOutput newstartClock) {
                           
        this.from_switchOn = newfrom_switchOn; 
        this.to_switchOn = newto_switchOn;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset; 
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced; 
        this.to_actuatorsReplaced = newto_actuatorsReplaced; 
        this.from_modeSwitch = newfrom_modeSwitch; 
        this.to_modeSwitch = newto_modeSwitch;
        this.externalManualDischarge = newexternalManualDischarge; 
        this.countdown = newcountdown;
        this.from_fault = newfrom_fault;
        this.to_fault = newto_fault;
        this.gasDischarged = newgasDischarged;
        this.gasNotDischarged = newgasNotDischarged;
        this.from_manualDischarge = newfrom_manualDischarge; 
        this.to_manualDischarge = newto_manualDischarge; 
        this.from_automaticDischarge = newfrom_automaticDischarge;
        this.to_automaticDischarge = newto_automaticDischarge;
        this.from_couting = newfrom_couting;
        this.to_couting = newto_couting;
        this.from_anyDischarge = newfrom_anyDischarge;
        this.to_anyDischarge = newto_anyDischarge;
        this.from_noDischarge = newfrom_noDischarge;
        this.to_noDischarge = newto_noDischarge;
        this.alarm = newalarm;
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
        this.systemState = newsystemState;
        this.clockFinished = newclockFinished;
        this.startClock = newstartClock;

        this.displayDischarge = new Any2OneChannel();
        this.switched = new Any2OneChannel();
        
    }
    
    /* runs this process */
    public void run() {
    	csp1 = new CSP1();
    	csp1.run();
        //(new CSP1()).run();
    }
    
}
