package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig the Area
 *
 * Created on 21 May 2003, 17:54
 * @author  Marcel Oliveira
*/
public class Area implements CSProcess {
    
    /* Area Id */
    private AreaId id;

    /* switchOn channel */
    private final AltingChannelInput[] from_switchOn;
    /*private*/public final ChannelOutput to_switchOn;

    /* detection channel */
    private final AltingChannelInput[] from_detection;
    private final ChannelOutput to_detection;
    
    /* reset channel */
    private final AltingChannelInput[] from_reset;
    private final ChannelOutput to_reset;
    
    /* actuatorsReplaced channel */
    private final AltingChannelInput[] from_actuatorsReplaced;
    private final ChannelOutput to_actuatorsReplaced;

    /* silenceAlarm channel */
    private final AltingChannelInput[] from_silenceAlarm;
    private final ChannelOutput to_silenceAlarm;

    /* modeSwitch channel */
    private final AltingChannelInput[] from_modeSwitch;
    private final ChannelOutput to_modeSwitch;
    
    /* countdown */
    private final ChannelOutput countdown;

    /* gasDischarged channel */
    private ChannelOutput[] gasDischarged;

    /* gasNotDischarged channel */
    private ChannelOutput[] gasNotDischarged;

    /* manualDischarge channel */
    private final AltingChannelInput[] from_manualDischarge;
    private final ChannelOutput to_manualDischarge;
    
    /* automaticDischarge channel */
    private final AltingChannelInput[] from_automaticDischarge;
    private final ChannelOutput to_automaticDischarge;

    /* counting channel */
    private final AltingChannelInput[] from_counting;
    private final ChannelOutput to_counting;

    /* anyDischarge channel */
    private final AltingChannelInput[] from_anyDischarge;
    private final ChannelOutput to_anyDischarge;

    /* noDischarge channel */
    private final AltingChannelInput[] from_noDischarge;
    private final ChannelOutput to_noDischarge;

    final Integer KEYBOARD_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("KEYBOARD_SYNC_ID")));
    final Integer FIRE_CONTROL_SYNC_AREAS_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("FIRE_CONTROL_SYNC_AREAS_ID")));
    final Integer AREA_SYNC_ID;
    final Integer AREA_SYNC_ID_MODE_SWITCH;
    final Integer AREA_SYNC_ID_TO_INTERNAL_SYSTEM;

    /* Creates a new instance of Area */
    public Area(AreaId newid, 
                AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn,
                AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection,
                AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset,
                AltingChannelInput[] newfrom_actuatorsReplaced, ChannelOutput newto_actuatorsReplaced,
                AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm,
                AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch,
                ChannelOutput newcountdown, 
                ChannelOutput[] newgasDischarged, ChannelOutput[] newgasNotDischarged,
                AltingChannelInput[] newfrom_manualDischarge, ChannelOutput newto_manualDischarge,
                AltingChannelInput[] newfrom_automaticDischarge, ChannelOutput newto_automaticDischarge,
                AltingChannelInput[] newfrom_counting, ChannelOutput newto_counting,
                AltingChannelInput[] newfrom_anyDischarge, ChannelOutput newto_anyDischarge,
                AltingChannelInput[] newfrom_noDischarge, ChannelOutput newto_noDischarge) {
        this.id = newid;
        
        Integer AREAS_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("AREAS_SYNC_ID")));
        AREA_SYNC_ID = new Integer(AREAS_SYNC_ID.intValue() + newid.getValue());
        
        Integer AREAS_SYNC_ID_MODE_SWITCH = new Integer(Integer.parseInt(Config.getInstance().getMessage("AREAS_SYNC_ID_MODE_SWITCH")));
        AREA_SYNC_ID_MODE_SWITCH = new Integer(AREAS_SYNC_ID_MODE_SWITCH.intValue() + newid.getValue());
        
        Integer AREAS_SYNC_ID_TO_INTERNAL_SYSTEM = new Integer(Integer.parseInt(Config.getInstance().getMessage("AREAS_SYNC_ID_TO_INTERNAL_SYSTEM")));
        AREA_SYNC_ID_TO_INTERNAL_SYSTEM = new Integer(AREAS_SYNC_ID_TO_INTERNAL_SYSTEM.intValue() + newid.getValue());

        this.from_switchOn = newfrom_switchOn;
        this.to_switchOn = newto_switchOn;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset;
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newto_actuatorsReplaced;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_modeSwitch = newfrom_modeSwitch;
        this.to_modeSwitch = newto_modeSwitch;
        this.countdown = newcountdown;
        this.gasDischarged = newgasDischarged;
        this.gasNotDischarged = newgasNotDischarged;
        this.from_manualDischarge = newfrom_manualDischarge;
        this.to_manualDischarge = newto_manualDischarge;
        this.from_automaticDischarge = newfrom_automaticDischarge;
        this.to_automaticDischarge = newto_automaticDischarge;
        this.from_counting = newfrom_counting;
        this.to_counting = newto_counting;
        this.from_anyDischarge = newfrom_anyDischarge;
        this.to_anyDischarge = newto_anyDischarge;
        this.from_noDischarge = newfrom_noDischarge;
        this.to_noDischarge = newto_noDischarge;
    }
    public class AreaCsp implements CSProcess {
        /* controled zones */
        private SetOfType controlledZones;

        /* active zones */
        private SetOfType activeZones;

        /* Indicates if a discharged is ocurring */
        private boolean discharge;

        /* Indicates if this area is active (a discharge might occur)  */
        private boolean active;

        /* Mode in which the area is running */
        private Mode mode;
        
        /* Guarantees the state invariant */
        public void invariant() {
            controlledZones = AxiomaticDefinitions.getZones(id);
            if (mode.getValue() == Mode.AUTOMATIC) {
                if (activeZones.size() >= 2) {
                    active = true;
                } else {
                    active = false;
                }
            } 
            if (mode.getValue() == Mode.MANUAL) {
                if (activeZones.size() >= 1) {
                    active = true;
                } else {
                    active = false;
                }
            }
            if (!controlledZones.contains(activeZones)) {
                throw new RuntimeException();
            }                
        }
        
        /* Schema InitArea */
        private void initArea() {
            activeZones = new SetOfType();
            discharge = false;
            mode = new Mode(Mode.AUTOMATIC);
            invariant();
        }

        /* Schema SwitchAreaMode */
        private void switchAreaMode(SwitchMode newMode){
            mode = newMode;
            invariant();
        }
        
        /* Schema SwitchArea2AutomaticMode */
        private void switchArea2AutomaticMode(){
            mode = new Mode(Mode.AUTOMATIC);
            invariant();
        }
        
        /* Schema SwitchArea2DisabledMode */
        private void switchArea2DisabledMode(){
            mode = new Mode(Mode.DISABLED);
            invariant();
        }
        
        /* Schema ActivateZone */
        private void activateZone(ZoneId newZone) {
            if (controlledZones.contains(newZone)){
                activeZones.addElement(newZone); 
            }
            invariant();
        }

        /* Schema AutomaticDischarge */
        private void automaticDischarge() {
            discharge = active; 
            invariant();
        }

        /* Schema ManualDischarge */
        private void manualDischarge(SetOfType areas) {
            if(areas.contains(id) && active==true) {
                discharge = true;
            } else {
                discharge = false;
            }
            invariant();
        }

        /* Action StartArea */
        private void startArea(){
            // Wait a multi-sinchronisation on channel switchOn
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_switchOn[AREA_SYNC_ID.intValue()], to_switchOn, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            seqOfSync.addElement(sync);

            Vector seqOfNotSync = new Vector();
            MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
            client.run();

            initArea();
            areaCycle();
        }
        
        /* Action AreaCycle */
        private void areaCycle() {
            final int ACTUATORS_REPLACED  = 0;
            final int DETECTION           = 1;
            final int MODE_SWITCH         = 2;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_actuatorsReplaced[AREA_SYNC_ID.intValue()], to_actuatorsReplaced, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync3 = new Object[]{from_modeSwitch[AREA_SYNC_ID_MODE_SWITCH.intValue()], to_modeSwitch, AREA_SYNC_ID_MODE_SWITCH, KEYBOARD_SYNC_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);
            seqOfSync.addElement(sync3);

            Vector seqOfNotSync = new Vector();
            MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
            client.run();

            switch(client.getChoosen()) {
                case ACTUATORS_REPLACED:
                    switchArea2AutomaticMode();
                    resetArea();
                    break;
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    activateZone(newZone);
                    if (mode.getValue() == Mode.AUTOMATIC) {
                        autoArea();
                    } else if (mode.getValue() == Mode.MANUAL) {
                        manualArea();
                    }
                    break;
                case MODE_SWITCH:
                    SwitchMode newMode = (SwitchMode)client.getValueTrans();
                    switchAreaMode(newMode);
                    areaCycle();
                    break;
            } 
        }

        /* Action AutoArea */
        private void autoArea() {
            if (active == true) {
                countdown.write(null);

                final int COUNTING = 0;

                Vector seqOfSync = new Vector();
                Object[] sync = new Object[]{from_counting[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_counting, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
                seqOfSync.addElement(sync);

                Vector seqOfNotSync = new Vector();
                MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
                client.run();

                switch(client.getChoosen()) {
                    case COUNTING:
                        waitingDischarge();
                        break;
                } 

            } else if (active == false) {
                final int RESET               = 0;
                final int DETECTION           = 1;
                final int COUNTING            = 2;

                // Wait a multi-sinchronisation on the given channel
                Vector seqOfSync = new Vector();
                Object[] sync = new Object[]{from_reset[AREA_SYNC_ID.intValue()], to_reset, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
                Object[] sync2 = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
                Object[] sync3 = new Object[]{from_counting[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_counting, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
                seqOfSync.addElement(sync);
                seqOfSync.addElement(sync2);
                seqOfSync.addElement(sync3);

                Vector seqOfNotSync = new Vector();
                MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
                client.run();

                switch(client.getChoosen()) {
                    case RESET:
                        initArea();
                        areaCycle();
                        break;
                    case DETECTION:
                        ZoneId newZone = (ZoneId)client.getValueTrans();
                        activateZone(newZone);
                        autoArea();
                        break;
                    case COUNTING:
                        waitingDischarge();
                        break;
                } 
            }
        }
        /* Action ManualArea */
        private void manualArea() {
            final int SILENCE_ALARM       = 0;
            final int DETECTION           = 1;
            final int MANUAL_DISCHARGE    = 2;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_silenceAlarm[AREA_SYNC_ID.intValue()], to_silenceAlarm, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync3 = new Object[]{from_manualDischarge[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_manualDischarge, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);
            seqOfSync.addElement(sync3);

            Vector seqOfNotSync = new Vector();
            MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
            client.run();

            switch(client.getChoosen()) {
                case SILENCE_ALARM:
                    resetArea();
                    break;
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    activateZone(newZone);
                    manualArea();
                    break;
                case MANUAL_DISCHARGE:
                    SetOfType areas = (SetOfType)client.getValueTrans();
                    manualDischarge(areas);
                    if (discharge == true) {
                        gasDischarged[id.getValue()].write(null);
                    } else if (discharge == false) {
                        gasNotDischarged[id.getValue()].write(null);
                    }
                    final int ANY_DISCHARGE  = 0;
                    final int NO_DISCHARGE   = 1;

                    // Wait a multi-sinchronisation on the given channel
                    seqOfSync = new Vector();
                    sync = new Object[]{from_anyDischarge[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_anyDischarge, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
                    sync2 = new Object[]{from_noDischarge[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_noDischarge, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
                    seqOfSync.addElement(sync);
                    seqOfSync.addElement(sync2);

                    client = new MultiSyncClient(seqOfSync,new Vector(), null);
                    client.run();

                    switch(client.getChoosen()) {
                        case ANY_DISCHARGE:
                            switchArea2DisabledMode();
                            resetArea();
                            break;
                        case NO_DISCHARGE:
                            manualArea();
                            break;
                    }
                    break;
            } 
        }

        /* Action WaitingDischarge */
        private void waitingDischarge() {
            
            final int DETECTION           = 0;
            final int AUTOMATIC_DISCHARGE = 1;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_automaticDischarge[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_automaticDischarge, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);

            Vector seqOfNotSync = new Vector();
            MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
            client.run();

            switch(client.getChoosen()) {
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    waitingDischarge();
                    break;
                case AUTOMATIC_DISCHARGE:
                    automaticDischarge();
                    if (discharge == true) {
                        gasDischarged[id.getValue()].write(null);
                    } else {
                        gasNotDischarged[id.getValue()].write(null);
                    }
                    
                    final int ANY_DISCHARGE  = 0;

                    // Wait a multi-sinchronisation on the given channel
                    seqOfSync = new Vector();
                    sync = new Object[]{from_anyDischarge[AREA_SYNC_ID_TO_INTERNAL_SYSTEM.intValue()], to_anyDischarge, AREA_SYNC_ID_TO_INTERNAL_SYSTEM, FIRE_CONTROL_SYNC_AREAS_ID};
                    seqOfSync.addElement(sync);

                    client = new MultiSyncClient(seqOfSync,new Vector(), null);
                    client.run();
                    
                    switch(client.getChoosen()) {
                        case ANY_DISCHARGE:
                            switchArea2DisabledMode();
                            resetArea();
                            break;
                    }
                    break;
            } 
        }

        /* Action ResetArea */
        private void resetArea() {
            final int DETECTION           = 0;
            final int RESET               = 1;
            final int ACTUATORS_REPLACED  = 2;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_reset[AREA_SYNC_ID.intValue()], to_reset, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync3 = new Object[]{from_actuatorsReplaced[AREA_SYNC_ID.intValue()], to_actuatorsReplaced, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);
            seqOfSync.addElement(sync3);

            MultiSyncClient client = new MultiSyncClient(seqOfSync,new Vector(), null);
            client.run();

            switch(client.getChoosen()) {
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    activateZone(newZone);
                    resetArea();
                    break;
                case RESET:
                    if (mode.getValue() == Mode.DISABLED) {
                        areaD();
                    } else if (mode.getValue() != Mode.DISABLED){ 
                        initArea();
                        areaCycle();
                    }
                    break;
                case ACTUATORS_REPLACED:
                    switchArea2AutomaticMode();
                    resetArea();
                    break;
            } 
        }

        /* Action AreaD */
        private void areaD() {
            final int DETECTION           = 0;
            final int ACTUATORS_REPLACED  = 1;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_actuatorsReplaced[AREA_SYNC_ID.intValue()], to_actuatorsReplaced, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);

            MultiSyncClient client = new MultiSyncClient(seqOfSync,new Vector(), null);
            client.run();

            switch(client.getChoosen()) {
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    activateZone(newZone);
                    disabledArea();
                    break;
                case ACTUATORS_REPLACED:
                    initArea();
                    areaCycle();
                    break;
            } 
        }

        /* Action DisabledArea */
        private void disabledArea() {
            final int DETECTION     = 0;
            final int SILENCE_ALARM = 1;

            // Wait a multi-sinchronisation on the given channel
            Vector seqOfSync = new Vector();
            Object[] sync = new Object[]{from_detection[AREA_SYNC_ID.intValue()], to_detection, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            Object[] sync2 = new Object[]{from_silenceAlarm[AREA_SYNC_ID.intValue()], to_silenceAlarm, AREA_SYNC_ID, KEYBOARD_SYNC_ID};
            seqOfSync.addElement(sync);
            seqOfSync.addElement(sync2);

            MultiSyncClient client = new MultiSyncClient(seqOfSync,new Vector(), null);
            client.run();

            switch(client.getChoosen()) {
                case DETECTION:
                    ZoneId newZone = (ZoneId)client.getValueTrans();
                    activateZone(newZone);
                    disabledArea();
                    break;
                case SILENCE_ALARM:
                    resetArea();
                    break;
            } 
        }

        /* Runs this process */
        public void run() {
            startArea();
        }
    }
    public void run() {
    	AreaCsp acsp = new AreaCsp ();
    	acsp.run();
    }
    
}

