package fireControlSystem.gui;

import fireControlSystem.typing.*;
import fireControlSystem.util.*;

/*
 * Auxiliar class used to get aditional information to the GUI
 *
 * Created on 14 May 2003, 13:57
 * @author  Marcel Oliveira
 */
public abstract class Mappings {
    
    private static International international = International.getInstance();
    
    /* Creates a new instance of Mappings */
    public Mappings() {
    }
    
    public static String getLampDescription(Type type){
        String description = international.getMessage("MSG_0001");
        if (type instanceof AreaId) {
            description = international.getMessage("MSG_0002")+type.getValue();
        }
        if (type instanceof ZoneId) {
            description = international.getMessage("MSG_0003")+type.getValue();
        }
        if (type instanceof LampId) {
            int id = type.getValue();
            
            switch (id) {
                case LampId.ZONE_FAULT_LAMP:
                    description = international.getMessage("MSG_0004");
                    break;
                case LampId.EARTH_FAULT_LAMP:
                    description = international.getMessage("MSG_0005");
                    break;
                case LampId.SOUNDER_LINE_FAULT_LAMP:
                    description = international.getMessage("MSG_0006");
                    break;
                case LampId.POWER_FAULT_LAMP:
                    description = international.getMessage("MSG_0007");
                    break;
                case LampId.ISOLATE_REMOTE_SIGNAL_LAMP:
                    description = international.getMessage("MSG_0008");
                    break;
                case LampId.ACTUATOR_LINE_FAULT_LAMP:
                    description = international.getMessage("MSG_0009");
                    break;
                case LampId.ALARM_SILENCED_LAMP:
                    description = international.getMessage("MSG_0010");
                    break;
                case LampId.SYSTEM_ON_LAMP:
                    description = international.getMessage("MSG_0011");
                    break;
                case LampId.CIRCUIT_FAULT_LAMP:
                    description = international.getMessage("MSG_0012");
                    break;
            }
        }
        
        return description;
    }
    
    public static int getY(Type type) {
        int y = 0;
        if (type instanceof AreaId) {
            y=0;
        }
        if (type instanceof ZoneId) {
            y=1;
        }
        if (type instanceof LampId) {
            y=2;
        }
        return y;  
    }
}
