package fireControlSystem.gui;

import fireControlSystem.util.*;

/*
 * Presents the system counting down to discharge
 *
 * Created on 28 May 2003, 19:01
 * @author  Marcel Oliveira
 */
public class ClockGui extends javax.swing.JFrame {
    
    private final String TITLE = International.getInstance().getMessage("MSG_0040"); 
    private final String SECONDS = International.getInstance().getMessage("MSG_0041"); 
    private final int SIZE_X = Integer.parseInt(Config.getInstance().getMessage("COUNTDOWN_SIZE_X"));
    private final int SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("COUNTDOWN_SIZE_Y"));
    private final int ALARM_SIZE_X = Integer.parseInt(Config.getInstance().getMessage("ALARM_SIZE_X"));
    private final int LAMPS_SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("GENERIC_LAMP_SIZE_Y"));
    private final int LAMPS_TYPES = Integer.parseInt(Config.getInstance().getMessage("LAMPS_TYPES"));

    /* Creates new form ClockGui */
    public ClockGui() {
        initComponents();
        
        this.setTitle(this.TITLE);
        this.jLabelSeconds.setText(this.SECONDS);
        this.setSize(this.SIZE_X,this.SIZE_Y);
        this.setLocation(this.ALARM_SIZE_X,this.LAMPS_TYPES*this.LAMPS_SIZE_Y);
    }
    
    /* This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelTocks = new javax.swing.JLabel();
        jLabelSeconds = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Clock");
        setEnabled(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabelTocks.setFont(new java.awt.Font("Dialog", 1, 24));
        jLabelTocks.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        getContentPane().add(jLabelTocks, gridBagConstraints);

        jLabelSeconds.setText("Seconds");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(jLabelSeconds, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /* Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /*
     * Sets the number of seconds to go
     */
    public void setTocks(int tocks) {
        this.jLabelTocks.setText(tocks+"");
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelTocks;
    private javax.swing.JLabel jLabelSeconds;
    // End of variables declaration//GEN-END:variables
    
}
