package jcircus.util;

/*
 * CodeFormatting.java
 *
 * Formats an unformatted code in order to make it more readable
 * Created on 15 March 2005, 13:53
 * @author Marcel Oliveira
 */

import java.util.StringTokenizer;
import java.io.File;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CodeFormatting {
    
    public static String SEQUENCE       = ";";
    public static String OPEN_BLOCK     = "{";
    public static String CLOSE_BLOCK    = "}";
    public static String LINE_BREAK     = "\n";
    public static String TAB            = "\t";
    
    /*
     * Insert a given string after a given symbol
     */
    private static String insertString(String input, String insertString, String afterString){
        String output = "";
        StringTokenizer tokenizer = new StringTokenizer(input,afterString,true);
        while(tokenizer.hasMoreTokens()){
            String next = tokenizer.nextToken();
            if(next.equals(afterString)){
                output = output + next + insertString;
            } else {
                output = output + next.trim();
            }
        }
        return output;
    }

    /*
     * Insert line breaks after a given symbol
     */
    private static String insertLineBreaks(String input, String afterString){
        return insertString(input, LINE_BREAK, afterString);
    }
    
    /*
     * Counts how many times c happens in str
     */
    private static int count(char c, String str) {
        int count = 0;
        for(int i=0; i<str.length(); i++){
            if(str.charAt(i) == c) {
                count++;
            }
        }
        return count;
    }
    
    /*
     * Returns a string containing n characters c
     */
    private static String repeat(char c, int n) {
        String output = "";
        for(int i=0; i<n; i++){
            output = output + c;
        }
        return output;
    }

    /*
     * Insert tabs after a given symbol
     */
    private static String insertTabs(String input){
        String output = "";
        String done = "";
        String toDo = "";
        StringTokenizer tokenizer = new StringTokenizer(input,LINE_BREAK,true);
        while(tokenizer.hasMoreTokens()){
            String next = tokenizer.nextToken();
            done = done + next;
            if(next.equals(LINE_BREAK)){
                int numberOfOpenBlocks = count(OPEN_BLOCK.charAt(0),done);
                int numberOfCloseBlocks = count(CLOSE_BLOCK.charAt(0),done);
                int numberOfTabs = numberOfOpenBlocks - numberOfCloseBlocks;
                output = output + next + repeat(TAB.charAt(0),numberOfTabs);
            } else {
                output = output + next.trim();
            }
        }
        
        // Removing extra tabs that were inserted before closing blocks
        output = output.replaceAll(TAB+CLOSE_BLOCK,CLOSE_BLOCK);
        return output;
        /*
        String correctOutput = "";
        tokenizer = new StringTokenizer(output,CLOSE_BLOCK,true);
        while(tokenizer.hasMoreTokens()){
            String next = tokenizer.nextToken();
            if(next.equals(CLOSE_BLOCK)){
                correctOutput = correctOutput + next;
            } else {
                correctOutput = correctOutput + next.substring(0,next.length()-1);
            }
        }
        return correctOutput;
         */
    }

    public static String format(String input){
        String output = input;
        if (input != null) {
            output = output.replaceAll(LINE_BREAK,"");
            output = insertLineBreaks(output,OPEN_BLOCK);
            output = insertLineBreaks(output,CLOSE_BLOCK);
            output = insertLineBreaks(output,SEQUENCE);
            output = insertTabs(output);
        }
        return output;
    }

    public static void main(String args[]){
        String input = "";
        BufferedReader reader = null;
        String line;
        try {
            reader = new BufferedReader(new FileReader(new File("source.txt")));
            line = reader.readLine();
            while (line != null) {
                input = input + line + CodeFormatting.LINE_BREAK;
                line = reader.readLine();
            }
        } catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        } catch (IOException io) {
            io.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        String output = CodeFormatting.format(input);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File("target.txt")));
            writer.write(output);
        } catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        } catch (IOException io) {
            io.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
    
}
