package jcircus.translator;


import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import jcircus.complementaryenvs.CallProc2ChannelSetEnv;
import jcircus.complementaryenvs.ChanComplexCommEnv;
import jcircus.complementaryenvs.ChanDimEnv;
import jcircus.complementaryenvs.ChanDotFieldEnv;
import jcircus.complementaryenvs.ChanExtChoiceEnv;
import jcircus.complementaryenvs.ChanForcedInterleavingEnv;
import jcircus.complementaryenvs.ChanTransMSEnv;
import jcircus.complementaryenvs.PId2PNameEnv;
import jcircus.complementaryenvs.ProcName2ProcChanEnv;
import jcircus.complementaryenvs.ProcProcessParaEnv;
import jcircus.complexcomms.AbsCommValuesGenerator;
import jcircus.complexcomms.CCUtil;
import jcircus.complexcomms.ChanTypeEnv4CC;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ChanUseEnv;
import jcircus.environment.Environment;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.runtime.InvalidSubTypeException;
import jcircus.exceptions.runtime.VisitorException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.runtime.UnrecoveredErrorException;
import jcircus.generators.GCArrayGenerator;
import jcircus.generators.GPSEGenerator;
import jcircus.parallelism.HiddenFromGUIInfo;
import jcircus.parallelism.ParallelismVisitor;
import jcircus.parallelism.ProcHiddenFromGUIEnv;
import jcircus.util.CircusType;
import jcircus.util.CodeFormatting;
import jcircus.util.Constants;
import jcircus.util.ChanUse;
import jcircus.util.MathToolkitConstants;
import jcircus.util.ProcInfo;
import jcircus.util.Util;
import jcircus.visitor.EnvLoadingVisitor;
import jcircus.visitor.TranslatorVisitor;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.NarrSect;
import net.sourceforge.czt.z.ast.Sect;
import net.sourceforge.czt.z.ast.ZBranchList;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName/*DeclName*/;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.ZSectImpl;
import net.sourceforge.czt.z.util.Factory;
import newjcircusutil.multisync.GeneralChannel;


/**
 * Translator2Java.java
 *
 * @author  Angela Freitas
 */
public class Translator2Java {
    private String _projectDir;
    private String _projectName;
    private String _compl = ""; //Acrescentado por Samuel
    private Spec/*Term*/ _spec;
    private TranslatorVisitor _translatorVisitor;
    private EnvLoadingVisitor _envLoadingVisitor;
    private Environment _environment;
    private List<ProcInfo> _procInfoList;
    private List<String> _axParaCodeList;
    
    private boolean useBarriers; //Sam's
    private ChanDimEnv updatedChanDimEnv;
    private ChanDotFieldEnv chanDotFieldEnv;
   
    private ProcProcessParaEnv procProcessParaEnv;
    public ProcProcessParaEnv getProcProcessParaEnv () {
    	return this.procProcessParaEnv;
    }
    public void setProcProcessParaEnv (ProcProcessParaEnv env) {
    	this.procProcessParaEnv = env;
    }
    private PId2PNameEnv id2name = new PId2PNameEnv ();
    public PId2PNameEnv getPId2PNameEnv () {
    	return this.id2name;
    }
    private ProcName2ProcChanEnv pn2pce = new ProcName2ProcChanEnv ();
    public ProcName2ProcChanEnv getProcName2ProcChanEnv () {
    	return this.pn2pce;
    }
    public void setProcName2ProcChanEnv (ProcName2ProcChanEnv pn2pce) {
    	this.pn2pce = pn2pce;
    }
    private CallProc2ChannelSetEnv cp2cse = new CallProc2ChannelSetEnv ();
	private int minComm; //Sam's
	private int maxComm; //Sam's
    public CallProc2ChannelSetEnv getCallProc2ChannelSetEnv () {
    	return this.cp2cse;
    }
    public ChanTypeEnv4CC cte = new ChanTypeEnv4CC ();

    private ChanForcedInterleavingEnv cfie;
    private ChanComplexCommEnv ccce;
    private ParallelismVisitor parallelismVisitor = new ParallelismVisitor(); //Sam's
    
    private ChanExtChoiceEnv cece = new ChanExtChoiceEnv (); //Sam's
    public void setChanExtChoiceEnv (ChanExtChoiceEnv cece) { //Sam's
    	this.cece = cece;
    }
    
    ProcHiddenFromGUIEnv prochid = new ProcHiddenFromGUIEnv ();

    boolean fullparallelism;
    /**
     * Constructor.
     *
     */
    public Translator2Java(String projectDir, String projectName, Spec/*Term*/ spec, String compl, boolean useBarriers, boolean parallelism/*, int minComm, int maxComm*/) {
        this._projectDir = projectDir;
        this._projectName = projectName;
        this._spec = spec;
        this._compl = compl; //Sam's
        this._environment = new Environment();
        this._envLoadingVisitor =
        	new EnvLoadingVisitor(this._environment, projectDir, projectName, _compl, /*minComm, maxComm,*/ useBarriers);
        this._translatorVisitor =
        	new TranslatorVisitor(
        			this._environment,
        			projectDir, 
        			projectName, 
        			useBarriers, 
        			this._envLoadingVisitor.getChanMultiSyncEnv(), 
        			this._envLoadingVisitor.getChanTypeEnv4CC(), 
        			this._envLoadingVisitor.getChanDimEnv(), 
        			_compl,
        			this._envLoadingVisitor.getProcProcessParaEnv(), 
        			this._envLoadingVisitor.getChanDotFieldEnv(), 
        			this._envLoadingVisitor.getPId2PNameEnv(), 
        			this._envLoadingVisitor.getCallProc2ChannelSetEnv(), 
        			0, //minComm,
        			this._envLoadingVisitor.getMaxAbsValueComm(),//maxComm, 
        			this._envLoadingVisitor.getChanForcedInterleavingEnv(), 
        			this._envLoadingVisitor.getChanComplexCommEnv(),
        			this._envLoadingVisitor.getChanExtChoiceEnv(),
        			this._envLoadingVisitor.getTypeSizeEnv()
        	);
        this.chanDotFieldEnv = _envLoadingVisitor.getChanDotFieldEnv();

        this._procInfoList = new ArrayList<ProcInfo>();
        this._axParaCodeList = new ArrayList<String>();

        this.id2name = this._envLoadingVisitor.getPId2PNameEnv();
        this.useBarriers = useBarriers; //By Samuel Barrocas 16/12/2010, 17:31hs
        this.fullparallelism = parallelism;
        this.setProcProcessParaEnv(this._envLoadingVisitor.getProcProcessParaEnv()); //By Samuel Barrocas 16/12/2010, 17:31hs
        this.setProcName2ProcChanEnv(this._envLoadingVisitor.getProcName2ProcChanEnv());
        this.cp2cse = this._envLoadingVisitor.getCallProc2ChannelSetEnv();
        //this.minComm = minComm;
        this.minComm = 0;
        this.maxComm = this._envLoadingVisitor.getMaxAbsValueComm();
        this.cfie = this._envLoadingVisitor.getChanForcedInterleavingEnv();
        this.ccce = this._envLoadingVisitor.getChanComplexCommEnv();
        this.cte = this._envLoadingVisitor.getChanTypeEnv4CC();
        System.out.print("");
    }
    public static String brackets (int dim) {
        String r = "";
        for (int i = 0; i < dim; i++) {
            r = r + "[]";
        }
        return r;
    }
    /**
     * Main method of this class.
     *
     * @param projectDir
     * @param projectName
     * @param spec
     * @param nameProjectRun
     * @throws Exception
     */
    public void translate(boolean gui) throws FailTranslationException {

        _projectDir = _projectDir + "\\" + _projectName + "\\" + Constants.DIR_SOURCE;

        if (fullparallelism) {
        	parallelismVisitor.updateSpec(_spec);
        	this.prochid = parallelismVisitor.prochid;
        }
        try {
        	_envLoadingVisitor.visitSpec(_spec); //Angela's
            this.updatedChanDimEnv = TranslatorVisitor.updateChanDim(this._envLoadingVisitor.getChanDimEnv(), this._envLoadingVisitor.getChanMultiSyncEnv(), this._envLoadingVisitor.getChanDotFieldEnv(), this._envLoadingVisitor.getChanComplexCommEnv(), this._envLoadingVisitor.getChanExtChoiceEnv());
            this._translatorVisitor.setUpdatedChanDimEnv(this.updatedChanDimEnv);
        } catch (UnrecoveredErrorException e) {
            // There was a fatal error
        	//System.out.println ("Exce��o 1");
            throw new FailTranslationException(_envLoadingVisitor.getErrors(), e);
        }
        if (!_envLoadingVisitor.getErrors().isEmpty()) {
            // There was not a fatal error, but errors need to be reported
        	//System.out.println ("Exce��o 2");
            throw new FailTranslationException(_envLoadingVisitor.getErrors());
        }
        
        // Iterates over the paragraphs to translate and loads information about
        // process paragraphs and axiomatic definitions

        //System.out.println ("....----....----....");

        Iterator iterator;
        if (_spec.getSect().get(0) instanceof ZSectImpl) {
        	iterator = ((List<Sect>) ((ZSect) (_spec).getSect().get(0)).getParaList()).iterator();
        }
        else {
        	iterator = ((List<Sect>) ((ZSect) (_spec).getSect().get(1)).getParaList()).iterator();        	
        }

        while (iterator.hasNext()) {
            
            Para para = (Para) iterator.next();
            //System.out.print ("Par�grafo:::::::: " + para);
            if (para instanceof AxPara) {
            	//System.out.println ("AXPARA"");
            }
            else {
            	//System.out.println ();
            }

            if (para instanceof ProcessPara) {
                
                ZName/*DeclName*/ procName = ((ProcessPara) para).getZName/*getDeclName*/();
                CircusProcess circusProcess = ((ProcessPara) para).getCircusProcess();
                
                String procParaCode = null;
                try {
                    // Translates the process definition
                    //System.out.println ("COME�OU TRY");
                	//_translatorVisitor.setChanDimEnv (_envLoadingVisitor); //Sam's
                	
                    procParaCode = (String) para.accept(_translatorVisitor);
                    
                    //System.out.prJintln ("ACABOU TRY");
                    
                } catch (UnrecoveredErrorException e) {
                    //System.out.println ("Catchou uma exception UnrecoveredError");
                    // There was a fatal error
                    throw new FailTranslationException(_translatorVisitor.getErrors(), e);
                }
                
                //System.out.println ("Vai executar if _translatorVisitor. ...");

                if (!_translatorVisitor.getErrors().isEmpty()) {
                    // There was not a fatal error
                    throw new FailTranslationException(_translatorVisitor.getErrors());
                }
                
                // If this is not being run with GUI, a class Main will be created
                // only for those processes which are not parameterized
                boolean createMain;
                if (!gui && !(circusProcess instanceof ParamProcess)) {
                    createMain = true;
                } else {
                    createMain = false;
                }

                // Stores information about the process definition
                ProcInfo procInfo = new ProcInfo(procName.toString(), (ProcessPara) para,
                        procParaCode, getNormalizedParams(circusProcess), createMain);

                _procInfoList.add(procInfo);

            } else if (para instanceof AxPara) {
                
                // Translates the axiomatic definition
                String axParaCode = (String) para.accept(_translatorVisitor);
                //System.out.println ("Passou pelo else de AxPara!!!!!!");
                _axParaCodeList.add(axParaCode);
            }
            else {
                //System.out.println ("Nem ProcessPara, nem AxPara");
            }
        }
    }

    /**
     * This method is the implementation of
     *
     * |[ CircusProgram ]|^{Program} proj
     *
     * in the strategy, where:
     *
     * - CircusProgram is the program defined by the attribute Spec
     * - proj is the name of the project, defined by the attribute "projectName"
     */
    public void createSources() throws JCircusException {

        // Create the directories for the project
        createDirStructure();

    	(new GPSEGenerator (this._envLoadingVisitor.dim, this._envLoadingVisitor.getMinComm(), this._envLoadingVisitor.getMaxAbsValueComm(), "paper", "src", this._envLoadingVisitor.getProjectDir(), this._envLoadingVisitor.getSpecNameOnTranslation())).generateClass();
    	GCArrayGenerator.generate (this._envLoadingVisitor.dim, this._envLoadingVisitor.getProjectDir() + "\\" + this._envLoadingVisitor.getProjectName() + "\\src\\" + this._envLoadingVisitor.getProjectName() + "\\typing\\GCArray.java", this._envLoadingVisitor.getSpecNameOnTranslation());
    	Vector <AbsCommValuesGenerator> absGens = new Vector <AbsCommValuesGenerator> ();
    	absGens = this._envLoadingVisitor.getAbsGens();
    	for (int i = 0; i < absGens.size(); i++) {
    		absGens.elementAt(i).generate();
    	}
        // Corresponds to function "DeclareTypeClass" in the 
        // translation strategy documentation
        createTypeClass();
        
        // Creates class that represents the basic type \arithmos (number)
        createCircusIntegerClass();
        
        // Corresponds to function |[ ]|^{FreeTypes} in the strategy doc.
        createClassesForFreeTypes();
        
        // Corresponds to function "DeclareAxDefClass" in the strategy doc.
        createAxDefHorizDefClass();
        
        // Implements "|[ ProcDecls ]|^{ProcDecls} proj" in the strategy doc.
        for (int i = 0; i < _procInfoList.size(); i++) {
            ProcInfo procInfo = _procInfoList.get(i);
            
            procInfo.setCreateMain(true); //Em CRefine, JCircus criará Main para todos os processos.
            // Class for process
            createProcessClass(procInfo.getProcessName(), procInfo.getCode());
            
            // Main for process
            if (procInfo.getCreateMain()) {
                createClassMain(procInfo);
                createGUI(procInfo);
                createBatFile(procInfo);
            }
            
        }
        System.out.println("Source files for project \'" + _projectName + 
                "\' were created at " + _projectDir);
    }

    /**
     * Creates the project folders.
     */
    private void createDirStructure() throws SecurityException {
        
        File dirProcesses = new File(_projectDir + "\\" + _projectName + "\\" + 
                Constants.PKG_PROCESSES);
        File dirAxDefs = new File(_projectDir + "\\" + _projectName + "\\" + 
                Constants.PKG_AXDEFS);
        File dirTyping = new File(_projectDir + "\\" + _projectName + "\\" + 
                Constants.PKG_TYPING);
        File dirGui = new File(_projectDir + "\\" + _projectName + "\\" + 
                Constants.PKG_GUI);
        
        File dirChannels = new File(_projectDir + "\\" + _projectName + "\\" + 
                "channels");
        
        File dirCCMaps = new File(_projectDir + "\\" + _projectName + "\\" + 
                "ccmaps");
        
        dirProcesses.mkdirs();
        dirAxDefs.mkdirs();
        dirTyping.mkdirs();
        dirGui.mkdirs();
        dirChannels.mkdirs();
        dirCCMaps.mkdirs();
    }
    
    /**
     * Pg. 165.
     *
     * @param projectDir
     * @param projectName
     */
    private void createTypeClass() throws JCircusException {
        
        String typeConstants = declareTypeConstants();
        String pkg = getPackage(_projectName, Constants.PKG_TYPING, _compl);

        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_TYPE_DECLCONST, typeConstants);
        map.put(Constants.C_TYPE_PKG, pkg);
        
        try {
            
            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_TYPING + "\\" + Constants.CLS_TYPE + Constants.JAVA_EXT;
            Util.createFileFromTemplate(Constants.TMP_TYPE, map, fileName);
            
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create Type class", t);
        }
    }
    
    /**
     * Returns Java code for the declaration of constants for all the types.
     * Pg. 166.
     *
     * @return
     */
    private String declareTypeConstants() {
        String code = "";
        
        int numberFt = _environment.freeTypesEnvironmentSize();
        // Insert all the free types
        for (int i = 0; i < numberFt; i++) {
            Freetype ft = _environment.freeTypesEnvironmentGet(i);
            code += "\npublic static final int " +
                    ft.getZName()/*getDeclName*/ + " = " + i + ";";
        }
        // Insert the CircusInteger type
        code += "\npublic static final int " + Constants.CLS_CIRCNUM + " = " + numberFt + ";";
        
        // min and max constants
        code += "\n\npublic static final int MIN_TYPE_ID = 0;";
        code += "\npublic static final int MAX_TYPE_ID = " + numberFt + ";";
        
        return code;
    }

    /**
     * Create CircusInteger.class
     *
     * @param projectDir
     * @param projectName
     */
    private void createCircusIntegerClass() throws JCircusException {
        
        try {
            
            String pkg = getPackage(_projectName, Constants.PKG_TYPING, _compl);
            
            // File from template
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(Constants.C_CIRCINT_PKG, pkg);
            
            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_TYPING + "\\" + Constants.CLS_CIRCNUM + Constants.JAVA_EXT;
            Util.createFileFromTemplate(Constants.TMP_CIRCINT, map, fileName);
            
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create CircusInteger class.", t);
        }
    }
    
    /**
     * Creates classes for all the free types.
     *
     */
    private void createClassesForFreeTypes() throws JCircusException {
        
        for (int i=0; i<this._environment.freeTypesEnvironmentSize(); i++) {
            
            Freetype freetype = _environment.freeTypesEnvironmentGet(i);
            createClassForFreeType(freetype);
        }
    }

    /**
     * Creates class for a free type.
     * Pg. 167.
     *
     * @param freetype
     */
    private void createClassForFreeType(Freetype freetype) throws JCircusException {

        String name = freetype./*getDeclName*/getZName().toString();
        String constants = "";
        String toStringCode = "\nString result = null;\nswitch(super.getValue()) {";

        String constructorCode = "";

        int index = 0;

        //Abaixo foi mudado!!!
        ZBranchList/*ListTerm*/ branches = (ZBranchList) (freetype.getBranchList());
        //ListTerm branches = freetype.getBranch();

        // Constants
        for (int i = 0; i < branches.size(); i++) {
            Branch branch = (Branch) branches.get(i);
            String nameFreeTypeElement = branch.getZName()/*getDeclName()*/.toString();
            constants = constants + "\npublic static final int " + nameFreeTypeElement + " = " + index + ";";

            toStringCode += "\ncase " + nameFreeTypeElement + ": result = \"" + nameFreeTypeElement + "\";\nbreak;";

            constructorCode += "\nif (st.equals(\"" + nameFreeTypeElement + "\"))\n\tthis.setValue(" + index + ");";

            index++;
        }

        toStringCode += "\n}";
        toStringCode += "\nreturn result;";

        constants = constants + "\npublic static final int MIN_VALUE = 0;";
        constants = constants + "\npublic static final int MAX_VALUE = " + (branches.size() - 1) + ";";
        
        // Formatting
        toStringCode = CodeFormatting.format(toStringCode);
        constructorCode = CodeFormatting.format(constructorCode);
        
        String pkg = getPackage(_projectName, Constants.PKG_TYPING, _compl);
        
        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_SUBTYPE_PROJ, _projectName);
        map.put(Constants.C_SUBTYPE_CLSNAME, name);
        map.put(Constants.C_SUBTYPE_CONST, constants);
        map.put(Constants.C_SUBTYPE_TOSTR, toStringCode);
        map.put(Constants.C_SUBTYPE_CONSTRUCTOR, constructorCode);
        map.put(Constants.C_SUBTYPE_PKG, pkg);
        try {

            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_TYPING + "\\" + name + ".java";
            Util.createFileFromTemplate(Constants.TMP_SUBTYPE, map, fileName);
            //System.out.println ("((((((((((((((((((((((((((((((((((((((((((((((((((");

        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create class for free type" +
                    name, t);
        }
    }
    
    /**
     * Creates class for the axiomatic definitions and horizontal definitions.
     */
    private void createAxDefHorizDefClass() throws JCircusException {

        String pkg = getPackage(_projectName, Constants.PKG_AXDEFS, _compl);
        String imp = getImports(_projectName);

        String body = "";
        for (int i = 0; i < _axParaCodeList.size(); i++) {
            body = body + _axParaCodeList.get(i) + "\n";
        }

        // Formatting
        body = CodeFormatting.format(body);

        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_AXDEFS_PKG, pkg);
        map.put(Constants.C_AXDEFS_IMP, imp);
        map.put(Constants.C_AXDEFS_BODY, body);
        
        try {
            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_AXDEFS + "\\" + Constants.CLS_AXDEFS + Constants.JAVA_EXT;
            Util.createFileFromTemplate(Constants.TMP_AXDEFS, map, fileName);
            
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create AxiomaticDefinitions class", t);
        }
    }
    
    /**
     * Creates class for a process definition.
     * Pg. 137.
     *
     * @param projectDir
     * @param projectName
     */
    private void createProcessClass(String processName, String processBody) throws JCircusException {

        // Format
        String formattedProcessBody = CodeFormatting.format(processBody);
        
        String pkg = getPackage(_projectName, Constants.PKG_PROCESSES, _compl);
        String imp = getImports(_projectName);
                
        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_PROC_PROJ, _projectName);
        map.put(Constants.C_PROC_CLSBODY, formattedProcessBody);
        map.put(Constants.C_PROC_CLSNAME, processName);
        map.put(Constants.C_PROC_PKG, pkg);
        map.put(Constants.C_PROC_IMP, imp);
        
        try {
            
            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_PROCESSES + "\\" + processName + ".java";
            Util.createFileFromTemplate(Constants.TMP_PROC, map, fileName);
            
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create process class for " +
                    processName, t);
        }
    }
    
    /**
     * Creates class Main for a process definition.
     *
     * @param projectDir
     * @param projectName
     * @param processDefinitionMain
     * @throws Exception
     */
    private void createClassMain(ProcInfo procInfo) throws JCircusException {
        // Parameters for template
        String pkg = getPackage(_projectName, null, _compl);
        String imp = getImports(_projectName);
        String nameMain = "Main_" + procInfo.getProcessName();
        String declarations = attributeDeclMainCode(procInfo.getProcessPara());
        String processCall = processCallCode(procInfo);
        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_MAIN_PKG, pkg);
        map.put(Constants.C_MAIN_IMP, imp);
        map.put(Constants.C_MAIN_PROJ, _projectName);
        map.put(Constants.C_MAIN_NMMAIN, nameMain);
        map.put(Constants.C_MAIN_DECLS, declarations);
        map.put(Constants.C_MAIN_PROCCALL, processCall);
        try {
            String fileName = _projectDir + "\\" + _projectName + "\\" + nameMain + ".java";
            Util.createFileFromTemplate(Constants.TMP_MAIN, map, fileName);
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create main class for " +
                    procInfo.getProcessName());
        }
    }

    /**
     * Code for declaration of channels in the main class.
     */
    // DUPLICATED CODE? TV.attributeDeclCode()
    private String attributeDeclMainCode(ProcessPara processParaMain) {
        String code = "";

        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv multiSyncEnv = Util.getChannelMSEnvAnn(processParaMain); //By Angela Freitas

        String key = this.procProcessParaEnv.getKey(processParaMain);
        ProcChanEnv procchanenv = this.getProcName2ProcChanEnv().get(key);
        ChanInfoEnv cie = procchanenv.getChanInfoEnv();

        multiSyncEnv.setChannelSet(cie.getChannelSet());
        //ChanInfoEnv multiSyncEnv = this.getProcName2ProcChanEnv().get(this.procProcessParaEnv.getKey(processParaMain)).getChanInfoEnv();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();

        // Gets process id
        Integer procId = Util.getIdCircusProcessAnn(circusProcess).getId();

        Iterator it = multiSyncEnv.iteratorKeys();
        // For each channel
        while(it.hasNext()) {

            String channelName = (String) it.next();
            ProcChanUseEnv chanMSEnv = multiSyncEnv.get(channelName);
            chanMSEnv.setChannelSet(multiSyncEnv.getChannelSet());

            if (!chanUseEnvHid.containsKey(channelName)) {
                // Code for the declaration of the channel - only channels that
                // are not hidden can appear in the gui
                code = code + channelCode(channelName, procId, chanMSEnv);
            }
        }
        return code;
    }
    
    /**
     *  Code for declaration of one channel in the main class. Example of code:
     *
     *  final Any2OneChannel[] from_a = Any2OneChannel.create(3); // number of processes that take part in the MS - MS only
     *
     *  final Any2OneChannel to_a = new Any2OneChannel();
     *
     *  Hashtable ht = new Hashtable();
     *  ht.put("GC_A", new Integer(1));
     *  ht.put("GC_B", new Integer(0));
     *  ht.put("GC_C", new Integer(2));
     *  final ChanInfo chanInfo = new ChanInfo(ht);
     *
     *  final GeneralChannel a = new GeneralChannel(
     *          to_a,
     *          from_a, // MS only
     *          chanInfo,
     *          "GC_P");
     *
     * OBS: Variables are no longer 'final', I do not remeber why they were like this
     * before.
     *
     */
    private String channelCode(String channelName, Integer procId, ProcChanUseEnv chanMSEnv) {
        String code = "";
        String toChannel = "to_" + channelName;
        String fromChannel = "from_" + channelName;
        String chanInfo = "chanInfo_" + channelName;
        /**
         * The variables in the
         *
         */
        if (chanMSEnv.isMultiSync()) {
            // from_channel declaration, if this channel takes part in multisynchronization
        	//code = code + "Any2OneChannel[] " + fromChannel + " = Any2OneChannel.create(" + //Angela's, JCSP antigo
            	//chanMSEnv.getCardinality() + ");\n"; //Angela's, JCSP antigo
            if (!useBarriers) {
        		code = code + "org.jcsp.lang.Any2OneChannel[] " + fromChannel + " = org.jcsp.lang.Channel.any2oneArray (" + chanMSEnv.getCardinality() + ");\n		"; //Sam's, JCSP novo
        	}
        }
        // to_channel declaration
        //code = code + "Any2OneChannel " + toChannel + " = new Any2OneChannel();\n"; //Angela's, JCSP antigo
        if (!useBarriers) {
        	code = code + "org.jcsp.lang.Any2OneChannel " + toChannel + " = org.jcsp.lang.Channel.any2one ();\n		"; //Sam's, JCSP novo
        }
        List<Integer> ids = Util.resolveUndefinedChannels(chanMSEnv, true/*, channelName, this.getProcProcessParaEnv()*/); //By Angela Freitas
        code = code + Constants.CLS_CHINFO + " " + chanInfo + " = new " + Constants.CLS_CHINFO + "();\n		";
        for (int i = 0; i < ids.size(); i++) { //This loop was implemented by Samuel Barrocas, in 16/12/2010, 18:07hs
        	System.out.println ("ids.size == " + ids.size());
            	Integer subProcId = (Integer) ids.get(i);/*.get(j);*/
            	code = code + chanInfo + ".put(new Integer(" + subProcId + "), new Integer(" + i + "));/*" + i + "*/\n		";
        }
        // general channel
        if (chanMSEnv.isMultiSync()) {
            // multisynchronization
        	code = code + "/*" + channelName + " é um canal multisincronizado!*/ \n";
        	int dimChannel = this.updatedChanDimEnv.get(channelName);
            code = code + "		GeneralChannel " + (brackets (dimChannel)) + " " + channelName + " = GCArray.create" + ((dimChannel < 0)? 0 : dimChannel) + "Array(";
            if (!useBarriers) {
            	code = code + toChannel + ",";
            	code = code +  fromChannel + ",";
        	}
            code = code +  chanInfo + ",";
            code = code +  "new Integer(" + procId + "));\n";
        } else {
            // not multisynchronization
        	code = code + "/*" + channelName + " NÃO é um canal multisincronizado! */ \n";
        	int dimChannel = this.updatedChanDimEnv.get(channelName);

            code = code + "\t\tGeneralChannel " + (brackets (dimChannel)) + " " + channelName + " = /*1*/" + "GCArray.create" + ((dimChannel < 0)? 0 : dimChannel) + "Array(";
            if (!useBarriers) {
            	code = code + toChannel + ",";
            }
            code = code + chanInfo + ","
                    + "new Integer(" + procId + "));\n	";
        }
        return code;
    }
    
    /**
     * Code for call to the main process.
     *
     */
    private String processCallCode(ProcInfo procInfo) throws JCircusException {
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        ChanInfoEnv chanInfoEnv = Util.getChannelMSEnvAnn(procInfo.getProcessPara());
        Integer procId = Util.getIdCircusProcessAnn(circusProcess).getId();
        ProcessPara processPara = procInfo.getProcessPara();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processPara);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        String params = paramsCode(procInfo);
        String processNameGui = getNameGui(processName);
        List<String> listProcessesCode = new ArrayList();
        /**
         * Builds the parameters for the GUI, that is, the code for the
         * passage of channels as parameters.
         */
        // c is the number of channels that take part in the gui
        int c = 0;
        String paramsGui = "";
        String comma = ", ";

        Iterator it = chanInfoEnv.iteratorKeys();

        String params4Par = ""; //Variável criada por Samuel Barrocas
        String p_name = "p_", p_gui_name = "p_gui_"; //Variáveis criada por Samuel Barrocas
        String list_of_gpse_p_channels = ""; //By Samuel Barrocas
        String list_of_gpse_gui_channels = ""; //By Samuel Barrocas
        int counter_gpse_channels = 1; //By Samuel Barrocas

        while (it.hasNext()) {
            String channelName = (String) it.next();
            ProcChanUseEnv chanMSEnv = chanInfoEnv.get(channelName);
            if (!chanMSEnv.isSync() && !chanUseEnvHid.containsKey(channelName)) {
                /**
                 * Independent channels - they will synchronize only with the gui.
                 * They cannot be hidden otherwise the gui cannot see them.
                 */
            	if (isTranslatedAsSimpleSynchronized (channelName)) {
            		paramsGui = paramsGui + comma + "/*V*/" + channelName +
        				"/*new " + Constants.CLS_GENCHAN + "(" + channelName + //Angela's
        				", new Integer(-1))*/"; // global id of gui is -1 //Angela's
            	}
            	else {
            		paramsGui = paramsGui + comma + "/*V*/ GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")" +
            			"/*new " + Constants.CLS_GENCHAN + "(" + channelName + //Angela's
            			", new Integer(-1))*/"; // global id of gui is -1 //Angela's
            	}
                c++;
            }
            /*Abaixo código escrito por Samuel Barrocas (Sam's)*/
            if (useBarriers) {
            	p_name = p_name + channelName + "_";
            	p_gui_name = p_gui_name + channelName + "_";
            	//if (!chanMSEnv.isSync()) {
            		if (!this._envLoadingVisitor.getEnvLoadingParProcessEnv().get(processName)) {
            			if (!isTranslatedAsSimpleSynchronized (channelName)) {
            				list_of_gpse_p_channels = list_of_gpse_p_channels + "GPSE.getProcessSyncEnds (new Integer (" + procId + "), " + channelName + ")";
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + "GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")";
            			}
            			else {
            				list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;
            				//list_of_gpse_gui_channels = list_of_gpse_gui_channels + "GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")";
            			}
            		}
            		else {
                		list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
        				//list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;
        				list_of_gpse_gui_channels = list_of_gpse_gui_channels + "GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")";                		
            		}
            	//}
            	/*else {
                	list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
    				list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;
            	}*/
            	if (counter_gpse_channels < chanInfoEnv.size()) {
            		list_of_gpse_p_channels = list_of_gpse_p_channels + ", ";
            		list_of_gpse_gui_channels = list_of_gpse_gui_channels + ", ";
            	}
            	counter_gpse_channels++;
            }
            /*Acima c�digo escrito por Samuel Barrocas (Sam's)*/
        }
    	listProcessesCode.add (p_name);
    	//if (!atLeastOneDependentChannel) //Sam's
    	listProcessesCode.add (p_gui_name);
    	if (useBarriers) {
    		params4Par = params4Par + processName + " " + p_name + " = new " + processName + "(" + list_of_gpse_p_channels + ");\n";
    		//if (!atLeastOneDependentChannel)
    			params4Par = params4Par +
    				"\t\tGui_" + processName + " " + p_gui_name + " = new Gui_" + processName + "(\"" + processName + "\", " + list_of_gpse_gui_channels + ");\n";
    	}
        // c is the number of channels that take part in the gui
        paramsGui = "\"" + processName + "\"" + paramsGui;

        String parCodeLeft;
        String parCodeRight;
//Abaixo, código do protocolo de multi-sincronização (nada a ver com a solução com barreiras alternantes)
        if (chanInfoEnv.noMultiSync() == 0) {
            /**
             * If there is no multi-synchronization, the main call is the
             * parallelism of the main process and GUI.
             */
            parCodeLeft = cspProcessCallCode(processName, params);
            parCodeRight = cspProcessCallCode(processNameGui, paramsGui);

            System.out.println ();
        } else {

            /**
             * If there is multi-synchronization, the main call is the
             * parallelism of ProcessManagerMultiSync and ControllersManager.
             */
            parCodeLeft = processManagerCallCode(processName, params, processNameGui, 
                    paramsGui);
            parCodeRight = controllersManagerCallCode(chanInfoEnv);
        }
        /**
         * Creates the parallelism
         */
        if (!useBarriers) {
        	listProcessesCode.add(parCodeLeft);
        	listProcessesCode.add(parCodeRight);
        }
        else { //Samuel Barrocas (Sam's)
        	//listProcessesCode.add (channelName + "_" + processName);
        }
        code = code + params4Par; //Samuel Barrocas (Sam's)
        
        code = code + parallelCallRunCode(listProcessesCode, true);

        return code;
    }
    
    /**
     * Code for the params to the main process in class Main.
     *
     */
    private String paramsCode(ProcInfo procInfo) {
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        String procParamCode = "";
        // parameters of the process
        if (circusProcess instanceof ParamProcess) {
            procParamCode = paramList(procInfo.getCodeForActuals());
        }
        // visible channels passed as parameters
        String chanParamCode = paramPassageCode(procInfo.getProcessPara());
        // Channels come first
        if (!chanParamCode.equals("") && !procParamCode.equals("")) {
            code = chanParamCode + ", " + procParamCode;
        } else {
            code = chanParamCode + procParamCode;
        }
        return code;
    }
    
    /**    
     * Return code for the expressions which are parameters of the process
     */
    private String paramList(List<String> codeForActuals) {
        String code = "";

        String comma = "";
        for (int i = 0; i < codeForActuals.size(); i++) {
            code = code + comma + codeForActuals.get(i);
            comma = ", ";
        }
        return code;
    }
    
    /**
     *
     */
    private String paramPassageCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        Integer id = Util.getIdCircusProcessAnn(circusProcess).getId();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        String comma = "";
        Iterator it = channelMSEnv.iteratorKeys();
        // For each channel
        while(it.hasNext()) {
            String channelName = (String) it.next();
            if (!chanUseEnvHid.containsKey(channelName)) {
                // Hidden channels are not seen in main
                ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
                code = code + comma + channelName;
                comma = ", ";
            }
            /**
             * Don't think this is necessary anymore. Why create a new channel
             * for the process with the same id ?
             *
            if (!syncEnv.isSync()) {
                // This channel will synchronize with the GUI
                ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
 
                code = code + comma + "new GeneralChannel(" + channelName +
                        ", new Integer(" + id.intValue() + "))";
            } else {
 
                code = code + comma + channelName;
            }
 
            if (comma.equals("")) comma = ", ";
             */
        }
        return code;
    }

    /**
     *
     */
    private String cspProcessCallCode(String name, String paramsCode) {
        return "new " + name + "(" + paramsCode + ")";
    }
    
    /**
     * Returns the code for the call to the constructor of class ProcessManagerMultiSync.java.
     *
     * Typically, this constructor will receive a process which is the parallelism of the main
     * class and the gui.
     *
     */
    private String processManagerCallCode (String processName, String params, 
            String processNameGui, String paramsGui) throws JCircusException {
        String code;
        List<String> listProcessesCode = new ArrayList<String>();
        listProcessesCode.add(cspProcessCallCode(processName, params));
        listProcessesCode.add(cspProcessCallCode(processNameGui, paramsGui));
        String parallelismCode = parallelCallRunCode(listProcessesCode, false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Constants.C_PROCMNGR_PROC, parallelismCode);
        code = Util.getCodeFromTemplate(Constants.TMP_PROCMNGR, hashMap);
        return code;
    }

    /**
     * Returns the code for the call to the constructor of class ControllersManager.java.
     *
     */
    private String controllersManagerCallCode(ChanInfoEnv chanInfoEnv) 
            throws JCircusException {
        
        String code;

        String call;
        if (chanInfoEnv.noMultiSync() == 1) {
            
            /**
             * If there is only one controller, this is the call to the
             * method run of the controller.
             */
            Iterator<String> it = chanInfoEnv.iteratorKeys();
            
            String channelName = "";
            while(it.hasNext()) {
                channelName = it.next();
                ProcChanUseEnv syncEnv = chanInfoEnv.get(channelName);
                if (syncEnv.isMultiSync())
                    break;
            }
            
            call = "new " + Constants.CLS_MSCTRL + "(Channel.getOutputArray (from_" + channelName +
                    "), to_" + channelName + ".in())";
            
        } else {
            
            /**
             * If there is more than one, this is the call to the method
             * run of the parallelism of the controllers.
             *
             */
            
            List<String> listProcessCode = new ArrayList<String>();
            /**
             * iterates over the environments and when it finds one
             * channel that is multisynchronized,
             * adds its name to the array
             */
            Iterator<String> it = chanInfoEnv.iteratorKeys();
            while(it.hasNext()) {
                
                String channelName = it.next();
                ProcChanUseEnv syncEnv = chanInfoEnv.get(channelName);
                
                if (syncEnv.isMultiSync()) {
                    
                    String processCode = "";
                    /**
                     * Multi synchronization.
                     */
                    processCode = "new " + Constants.CLS_MSCTRL + " (from_" +
                            channelName + ", to_" + channelName + ")";
                    
                    listProcessCode.add(processCode);
                }
            }
            call = parallelCallRunCode(listProcessCode, false);
        }

        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Constants.C_CTRLMNGR_CALL, call);
        code = Util.getCodeFromTemplate(Constants.TMP_CTRLMNGR, hashMap);

        return code;
    }
    
    /**
     * Returns the source code for the call for the constructor of a parallelism.
     *
     * Receives the code for each CSPProcess that takes part in the parallelism.
     *
     * @param   boolean     run     If it is true, appends the call method run() at the end.
     */
    private String parallelCallRunCode(List<String> processes, boolean run) 
            throws JCircusException {
        String code;
        String listProcessesCode = "";
        String comma = "";
        for (int i=0; i < processes.size(); i++) {
            listProcessesCode += comma + processes.get(i);
            comma = ", ";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Constants.C_PARCALL_LISTPROC, listProcessesCode);
        code = Util.getCodeFromTemplate(Constants.TMP_PARCALL, hashMap);
        if (run) {
            code = code + ".run();";
        }
        return code;
    }
            
    /**
     * Create class GUI for a process definition.
     */
    private void createGUI(ProcInfo procInfo) throws JCircusException {

        String nameMain = procInfo.getProcessName();

        String pkg = getPackage(_projectName, Constants.PKG_GUI, _compl);
        String imp = getImports(_projectName);
        String nameGui = getNameGui(nameMain);
        String chanDecl = chanDeclGuiCode(procInfo.getProcessPara());
        String chanAssig = chanAssignGuiCode(procInfo.getProcessPara());
        String chanParam = chanParamGuiCode(procInfo.getProcessPara());
        String chanInit = chanInitGuiCode(procInfo.getProcessPara());
        String chanActPerf = chanActPerfGuiCode(procInfo.getProcessPara());

        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_GUI_PKG, pkg);
        map.put(Constants.C_GUI_IMP, imp);
        map.put(Constants.C_GUI_CLSNAME, nameGui);
        map.put(Constants.C_GUI_CHANDECL, chanDecl);
        map.put(Constants.C_GUI_CHANASSIG, chanAssig);
        map.put(Constants.C_GUI_CHANPARAM, chanParam);
        map.put(Constants.C_GUI_CHANINIT, chanInit);
        map.put(Constants.C_GUI_CHANACTPERF, chanActPerf);

        try {
            String fileName = _projectDir + "\\" + _projectName + "\\" +
                    Constants.PKG_GUI + "\\" + nameGui + ".java";
            Util.createFileFromTemplate(Constants.TMP_GUI, map, fileName);
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create GUI for " +
                    procInfo.getProcessName(), t);
        }
        
    }

    /**
     * Code for declaration of GUI components of a channel.
     */
    private String chanDeclGuiCode(ProcessPara processParaMain) {
        String code = "";

        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        
        //Iterator it = channelMSEnv.iteratorKeys();
        Set keys = channelMSEnv.keys();
        Iterator it = keys.iterator();
        boolean instTextFieldsAndGetValues = false;
        // for each channel
        while (it.hasNext()) {

            String channelName = (String) it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);

            HiddenFromGUIInfo infoprocessname = this.prochid.get(processName);
            //if (!syncEnv.isSync() && !chanUseEnvHid.containsKey(channelName)) {
        	//if (this.prochid.get(processName).getCoadjChannels().contains(channelName))
        	
            //channelName = this.prochid.get(processName).get (channelName);
            
            if (this.prochid.get(processName).getPutDecl(channelName) == false) {
            	this.prochid.get(processName).putPutDecl(channelName, true);
                // The channel does not take part in a parallelism, so it will
                // be in the graphical interface

            	code = code + "	\n	private GeneralChannel " + CCUtil.bracketizeds(this._envLoadingVisitor.getChanDimEnv().get(channelName), "") + " " + channelName + ";";

                /*Vector <String> hidChans = new Vector <String> ();
                if (this.prochid.get(processName).reverseGet(channelName) != null)
                	hidChans = this.prochid.get(processName).reverseGet(channelName);
                int sizeHidChans = hidChans.size();
                for (int i = 0; i < sizeHidChans; i++) {
                	int dim = this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get (hidChans.get(i))); //A dimensão do canal coadjuvante é igual à do seu canal principal
                	code = code + "	\n	private GeneralChannel " + CCUtil.bracketizeds (dim, "") + " " + hidChans.get(i) + ";";
                }*/

                code = code + "	\n	private javax.swing.JButton btn_" + channelName + ";";
                code = code + "	\n	private javax.swing.JLabel lbl_" + channelName + ";";
                code = code + " \n  private javax.swing.JPanel panel_" + channelName + " = new javax.swing.JPanel ();";
                code = code + "	\n	private javax.swing.JComboBox " + "[]" + " combo_" + channelName + 
                	" = new javax.swing.JComboBox [" +
                		(this._envLoadingVisitor.getChanDimEnv().get(channelName) < 0?
                				0 : this._envLoadingVisitor.getChanDimEnv().get(channelName)) + "]; //Changed by Samuel Barrocas";
                if (!instTextFieldsAndGetValues) {
                	code = code +
                				"\n		Vector <String []> boxcontent = new Vector <String []> ();\n" +
                				"		public JComboBox [] instComboBoxes (int x) { //Code Developed by Samuel Barrocas (Sam's)\n" +
                			  	"			javax.swing.JComboBox [] cb = new javax.swing.JComboBox [x];\n";
                			  	
                	Vector <Vector <BigInteger>> vec = cte.get(channelName);
                	for (int i = 0; i < vec.size(); i++) {
                		code = code + 
                				"			boxcontent.addElement (" + ChanTypeEnv4CC.stringCode (channelName, i, cte) + ");\n";
                	}
                		code = code +
                				"			\n" +
                			  	"			for (int i = 0; i < x; i++) {\n" +
                			  	"				cb [i] = new javax.swing.JComboBox (boxcontent.elementAt (i));\n" +
                			  	"			}\n" +
                			  	"			return cb;\n" +
                			  	"		}\n";
                		code = code +
                			  	"	public int [] getValues (JComboBox [] jcb, Vector <String []> boxcontent) { //Method developed by Samuel Barrocas (Sam's)\n" +
                			  	"		int [] values = new int [" + numberOfValuesComm (channelName) + "];\n";
                		for (int i = 0; i < vec.size(); i++) {
                			code = code +
                				"	values [" + i + "] = /*Integer.parseInt (*/(new " + cte.getFreeType (channelName, i) + "(boxcontent.elementAt(" + i + ") [jcb [" + i + "].getSelectedIndex()])).getValue()/*)*/;\n";
                		}
                			  	
                			  	/*"		for (int i = 0; i < " + numberOfValuesComm (channelName) + "; i++) {\n" +
                			  	"			values [i] = Integer.parseInt (boxcontent.elementAt(i) [jcb [i].getSelectedIndex()]);\n" +
                			  	"		}\n" +*/
                		code = code + "		return values;\n" +
                			"	}\n";
                	instTextFieldsAndGetValues = true;
                }
        	}
            //}
        }
        
        return code;
    }
    //(this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && !this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName))
    public boolean isTranslatedAsSimpleSynchronized (String chanName) {
        if (this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
            	|| this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)
            	//|| this._envLoadingVisitor.getChanForcedInterleavingEnv().get(chanName) //No paralelismo com Renaming, isso cai fora
            	|| this._envLoadingVisitor.getChanDotFieldEnv().get(chanName)
        		//|| this._envLoadingVisitor.getChanExtChoiceEnv().get(chanName)
        		|| (this._envLoadingVisitor.getChanDimEnv().get(chanName) <= 0) || this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)) {
//!this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
        	return false;
        }
    	return true;
    }
    public int numberOfValuesComm (String chanName) {
        if (this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
            	|| this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)
            	//|| this._envLoadingVisitor.getChanForcedInterleavingEnv().get(chanName)
            	|| this._envLoadingVisitor.getChanDotFieldEnv().get(chanName)
            	//|| this._envLoadingVisitor.getChanExtChoiceEnv().get(chanName)
        ) {
        	return this._envLoadingVisitor.getChanDimEnv().get(chanName);
        }
    	return this._envLoadingVisitor.getChanDimEnv().get(chanName) + 1;
    }
    /**
     * Code for the body of a constructor in the GUI component.
     */
    private String chanAssignGuiCode(ProcessPara processParaMain) {
        String code = "";
        
        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();

        Iterator it = channelMSEnv.iteratorKeys();
        // for each channel
        while (it.hasNext()) {
            String channelName = (String) it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (/*!syncEnv.isSync() &&*/ !chanUseEnvHid.containsKey(channelName)) {
                // The channel does not take part in a parallelism, so it will
                // be in the graphical interface
            	if (this.prochid.get(processName).getCoadjChannels().contains(channelName)) {
            		code = code + "this." + channelName + " = " + channelName + ";";
            	}
            	/*else if (!fullparallelism) {
            		code = code + "this." + channelName + " = " + channelName + ";";            		
            	}*/
            	else {
            		Vector <String> coadjChannels = this.prochid.get(processName).reverseGet(channelName);
            		if (coadjChannels == null) {
            			System.out.print("");
            		}
            		else {
        				for (int i = 0; i < coadjChannels.size(); i++) {
            				code = code + "this." + coadjChannels.get(i) + " = " + coadjChannels.get(i) + ";";
        				}
            		}
            	}
            }
        }
        return code;
    }
    
    /**
     * Code for parameters in the constructor in a GUI component.
     */
    private String chanParamGuiCode(ProcessPara processParaMain) {
        String code = "";

        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);

        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();

        Iterator it = channelMSEnv.iteratorKeys();

        // for each channel
        while (it.hasNext()) {
            
            String channelName = (String) it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            
            if (/*!syncEnv.isSync() &&*/ !chanUseEnvHid.containsKey(channelName)) {
                
                // The channel does not take part in a parallelism, so it will
                // be in the graphical interface
                // And also it cannot be hidden, otherwise the gui cannot see it

            	//if (this.prochid.get(processName).getCoadjChannels().contains(channelName)) {
            	/*boolean parallelismBeingUsed = this.parallelismVisitor.parallelismBeingUsed;
            	int dim = 0;
            	if (parallelismBeingUsed) {
            		dim = this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get(channelName));
            	}
            	else {*/
            		int dim = this._envLoadingVisitor.getChanDimEnv().get(channelName);
            	//}
            	code = code + ", /*III*/"
            		+ Constants.CLS_GENCHAN + " "
            		+ CCUtil.bracketizeds(dim, "") + " " + channelName;
            	//}
            	/*else if (!fullparallelism) {
            		code = code + ", "
        			+ Constants.CLS_GENCHAN + " "
        			+ CCUtil.bracketizeds(this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get(channelName)), "") + " " + channelName;
            	}*/
            	/*else {
            		Vector <String> coadjChannels = this.prochid.get(processName).reverseGet(channelName);
            		if (coadjChannels == null)
            			System.out.print("");
            		else {
            			for (int i = 0; i < coadjChannels.size(); i++) {
            				code = code
            				+ ", "
            				+ Constants.CLS_GENCHAN 
            				+ " " 
            				+ CCUtil.bracketizeds(
            						this._envLoadingVisitor.getChanDimEnv().get(
            								channelName
            						), 
            					""
            					) 
            				+ " " 
            				+ coadjChannels.get(i);
            			}
            		}
            	}*/
            }
        }
        return code;
    }
    
    /**
     *
     */
    private String chanInitGuiCode(ProcessPara processParaMain) {
        String code = "";
        
        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        
        Iterator it = channelMSEnv.iteratorKeys();
        
        // for each channel
        while (it.hasNext()) {
            
            String channelName = (String) it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            
            if (/*!syncEnv.isSync() &&*/ !chanUseEnvHid.containsKey(channelName)) { //TODO descomentar isSync()?
                
                ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
                CircusType circusType = procChanEnv.getNameTypeEnv().getCircusType(channelName);
                
                /**
                 * Error when I try to use velocity:
                 * org.apache.velocity.exception.ParseErrorException: Encountered "java" at line 5, column 37.
                 * Was expecting one of:
                 * "," ...
                 * ")" ...
                 * at org.apache.velocity.Template.process(Template.java:141)
                 *
                 */
                if (circusType != null) {
                	if (circusType.isSyncType()) {
                    	if (!this.prochid.get(processName).getCoadjChannels().contains(channelName)) //"if" by Samuel Barrocas
                			code = code + "/*_A_*/" + initGuiChanSync(processName, channelName);
                    	else {
                    		code = code + "/*_B_*/" + initGuiChanSync(processName, this.prochid.get(processName).get(channelName));
                    	}
                	} else {
                		String commTypeName = circusType.getJavaCircusTypeName();
                    	if (!this.prochid.get(processName).getCoadjChannels().contains(channelName)) //"if" by Samuel Barrocas
                    		code = code + "/*_C_*/" + initGuiChanComm(processName, channelName, chanUse.toStringGUI(), 
                    			commTypeName);
                    	else {
                    		code = code + "/*_D_*/" + initGuiChanComm(processName, this.prochid.get(processName).get(channelName), chanUse.toStringGUI(), 
                        			commTypeName);
                    		//code = code + initGuiChanSync(this.hid.get(channelName));
                    	}
                	}
                }
            }
        }
        return code;
    }
    
    /**
     * Code for initialisation of the GUI components for a synchronisation channel.
     */
    private String initGuiChanSync(String processName, String chanName) {

        String code = "";
    	if (this.prochid.get(processName).getCoadjChannels().contains(chanName))
    		chanName = this.prochid.get(processName).get (chanName);
    	HiddenFromGUIInfo hie = this.prochid.get(processName);
        if (this.prochid.get(processName).getPutAtt(chanName) == false || !fullparallelism) {
        	this.prochid.get(processName).putPutAtt (chanName, true);
        	code += "\n\t\tbtn_" + chanName + " = new javax.swing.JButton(\"" + chanName + "\");";
        	code += "\n\t\tpanel_" + chanName + " = new javax.swing.JPanel();";
        	code += "\n\t\tbtn_" + chanName + ".addActionListener(new java.awt.event.ActionListener() {";
        	code += "\n\t\t\tpublic void actionPerformed(java.awt.event.ActionEvent evt) {";
        	code += "\n\t\t\t\tbtn_" + chanName + "_ActionPerformed(evt);";
        	code += "\n\t\t\t}";
        	code += "\n\t\t});";
        	//code += "\n\t\tthis.getContentPane().add(btn_" + chanName + ");";
        	code += "\n\t\tpanel_" + chanName + ".add(btn_" + chanName + ");";
        	code += "\n\t\tthis.getContentPane().add(panel_" + chanName + ");";
        	code += "\n\t\tthis.getContentPane().add(new javax.swing.JLabel(\"\"));";
        	//code += "\n\t\tthis.getContentPane().add(new javax.swing.JLabel(\"\"));";
        	//code += "\n\t\tthis.getContentPane().add(new javax.swing.JLabel(\"\"));";
        	code += "\n";
        }
        return code;
    }
    
    /**
     * Code for initialisation of the GUI components for a communication channel.
     */
    private String initGuiChanComm(String processName, String chanName, String chanType,
            String commType) {
        String code = "";
    	if (this.prochid.get(processName).getCoadjChannels().contains(chanName))
    		chanName = this.prochid.get(processName).get (chanName);
        if (this.prochid.get(processName).getPutAtt(chanName) == false) {
        	this.prochid.get(processName).putPutAtt(chanName, true);

        	code += "\n\t\tbtn_" + chanName +
                " = new javax.swing.JButton(\"" + chanName + "\");";
        	code += "\n\t\tcombo_" + chanName +
                " = instComboBoxes (" + numberOfValuesComm(chanName) /*this._envLoadingVisitor.getChanDimEnv().get(chanName)*/ + "); //Modificado por Samuel Barrocas (Sam's)"; //Sam's
        	code += "\n\t\tlbl_" + chanName +
                " = new javax.swing.JLabel(\"/*__*/" + chanType + ": " + commType +
                "\", SwingConstants.LEFT);";
        	code += "\n\t\tthis.btn_" + chanName + ".addActionListener(new java.awt.event.ActionListener() {";
        	code += "\n\t\t\tpublic void actionPerformed(java.awt.event.ActionEvent evt) {";
        	code += "\n\t\t\t\tbtn_" + chanName + "_ActionPerformed(evt);";
        	code += "\n\t\t\t}";
        	code += "\n\t\t});";
        	code += "\n";
        	code += "\n\t\tthis.panel_" + chanName + ".add(btn_" + chanName + ");";
        	code += "\n\t\tthis.panel_" + chanName + ".setLayout (new FlowLayout());";

        	code += "\n\t\tfor (int i = 0; i < " + numberOfValuesComm (chanName)/*this._envLoadingVisitor.getChanDimEnv().get(chanName)*/ + "; i++) { //Criado por Samuel Barrocas (Sam's)\n" +
        		"\t\t\tthis.panel_" + chanName + ".add(combo_" + chanName + " [i]);\n" +
        		"\t\t}\n";
        	code += "\t\tthis.getContentPane().add(panel_" + chanName + ");";
        	//code += "\n\t\tthis.getContentPane().add(lbl_" + chanName + ");";
        	code += "\n";
        }
        return code;
    }
        
    /**
     *
     */
    String currentProcess = ""; //Sam's
    private String chanActPerfGuiCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        currentProcess = processName; //Sam's
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        // for each channel
        while (it.hasNext()) {
            String channelName = (String) it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (!syncEnv.isSync() && !chanUseEnvHid.containsKey(channelName)) { //TODO descomentar isSync()?
                if (channelName.equals ("out")) {
                	syncEnv._out_ = true;
                }
                ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
                CircusType circusType = procChanEnv.getNameTypeEnv().getCircusType(channelName);
                // The channel does not take part in a parallelism, so it will
                // be in the graphical interface
                if (chanUse.equals(ChanUse.Input)) {
                	if (!this.prochid.get(processName).getCoadjChannels().contains(channelName)) { //By Samuel Barrocas
                		if (!this.prochid.get(processName).getPutActionPerformed (channelName)) {
                			code = code + chanActPerfWrite (processName, channelName, circusType);
                			this.prochid.get(processName).putPutActionPerformed (channelName, true);
                		}
                	}
                	else if (!fullparallelism) {
            			code = code + chanActPerfWrite (processName, channelName, circusType);
                	}
                	else {
                		if (!this.prochid.get(processName).getPutActionPerformed(this.prochid.get(processName).get(channelName))) {
                			code = code + chanActPerfWrite (processName, this.prochid.get(processName).get(channelName), circusType);
                			this.prochid.get(processName).putPutActionPerformed (this.prochid.get(processName).get(channelName), true);
                		}
                	}
                } else {
                	if (!this.prochid.get(processName).getCoadjChannels().contains (channelName)) { //By Samuel Barrocas
                		if (!this.prochid.get(processName).getPutActionPerformed (channelName)) {
                			code = code + chanActPerfRead (processName, channelName, circusType);
                			this.prochid.get(processName).putPutActionPerformed (channelName, true);
                		}
                	}
                	else if (!fullparallelism) {
            			code = code + chanActPerfRead (processName, channelName, circusType);
                	}
                	else {
                		if (!this.prochid.get(processName).getPutActionPerformed (this.prochid.get(processName).get(channelName))) {
                			code = code + chanActPerfRead (processName, this.prochid.get(processName).get(channelName), circusType);
                			this.prochid.get(processName).putPutActionPerformed (this.prochid.get(processName).get(channelName), true);
                		}
                	}
                }
            }
            else {
            	if (!this.prochid.get(processName).getCoadjChannels().contains(channelName)) { //By Samuel Barrocas
            		if (!this.prochid.get(processName).getPutActionPerformed (channelName)) {
            			code = code + chanActPerfCompl (processName, channelName);
            			this.prochid.get(processName).putPutActionPerformed (channelName, true);
            		}
            	}
            	else if (!fullparallelism) {
        			code = code + chanActPerfCompl (processName, channelName);
            	}
            	else {
            		if (!this.prochid.get(processName).getPutActionPerformed(this.prochid.get(processName).get(channelName))) {
            			code = code + chanActPerfCompl (processName, this.prochid.get(processName).get(channelName));
            			this.prochid.get(processName).putPutActionPerformed (this.prochid.get(processName).get(channelName), true);
            		}
            	}
            }
            /*else { //By Samuel Barrocas, 09/08(Agosto)/2011
                code += "\n\tprivate void btn_" + channelName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";
            	if (!useBarriers)
                    code += "\n\t\t" + channelName + ".read();";
        		else {
        			if (!this.prochid.get(processName).getMainChannels().contains(channelName)) //"if" by Samuel Barrocas
        				code += "\n\t\t" + channelName + ".timerSync(area);";
        			else {
        				Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(channelName);
                		code += HiddenFromGUIInfo.hiddenSyncCode(hiddenChannelsFromGui, "","timerSync (area)");
        			}
        		}
            	code += "\t\n}";
            }*/
        }
        
        return code;
    }
    
    /**
     *
     */
    private String chanActPerfCompl (String processName, String chanName) {
    	//JOptionPane.showMessageDialog (null, "PerfCompl");
        String code = "";
        code += "\n\tprivate void btn_" + chanName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";
		code +=	"\n\t\tfinal int [] values = getValues (" + "this.combo_" + chanName + ", boxcontent);\n";
		if (!(this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
        	|| this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)
        	|| this._envLoadingVisitor.getChanDotFieldEnv().get(chanName)
        	|| this._envLoadingVisitor.getChanExtChoiceEnv().get(chanName)
        	|| (this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)))
		) {
			if (!this.prochid.get(processName).getMainChannels().contains(chanName))
				code += "\n\t\t" + chanName + bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName) - 1) + ".guiTimerSimpleWrite (values " + guibracketized(this._envLoadingVisitor.getChanDimEnv().get(chanName)) + ", area);";
			else {
        		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
        		code +=
        			HiddenFromGUIInfo.hiddenSyncCode(
        				hiddenChannelsFromGui,
        				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
        				"guiTimerSimpleWrite (values " + guibracketized(this._envLoadingVisitor.getChanDimEnv().get(chanName)) + ", area)");
			}
		}
		else {
			if (this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)) {
            	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
            		code += "\n\t\t" + chanName +
            			ccBracketizedsValues (
            				this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get(chanName)),
            				chanName/*this.prochid.get(processName).get(chanName)*/
            			) + ".timerSync(area);";
            	else {
            		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
            		code +=
            			HiddenFromGUIInfo.hiddenSyncCode(
            				hiddenChannelsFromGui,
            				ccBracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName), chanName),
            				"timerSync (area)");
            	}
			}
			else {
            	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
            		code += "\n\t\t" + chanName +
            			bracketizedsValues (
            				this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get(chanName))) + ".timerSync(area);";
            	else {
            		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
            		code +=
            			HiddenFromGUIInfo.hiddenSyncCode(
            				hiddenChannelsFromGui,
            				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
            				"timerSync (area)");
            	}
			}
		}
        code += "\n\t}";
        return code;
	}
    private String chanActPerfWrite(String processName, String chanName, CircusType circusType) {
    	//JOptionPane.showMessageDialog (null, "PerfWrite");
        String code = "";
        code += "\n\tprivate void btn_" + chanName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";
        if (circusType != null) {
        	if (circusType.isSyncType()) {
        		if (!useBarriers)
        			code += "\n\t\t" + chanName + ".write(null);";
        		else {
        			if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
        				code += "\n\t\t" + chanName + ".timerSync (area);/*.sync()*/;";
        			else {
        				Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                		code += HiddenFromGUIInfo.hiddenSyncCode(hiddenChannelsFromGui, "","timerSync (area)");
        			}
        		}
        	} 
        	else {
        		String chanCommType = circusType.getJavaCircusTypeName();
        		if (!useBarriers) {
        			code += "\n\t\tString st = this.txt_" + chanName + ".getText();\n";
        			code += "\n\t\t" + chanCommType + " o = new " + chanCommType + " (st);";
        			code += "\n\t\t" + chanName + ".write(o);";
        		}
        		else {
        			code +=	"\n\t\tfinal int [] values = getValues (" + "this.combo_" + chanName + ", boxcontent);\n";
        			if (!(this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
                    	|| this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)
                    	|| this._envLoadingVisitor.getChanDotFieldEnv().get(chanName)
                    	|| this._envLoadingVisitor.getChanExtChoiceEnv().get(chanName)
                    	|| (this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)))
        			) {
        				if (!this.prochid.get(processName).getMainChannels().contains(chanName))
        					code += "\n\t\t" + chanName + bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName) - 1) + ".guiTimerSimpleWrite (values " + guibracketized(this._envLoadingVisitor.getChanDimEnv().get(chanName)) + ", area);";
        				else {
                    		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                    		code +=
                    			HiddenFromGUIInfo.hiddenSyncCode(
                    				hiddenChannelsFromGui,
                    				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
                    				"guiTimerSimpleWrite (values " + guibracketized(this._envLoadingVisitor.getChanDimEnv().get(chanName)) + ", area)");
        				}
        			}
        			else {
        				if (this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)) {
                        	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
                        		code += "\n\t\t" + chanName +
                        			ccBracketizedsValues (
                        				this._envLoadingVisitor.getChanDimEnv().get(chanName/*this.prochid.get(processName).get(chanName)*/),
                        				chanName/*this.prochid.get(processName).get(chanName)*/
                        			) + ".timerSync(area); /*1*/";
                        	else {
                        		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                        		code +=
                        			HiddenFromGUIInfo.hiddenSyncCode(
                        				hiddenChannelsFromGui,
                        				ccBracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName), chanName),
                        				"timerSync (area)/*2*/");
                        	}
        				}
        				else {
                        	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
                        		code += "\n\t\t" + chanName +
                        			bracketizedsValues (
                        				this._envLoadingVisitor.getChanDimEnv().get(chanName/*this.prochid.get(processName).get(chanName)*/)) + ".timerSync(area);/*3*/";
                        	else {
                        		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                        		code +=
                        			HiddenFromGUIInfo.hiddenSyncCode(
                        				hiddenChannelsFromGui,
                        				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
                        				"timerSync (area)/*4*/");
                        	}
        				}
        			}
        		}
        	}
        }
        code += "\n\t}";
        return code;
    }
	public static String guibracketized (Object value) {
		Integer i = (Integer) value;
		return "[" + ((Integer) value < 0? 0 : value) + "]";
	}

    public String bracketizedsValues (int x) { //Developed by Samuel Barrocas
    	String str = "";
    	for (int i = 0; i < x; i++) {
    		str = str + CCUtil.bracketized ("values [" + i + "]");
    	}
    	return str;
    }

    public String ccBracketizedsValues (int x, String chanName) { //Developed by Samuel Barrocas
    	String str = "";
    	for (int i = 0; i < x; i++) {
    		str = str +
    		CCUtil.bracketized ("(new Abs_" + chanName/*currentProcess*/ + " ()).abs (\"" + chanName + "\", " + i + ", new BigInteger (\"\" + values [" + i + "] + \"\"))");
    	}
    	return str;
    }
    
    /**
     *
     */
    private String chanActPerfRead(String processName, String chanName, CircusType circusType) {

        String code = "";
        //JOptionPane.showMessageDialog (null, "Passou por Translator2Java.chanActPerfRead");
        code += "\n\tprivate void btn_" + chanName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";

        if (circusType.isSyncType()) { //AQUI � UM IF QUE EXECUTA O BLOCO ABAIXO SE O CANAL EM QUEST�O N�O COMUNICA VALORES
        	if (!useBarriers)
                code += "\n\t\t" + chanName + ".read();";
    		else {
    			if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
    				code += "\n\t\t" + chanName + ".timerSync(area);/*.sync()*/;";
    			else {
    				Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
            		code += HiddenFromGUIInfo.hiddenSyncCode(hiddenChannelsFromGui, "","timerSync (area)");
    			}
    		}
        } else {
            if (!useBarriers) {
            	String chanCommType = circusType.getJavaCircusTypeName();
            	code += "\n\t\t" + chanCommType + " o = (" + chanCommType + ") " + chanName + ".read();";
            	code += "\n\t\tString st = o.toString();";
            	code += "\n\t\tthis.txt_" + chanName + ".setText(st);";
            }
            else {
                code +=	"\n\t\tint [] values = getValues (" + "this.combo_" + chanName + ", boxcontent);\n";
                if (!(this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
                	|| this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)
                	//|| this._envLoadingVisitor.getChanForcedInterleavingEnv().get(chanName)
                	|| this._envLoadingVisitor.getChanDotFieldEnv().get(chanName)
                	|| this._envLoadingVisitor.getChanExtChoiceEnv().get(chanName)
                	|| (this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)))
                ) {
                	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) { //"if" by Samuel Barrocas
                		code += "\n\t\tint x = (Integer) " + chanName + bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName) - 1) + ".guiTimerSimpleRead (area);";
                		code += "\n\t\t/*System.out.println (x);*/";
                	}
                	else {
                		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                		code +=
                			HiddenFromGUIInfo.hiddenSyncCode(
                				hiddenChannelsFromGui,
                				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
                				"guiTimerSimpleRead (area)");
                		code += "\n\t\t/*System.out.println (x);*/";
                	}
                }
                else {
                	if (this._envLoadingVisitor.getChanComplexCommEnv().get(chanName)) {
                    	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
                    		code += "\n\t\t" + chanName +
                    			ccBracketizedsValues (
                    				this._envLoadingVisitor.getChanDimEnv().get(this.prochid.get(processName).get(chanName)), 
                    				chanName/*this.prochid.get(processName).get(chanName)*/
                    			) + ".timerSync(area);";
                    	else {
                    		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                    		code +=
                    			HiddenFromGUIInfo.hiddenSyncCode(
                    				hiddenChannelsFromGui,
                    				ccBracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName), chanName),
                    				"timerSync (area)");
                    	}
                	}
                	else {
                    	if (!this.prochid.get(processName).getMainChannels().contains(chanName)) //"if" by Samuel Barrocas
                    		code += "\n\t\t" + chanName +
                    			bracketizedsValues 
                    				(this._envLoadingVisitor.getChanDimEnv().get(
                    						this.prochid.get(processName).get(chanName)
                    				)) + ".timerSync(area);";
                    	else {
                    		Vector <String> hiddenChannelsFromGui = this.prochid.get(processName).reverseGet(chanName);
                    		code +=
                    			HiddenFromGUIInfo.hiddenSyncCode(
                    				hiddenChannelsFromGui,
                    				bracketizedsValues (this._envLoadingVisitor.getChanDimEnv().get(chanName)),
                    				"timerSync (area)");
                    	}
                	}
                }
            }
        }
        code += "\n\t}";
        
        return code;
    }
    
    /**
     * Creates the .bat file for a process.
     */
    private void createBatFile(ProcInfo procInfo) throws JCircusException {
        
        String processName = procInfo.getProcessName();
        
        // File from template
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Constants.C_BAT_PROJ, _projectName);
        map.put(Constants.C_BAT_MAIN, getNameMain(processName));
        
        try {
            
            String fileName = _projectDir + "\\" + getNameBat(processName) + ".bat";
            Util.createFileFromTemplate(Constants.TMP_BAT, map, fileName);
            
        } catch (Throwable t) {
            throw new JCircusException("Error while trying to create .bat file for " +
                    processName, t);
        }
    }
    
    /*******************************************
     * Simple accessors.
     *******************************************/
    
    /**
     * Code for package declaration.
     */
    public String getPackage(String projectName, String pkg,
    		/*Par�metro acrescentado por Samuel*/String compl) {
        String code = "";

        code = "package ";
        if (!_compl.equals ("")) {
        	//code = code + compl + "."; 
        }
        code = code + projectName + "." + "src." + projectName;
        if (pkg != null) {
            code += "." + pkg;
        }
        code += ";\n\n /**/";
        
        return code;
    }
    
    /**
     * Code for imports of a class.
     */
    
    /*M�todo abaixo acrescentado por Samuel*/
    public String getCompl () {
    	if (_compl == null) {
    		return "";
    	}
    	else return "/*" + _compl + ".*/paper.";
    }
    /*M�todo acima acrescentado por Samuel*/
        
    public String getImports(String projectName) {
        
        String code = "/**/\n";
        
        code += "import java.util.*;\nimport org.jcsp.lang.*;\n\n";
        
        code += "import " + /*getCompl () + */ projectName + "." + "src." + projectName + ".axiomaticDefinitions.*;\n";
        code += "import " + /*getCompl () + */ projectName + "." + "src." + projectName + ".processes.*;\n";
        code += "import " + /*getCompl () + */ projectName + "." + "src." + projectName + ".typing.*;\n";
        code += "import " + /*getCompl () + */ projectName + "." + "src." + projectName + ".channels.*;\n";
        code += "import " + /*getCompl () + */ projectName + "." + "src." + projectName + ".ccmaps.*;\n";
        code += "import newjcircusutil." + Constants.CLS_RANGEN + ";\n";
        code += "import newjcircusutil.multisync.*;\n";
        code += "import " + /*getCompl () +*/ projectName + "." + "src." + projectName + ".gui.*;\n";
        
        return code;
    }
    
    /**
     * Returns the name of the GUI class.
     */
    private String getNameGui(String processName) {
        return "Gui_" + processName;
    }
    
    /**
     * Returns the name of the .bat file.
     */
    private String getNameBat(String processName) {
        return "Run_" + processName;
    }
    
    /**
     * Returns the name of the Main class.
     */
    private String getNameMain(String processName) {
        return "Main_" + processName;
    }
    
    /**
     * Gets the parameters of a parameterized process in a list of VarDecl.
     *
     */
    private List<VarDecl> getNormalizedParams(CircusProcess circusProcess) {
        
        Factory factory = new Factory();
        List<VarDecl> normParams = new ArrayList();
        
        if (circusProcess instanceof ParamProcess) {

            DeclList/*ListTerm*/ decls = ((ParamProcess) circusProcess)/*.getDecl()*/.getDeclList();
            //normParams = Util.formatDecls(decls); //By Angela, abaixo by Sam
            normParams = Util.formatDecls((ZDeclList) decls); //Sam's, modified from do de cima, n� Joel?
        }
        return normParams;
    }

    /**
     * Public Getters.
     */
    public List<ProcInfo> getProcInfoList() {
        return _procInfoList;
    }
    
    public Environment getEnvironment() {
        return _environment;
    }
    
}

