package jcircus.parallelism;

import java.util.HashMap;
import java.util.LinkedHashMap;

import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.RenameAction;
import net.sourceforge.czt.circus.impl.ExtChoiceActionImpl;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;

public class RenamingUtil { //Maps a channel name to its new name, when a renaming occurs in the specification
	private HashMap <String, String> map;
	public RenamingUtil () {
		map = new LinkedHashMap <String, String> ();
	}
	public void merge (HashMap <String, String> map2) {
		map.putAll(map2);
	}
	public void put (String name1, String name2) {
		map.put(name1, name2);
	}
	public static String [] indFromTo (int x, int y, String [] znl) {
		int r1 = x, r2 = y - x + 1, counter = 0;
		String [] z = new String [r2];
		for (int i = r1; i < r2; i++) {
			z[i] = znl [counter];
			counter++;
		}
		return z;
	}
	public static PrefixingAction prefixingActionWithRenamedComm (PrefixingAction pa, String str, CircusAction action, CircusProcess process, HashMap <String, FriendshipSets> spfemap, String actionParaName, ZParaList paraList) {
		Factory f = new Factory();
		Communication c = pa.getCommunication();
		Communication c2 = f.createCommunication(
				f.createRefExpr(f.createZName(c.getChannelExpr().getName().toString())),
				f.createCircusFieldList(c.getCircusFieldList()),
				c.getCommUsage(),
				c.getCommPattern(),
				c.getMultiSych(),
				c.getIndexed());
		PrefixingAction pa2 = f.createPrefixingAction(
				/*pa.getCircusAction()*/
				ParallelismVisitor.updatedParAction (pa.getCircusAction(), process, spfemap, actionParaName, paraList), c2);
        String name = pa.getCommunication().getChannelExpr().getName().toString();
        pa2.getCommunication().getChannelExpr().setName(f.createZName (str));
        return pa2;
	}
	/*public static CircusAction makeTheRenaming (RenameAction renameAction) { //TODO TERMINAR DE IMPLEMENTAR, E TESTAR
		CircusAction action = renameAction.getCircusAction();
		AssignmentPairs assignPairs = renameAction.getAssignmentPairs();
		NameList lhs = assignPairs.getLHS();
		ExprList rhs = assignPairs.getRHS();
	}*/
	public static CircusAction prefActToExtChoiceActWithRenamedComms (PrefixingAction pa, String [] znl, CircusAction action, CircusProcess process, HashMap <String, FriendshipSets> spfemap, String actionParaName, ZParaList paraList) { //TODO TESTAR
		int length = znl.length;
		if (length == 1) {
			return prefixingActionWithRenamedComm (pa, znl [0], action, process, spfemap, actionParaName, paraList);
		}
		if (length == 0) {
			return pa;
		}
		else {
			Factory f = new Factory ();
			ExtChoiceActionImpl eca = (ExtChoiceActionImpl) f.createExtChoiceAction();
			eca.setLeftAction (prefActToExtChoiceActWithRenamedComms (pa, indFromTo (0, length - 2, znl), action, process, spfemap, actionParaName, paraList));
			eca.setRightAction (prefixingActionWithRenamedComm (pa, znl [length - 1], action, process, spfemap, actionParaName, paraList));
			return eca;
		}
	}
	//public static 
}
