package jcircus.parallelism;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jcircus.util.SignatureExpression;

import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CircusStateAnn;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.OnTheFlyDefAnn;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.Process1;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.ZSignatureList;
import net.sourceforge.czt.circus.impl.BasicProcessImpl;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NarrSect;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.ast.ZSect;

public class ParallelismProcessUtil {
	static Factory f = new Factory ();
	static ParallelismFactory pf = new ParallelismFactory ();
	
	public static CircusProcess getContentOfCallProcess (CallProcess cp, Spec spec) {
		String processName = cp.getCallExpr().getZName().toString();
		CircusProcess callProcess = null;
		ZSect zSect;
    	if (spec.getSect().get(0) instanceof NarrSect)
    		zSect = (ZSect) spec.getSect().get(1);
    	else
    		zSect = (ZSect) spec.getSect().get(0);
        ZParaList paras = (ZParaList) zSect.getParaList();
		for (int i = 0; i < paras.size(); i++) {
			if (paras.get(i) instanceof ProcessPara) {
            	ProcessPara para = (ProcessPara) paras.get(i);
            	if (para.getName().toString().equals(processName)) {
            		callProcess = /*((ProcessPara)para).getCircusProcess();*/ pf.createCircusProcess(((ProcessPara)para).getCircusProcess());
            	}
			}
        }
		if (callProcess == null) {
			try {
				throw new Exception ("Action " + processName + " was not found on process");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return callProcess;
	}
	public static AxPara unifyCircusStates (AxPara sp1, AxPara sp2) { //TODO N�O TESTADO!!!!!!
		AxPara newPara = f.createAxPara();
		//if (sp1.getAnn(CircusStateAnn.class) != null && sp2.getAnn(CircusStateAnn.class) != null) {
			//sp1.
			ZSchText st1 = sp1.getZSchText();
			ZSchText st2 = sp2.getZSchText();
			ZDeclList decllist1 = st1.getZDeclList();
			ZNameList namelist1 = sp1.getZNameList();
			ZNameList namelist2 = sp2.getZNameList();
			ZDeclList decllist2 = st2.getZDeclList();
			newPara.setBox(sp1.getBox());
			namelist1.addAll(namelist2);
			decllist1.addAll(decllist2);
			newPara.setNameList(namelist1); //como demos um addAll(decllist2), � como se ele tivesse acrescentando as duas listas
			ZSchText zschtext = f.createZSchText();
			zschtext.setDeclList(decllist1);
			AndPred andPred = f.createAndPred();
			andPred.setLeftPred(st1.getPred());
			andPred.setRightPred(st2.getPred());
			zschtext.setPred(andPred);
			newPara.setSchText(zschtext);
		//}
		/*else {
			try {
				throw new Exception ("N�o � StatePara");
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}*/
		return newPara;
	}
	public static AxPara createValidState () { //TODO N�O TESTADO!!!!!!
		CircusStateAnn csa = f.createCircusStateAnn(); //Assinatura que deve ser colocada em 
		AxPara newPara = f.createAxPara();
		newPara.setBox(Box.OmitBox);
		ZSchText axParaSchText = f.createZSchText();
		//NameTypePair ntp = f.createNameTypePair();
		//ntp.setName(arg0);
		//ntp.setType(arg0);
		
		ZSignatureList siglist = f.createZSignatureList();//f.createSignature(nameTypePair);
		siglist.add(f.createSignature());
		//axparaschtextdecllist.add(f.createSignature());
		axParaSchText.setDeclList(f.createZDeclList());
		//axParaSchText.getZDeclList().addAll(axparaschtextdecllist);
		

		SchExpr schExpr = f.createSchExpr();
		ZSchText exprSchText = f.createZSchText();
		//exprSchText.getAnns().add(f.createSignatureAnn());
		exprSchText.setDeclList (f.createZDeclList());
		exprSchText.setPred (f.createTruePred());
		schExpr.setSchText(exprSchText);
		schExpr.getAnns().add(f.createSignatureAnn());
		ConstDecl constDecl = f.createConstDecl(f.createZName("$$defaultSt"), schExpr);

		axParaSchText.getZDeclList().add(constDecl);
		/*ZDeclList decllist1 = f.createZDeclList();
		ZNameList namelist1 = f.createZNameList();
		namelist1.add(f.createZName("$$defaultSt"));
		newPara.setBox(Box.OmitBox);*/
		newPara.setNameList(f.createZNameList()); //como demos um addAll(decllist2), � como se ele tivesse acrescentando as duas listas
		/*ZSchText zschtext = f.createZSchText();
		zschtext.setDeclList(f.createZDeclList());
		TruePred truePred = f.createTruePred();
		zschtext.setPred(truePred);
		zschtext.getAnns().add(f.createSignatureAnn());*/
		

		//decllist1.add(constDecl);
		newPara.setSchText(axParaSchText);
		AxPara statePara = newPara;
		statePara.getAnns().add(csa);
		return statePara;
	}

	public static AxPara allStatesUnified (CircusProcess process, Spec spec) { //TODO N�O TESTADO!!!!!!!!!
		Factory f = new Factory ();
		if (process instanceof BasicProcess) {
			if (((BasicProcess)process).getStatePara() != null) {
				ZSchText sch = f.createZSchText();
				ZDeclList decllist = f.createZDeclList();
				ZNameList namelist = f.createZNameList();
				ZSchText zschtext = f.createZSchText();
				zschtext.setDeclList(decllist);
				//AndPred pred = f.createAndPred();
				zschtext.setPred(f.createExprPred());
				AxPara ax = f.createAxPara();
				ax.setBox(Box.AxBox);
				ax.setNameList(f.createZNameList());
				ax.setSchText(zschtext);
				return ax;
			}
			return ((BasicProcess)process).getStatePara();
		}
		else if (process instanceof ParamProcess) {
			return allStatesUnified (((ParamProcess)process).getCircusBasicProcess(), spec);
		}
		else if (process instanceof Process1) {
			if (process instanceof CallProcess) {
				return allStatesUnified (getContentOfCallProcess ((CallProcess)process, spec), spec);
			}
			else {
				return allStatesUnified (((ParamProcess)process).getCircusProcess(), spec);
			}
		}
		else if (process instanceof Process2) {
			CircusProcess left = ((Process2)process).getLeftProcess();
			CircusProcess right = ((Process2)process).getRightProcess();
			AxPara stateleft = allStatesUnified (left, spec);
			AxPara stateright = allStatesUnified (right, spec);
			return unifyCircusStates (stateleft, stateright);
		}
		else {
			return f.createAxPara();
		}		
	}

	public static ZParaList actionParagraphs (CircusProcess process, Spec spec) { //TODO NÃO TESTADO!!!!! //Retorna os parágrafos do processo, exceto o do estado
		Factory f = new Factory ();
		if (process instanceof BasicProcess) {
			ZParaList finallist = f.createZParaList();
			ZParaList paras = ((BasicProcess)process).getZParaList();
			int size = paras.size();
			for (int i = 0; i < size; i++) {
				Para para = paras.get(i);
				if (para.getAnn(CircusStateAnn.class) == null && para instanceof ActionPara) {
					if (((ActionPara)para).getName().toString().contains("Previous"))
						finallist.add(para);
				}
			}
			return finallist;
		}
		else if (process instanceof ParamProcess) {
			return actionParagraphs (((ParamProcess)process).getCircusBasicProcess(), spec);
		}
		else if (process instanceof CallProcess) {
			CallProcess call = (CallProcess)process;
			CircusProcess cp = getContentOfCallProcess (call, spec);
			return actionParagraphs (getContentOfCallProcess (call, spec), spec);
		}
		else if (process instanceof Process1) {
			//else {
				return actionParagraphs (((Process1)process).getCircusProcess(), spec);
			//}
		}
		else if (process instanceof Process2) {
			Process2 process2 = (Process2) process;
			ZParaList finallist = actionParagraphs (process2.getLeftProcess(), spec);
			finallist.addAll(actionParagraphs (process2.getRightProcess(), spec));
			return finallist;
		}
		else {
			return f.createZParaList();
		}
	}

	/*public ZParaList unifyParagraphs (ZParaList pl1, ZParaList pl2) { //TODO N�O TESTADO
		Factory f = new Factory ();
		ZParaList finallist = f.createZParaList();
		int size1 = pl1.size();
		int size2 = pl2.size();
		for (int i = 0; i < size1; i++) {
			Para para = pl1.get(i);
			if (para.getAnn(CircusStateAnn.class) == null) {
				finallist.add(para);
			}
		}
		for (int i = 0; i < size2; i++) {
			Para para = pl2.get(i);
			if (para.getAnn(CircusStateAnn.class) == null) {
				finallist.add(para);
			}
		}
		return finallist;
	}*/
	
	private static CircusAction getPreviousMainAction (BasicProcess basic) {
		ZParaList paras = basic.getZParaList();
		CircusAction action = f.createSkipAction();
		for (int i = 0; i < paras.size(); i++) {
			Para para = paras.get(i);
			if (para instanceof ActionPara) {
				if (((ActionPara)para).getName().toString().contains("Previous") && ((ActionPara)para).getName().toString().contains("MA")) {
					action = ((ActionPara)para).getCircusAction();
				}
			}
		}
		return action;
	}
	public static CircusAction resultingMainAction2 (CircusProcess process, Spec spec) {
		Factory f = new Factory ();
		if (process instanceof BasicProcess) {
			CircusAction action = ((BasicProcess)process).getMainAction();//((BasicProcess)process).getMainAction();
			return action;
		}
		else if (process instanceof ParamProcess) {
			CircusAction action = ((ParamProcess)process).getCircusBasicProcess().getMainAction();
			return action;
		}
		else if (process instanceof ExtChoiceProcess) {
			ExtChoiceProcess ecp = (ExtChoiceProcess)process;
			ExtChoiceAction eca = f.createExtChoiceAction();
			eca.setLeftAction (resultingMainAction2 (ecp.getLeftProcess(), spec));
			eca.setRightAction (resultingMainAction2 (ecp.getRightProcess(), spec));
			return eca;
		}
		else if (process instanceof IntChoiceProcess) {
			IntChoiceProcess ecp = (IntChoiceProcess)process;
			IntChoiceAction eca = f.createIntChoiceAction();
			eca.setLeftAction (resultingMainAction2 (ecp.getLeftProcess(), spec));
			eca.setRightAction (resultingMainAction2 (ecp.getRightProcess(), spec));
			return eca;
		}
		else if (process instanceof ParallelProcess) {
			ParallelProcess pp = (ParallelProcess)process;
			ParallelAction pa = f.createParallelAction();
			pa.setLeftAction (resultingMainAction2 (pp.getLeftProcess(), spec));
			pa.setRightAction (resultingMainAction2 (pp.getRightProcess(), spec));
			pa.setChannelSet(pp.getChannelSet());
			pa.setLeftNameSet(f.createCircusNameSet());
			pa.setRightNameSet(f.createCircusNameSet());
			return pa;
		}
		else if (process instanceof InterleaveProcess) {
			InterleaveProcess pp = (InterleaveProcess)process;
			InterleaveAction pa = f.createInterleaveAction();
			pa.setLeftAction (resultingMainAction2 (pp.getLeftProcess(), spec));
			pa.setRightAction (resultingMainAction2 (pp.getRightProcess(), spec));
			pa.setLeftNameSet(f.createCircusNameSet());
			pa.setRightNameSet(f.createCircusNameSet());
			return pa;			
		}
		else if (process instanceof CallProcess) {
			ZExprList paramExprs = (ZExprList) ((CallProcess)process).getActuals();
			CircusProcess content = getContentOfCallProcess ((CallProcess)process, spec);
			CircusAction resultingMainAction = pf.createCircusAction(resultingMainAction2 (content, spec));
			CircusAction resultingMainActionAux = pf.createCircusAction (resultingMainAction);
			List <VarDecl> vardecls = new ArrayList <VarDecl> ();
			if (content instanceof ParamProcess) {
				ZDeclList decls = f.createZDeclList (((ParamProcess)content).getZDeclList());
				for (int i = 0; i < decls.size(); i++) {
					Decl decl = decls.get(i);
					if (decl instanceof VarDecl) {
						vardecls.add((VarDecl)decl);
					}
				}
				resultingMainActionAux = pf.createCircusAction (ParamProcessUtil.updatedExpression (vardecls, paramExprs, resultingMainAction));
			}
			return resultingMainActionAux;
		}
		else {
			return f.createSkipAction();
		}
	}
	
	public static CircusAction resultingMainAction (CircusProcess process, Spec spec) {
		Factory f = new Factory ();
		if (process instanceof BasicProcess) {
			CircusAction action = getPreviousMainAction ((BasicProcess)process);//((BasicProcess)process).getMainAction();
			return action;
		}
		else if (process instanceof ParamProcess) {
			CircusAction action = getPreviousMainAction (((ParamProcess)process).getCircusBasicProcess());
			return action;
		}
		else if (process instanceof ExtChoiceProcess) {
			ExtChoiceProcess ecp = (ExtChoiceProcess)process;
			ExtChoiceAction eca = f.createExtChoiceAction();
			eca.setLeftAction (resultingMainAction (ecp.getLeftProcess(), spec));
			eca.setRightAction (resultingMainAction (ecp.getRightProcess(), spec));
			return eca;
		}
		else if (process instanceof IntChoiceProcess) {
			IntChoiceProcess ecp = (IntChoiceProcess)process;
			IntChoiceAction eca = f.createIntChoiceAction();
			eca.setLeftAction (resultingMainAction (ecp.getLeftProcess(), spec));
			eca.setRightAction (resultingMainAction (ecp.getRightProcess(), spec));
			return eca;
		}
		else if (process instanceof ParallelProcess) {
			ParallelProcess pp = (ParallelProcess)process;
			ParallelAction pa = f.createParallelAction();
			pa.setLeftAction (resultingMainAction (pp.getLeftProcess(), spec));
			pa.setRightAction (resultingMainAction (pp.getRightProcess(), spec));
			pa.setChannelSet(pp.getChannelSet());
			pa.setLeftNameSet(f.createCircusNameSet());
			pa.setRightNameSet(f.createCircusNameSet());
			return pa;
		}
		else if (process instanceof InterleaveProcess) {
			InterleaveProcess pp = (InterleaveProcess)process;
			InterleaveAction pa = f.createInterleaveAction();
			pa.setLeftAction (resultingMainAction (pp.getLeftProcess(), spec));
			pa.setRightAction (resultingMainAction (pp.getRightProcess(), spec));
			pa.setLeftNameSet(f.createCircusNameSet());
			pa.setRightNameSet(f.createCircusNameSet());
			return pa;			
		}
		else if (process instanceof CallProcess) {
			ZExprList paramExprs = (ZExprList) ((CallProcess)process).getActuals();
			CircusProcess content = getContentOfCallProcess ((CallProcess)process, spec);
			CircusAction resultingMainAction = pf.createCircusAction(resultingMainAction (content, spec));
			CircusAction resultingMainActionAux = pf.createCircusAction (resultingMainAction);
			List <VarDecl> vardecls = new ArrayList <VarDecl> ();
			if (content instanceof ParamProcess) {
				ZDeclList decls = f.createZDeclList (((ParamProcess)content).getZDeclList());
				for (int i = 0; i < decls.size(); i++) {
					Decl decl = decls.get(i);
					if (decl instanceof VarDecl) {
						vardecls.add((VarDecl)decl);
					}
				}
				resultingMainActionAux = pf.createCircusAction (ParamProcessUtil.updatedExpression (vardecls, paramExprs, resultingMainAction));
			}
			return resultingMainActionAux;
		}
		else {
			return f.createSkipAction();
		}
	}
	public static void setValidMainAction (CircusAction action, BasicProcess process) {
		ZParaList paras = process.getZParaList();
		ActionPara actionPara = f.createActionPara();

		actionPara.setName(f.createZName("Not initialized"));

		for (int i = 0; i < paras.size(); i++) {
			Para para = paras.get(i);
			if (para instanceof ActionPara) {
				ActionPara actionPara2 = (ActionPara)para;
				if (actionPara2.getName().toString().contains("mainAction") && !actionPara2.getName().toString().contains("Previous")) {
					ActionPara actPara = (ActionPara)paras.get(i);
					actPara.setCircusAction(action);
					paras.set(i, actPara);
					//parasOTF.
				}
			}
		}
		if (actionPara.getName().toString().equals ("Not initialized")) { //BLOCO DE C�DIGO N�O VISITADO POR TESTENEWPAR
			ActionPara mainPara = f.createActionPara();
			mainPara.setName(f.createZName("$$mainAction"));
			mainPara.setCircusAction(action);
			OnTheFlyDefAnn otfda = f.createOnTheFlyDefAnn();
			mainPara.getAnns().add(otfda);
			process.getZParaList().add(mainPara);
			ZNameList znl = f.createZNameList();

			//System.out.println ("Valid? " + process.isMainActionValid());
			//((ZParaList)process.getLocalPara()).add(mainPara);
			System.out.print("");
		}
	}
	/*public static void setStatePara (AxPara ax, BasicProcess process) { //TODO N�O TESTADO!!!!!!!!
		ZParaList paras = process.getZParaList();
		for (int i = 0; i < paras.size(); i++) {
			if (paras.get(i) instanceof AxPara) {
				AxPara axPara = (AxPara)paras.get(i);
				if (axPara.equals(process.getStatePara())) {
					paras.set(i, ax);
				}
			}
		}
	}*/
	public static CircusProcess transformToBasicProcess (CircusProcess process, Spec spec) {
		if (process instanceof BasicProcess) {
			return (BasicProcess)process;
		}
		else if (process instanceof ParamProcess) {
			return ((ParamProcess)process);/*.getCircusBasicProcess()*/
		}
		Factory f = new Factory ();
		BasicProcess basic = f.createBasicProcess();

		//AxPara state = allStatesUnified (process, spec);
		AxPara state = createValidState();
		ZParaList paras = actionParagraphs (process, spec);
		paras.add(state);
		basic.setParaList(paras);

		//((ZParaList)basic.getLocalPara()).addAll(paras);
		//((ZParaList)basic.getOnTheFlyPara()).addAll(paras);
		CircusAction mainAction = resultingMainAction (process, spec);
		//setStatePara (state, basic);
		setValidMainAction (mainAction, basic);
		return basic;
	}
}
