package jcircus.parallelism;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.RenameAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZParaList;

public class CallUtil {
	static ParallelismFactory pf = new ParallelismFactory ();
	
	public static void transformAction () {
		
	}

	public CircusAction transformCallActionsIntoRealActions (CircusAction action, CircusProcess process) {
		if (action instanceof CallAction) {
			return getContentOfCallAction (((CallAction)action), process);
		}
		else if (action instanceof Action2) {
			((Action2)action).setLeftAction(transformCallActionsIntoRealActions (((Action2)action).getLeftAction(), process));
			((Action2)action).setRightAction(transformCallActionsIntoRealActions (((Action2)action).getRightAction(), process));
			return action;
		}
		else return action;
	}

	private static void transformToMuAction (CircusAction action) {
		
	}

	private static Vector <String> callsWithoutDuplicates (Vector <String> callsvec) {
		Vector <String> callsvec2 = new Vector <String> ();
		for (int i = 0; i < callsvec.size(); i++) {
			if (!callsvec2.contains(callsvec.elementAt(i)))
				callsvec2.add(callsvec.elementAt(i));
		}
		return callsvec2;
	}
	public static Vector <String> recursiveCalls (CircusProcess process) {
		Vector <String> callsvecRec = new Vector <String> ();
/*		Vector <String> callsvec2 = new Vector <String> ();
		Vector <String> callsvec = new Vector <String> ();
		callsvec.addAll(calls (action, process, new Vector <String> ()));
		callsvec2.addAll(callsWithoutDuplicates (callsvec));
*/
		Vector <String> actionParaNames = new Vector <String> ();
		BasicProcess bp;
		if (process instanceof ParamProcess) {
			bp = ((ParamProcess)process).getCircusBasicProcess();
		}
		else {
			bp = (BasicProcess)process;
		}
		ZParaList paras = bp.getZParaList();
		Vector <String> alreadySeen;
		for (int i = 0; i < paras.size(); i++) {
			if (paras.get(i) instanceof ActionPara) {
				ActionPara actionPara = ((ActionPara)paras.get(i));
				alreadySeen = new Vector <String> ();
				//alreadySeen.addElement(((ActionPara)paras.get(i)).getName().toString());
				//actionParaNames.add(((ActionPara)paras.get(i)).getZName().toString());
				CircusAction action = ((ActionPara)paras.get(i)).getCircusAction();
				
				String paraName = actionPara.getName().toString();
				/*Vector <*/HashMap <String, Integer>/*>*/ allCalls = calls (action, process);
				boolean hasRecursiveCall = allCalls.keySet().contains(paraName);//hasRecursiveCall (action, process, paraName, alreadySeen);
				if (hasRecursiveCall) {
					callsvecRec.add(((ActionPara)paras.get(i)).getName().toString());
				}
				System.out.print("");
			}
		}
		return callsvecRec;
	}

	public static Vector <String> recursiveCalls (CircusAction action, CircusProcess process) {
		Vector <String> all = recursiveCalls (process);
		/*Vector <*/HashMap <String, Integer>/*>*/ fromAction = calls (action, process);
		Vector <String> ret = new Vector <String> ();
		for (int i = 0; i < all.size(); i++) {
			if (fromAction.keySet().contains(all.elementAt(i))) {
				if (fromAction.get(all.elementAt(i)) > 1) {
					ret.addElement(all.elementAt(i));
				}
			}
		}
		return ret;
	}

	/*public static boolean hasRecursiveCall (CircusAction action, CircusProcess process, String callvec, Vector <String> alreadySeen) { //TODO N�O TESTADO
		alreadySeen = callsWithoutDuplicates (alreadySeen);
		if (action instanceof Action1) {
			return hasRecursiveCall (((Action1)action).getCircusAction(), process, callvec, alreadySeen);
		}
		else if (action instanceof Action2) {
			return hasRecursiveCall (((Action2)action).getLeftAction(), process, callvec, alreadySeen) || hasRecursiveCall (((Action2)action).getRightAction(), process, callvec, alreadySeen);
		}
		else if (action instanceof CallAction) {
			String name = ((CallAction)action).getName().toString();
			alreadySeen.add(name);
			if (name.equals(callvec))
				return true;
			else if (alreadySeen.contains(callvec)) {
				return false;
			}
			else {
				return hasRecursiveCall (getContentOfCallAction ((CallAction)action, process), process, callvec, alreadySeen);
			}
		}
		else {
			return false;
		}
	}*/
	public static /*Vector <*/HashMap <String, Integer>/*>*/ calls (CircusAction action, CircusProcess process) {
		return calls (action, process, new /*Vector <*/HashMap <String, Integer>/*>*/ ());
	}
	public static /*Vector <*/HashMap <String, Integer>/*>*/ calls (CircusAction action, CircusProcess process, /*Vector <*/HashMap <String, Integer>/*>*/ callsvec) { //TESTADO PARA A A��O (ACT || (ACT || ((ACT || ACT) || (ACT || ACT))))
		if (action instanceof PrefixingAction) {
			/*Vector <*/HashMap <String, Integer>/*>*/ callsvec2 = new /*Vector <*/HashMap <String, Integer>/*>*/ ();
			callsvec2.putAll(callsvec);
			callsvec2.putAll(calls (((PrefixingAction)action).getCircusAction(), process, callsvec));
			return callsvec2;
		}
		else if (action instanceof Action2) {
			Action2 action2 = (Action2) pf.createCircusAction(action);
			/*Vector <*/HashMap <String, Integer>/*>*/ callsvec2 = new /*Vector <*/HashMap <String, Integer>/*>*/ ();
			callsvec2.putAll(callsvec);
			callsvec2.putAll(calls (action2.getLeftAction(), process, callsvec));
			callsvec2.putAll(calls (action2.getRightAction(), process, callsvec));
			return callsvec2;
		}
		else if (action instanceof CallAction) {
			String name = ((CallAction)action).getName().toString();
			/*Vector <*/HashMap <String, Integer>/*>*/ callsvec2 = new /*Vector <*/HashMap <String, Integer>/*>*/ ();
			callsvec2.putAll(callsvec);
			/*if (!callsvec2.contains(name)) {
				callsvec2.add(name);
				callsvec2.addAll(calls (getContentOfCallAction ((CallAction)action, process), process, callsvec));
			}*/
			if (!callsvec2.keySet().contains(name)) {
				callsvec2.put(name, 1);
				return /*callsvec2*/ calls (getContentOfCallAction ((CallAction)action, process), process, callsvec2);
			}
			else if (callsvec2.keySet().contains(name)) {
				callsvec2.put(name, callsvec2.get(name) + 1);
				return callsvec2 /*calls (getContentOfCallAction ((CallAction)action, process), process, callsvec2)*/;
			}
			else
				return callsvec;
		}
		else {
			return callsvec;
		}
	}
	public static CircusAction seqVersionOfAction (CircusAction action) {
		Factory f = new Factory ();
		if (action instanceof PrefixingAction) {
			SeqAction seq = f.createSeqAction();
			Communication c = ((PrefixingAction)action).getCommunication();
			CircusAction ca = ((PrefixingAction)action).getCircusAction();
			seq.setLeftAction (f.createPrefixingAction (f.createSkipAction(), c));
			seq.setRightAction(seqVersionOfAction (((PrefixingAction) action).getCircusAction()));
			seq.getAnns().addAll(action.getAnns());
			return seq;
		}
		else if (action instanceof ExtChoiceAction) {
			ExtChoiceAction eca = f.createExtChoiceAction();
			Action2 action2 = (Action2)action;
			CircusAction left = action2.getLeftAction();
			CircusAction right = action2.getRightAction();
			if (left instanceof PrefixingAction || right instanceof PrefixingAction) {
				if (left instanceof PrefixingAction && !(right instanceof PrefixingAction)) {
					CircusAction pfLeft = ((PrefixingAction)left).getCircusAction ();
					pfLeft = seqVersionOfAction (pfLeft);
					((PrefixingAction)left).setCircusAction(pfLeft);
					eca.setLeftAction (left);
					eca.setRightAction (seqVersionOfAction (right));
					//eca.getAnns().addAll(action.getAnns());
					//return eca;
				}
				else if (!(left instanceof PrefixingAction) && right instanceof PrefixingAction) {
					CircusAction pfRight = ((PrefixingAction)right).getCircusAction ();
					pfRight = seqVersionOfAction (pfRight);
					((PrefixingAction)right).setCircusAction(pfRight);
					eca.setRightAction (right);
					eca.setLeftAction (seqVersionOfAction (left));
					//eca.setRightAction (right);
					//eca.getAnns().addAll(action.getAnns());
					//return eca;
				}
				else /*if (left instanceof PrefixingAction && right instanceof PrefixingAction)*/ {
					CircusAction pfLeft = ((PrefixingAction)left).getCircusAction ();
					CircusAction pfRight = ((PrefixingAction)right).getCircusAction ();				
					pfLeft = seqVersionOfAction (pfLeft);
					pfRight = seqVersionOfAction (pfRight);
					((PrefixingAction)left).setCircusAction(pfLeft);
					((PrefixingAction)right).setCircusAction(pfRight);
					eca.setLeftAction (left);
					eca.setRightAction (right);
					eca.getAnns().addAll(action.getAnns());
					return eca;
				}
				/*eca.setLeftAction (left);
				eca.setRightAction (right);*/
				eca.getAnns().addAll(action.getAnns());
				return eca;
			}
			else {
				eca.setLeftAction(seqVersionOfAction (left));
				eca.setRightAction(seqVersionOfAction (right));
				eca.getAnns().addAll(action.getAnns());
				return eca;
			}
		}
		else if (action instanceof IntChoiceAction) {
			IntChoiceAction eca = f.createIntChoiceAction();
			Action2 action2 = (Action2)action;
			eca.setLeftAction(seqVersionOfAction (action2.getLeftAction()));
			eca.setRightAction(seqVersionOfAction (action2.getRightAction()));
			eca.getAnns().addAll(action.getAnns());
			return eca;
		}
		else if (action instanceof ParallelAction) {
			ParallelAction eca = f.createParallelAction();
			Action2 action2 = (Action2)action;
			eca.setLeftAction(seqVersionOfAction (action2.getLeftAction()));
			eca.setRightAction(seqVersionOfAction (action2.getRightAction()));
			eca.setLeftNameSet(((ParallelAction)action).getLeftNameSet());
			eca.setRightNameSet(((ParallelAction)action).getRightNameSet());
			eca.setChannelSet(((ParallelAction)action).getChannelSet());
			eca.getAnns().addAll(action.getAnns());
			return eca;
		}
		else if (action instanceof InterleaveAction) {
			InterleaveAction eca = f.createInterleaveAction();
			Action2 action2 = (Action2)action;
			eca.setLeftAction(seqVersionOfAction (action2.getLeftAction()));
			eca.setRightAction(seqVersionOfAction (action2.getRightAction()));
			eca.getAnns().addAll(action.getAnns());
			return eca;
		}
		else if (action instanceof SeqAction) {
			SeqAction eca = f.createSeqAction();
			Action2 action2 = (Action2)action;
			eca.setLeftAction(seqVersionOfAction (action2.getLeftAction()));
			eca.setRightAction(seqVersionOfAction (action2.getRightAction()));
			eca.getAnns().addAll(action.getAnns());
			return eca;
		}
		else if (action instanceof MuAction) {
			MuAction mu = f.createMuAction();
			mu.setName(((MuAction)action).getName());
			mu.setCircusAction(seqVersionOfAction (((MuAction)action).getCircusAction()));
			mu.getAnns().addAll(action.getAnns());
			return mu;
		}
		else if (action instanceof CallAction) {
			CallAction ca = f.createCallAction(f.createZName (((CallAction)action).getZName().toString()), f.createZExprList());
			ca.getAnns().addAll(action.getAnns());
			return ca;
		}
		else if (action instanceof RenameAction) {
			//CallAction ca = f.createRenameAction(f.createZName (((RenameAction)action).getZName().toString()), f.createZExprList());
			RenameAction ra = f.createRenameAction();
			ra.setAssignmentPairs(((RenameAction)action).getAssignmentPairs());
			ra.setCircusAction(seqVersionOfAction (((RenameAction)action).getCircusAction()));
			ra.getAnns().addAll(action.getAnns());
			return ra;
		}
		else if (action instanceof GuardedAction) {
			GuardedAction ga = f.createGuardedAction ();
			ga.setPred(((GuardedAction)action).getPred());
			ga.setCircusAction(seqVersionOfAction (((GuardedAction)action).getCircusAction()));
			return ga;
		}
		/*else if (action instanceof HideAction) { //TODO
			return 
		}*/
		else {
			SkipAction skp = f.createSkipAction();
			//skp.getAnns().addAll(action.getAnns());
			return skp;
		}
	}

	public static CircusAction getContentOfCallAction (CallAction ca, CircusProcess process) {
		Factory f = new Factory ();
		String actionName = ca.getName().toString();
		CircusAction callAction = null;
		if (process instanceof BasicProcess) {
			List <? extends Para> actionParas = (List <? extends Para>) ((BasicProcess)process).getZParaList();
			int size = actionParas.size();
			for (int i = 0; i < size; i++) {
				Para para = actionParas.get(i);
				if (para instanceof ActionPara) {
					if (((ActionPara)para).getZName().toString().equals(actionName)) {
						callAction = /*pf.createCircusAction*/(((ActionPara)para).getCircusAction());
						//callAction = ((ActionPara)para).getCircusAction();
						//callAction.getAnns().addAll(((ActionPara)para).getCircusAction().getAnns());
					}
				}
			}
		}
		if (process instanceof ParamProcess) {
			List <? extends Para> actionParas = (List <? extends Para>) ((ParamProcess)process).getCircusBasicProcess().getZParaList(); //falta testar esta linha
			int size = actionParas.size();
			for (int i = 0; i < size; i++) {
				Para para = actionParas.get(i);
				if (para instanceof ActionPara) {
					if (((ActionPara)para).getZName().toString().equals(actionName)) {
						callAction = pf.createCircusAction(((ActionPara)para).getCircusAction());
						//callAction = ((ActionPara)para).getCircusAction();
						callAction.getAnns().addAll(((ActionPara)para).getCircusAction().getAnns());
					}
				}
			}
		}
		if (callAction == null) {
			try {
				System.out.println ("*******************\nAction " + actionName + " was not found on process, in the first search. " +
						"If it starts with \"X\", then no problem, it is a recursive action.\n*******************\n");
			} catch (Exception e) {
				//e.printStackTrace();
			}
		}
		return callAction;
	}

	public static CircusAction expandAction (CircusAction action, CircusProcess process, Consumer c) {
		Factory f = new Factory ();
		ParallelismFactory pf = new ParallelismFactory ();
		if (action instanceof CallAction) {
			CircusAction content = getContentOfCallAction ((CallAction)action, process);
			if (c.callStatus (((CallAction)action).getName().toString()) == Consumer.RECSTART) {
				MuAction mu = f.createMuAction();
				mu.setName(f.createZName("X" + ((CallAction)action).getName().toString()));
				CircusAction act = expandAction (content, process, c);
				mu.getAnns().addAll(act.getAnns());
				mu.setCircusAction (act);
				return mu;
			}
			else if (c.callStatus (((CallAction)action).getName().toString()) == Consumer.RECCALL) {
				CallAction act2 = f.createCallAction ();
				act2.setName(f.createZName("X" + ((CallAction)action).getName().toString()));
				act2.setExprList (((CallAction)action).getExprList());
				return act2;
			}
			else if (c.callStatus (((CallAction)action).getName().toString()) == Consumer.NORMALCALL) {
				return expandAction (getContentOfCallAction ((CallAction)action, process), process, c);
			}
			else {
				return f.createSkipAction();
			}
		}
		else if (action instanceof PrefixingAction) {
			PrefixingAction pa = f.createPrefixingAction();
			pa.setCommunication(pf.createCommunication(((PrefixingAction)action).getCommunication()));
			pa.setCircusAction(expandAction (((Action1)action).getCircusAction(), process, c));
			return pa;
		}
		else if (action instanceof MuAction) {
			MuAction mu = f.createMuAction ();
			mu.setName(((MuAction)action).getName());
			mu.setCircusAction(((MuAction)action).getCircusAction());
			return mu;
		}
		/*
		 TODO os outros elses de Action1: HideAction, e etc
		 * */
		else if (action instanceof GuardedAction) {
			GuardedAction ga = f.createGuardedAction ();
			ga.setPred(((GuardedAction)action).getPred());
			ga.setCircusAction(((GuardedAction)action).getCircusAction());
			return ga;
		}
		else if (action instanceof Action2) { //TODO N�O ESTOU GOSTANDO MUITO 
			Action2 action2 = /*(Action2) pf.createCircusAction*/ ((Action2)action);
			action2.setLeftAction(expandAction (((Action2)action).getLeftAction(), process, c));
			action2.setRightAction(expandAction (((Action2)action).getRightAction(), process, c));
			if (action instanceof ParallelAction) {
				((ParallelAction)action2).setChannelSet(((ParallelAction)action).getChannelSet());
				((ParallelAction)action2).setLeftNameSet(((ParallelAction)action).getLeftNameSet());
				((ParallelAction)action2).setRightNameSet(((ParallelAction)action).getRightNameSet());
			}
			else if (action instanceof InterleaveAction) {
				((InterleaveAction)action2).setLeftNameSet(((InterleaveAction)action).getLeftNameSet());
				((InterleaveAction)action2).setRightNameSet(((InterleaveAction)action).getRightNameSet());				
			}
			return action2;
		}
		else if (action instanceof SkipAction) {
			return f.createSkipAction();
		}
		else if (action instanceof StopAction) {
			return f.createStopAction();
		}
		else if (action instanceof ChaosAction) {
			return f.createChaosAction();
		}
		else {
			return f.createSkipAction();
		}
	}
	public static ActionPara similarRecursiveActionPara (ActionPara para, CircusProcess process) {
		Factory f = new Factory ();
		CircusAction action = /*pf.createCircusAction*/(para.getCircusAction());
		action.getAnns().addAll(para.getCircusAction().getAnns());
		Vector <String> calls = recursiveCalls (action, process);
		Consumer c = new Consumer (calls);
		if (calls.contains(para.getName().toString())) {
			c.setStatus(Consumer.RECCALL, para.getName().toString());
			MuAction mu = f.createMuAction();
			mu.setName(f.createZName ("X" + para.getName().toString()));
			CircusAction action3 = expandAction (action, process, c);
			action3.getAnns().addAll(para.getCircusAction().getAnns());
			mu.setCircusAction(action3);
			//mu.getAnns().addAll(para.getCircusAction().getAnns());
			para.setCircusAction(mu);
			return para;
		}
		else {
			CircusAction action2 = expandAction (action, process, c);
			action2.getAnns().addAll(para.getCircusAction().getAnns());
			para.setCircusAction (action2);
			return para;
		}
	}
}
