package jcircus.newfrontendmethod;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

import jcircus.parallelism.CallUtil;
import jcircus.parallelism.ParallelismProcessUtil;
import jcircus.parallelism.ParallelismTestBuilders;
import jcircus.parallelism.ParallelismVisitor;

import net.sourceforge.czt.base.util.UnmarshalException;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.Process1;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.parser.oz.ParseUtils;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.z.ast.NarrSect;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.ZSect;

//Esta classe percorrerá a AST da especificação atrás de comunicações e sincronizações, adicionando assinaturas FrontEndAnn a cada comunicação que aparecer, com um inteiro diferente
public class FrontEndProcessor {
	HashMap <String, FrontEndMap> map = new LinkedHashMap <String, FrontEndMap> ();
	public static FrontEndMap mountFrontEndMap (CircusProcess process, Spec spec) {
		if (process instanceof ParProcess) {
			CircusProcess left = ((ParProcess)process).getLeftProcess();
			CircusProcess right = ((ParProcess)process).getRightProcess();
			FrontEndMap femleft = mountFrontEndMap (left, spec);
			FrontEndMap femright = mountFrontEndMap (right, spec);
			FrontEndMap femparallel = FrontEndMap.mergeParallel(femleft, femright);
			return femparallel;
		}
		else if (process instanceof Process2 && !(process instanceof ParProcess)) {
			CircusProcess left = ((Process2)process).getLeftProcess();
			CircusProcess right = ((Process2)process).getRightProcess();
			FrontEndMap femleft = mountFrontEndMap (left, spec);
			FrontEndMap femright = mountFrontEndMap (right, spec);
			FrontEndMap femnormal = FrontEndMap.mergeNormal(femleft, femright);
			return femnormal;
		}
		else if (process instanceof CallProcess) {
			return mountFrontEndMap (ParallelismProcessUtil.getContentOfCallProcess((CallProcess)process, spec), spec);
		}
		else if (process instanceof Process1) {
			return mountFrontEndMap (((Process1)process).getCircusProcess(), spec);
		}
		else if (process instanceof BasicProcess) {
			BasicProcess basicProcess = (BasicProcess)process;
			ZParaList paras = basicProcess.getZParaList();
			CircusAction mainAction = basicProcess.getMainAction();
			return mountFrontEndMap (mainAction, process);
		}
		else {
			return new FrontEndMap ();
		}
	}
	public static FrontEndMap mountFrontEndMap (CircusAction action, CircusProcess process) {
		if (action instanceof ParAction) {
			CircusAction left = ((ParAction)action).getLeftAction();
			CircusAction right = ((ParAction)action).getRightAction();
			FrontEndMap femleft = mountFrontEndMap (left, process);
			FrontEndMap femright = mountFrontEndMap (right, process);
			FrontEndMap femparallel = FrontEndMap.mergeParallel(femleft, femright);
			return femparallel;
		}
		else if (action instanceof Action2 && (!(action instanceof ParAction))) {
			CircusAction left = ((Action2)action).getLeftAction();
			CircusAction right = ((Action2)action).getRightAction();
			FrontEndMap femleft = mountFrontEndMap (left, process);
			FrontEndMap femright = mountFrontEndMap (right, process);
			FrontEndMap femnormal = FrontEndMap.mergeNormal(femleft, femright);
			return femnormal;
		}
		else if (action instanceof PrefixingAction) {
			Communication c = ((PrefixingAction)action).getCommunication();
			String channel = c.getChannelExpr().getName().toString();
			FrontEndMap fem = new FrontEndMap ();
			fem.put(channel);
			return fem;
		}
		else if (action instanceof CallAction) {
			return mountFrontEndMap (CallUtil.getContentOfCallAction((CallAction)action, process), process);
		}
		else if (action instanceof Action1 && !(action instanceof PrefixingAction) && !(action instanceof CallAction)) {
			return mountFrontEndMap (((Action1)action).getCircusAction(), process);
		}
		else /*if (action instanceof BasicAction)*/{
			return new FrontEndMap ();
		}
	}
//Agora que já temos o método para montar o FrontEndMap a partir de uma ação Circus, o que fazer?
	public static void main (String args []) {
		Factory f = new Factory ();
		Spec spec = f.createSpec();
		ZSect zSect = f.createZSect();
		BasicProcess process = f.createBasicProcess ();
		ExtChoiceAction eca = 
			ParallelismTestBuilders.buildLargerExtChoiceAction(
					new String [][] {
						new String [] {"a", "b", "c"},
						new String [] {"d", "e", "f"}
					}
			);
		IntChoiceAction ica =
			ParallelismTestBuilders.buildLargerIntChoiceAction(
					new String [][] {
						new String [] {"a", "b", "c"},
						new String [] {"a", "e", "f"}
					}
			);
		ParallelAction pa = f.createParallelAction ();
		pa.setLeftAction(ica);
		pa.setRightAction(eca);
		FrontEndMap fem = mountFrontEndMap (pa, f.createBasicProcess());
		System.out.print("");
	}
}
/*
		FileSource source = new FileSource ("C:\\Users\\sam\\Softwares\\workspaceGalileo\\circus\\src\\jcircus\\fe.tex");
		Spec spec = null;
		try {
			spec = (Spec) ParseUtils.parse(source, new SectionManager ("circus"));
			System.out.println ("Parseou");
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UnmarshalException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ZSect zSect;
		if (spec.getSect().get(0) instanceof NarrSect)
    		zSect = (ZSect) spec.getSect().get(1);
    	else
    		zSect = (ZSect) spec.getSect().get(0);
		ZParaList paras = zSect.getZParaList();
		for (int i = 0; i < paras.size(); i++) {
			Para para = paras.get(i);
			if (para instanceof ProcessPara) {
				ProcessPara ppara = (ProcessPara)para;
				CircusProcess process = ppara.getCircusProcess();
				FrontEndMap fem = mountFrontEndMap (process, spec);
				System.out.print("");
			}
		}
 * */