package jcircus.gui;


import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;
import jcircus.JCircusController;
import jcircus.JCircusControllerFrame;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.runtime.VisitorException;
import jcircus.exceptions.TranslationCancelledException;
import jcircus.util.Constants;
import jcircus.util.Error;
import jcircus.util.ErrorMessage;
import jcircus.util.ProcInfo;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.typecheck.circus.ErrorAnn;

/**
 * JCircusFrame.java
 *
 * JCircus initial screen.
 *
 * @author Angela
 */
public class JCircusFrame extends JFrame implements ActionListener {

    static private final String NEWLINE = "\n";

    // This must be an attribute because parser and typechecker may be called
    // more than one time, and the environments must be kept.
    private JCircusControllerFrame _controller;
    public JCircusControllerFrame getController () {
    	return this._controller;
    }
    private boolean _canceled = false;

    // Interface components
    private JLabel lblInputSpec;
    private JTextField txfInputSpec;
    private JButton btnChooseInput;
    
    private JLabel lblProjName;
    private JTextField txfProjName;
    
    private JLabel lblOutputPath;
    private JTextField txfOutputPath;
    private JButton btnChooseOutput;

    //Abaixo acrescentado por Samuel
    private JLabel lblCompl;
    private JTextField txfCompl;
    private String _compl_ = "";
    private int minimum_communicable;
    private int maximum_communicable;
    //Acima acrescentado por Samuel
    
    private JLabel lblOutputDir;
    private JTextField txfOutputDir;
    
    private JButton btnTranslate;
    
    private JLabel lblLog;
    private JTextArea txaLog;

    private JRadioButton cBox;
    private JRadioButton bparallelism;
    private JLabel blabel;
    private JLabel lparallelism;
    
    private boolean useBarriers = false;
    private boolean parallelism = false;

/**Sam's labels and text fields to choose the maximum and the minimum communicable value for the channels*/
	JLabel lblMaxValueComm = new JLabel ("Maximum value to be communicated: ");
	JLabel lblMinValueComm = new JLabel ("Minimum value to be communicated: ");
	JTextField txtMaxValueComm = new JTextField ("9");
	JTextField txtMinValueComm = new JTextField ("0");
/**Sam's labels and text fields to choose the maximum and the minimum communicable value for the channels*/

    /**
     * Constructor.
     */
    public JCircusFrame(JCircusControllerFrame controller) {

    	/**Sam's JCheckBox 2 ABAIXO choose if the user wants to use the multi-synchronization protocol, or barriers*/
    	cBox = new JRadioButton ();
    	cBox.setName("barriers");
    	cBox.setSelected(true);
    	useBarriers = true;

    	cBox.addItemListener(
    			new ItemListener () {
    				public void itemStateChanged (ItemEvent e) {
    					Object source = e.getItemSelectable();
    					if (e.getStateChange() == ItemEvent.DESELECTED) {
    						useBarriers = false;
    					}
    					else /*if (e.getStateChange() == ItemEvent.SELECTED)*/ {
    						useBarriers = true;
    					}
    				}
    			}
    	);
    	blabel = new JLabel ("Use barriers 4 multi-sync");
/**Sam's JCheckBox 2 ACIMA choose if the user wants to use the multi-synchronization protocol, or barriers*/

/**Sam's JCheckBox 2 ABAIXO choose if the user wants to use the CSP's parallelism method*/
    	bparallelism = new JRadioButton ();
    	bparallelism.setName("parallelism");
    	bparallelism.setSelected(true);
    	parallelism = true;
    	
    	bparallelism.addItemListener(
    			new ItemListener () {
    				public void itemStateChanged (ItemEvent e) {
    					Object source = e.getItemSelectable();
    					if (e.getStateChange() == ItemEvent.DESELECTED) {
    						parallelism = false;
    					}
    					else /*if (e.getStateChange() == ItemEvent.SELECTED)*/ {
    						parallelism = true;
    					}
    				}
    			}
    	);
    	lparallelism = new JLabel ("Use CSP's parallelism");
/**Sam's JCheckBox 2 ACIMA choose if the user wants to use the multi-synchronization protocol, or barriers*/
    	
    	this._controller = controller;
        
        // Initializes graphical interface
        
        this.setTitle("JCircus 2.0");
        //this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Create and set up the content pane.
        JComponent contentPane = new JPanel();
        contentPane.setOpaque(true); //content panes must be opaque
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        
        //Create and set up the layout
        GridBagLayout gridBagLayout = new GridBagLayout();
        contentPane.setLayout(gridBagLayout);
        
        //Create and set up the components
        lblInputSpec = new JLabel("Input specification:");
        txfInputSpec = new JTextField();
        txfInputSpec.setPreferredSize(new Dimension(400, 22));
        btnChooseInput = new JButton("...");
        btnChooseInput.setPreferredSize(new Dimension(30, 22));
        btnChooseInput.addActionListener(this);
        
        lblProjName = new JLabel("Project name:");
        txfProjName = new JTextField();
        txfProjName.setPreferredSize(new Dimension(400, 22));
        txfProjName.getDocument().addDocumentListener(new TextFieldsDocumentListener());

        lblOutputPath = new JLabel("Project path:");
        txfOutputPath = new JTextField();
        txfOutputPath.setPreferredSize(new Dimension(400, 22));
        txfOutputPath.getDocument().addDocumentListener(new TextFieldsDocumentListener());

        btnChooseOutput = new JButton("...");
        btnChooseOutput.setPreferredSize(new Dimension(30, 22));
        btnChooseOutput.addActionListener(this);

        lblOutputDir = new JLabel("Project folders will be created in:");
        txfOutputDir = new JTextField();
        txfOutputDir.setPreferredSize(new Dimension(400, 22));
        txfOutputDir.setEditable(false);

        btnTranslate = new JButton("Translate");
        btnTranslate.setPreferredSize(new Dimension(100, 25));
        btnTranslate.addActionListener(this);

        lblLog = new JLabel("Log:");
        txaLog = new JTextArea(5,20);
        txaLog.setMargin(new Insets(5,5,5,5));
        txaLog.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(txaLog);
        
        //Add components to the content pane
        
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = GridBagConstraints.EAST;

        // First row
        // Input spec - label
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.NONE;
        c.weightx = 0.0;
        contentPane.add(lblInputSpec, c);

        // Input spec - label
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        contentPane.add(txfInputSpec, c);
        
        // Input spec - button
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 0.0;
        contentPane.add(btnChooseInput, c);
        
        // Second row
        // Project name - label
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.NONE;
        c.weightx = 0.0;
        contentPane.add(lblProjName, c);

        // Input spec - label
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        contentPane.add(txfProjName, c);
        
        // Third row
        // Output dir - label
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.NONE;
        c.weightx = 0.0;
        contentPane.add(lblOutputPath, c);

        // Output dir - label
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        contentPane.add(txfOutputPath, c);
        
        // Output dir - button
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 0.0;
        contentPane.add(btnChooseOutput, c);
        
        // Rest of components
        c.gridx = 0;
        c.gridy = 3;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(10, 0, 0, 0);
        contentPane.add(lblOutputDir, c);
        
        c.gridy = GridBagConstraints.RELATIVE;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add(txfOutputDir, c);

        c.fill = GridBagConstraints.NONE;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(10, 0, 0, 0);
        contentPane.add(btnTranslate, c);
        
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add(lblLog, c);
        
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add(logScrollPane, c);

/**Sam's JCheckBox 2 ABAIXO choose if the user wants to use the multi-synchronization protocol, or barriers*/
        contentPane.add(cBox, c);
        contentPane.add(blabel, c);
        contentPane.add(bparallelism, c);
        contentPane.add(lparallelism, c);
        contentPane.add(lblMaxValueComm);
        txtMaxValueComm.setPreferredSize(new Dimension(100, 22));
        txtMaxValueComm.setVisible(true);
        contentPane.add(txtMaxValueComm);
        contentPane.add(lblMinValueComm);
        txtMinValueComm.setPreferredSize(new Dimension(100, 22));
        txtMinValueComm.setEnabled(false);
        txtMinValueComm.setVisible(true);
        contentPane.add(txtMinValueComm);
/**Sam's JCheckBox 2 ACIMA choose if the user wants to use the multi-synchronization protocol, or barriers*/

/*
/**Sam's labels and text fields to choose the maximum and the minimum communicable value for the channels
    	JLabel lblMaxValueComm = new JLabel ("Maximum value to be communicated: ");
    	JLabel lblMinValueComm = new JLabel ("Minimum value to be communicated: ");
    	JTextField txtMaxValueComm = new JTextField ();
    	JTextField txtMinValueComm = new JTextField ();    	
Sam's labels and text fields to choose the maximum and the minimum communicable value for the channels*/
    }

    /**
     * This is invoked when a button is pressed.
     */
    public void actionPerformed(ActionEvent e) {

        if (e.getSource() == btnChooseInput) {
            btnChooseInputActionPerformed();
        } else if (e.getSource() == btnChooseOutput) {
            btnChooseOutputActionPerformed();
        } else if (e.getSource() == btnTranslate) {
            btnTranslateActionPerformed();
        }
    }

    /**
     * This is invoked when the button for choosing input file is pressed.
     */
    private void btnChooseInputActionPerformed() {

        //Create a file chooser
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setCurrentDirectory(new File(Constants.DIR_EXAMPLES));
        fc.setCurrentDirectory(new File("."));

        int returnVal = fc.showOpenDialog(this);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            // If a file has been chosen

            File file = fc.getSelectedFile();
            // Shows the path in the input field
            String path = file.getAbsolutePath();
            txfInputSpec.setText(path);
        }        
    }

    /**
     * This is invoked when the button for choosing output directory is pressed.
     */
    private void btnChooseOutputActionPerformed() {

        //Create a file chooser
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.setCurrentDirectory(new File(Constants.DIR_PROJECTS));
        fc.setCurrentDirectory(new File("."));
            
        int returnVal = fc.showOpenDialog(this);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            // If a file has been chosen
            
            File file = fc.getSelectedFile();
            // Shows the path in the input field
            String path = file.getAbsolutePath();
            txfOutputPath.setText(path);
        }        
    }
    
    /**
     * This is invoked when the button 'Translate' is pressed.
     */
    private void btnTranslateActionPerformed() {

        // clear the log
        txaLog.setDocument(new PlainDocument());

        // Checks if the input file has been entered
        String path = txfInputSpec.getText();
        if (path == null || path.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the input file.");
            return;
        }

        // Checks if the project name has been entered
        String projectName = txfProjName.getText();
        if (projectName == null || projectName.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the project name.");
            return;
        }

        // Checks if the output path has been entered
        String projectDir = txfOutputPath.getText();
        if (projectDir == null || projectDir.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the output dir.");
            return;
        }

        try {
            // Call the translation
            _controller.translate(path, projectDir, projectName, _compl_, useBarriers, parallelism/*, Integer.parseInt (this.txtMinValueComm.getText().toString()), Integer.parseInt (this.txtMaxValueComm.getText().toString())*/);
        } catch (Throwable t) {

            //JOptionPane.showMessageDialog(this, "Unexpected error. See log for details.", 
                    //"Error", JOptionPane.ERROR_MESSAGE);

            try {

                PrintStream printStream = new PrintStream("/log.txt");
                printStream.print(t.toString());
                printStream.close();

            } catch (IOException ioe) {

                //JOptionPane.showMessageDialog(this, "Can't create log.", 
                        //"Error", JOptionPane.ERROR_MESSAGE);
                ioe.printStackTrace();
            } finally {
                t.printStackTrace();
            }
        }
    }

    /**
     * Reports an error in the Log area.
     */
    public void reportMessage(String message) {
        txaLog.append(message);
    }
    
    /**
     * Changes the output directory.
     */
    private void changeOutputDir() {
        String outputPath = txfOutputPath.getText();
        String projectName = txfProjName.getText();
        String projectDir = _controller.getOutputDir(outputPath, projectName);
        txfOutputDir.setText(projectDir);
    }
    
    /**
     * Shows the dialog to select the process for which a class main is
     * to be created.
     *
     */
    public void promptForMainProcesses(List<ProcInfo> procInfoList) 
            throws TranslationCancelledException {
        
        ChooseMainDialog chooseMainDialog = new ChooseMainDialog(this, _controller, procInfoList);
        chooseMainDialog.pack();
        chooseMainDialog.setVisible(true);
        
        if (this._canceled == true) {
            JOptionPane.showMessageDialog(this, "Translation canceled by the user.");
            // Cancel the translation
            _controller.cancelTranslation();
        } 
    }
    
    /**
     * Shows the dialog to prompt for parameters.
     *
     */
    public void promptForParameters(ProcInfo procInfo) 
            throws TranslationCancelledException {
        
        ParametersDialog paramDialog = new ParametersDialog(this, _controller, procInfo);
        paramDialog.pack();
        paramDialog.setVisible(true);
        
        if (this._canceled == true) {
            JOptionPane.showMessageDialog(this, "Translation canceled by the user.");
            // Cancel the translation
            _controller.cancelTranslation();
        }
    }
    
    /**
     * Listener. Listen for changes in the textfields to change the 
     * Project Directory accordingly.
     */
    public class TextFieldsDocumentListener implements DocumentListener {
        
        public void insertUpdate(DocumentEvent e) {
            changeOutputDir();
        }
        
        public void removeUpdate(DocumentEvent e) {
            changeOutputDir();
        }
        
        public void changedUpdate(DocumentEvent e) {
            changeOutputDir();
        }        
    }

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    public void showGui() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Complete text areas with default values for testing
        setUpForTesting();

        //Display the window.
        pack();
        setVisible(true);
    }

    /**
     * Only for tests.
     */
    public void setUpForTesting() {

    	//OBSERVA��ES IMPORTANTES:
    	//1. As especifica��es acusam NoNameTypeAnnotationException quando
    	// seu circstate tem o formato de um schema normal, sem a palavra-chave
    	// "circstate". No entanto, quando o shema de estado � colocado numa 
    	// formata��o com circstate, o erro cessa
    	//2. Os nomes das especifica��es T_<...>Mod.tex que tem um underline _ causam algum bug de caracteres na tradu��o
    	// no novo parser. Nas entradas verificadas abaixo, os underline foram retirados
    	//As tradu��es consideradas CORRETAS ignoraram as varia��es nos argumentos de "chanInfo.put", presentes nos c�digos Main desta especifica��o no que foi gerado pelo JCircus antigo e no que foi gerado pelo JCircus novo
    	//3. 21/04/2010: As especifica��es com "Tradu��o equivalente" e "Tradu�a� correta" foram checadas antes do dia 21/04

    	//Especifica��es anteriores
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemplo_czt_1_5_0.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Exemplo");
        this._compl_ = "Exemplo";*/

    	//Especifica��es anteriores
    	/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemploNotMS.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploNotMS");
        this._compl_ = "ExemploNotMS";
*/
    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemploMS.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploMS");
        this._compl_ = "ExemploMS";

    	//Especifica��es anteriores
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\In\\MultiSyncInter.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\out\\MultiSyncInter");
        this._compl_ = "MultiSyncInter";*/

    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\In\\MultiSyncComplexComm.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\out\\MultiSyncComplexComm");
        this._compl_ = "MultiSyncComplexComm";*/

        /*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\In\\MultiSyncMS.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\out\\MultiSyncMS");
        this._compl_ = "MultiSyncMS";
*/
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\In\\Ext.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\out\\Ext");
        this._compl_ = "Ext";
*/
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_ComunCompl\\In\\ComplexComms.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_ComunCompl\\out\\ComplexComms");
        this._compl_ = "ComplexComms";*/

		//C:\\Users\\sam\\Softwares\\workspaceGalileo\\circus\\src\\jcircus\\complex_comms.tex
		this.txfInputSpec.setText ("C:\\Users\\sam\\Softwares\\workspaceGalileo\\circus\\src\\jcircus\\complex_comms.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_ComunCompl\\Out\\ComplexComms");
        this._compl_ = "ComplexComms";

    	this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\NamoroOuAmizade\\src\\namoroouamizade.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\NamoroOuAmizade\\src");
        this._compl_ = "NamoroOuAmizade";

        /*this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\NamoroOuAmizade\\src\\joptest.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\NamoroOuAmizade\\src");
        this._compl_ = "NamoroOuAmizade";*/

/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\AcordesMusicais\\acordesmusicais.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\AcordesMusicais\\src\\AcordesMusicais");
        this._compl_ = "AcordesMusicais";
*/
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\FluxoDeCarros\\fluxodecarros.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\FluxoDeCarros\\src\\FluxoDeCarros");
        this._compl_ = "FluxoDeCarros";
*/

/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\ControleDeLargada\\src\\controledelargada.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\ControleDeLargada\\src");
        this._compl_ = "ControleDeLargada";
*/
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\circus\\src\\jcircus\\complexcommtimemilis.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteNewPar");
        this._compl_ = "TesteNewPar";*/

/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_ComunCompl\\In\\FreeTypeComplexComm.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_ComunCompl\\out\\FreeTypeComplexComm");
        this._compl_ = "FreeTypeComplexComm";
*/
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\In\\SingleWriting.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\out\\SingleWriting");
        this._compl_ = "SingleWriting";

        this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\In\\SingleDotComm.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\out\\SingleDotComm");
        this._compl_ = "SingleDotComm";

        this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\In\\SingleComplexComm.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\out\\SingleComplexComm");
        this._compl_ = "SingleComplexComm";
*/
/*        this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\In\\ExPQR.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_NovoJCSP\\out\\ExPQR");
        this._compl_ = "ExPQR";
*/
/*
    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\In\\Interleaving.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\out\\Interleaving");
        this._compl_ = "Interleaving";
*/
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\In\\circus_parking_spot_forced_interleaving.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\out\\ParkingSpot");
        this._compl_ = "ParkingSpot";
*/
/*
    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\In\\ECQualif.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_Interleaving\\out\\ECQualif");
        this._compl_ = "ECQualif";
*/
/*        this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteNewPar.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteNewPar");
        this._compl_ = "TesteNewPar";
*/
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Softwares\\workspaceGalileo\\circus\\src\\jcircus\\TesteNewPar.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteNewPar");
        this._compl_ = "TesteNewPar";*/
/*        this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TestActInfo.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TestActInfo");
        this._compl_ = "TestActInfo";
*/
/*		this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\paramtest.tex");
		this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\Paramtest");
		this._compl_ = "Paramtest";
*/
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\OrdinaryPerson\\in\\ordinaryperson.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\OrdinaryPerson\\out\\OrdinaryPerson");
        this._compl_ = "OrdinaryPerson";*/

        /*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\SteamBoiler\\steam-boiler-singleenv.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\SteamBoiler\\out\\SteamBoiler");
        this._compl_ = "SteamBoiler";*/
        
        //C:\Users\sam\Mestrado\JCircus3\JCircus\SteamBoiler\steam-boiler-singleenv.tex
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\RecTest.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\RecTest");
        this._compl_ = "RecTest";*/
        
        /*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteRenaming.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\TesteRenaming");
        this._compl_ = "TesteRenaming";*/

/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\In\\Maingui.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\Testes_MainGUI\\out\\Maingui");
        this._compl_ = "Maingui";
*/
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemploInter_czt_1_5_0.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploInter");
        this._compl_ = "ExemploInter";
        */

    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemploMegaSena_czt_1_5_0.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploMegaSena");
        this._compl_ = "ExemploMegaSena";*/

    	/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemploExtIntChoice_czt_1_5_0.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploExtIntChoice");
        this._compl_ = "ExemploExtIntChoice";
*/
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\src\\jcircus\\exemplo.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus3\\JCircus\\ExemploQualifMes");
        this._compl_ = "ExemploQualifMes";*/
    	    	
    	//Especifica��o 1: T_ActMod.tex // * 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ActMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Act");
        this._compl_ = "Act";
*/        

    	//Especifica��o 2: T_ActionParallelismMod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ActionParallelismMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ActionParallelism");
    	this._compl_ = "ActionParallelism";
*/        
    	//Especifica��o 3: T_ActionParExMod.tex 
    	//TRADU�A� EQUIVALENTE
    	// TRADU��O CORRETA
/*    	
    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ActionParExMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ActionParEx");
    	this._compl_ = "ActionParEx";
*/        

    	//Especifica��o 4: T_AxDefMod.tex
    	//TRADU��O CORRETA
    	//TRADU��O EQUIVALENTE
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_AxDefMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\AxDef");
    	this._compl_ = "AxDef";
*/    	

        //Especifica��o 5: T_ChronometerMod.tex
    	//TRADU��O EQUIVALENTE
    	//1 ERRO DE COMPILA��O
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ChronometerMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Chronometer");
    	this._compl_ = "Chronometer";
*/    	
        
        //Especifica��o 6: T_Dot.tex // 
    		//TRADU��O EQUIVALENTE
    		//ERROS DE COMPILA��O
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_DotMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Dot");
    	this._compl_ = "Dot";
*/        
    	
        //Especifica��o 7: T_Err.tex
    	//No type checking errors!
    	//AQUI EST� OK!!! 
    	//	N�O PRECISA VERIFICAR, POIS A ESPECIFICA��O DEVE REALMENTE ACUSAR FALTA DE REQUISITOS PARA A TRADU��O!!
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ErrMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Err");
    	this._compl_ = "Err";
    	*/
        
        //Especifica��o 8: T_Ex1Mod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_Ex1Mod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Ex1");
    	this._compl_ = "Ex1";
*/        
    	
        //Especifica��o 9: T_ExtMultiSingleMod.tex 
    	//TRADU��O CORRETA
    	//TRADU��O EQUIVALENTE
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ExtMultiSingleMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ExtMultiSingleMod");
    	this._compl_ = "ExtMultiSingleMod";
*/        
    	
        //Especifica��o 10: T_FCSMod.tex
    	//A especifica��o original tem o processo
    		//ConcreteFireControl, removido na entrada adaptada
    		//pq provocava um UnsupportedAstClassException
    	//TRADU��O EQUIVALENTE
    	//ERROS DE COMPILA��O
    	//Diferen�as entre os c�digos gerados:
    		//1. DisplayCicle (resp. Angela e Sam):
    			//Linhas 73 e 126: aux_left_Mode_0 onde era para ser aux_right_Mode_0
    			//Linhas 99 e 142: left_3 onde era para ser left_6
    			//Linhas 319 e 152: right_3 onde era para ser right_6
    			//Linhas 369 e 361: detection onde era para ser fault
    	//Como foi constado que as diferen�as acima foram causadas por causa da
    		//parentiza��o de switchLampsOff, considero a tradu��o equivalente
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_FCSMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\FCS");
        this._compl_ = "FCS";
*/
    	//Especifica��o 11: T_FibonacciMod.tex 
    	//TRADU��O CORRETA
    	//TRADU��O EQUIVALENTE
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_FibonacciMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Fibonacci");
    	this._compl_ = "Fibonacci";
*/    	
    	
        //Especifica��o 12: T_GCDMod.tex
    	//TRADU��O CORRETA
    	//TRADU��O EQUIVALENTE
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_GCDMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\GCD");
    	this._compl_ = "GCD";
*/        
    	
        //Especifica��o 13: T_GenChannelMod.tex 
    	//TRADU��O EQUIVALENTE
    	//ERROS DE COMPILA��O
    	
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_GenChannelMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\GenChannel");
    	this._compl_ = "GenChannel";
*/    	
        
        //Especifica��o 14: T_GuardedMod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_GuardedMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Guarded");
    	this._compl_ = "Guarded";
*/        
    	
        //Especifica��o 15: T_LocalEnvMod.tex 
    	//(Com entrada 3): 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_LocalEnvMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\LocalEnv");
    	this._compl_ = "LocalEnv";
        */
    	
        //Especifica��o 16: T_MSMod.tex
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA

    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_MSMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\MS");
    	this._compl_ = "MS";*/

        //Especifica��o 17: T_MS2Mod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_MS2Mod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\MS2");
        this._compl_ = "MS2";
*/
        
        //Especifica��o 18: T_MS3Mod.tex 
    	//TRADU��O EQUIVALENTE
    	//ERROS DE COMPILA��O
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_MS3Mod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\MS3");
        this._compl_ = "MS3";
*/        
        
        //Especifica��o 19: T_MSExtChoiceMod.tex 
        //TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
    	/*this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_MSExtChoiceMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\MSExtChoice");
        this._compl_ = "MSExtChoice";
        */
        
        //Especifica��o 20: T_NameReuseMod.tex 
    	//Com entrada 3:
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_NameReuseMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\NameReuse");
        this._compl_ = "NameReuse";
*/        
        //Especifica��o 21: T_PaperMod.tex
    	//TRADU��O EQUIVALENTE
    	//Uma �nica linha com erro de compila��o, em PaperP3
    	//Este caso de teste est� danificando a configura��o 
    	//do projeto de JCircusNewParser, verificar depois por que
    	
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_PaperMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Paper");
        this._compl_ = "Paper";
*/        
        //Especifica��o 22: T_ParActionsCommMod.tex
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	
    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ParActionsCommMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ParActionsComm");
        this._compl_ = "ParActionsComm";
*/        
        //Especifica��o 23: T_ParalelismoDoisaDoisMod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ParalelismoDoisaDoisMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ParalelismoDoisaDois");
        this._compl_ = "ParalelismoDoisaDois";
*/        
        //Especifica��o 24: T_ParSimpleMod.tex 
        //TRADU��O EQUIVALENTE
        //TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ParSimpleMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ParSimple");
        this._compl_ = "ParSimple";
*/        
        //Especifica��o 25: T_PowersMod.tex 
    	//TRADU��O EQUIVALENTE
    	//TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_PowersMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Powers");
        this._compl_ = "Powers";
*/        
    	
        //Especifica��o 26: T_ProcMod.tex
        //TRADU��O EQUIVALENTE
    	//Poucos erros de compila��o
    	
    	//Na linha 80, quando se vai executar Proc_P \circseq Test (5),
    		//o fato de Test ser parametrizado esta fazendo com que o typechecker lance
    		//uma UnsupportedAstClassException

    	//Na tradu��o, erro na chamada parametrizada de ProcQ. Em ProcIntChoiceP e noutros,
    		//faltam os par�metros na chamada de ProcQ.

    	//IMPORTANTE: Nomes de estados de processos, se os processos estiverem na mesma especifica��o, devem ser DIFERENTES!!!
    		//Se n�o forem diferentes, pode haver erro na tradu��o
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_ProcMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\ProcMod");
        this._compl_ = "ProcMod";
*/        
        //Especifica��o 26: T_SelfParallelMod.tex 
        //TRADU��O EQUIVALENTE
        //TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_SelfParallelMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\SelfParallel");
        this._compl_ = "SelfParallel";
*/        
        //Especifica��o 27: T_SelfParallelismMod.tex 
        //TRADU��O EQUIVALENTE
        //TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_SelfParallelismMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\SelfParallelism");
        this._compl_ = "SelfParallelism";
*/        
        //Especifica��o 28: T_SimpleMod.tex ADAPTADO COM MUDAN�AS ESTRUTURAIS
    	//ERROS DE COMPILA��O
    	//Observa��es:
    		//Processos "on the fly" com estados n�o est�o sendo compilados pelo parser 1.5.0;
    		//  � necess�rio "comentar" os estados de cada "on the fly" para que eles sejam aceitos
    		//  na compila��o
    		//Na linha 64 de T_SimpleMod, comentei a linha de "loc := blue \circseq" porque
    		//  ela leva a um estranho erro de n�o-declara��o de vari�vel. � estranho isso acontecer
    		//  porque "loc" � a vari�vel do comando guardado, e por isso, foi declarado. A menos que n�o
    		//  possa utilizar uma vari�vel do comando guardado dentro da a��o do comando
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_SimpleMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Simple");
        this._compl_ = "Simple";
*/        
        //Especifica��o 29: T_SomeParamProcMod.tex 
        //TRADU��O EQUIVALENTE
        //TRADU��O CORRETA
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_SomeParamProcMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\SomeParamProc");
        this._compl_ = "SomeParamProc";
*/        
        //Especifica��o 30: T_SyncOnMultipleMod.tex
    	//TRADU��O EQUIVALENTE
        //ERROS DE COMPILA��O
/*      this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_SyncOnMultipleMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\SyncOnMultiple");
        this._compl_ = "SyncOnMultiple";
*/        
        
        //Especifica��o 31: T_TunaMod.tex
    	//TRADU��O EQUIVALENTE
        //TRADU��O CORRETA
/*      this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\T_TunaMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Tuna");
        this._compl_ = "Tuna";
*/        
    	this.txfProjName.setText("paper");
    	
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\Anonymous.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\Anny");
        this._compl_ = "Anny";
*/        
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\Test_FCSMod.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\FCS");
        this._compl_ = "FCS";
*/
/*    	this.txfInputSpec.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\converted_new_latex\\TestCallProcess.tex");
        this.txfOutputPath.setText("C:\\Users\\sam\\Mestrado\\JCircus2\\JCircus\\generated_new_latex\\TestCall");
        this._compl_ = "TestCall";
*/
    	//Especifica��o
        changeOutputDir();
    }

    /**
     * Invoked by the dialogs when the translation is canceled
     */
    public void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }
    
}
