package jcircus.environment;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * ChannelEnv.java
 *
 * @author Angela Freitas
 */
public class ChannelEnv {
    
    /**
     * String (processName) -> ProcChanEnv
     *
     * Maps the process name into his channel environment.
     *
     */
    private Map<String, ProcChanEnv> _map;

    /**
     * Constructor
     *
     */
    public ChannelEnv() {
        this._map = new LinkedHashMap<String, ProcChanEnv>();
    }
    
    /**
     * 
     * @param processName
     * @param procChanEnv
     */
    public void put(String processName, ProcChanEnv procChanEnv) {
        this._map.put(processName, procChanEnv);
    }
    
    /**
     *
     * @param string
     * @return
     */
    public ProcChanEnv get(String string) {
        return (ProcChanEnv) this._map.get(string);
    }
    
}
