package jcircus.complexcomms;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

import javax.swing.JOptionPane;

//import paper.src.paper.gui.â;

import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.ZExprList;

//Este mapa mapeia um nome de canal ao seu Set Type. 
public class ChanTypeEnv4CC {
	private HashMap <String, Vector <Vector <BigInteger>>> _map;
	//private HashMap <String, Vector <Boolean>> isFreeMap;
	private HashMap <String, Vector <String>> freeTypeMap;
	public ChanTypeEnv4CC () {
		this._map = new LinkedHashMap <String, Vector <Vector <BigInteger>>> ();
		//this.isFreeMap = new LinkedHashMap <String, Vector <Boolean>> ();
		this.freeTypeMap = new LinkedHashMap <String, Vector <String>> ();
	}
	public void put (String channelName, Vector <Vector <BigInteger>> v) {
		this._map.put (channelName, v);
	}
	/*public void putIsFree (String channelName, Vector <Boolean> vb) {
		this.isFreeMap.put(channelName, vb);
	}*/
	private Vector <String> toVecString (Expr expr) {
		Vector <String> vec = new Vector <String> ();
		if (expr instanceof RefExpr) {
			//JOptionPane.showMessageDialog (null, "expr == " + ((RefExpr)expr).getZName().toString() + " == ℕ? " + ((RefExpr)expr).getZName().toString().equals("ℕ"));
			if ((Character.getNumericValue(((RefExpr)expr).getZName().toString().charAt(0))) == -1)
				//Gambiarra... ℕ não tem valor ASCII, portanto não é reconhecível... O jeito é identificá-lo através do seu não-valor ASCII -1
				vec.addElement("CircusInteger");
			else if (((RefExpr)expr).getZName().toString().equals("$$SYNCH"))
				vec.addElement("Synch");
			else
				vec.addElement(((RefExpr)expr).getZName().toString());
		}
		else if (expr instanceof SetExpr) {
			ZExprList list = ((SetExpr)expr).getZExprList();
			for (int i = 0; i < list.size(); i++) {
				vec.addAll(toVecString (list.get(i)));
			}
		}
		else if (expr instanceof ProdExpr) {
			ZExprList exprs = ((ProdExpr)expr).getZExprList();
			for (int i = 0; i < exprs.size(); i++) {
				if (exprs.get(i) instanceof RefExpr) {
					//vec.addElement(((RefExpr)exprs.get(i)).getZName().toString());
					vec.addAll(toVecString (((RefExpr)exprs.get(i))));
					//return toVecString (((RefExpr)exprs.get(i)));
				}
				else {
					vec.addAll(toVecString (exprs.get(i)));
				}
			}
		}
		return vec;
	}
	public void putType (String channelName, Expr expr) {
		this.freeTypeMap.put(channelName, toVecString (expr));
		Vector <String> vecstr = toVecString (expr);

		//JOptionPane.showMessageDialog(null, vecstr.elementAt(0) + " ASCII: " + Character.getNumericValue(vecstr.elementAt(0).charAt(0)));
		System.out.print ("");
		//Vector <Boolean> isFree = new Vector <Boolean> ();
		/*for (int i = 0; i < vb.size(); i++) {
			if (vb.elementAt(i).equals("ℕ")) {
				isFree.addElement(false);
			}
			else {
				isFree.addElement(true);				
			}
		}
		this.isFreeMap.put(channelName, isFree);*/
	}
	public String getFreeType (String channelName, int i) {
		if (i < this.freeTypeMap.get(channelName).size()/*!this.freeTypeMap.get(channelName).isEmpty()*/)
			return this.freeTypeMap.get(channelName).elementAt(i);
		else return "CircusInteger"; //Gambiarra... freeTypeMap está dando vazio para certas especificações, que não são $$SYNCH...
	}
	/*public Boolean getIsFree (String channelName, int i) {
		if (!this.isFreeMap.containsKey(channelName)) {
			return false;
		}
		return this.isFreeMap.get(channelName).elementAt(i);
	}*/
	public Vector <Vector <BigInteger>> get (String channelName) {
		return this._map.get (channelName);
	}
	public HashMap <String, Vector <Vector <BigInteger>>> getMap () {
		return this._map;
	}
	public static Vector <String []> toVectorString (String chan, ChanTypeEnv4CC cte) {
		Vector <String []> vecstr = new Vector <String []> ();
		Vector <Vector <BigInteger>> vvbi = cte.get(chan);
		int vvbisize = vvbi.size();
		for (int i = 0; i < vvbisize; i++) {
			Vector <BigInteger> vbi = vvbi.get(i);
			int vbilength = vbi.size();
			String [] str = new String [vbilength];
			for (int j = 0; j < str.length; j++) {
				str [j] = vbi.get(j).intValue() + "";
			}
			vecstr.addElement(str);
		}
		return vecstr;
	}

	public static String stringCode (String chan, int index, ChanTypeEnv4CC cte) {
		Vector <String []> vecstring = toVectorString (chan, cte);
		String [] str = vecstring.elementAt(index);
		String code = "new String [] {";
		for (int i = 0; i < str.length; i++) {
			code = code + //"\"" +
				(/*(cte.getIsFree(chan, i) == false)?*/ //str [i]
					"(new " + cte.getFreeType(chan, index) + "(" + str [i] + ")).toString()")
						//+ "\""
					;
			if (i < str.length - 1) {
				code = code + ", ";
			}
		}
		code = code + "}";
		return code;
	}
}
