package jcircus.complexcomms;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JOptionPane;

import org.jcsp.lang.Guard;

import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;

import java.math.BigInteger;

import jcircus.util.Constants;
import jcircus.util.Util;

//public static String guardsCode (String chanName, Communication communication, int min, int max, Visitor c)
public class CCCode {
	
	public static String inputDecoration (Communication communication) {
		String str = "";
		CircusFieldList cfl = communication.getCircusFieldList();
		for (int i = 0; i < cfl.size(); i++) {
			if (cfl.get(i) instanceof InputField) {
				str = str + "true";
			}
			else {
				str = str + "false";
			}
			if (i != cfl.size() - 1) {
				str = str + " , ";
			}
		}
		return str;
	}
	public static String commValues (Communication c, Visitor v) {
		String str = "";
		CircusFieldList cfl = c.getCircusFieldList();
		int size = cfl.size();
		for (int i = 0; i < size; i++) {
			if (cfl.get(i) instanceof InputField) {
				str = str + "-1";
			}
			else {
				str = str + "(" + ((DotField)cfl.get(i)).getExpr().accept(v) + ").getValue()";
			}
			if (i != size - 1) {
				str = str + " , ";
			}
		}
		return str;	
	}
	public static String varNames (Communication c, Visitor v) {
		String str = "";
		CircusFieldList cfl = c.getCircusFieldList();
		int size = cfl.size();
		for (int i = 0; i < size; i++) {
			if (cfl.get(i) instanceof InputField) {
				str = str + "\"" + ((InputField)cfl.get(i)).getVariableZName().toString() + "\"";
			}
			else {
				str = str + "\"" + "none" + "\"";
			}
			if (i != size - 1) {
				str = str + " , ";
			}
		}
		return str;	
	}
	public static String [] varNamesAsArray (Communication c, Visitor v) {
		CircusFieldList cfl = c.getCircusFieldList();
		int size = cfl.size();
		String [] str = new String [size];
		for (int i = 0; i < size; i++) {
			str [i] = "";
			if (cfl.get(i) instanceof InputField) {
				str [i] = ((InputField)cfl.get(i)).getVariableZName().toString();
			}
			else {
				str [i] = "none";
			}
		}
		return str;
	}
	public static String assignmentsCode (int indent, String [] varNames, int label) {
		//Ex:
		//int x = vfe.get("x");
		//int y = vfe.get("y");
		//
		String str = "";
		for (int i = 0; i < varNames.length; i++) {
			if (!varNames[i].equals("none")) {
				str = str + indent (indent) + "int " + varNames [i] + " = (Integer)((HashMap) ccMaps_" + label + ".mapFromSelectToVarEnv.get (select_" + label + ")).get (\"" + varNames [i] + "\");\n";
				str = str + indent (indent) + "System.out.println (\"" + varNames[i] + " = \" + " + varNames [i] + ");\n";
			}
		}
		return str;
	}
	public static String indent (int n) {
		String str = "";
		for (int i = 0; i < n; i++) {
			str = str + "	";
		}
		return str;
	}
	
	public static boolean isComplexCommCase (ExtChoiceAction eca) {
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		boolean b = false;
		if (eca.getLeftAction() instanceof PrefixingAction && eca.getRightAction() instanceof PrefixingAction) {
			leftPrefixingAction = (PrefixingAction)eca.getLeftAction();
			rightPrefixingAction = (PrefixingAction)eca.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();
			if (fstComm.getCircusFieldList().size() > 1 && fstComm.getCircusFieldList().size() > 1) {
				b = true;
			}
		}
		return b;
	}
	public static boolean isComplexCommCase (IntChoiceAction eca) {
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		boolean b = false;
		if (eca.getLeftAction() instanceof PrefixingAction && eca.getRightAction() instanceof PrefixingAction) {
			leftPrefixingAction = (PrefixingAction)eca.getLeftAction();
			rightPrefixingAction = (PrefixingAction)eca.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();
			if (fstComm.getCircusFieldList().size() > 1 && fstComm.getCircusFieldList().size() > 1) {
				b = true;
			}
		}
		return b;
	}
	public static boolean isComplexCommCase (ParAction eca) {
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		boolean b = false;
		if (eca.getLeftAction() instanceof PrefixingAction && eca.getRightAction() instanceof PrefixingAction) {
			leftPrefixingAction = (PrefixingAction)eca.getLeftAction();
			rightPrefixingAction = (PrefixingAction)eca.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();
			if (fstComm.getCircusFieldList().size() > 1 && fstComm.getCircusFieldList().size() > 1) {
				b = true;
			}
		}
		return b;
	}
	public static String complexCommsSingleCode (PrefixingAction pa, Visitor c, int min, int max, ChanTypeEnv4CC env, String paper, String src, String projectDir, String specName, String procName, int counter) {
		Communication comm = pa.getCommunication();
		MinsAndMaxs mam = MinsAndMaxs.getMinsAndMaxs(env.get(comm.getChannelExpr().getName().toString()));
		String code = "";
		CCMapsGenerator ccmg = new CCMapsGenerator (paper, src, projectDir, specName, procName, counter);
		ccmg.concatCode (
		"	public HashMap mapFromSelectToVarEnv = new HashMap ();\n" +
		"	public HashMap mapLeftOrRight = new HashMap ();\n" +
		"	public CCMaps_" + procName + "_" + counter + " () {\n" +
		"		makeEnvChannels ();\n" +
		"		makeOtherEnvs ();\n" +
		"	}\n" +
			CCUtil.makeEnvChannelsCode (comm.getChannelExpr().getName().toString(), env.get(comm.getChannelExpr().getName().toString())) +
		"	public void makeOtherEnvs () {\n" +
		"	" +	CCUtil.envsCode (comm.getChannelExpr().getName().toString(), comm, mam.min, mam.max, c, 0, 0, true, env.get(comm.getChannelExpr().getName().toString())).str +
		"	}\n"
	);
	ccmg.generate();
		code = code +
			"int select_" + counter + ";\n" +
			/*"Abs_" + comm.getChannelExpr().getName().toString() +*/ " abs_" + comm.getChannelExpr().getName().toString() + " = new " + "Abs_" + comm.getChannelExpr().getName().toString() + "();\n" +
			"CCMaps_" + procName + "_" + counter + " ccMaps_" + counter + " = new CCMaps_" + procName + "_" + counter + " ();\n" +
			"select_" + counter + " = (new Alternative (";
		code = code + "\n" +
			"	new Guard []\n " +
			"{\n" +
			"\n" +
			"	/*Guardas da comunica��o*/" + "\n" +
				CCUtil.guardsCode(comm.getChannelExpr().getName().toString(), comm, mam.min, mam.max, c, env.get(comm.getChannelExpr().getName().toString()), counter) +
			"	}" +
			")).select();\n" +
			assignmentsCode (3, varNamesAsArray (comm, c), counter) +
			"			" + pa.getCircusAction().accept(c);

		//JOptionPane.showMessageDialog (null, "Current time milis 2: " + System.currentTimeMillis());
		return code;
	}

	public static String [] getChannelNames (Communication [] c) { //TODO N�O TESTADO, MAS PROVAVELMENTE FUNCIONA, POIS � TRIVIAL
		String [] chanNames = new String [c.length];
		for (int i = 0; i < chanNames.length; i++) {
			chanNames [i] = c [i].getChannelExpr().getName().toString();
		}
		return chanNames;
	}
	public static List <Communication> getCommunications (CircusAction action) { //TODO N�O TESTADO
		List <Communication> comms = new ArrayList <Communication> ();
		if (action instanceof Action2) {
			CircusAction left = ((Action2)action).getLeftAction();
			CircusAction right = ((Action2)action).getRightAction();
			comms.addAll(getCommunications (left));
			comms.addAll(getCommunications (right));
		}
		else if (action instanceof Action1) {
			if (action instanceof GuardedAction || action instanceof HideAction || action instanceof MuAction /*|| TODO outras a��es un�rias*/) {
				comms.addAll(getCommunications (((Action1)action).getCircusAction()));
			}
			else if (action instanceof PrefixingAction) {
				comms.add(((PrefixingAction)action).getCommunication());
			}
		}
		return comms;
	}
	public static List <CircusAction> getPrefixedActions (CircusAction action) { //TODO N�O TESTADO
		List <CircusAction> comms = new ArrayList <CircusAction> ();
		if (action instanceof Action2) {
			CircusAction left = ((Action2)action).getLeftAction();
			CircusAction right = ((Action2)action).getRightAction();
			comms.addAll(getPrefixedActions (left));
			comms.addAll(getPrefixedActions (right));
		}
		else if (action instanceof Action1) {
			if (action instanceof GuardedAction || action instanceof HideAction || action instanceof MuAction /*|| TODO outras a��es un�rias*/) {
				comms.addAll(getPrefixedActions (((Action1)action).getCircusAction()));
			}
			else if (action instanceof PrefixingAction) {
				comms.add(((PrefixingAction)action).getCircusAction());
			}
		}
		return comms;
	}
	public static List <CircusAction> getPrefixingActions (CircusAction action) { //TODO N�O TESTADO
		List <CircusAction> comms = new ArrayList <CircusAction> ();
		if (action instanceof Action2) {
			CircusAction left = ((Action2)action).getLeftAction();
			CircusAction right = ((Action2)action).getRightAction();
			comms.addAll(getPrefixingActions (left));
			comms.addAll(getPrefixingActions (right));
		}
		else if (action instanceof Action1) {
			if (action instanceof GuardedAction || action instanceof HideAction || action instanceof MuAction /*|| TODO outras a��es un�rias*/) {
				comms.addAll(getPrefixingActions (((Action1)action).getCircusAction()));
			}
			else if (action instanceof PrefixingAction) {
				comms.add(((PrefixingAction)action));
			}
		}
		return comms;
	}

	public static boolean isTranslatable (ExtChoiceAction eca) {
        List <CircusAction> actions = getPrefixingActions(eca);
        CircusAction [] actionsArray = actionsToArray (actions);
        boolean aux = true;
        for (int i = 0; i < actionsArray.length; i++) {
        	if (!(actionsArray [i] instanceof PrefixingAction))
        		aux = false;
        }
        return aux;
	}
	public static CircusAction [] actionsToArray (List <CircusAction> actions) {
		CircusAction [] actionsArray = new CircusAction [actions.size()];
		for (int i = 0; i < actions.size(); i++) {
			actionsArray [i] = actions.get(i);
		}
		return actionsArray;
	}
	public static Communication [] commsToArray (List <Communication> comms) {
		Communication [] commsArray = new Communication [comms.size()];
		for (int i = 0; i < comms.size(); i++) {
			commsArray [i] = comms.get(i);
		}
		return commsArray;
	}
	
	public static String complexCommsExtChoiceCode (ExtChoiceAction eca, Visitor c, int min, int max, ChanTypeEnv4CC env, String paper, String src, String projectDir, String specName, String procName, int counter) { //OK
		//counter++;
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		String code = "";
        List <CircusAction> actions = getPrefixedActions(eca);
        CircusAction [] actionsArray = actionsToArray (actions);
        List <Communication> comms = getCommunications (eca);
        Communication [] commsArray = commsToArray (comms);
        String [] channelNames = getChannelNames (commsArray);
		//if (eca.getLeftAction() instanceof PrefixingAction && eca.getRightAction() instanceof PrefixingAction) {
		//if (isTranslatable (eca)) {
			/*leftPrefixingAction = (PrefixingAction)eca.getLeftAction();
			rightPrefixingAction = (PrefixingAction)eca.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();*/

			CCMapsGenerator ccmg = new CCMapsGenerator (paper, src, projectDir, specName, procName, counter);
			String concatCode = "";
			//ccmg.concatCode (
			concatCode =
				"	public HashMap mapFromSelectToVarEnv = new HashMap ();\n"
			+   "	public HashMap mapLeftOrRight = new HashMap ();\n" +
			"	public CCMaps_" + procName + "_" + counter + " () {\n";
			for (int i = 0; i < commsArray.length; i++) {
				concatCode += "		makeEnvChannels" + i + " ();\n";
				concatCode += "		makeOtherEnvs" + i + " ();\n";
			}
			/*"		makeEnvChannels0 ();\n" +
			"		makeEnvChannels1 ();\n" +
			"		makeOtherEnvs0 ();\n" +
			"		makeOtherEnvs1 ();\n" +*/
			concatCode += "	}\n" +
			CCUtil.makeEnvChannelsCode (channelNames,/*fstComm.getChannelExpr().getName().toString(), sndComm.getChannelExpr().getName().toString(),*/ env);
			//);
			int initCounterSelect = 0;
			for (int i = 0; i < commsArray.length; i++) {
				MinsAndMaxs mam = MinsAndMaxs.getMinsAndMaxs(env.get(channelNames [i]));
				StringAndCounter sac = CCUtil.envsCode (channelNames [i]/*fstComm.getChannelExpr().getName().toString()*/,
						commsArray [i], mam.min, mam.max, c, i, initCounterSelect, true, env.get(channelNames [i]/*fstComm.getChannelExpr().getName().toString()*/));
				concatCode +=
				"	public void makeOtherEnvs" + i + " () {\n" +
				"		" +	sac.str +
				"	}\n";
				initCounterSelect = sac.counter;
			}
			
			/*"	public void makeOtherEnvs0 () {\n" +
			"	" +	CCUtil.envsCode (fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, 0, 0, true, env.get(fstComm.getChannelExpr().getName().toString())) +
			"	}\n" +
			"	public void makeOtherEnvs1 () {\n" +
			"	" +	CCUtil.envsCode (sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, 1, CCUtil.numOfGuards(CCUtil.toInputDecoration(fstComm), env.get(fstComm.getChannelExpr().getName().toString())) - 1, true, env.get(sndComm.getChannelExpr().getName().toString())) +
			"	}\n"*/
			//);
			ccmg.concatCode(concatCode);
			ccmg.generate();

			code =
			"int select_" + counter + ";\n" +
			"CCMaps_" + procName + "_" + counter + " ccMaps_" + counter + " = new CCMaps_" + procName + "_" + counter + " ();\n";
			for (int i = 0; i < comms.size(); i++) {
				code = code + /*"Abs_" + comms.get(i).getChannelExpr().getName().toString() +*/ " abs_" + comms.get(i).getChannelExpr().getName().toString() + " = new " + "Abs_" + comms.get(i).getChannelExpr().getName().toString() + "();\n";
			}
			code += "select_" + counter + " = (new Alternative (" + "\n" +
			"	new Guard [] {\n";
			for (int i = 0; i < channelNames.length; i++) {
				MinsAndMaxs mam = MinsAndMaxs.getMinsAndMaxs(env.get(channelNames [i]));
				code = code +
				"	/*Guardas da " + i + "a comunica��o*/" +
				"\n"
				+ CCUtil.guardsCode(channelNames [i], commsArray [i], mam.min, mam.max, c, env.get(channelNames [i]), counter) + "\n";
			}
			/*"	Guardas da primeira comunica��o" + "\n" +
				CCUtil.guardsCode(fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, env.get(fstComm.getChannelExpr().getName().toString())) +
			"\n	Guardas da segunda comunica��o\n" +
				CCUtil.guardsCode(sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, env.get(sndComm.getChannelExpr().getName().toString())) +
			"	}" +*/
			code = code + "\n			})).select();\n" +
				/*"HashMap mapFromSelectToVarEnv = new HashMap ();\n"
			 +  "HashMap mapLeftOrRight = new HashMap ();\n" +*/

			/*CCUtil.envsCode (fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, 0, 0, true, env.get(fstComm.getChannelExpr().getName().toString())) +
			CCUtil.envsCode (sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, 1, CCUtil.numOfGuards(CCUtil.toInputDecoration(fstComm), env.get(fstComm.getChannelExpr().getName().toString())) - 1, true, env.get(sndComm.getChannelExpr().getName().toString())) +
			*/
			"	switch (((Integer)ccMaps_" + counter + ".mapLeftOrRight.get(select_" + counter + ")).intValue()) {\n";
			for (int i = 0; i < commsArray.length; i++) {
				code = code +
				"		case " + i + ": {\n" +
					assignmentsCode (3, varNamesAsArray (commsArray [i], c), counter) +
				"			" + actionsArray [i].accept(c) +
				"\n			break;\n	}\n";
			}
			code = code +  "	}\n";
			/*"		case 0: {\n" +
						assignmentsCode (3, varNamesAsArray (fstComm, c)) +
			"			" + leftPrefixingAction.getCircusAction().accept(c) +
			"\n			break;\n" +
			"		}\n" +
			"		case 1: {\n" +
						assignmentsCode (3, varNamesAsArray (sndComm, c)) +
			"			" + rightPrefixingAction.getCircusAction().accept (c) +
			"\n			break;\n" +
			"		}\n" +*/
		//}
		//else {
			//JOptionPane.showMessageDialog (null, "The input does not match the translation requirements: An action on the external choice is not a prefixing action");
		//}
		return code;
	}
}
/*	public static String complexCommsIntChoiceCode (IntChoiceAction ica, Visitor c, int min, int max, ChanTypeEnv4CC env, String paper, String src, String projectDir, String specName, String procName) {
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		String code = "";
		if (ica.getLeftAction() instanceof PrefixingAction && ica.getRightAction() instanceof PrefixingAction) {
			leftPrefixingAction = (PrefixingAction)ica.getLeftAction();
			rightPrefixingAction = (PrefixingAction)ica.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();

			CCMapsGenerator ccmg = new CCMapsGenerator (paper, src, projectDir, specName, procName);
			ccmg.concatCode (
				"	public HashMap mapFromSelectToVarEnv = new HashMap ();\n"
			+   "	public HashMap mapLeftOrRight = new HashMap ();\n" +
			CCUtil.makeEnvChannelsCode (fstComm.getChannelExpr().getName().toString(), sndComm.getChannelExpr().getName().toString(), env) +
			"	public void makeOtherEnvs0 () {\n" +
			"	" +	CCUtil.envsCode (fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, 0, 0, true, env.get(fstComm.getChannelExpr().getName().toString())) +
			"	}\n" +
			"	public void makeOtherEnvs1 () {\n" +
			"	" +	CCUtil.envsCode (sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, 1, CCUtil.numOfGuards(CCUtil.toInputDecoration(fstComm), env.get(fstComm.getChannelExpr().getName().toString())) - 1, true, env.get(sndComm.getChannelExpr().getName().toString())) +
			"\n}\n"
			);
			ccmg.generate();

			
			code =
			"int chosen_action = ((int)Math.random()) % 2;\n" +
			"switch (chosen_action) {\n" +
			"	case 0: {\n" +
			"		int select;\n" +
			"		CCMaps_" + procName + " ccMaps = new CCMaps_" + procName + " ();\n" +
			"		ccMaps.makeEnvChannels0 ();\n" +
			"		ccMaps.makeOtherEnvs0 ();\n" +
			"		select = (new Alternative (\n" +
			"				new Guard [] {\n" +
			"" +
								CCUtil.guardsCode(fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, env.get(fstComm.getChannelExpr().getName().toString())) +
			"				}\n" +
			"			)\n" +
			"		).select();\n" +
			"		\n" +
			assignmentsCode (3, varNamesAsArray (fstComm, c)) +
			leftPrefixingAction.getCircusAction().accept(c) +
			"\n		break;\n" +
			"	}\n" +
			"	case 1: {\n" +
			"		int select;\n" +
			"		CCMaps_" + procName + " ccMaps = new CCMaps_" + procName + " ();\n" +
			"		ccMaps.makeEnvChannels1 ();\n" +
			"		ccMaps.makeOtherEnvs1 ();\n" +
			"		select = (new Alternative (\n" +
			"				new Guard [] {\n" +
								CCUtil.guardsCode(sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, env.get(sndComm.getChannelExpr().getName().toString())) +
			"				}\n" +
			"			)\n" +
			"		).select();\n" +
			assignmentsCode (3, varNamesAsArray (sndComm, c)) +			
			rightPrefixingAction.getCircusAction().accept(c) +
			"\n		break;\n" +
			"	}\n" +
			"}\n";
		}
		else {
			JOptionPane.showMessageDialog (null, "The input does not match the translation requirements: One of the two actions on the external choice is not a prefixing action");
		}
		return code;
	}
	public static String complexCommsParallelCode (ParAction par, Visitor c, int min, int max, ChanTypeEnv4CC env, String paper, String src, String projectDir, String specName, String procName) {
		PrefixingAction leftPrefixingAction, rightPrefixingAction;
		String code = "";
		if (par.getLeftAction() instanceof PrefixingAction && par.getRightAction() instanceof PrefixingAction) {
			leftPrefixingAction = (PrefixingAction)par.getLeftAction();
			rightPrefixingAction = (PrefixingAction)par.getRightAction();
			Communication fstComm = leftPrefixingAction.getCommunication();
			Communication sndComm = rightPrefixingAction.getCommunication();

			CCMapsGenerator ccmg = new CCMapsGenerator (paper, src, projectDir, specName, procName);
			ccmg.concatCode (
				"	public HashMap mapFromSelectToVarEnv = new HashMap ();\n"
			+   "	public HashMap mapLeftOrRight = new HashMap ();\n" +
			CCUtil.makeEnvChannelsCode (fstComm.getChannelExpr().getName().toString(), sndComm.getChannelExpr().getName().toString(), env) +
			"	public void makeOtherEnvs0 () {\n" +
			"	" +	CCUtil.envsCode (fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, 0, 0, true, env.get(fstComm.getChannelExpr().getName().toString())) +
			"	}\n" +
			"	public void makeOtherEnvs1 () {\n" +
			"	" +	CCUtil.envsCode (sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, 1, CCUtil.numOfGuards(CCUtil.toInputDecoration(fstComm), env.get(fstComm.getChannelExpr().getName().toString())) - 1, true, env.get(sndComm.getChannelExpr().getName().toString())) +
			"\n}\n"
			);
			ccmg.generate();
			
			code =
			"(new Parallel (\n" +
			"	new CSProcess [] {" +
			"		new CSProcess () {\n" +
			"			public void run () {\n" +
			"				int select;\n" +
			"				CCMaps_" + procName + " ccMaps = new CCMaps_" + procName + " ();\n" +
			"				ccMaps.makeEnvChannels0 ();\n" +
			"				ccMaps.makeOtherEnvs0 ();\n" +
			"				select = (new Alternative (\n" +
			"					new Guard [] {\n" +
									CCUtil.guardsCode(fstComm.getChannelExpr().getName().toString(), fstComm, min, max, c, env.get(fstComm.getChannelExpr().getName().toString())) +
			"					}\n" +
			"					)\n" +
			"				).select();\n" +
			"				" + 
			leftPrefixingAction.getCircusAction().accept(c) +

			"			}\n" +
			"		}, \n" +
			"		new CSProcess () {\n" +
			"			public void run () {\n" +
			"				int select;\n" +
			"				CCMaps_ " + procName + " ccMaps = new CCMaps_" + procName + " ();\n" +
			"				ccMaps.makeEnvChannels1 ();\n" +
			"				ccMaps.makeOtherEnvs1 ();\n" +
			"				select = (new Alternative (\n" +
			"					new Guard [] {\n" +
									CCUtil.guardsCode(sndComm.getChannelExpr().getName().toString(), sndComm, min, max, c, env.get(sndComm.getChannelExpr().getName().toString())) +
			"					}\n" +
			"				)\n" +
			"				).select();\n" +
			"			" + 
			rightPrefixingAction.getCircusAction().accept(c) +
			"	}}})).run();\n";
		}
		else {
			JOptionPane.showMessageDialog (null, "The input does not match the translation requirements: One of the two actions on the external choice is not a prefixing action");
		}
		return code;
	}
}
*/