package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.LinkedHashMap;

//@autor: Samuel Lincoln Magalhes Barrocas
//This class maps a channel name to its kind of translation according to its multi-synchronized use or not (true if multi-synchronized, and false if not). For example:
//Spec 1: 
	//P = begin @ a -> SKIP [| {a} |] a -> SKIP end
//Spec 2: 
	//P = begin @ a -> SKIP [| {a} |] a -> SKIP end
	//Q = begin @ a -> SKIP [| {a} |] a -> SKIP [| {a} |] a -> SKIP
//In "Spec 1", the channel "a" must be translated as a simple synchronized channel ("a" mapped to false). In "Spec 2", even if there is a case where "a" is simple synchronized,
	//as there is at least a multi-synchronization involving "a", it must be translated as a multi-synchronized channel
public class ChanTransMSEnv {
	private HashMap <String, Boolean> _map;
	public ChanTransMSEnv () {
		this._map = new LinkedHashMap <String, Boolean> ();
	}
	public void update (String channelName, boolean b) {
		if (_map.containsKey (channelName)) {
			_map.remove (channelName);
		}
		this._map.put (channelName, b);
	}
	public boolean get (String channelName) {
		if (!this._map.containsKey(channelName)) {
			return false;
		}
		return this._map.get (channelName);
	}
}