package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.LinkedHashMap;

import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.InputField;

public class ChanComplexCommEnv {
	private HashMap <String, Boolean> _map;
	public ChanComplexCommEnv () {
		this._map = new LinkedHashMap <String, Boolean> ();
	}
	public void update (String channelName, boolean b) {
		if (_map.containsKey (channelName)) {
			_map.remove (channelName);
		}
		this._map.put (channelName, b);
	}
	public boolean get (String channelName) {
		if (_map.containsKey (channelName))
			return this._map.get (channelName);
		else {
			return false;
		}
	}
	public static boolean isComplexComm (Communication c) {
		CircusFieldList cfl = c.getCircusFieldList();
		int size = cfl.size();
		if (size > 1) {
			for (int i = 0; i < size - 1; i++) {
				Field field = cfl.get(i);
				if (field instanceof InputField) {
					return true;
				}
			}
			return false;
		}
		else {
			return false;
		}
	}
}
