/*
 * JCircusControllerText.java
 */

package jcircus;

import java.util.List;
import jcircus.util.Error;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.TranslationCancelledException;
import jcircus.translator.Translator2Java;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.typecheck.z.ErrorAnn;
public class JCircusControllerText extends JCircusController {
    /**
     * Constructor.
     */
    public JCircusControllerText() { }
    protected void translate2Java (String projectDir, String projectName, Spec /*Term*/ spec, String compl, boolean useBarriers, boolean parallelism/*, int minComm, int maxComm*/)
            throws FailTranslationException, TranslationCancelledException, JCircusException {

        _translator = new Translator2Java(projectDir, projectName, spec, compl, useBarriers, parallelism/*, minComm, maxComm*/);

        // Translate the specification, and store the resulting code in ProcInfo
        _translator.translate(false);

        // Create the source code files
        _translator.createSources(); 
    }
    
    protected void reportMessage (String message) {
        System.out.println(message);
    }
    
    /**
     *
     */
    protected void reportParsingErrors(List<String> errors) throws FailParsingException {

        String message = parsingErrorMessage(errors);
        reportMessage(message);
        throw new FailParsingException(errors);
    }
    
    /**
     *
     */
    protected void reportTypeCheckingErrors(List<ErrorAnn> errors) throws FailTypeCheckingException {
        String message = typeCheckingErrorMessage(errors);
        reportMessage(message);
        throw new FailTypeCheckingException(errors);
    }
    
    /**
     *
     */
    protected void reportTranslationErrors(List<Error> errors) throws FailTranslationException {
        String message = translationErrorMessage(errors);
        reportMessage(message);
        throw new FailTranslationException(errors);
    }
}